/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.model;

import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.tree.gui.ColorBroker;
import com.insightful.miner.tree.model.CategoricalLevelMapper;
import com.insightful.miner.tree.model.ClassificationRegressionTree;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClassificationRegressionTreeNode
extends DefaultMutableTreeNode {
    private String node_split;
    private int node_splitColIndex = -1;
    private boolean isSplitColContinuous = true;
    private double[] node_splitVals;
    private int relationalOperator = 0;
    private int splitGroup = -1;
    private int node_size;
    private double node_record_ratio;
    private double node_deviation;
    private double node_gini;
    private double node_entropy;
    private double node_risk;
    private String node_score;
    private double[] node_yval_prob;
    private String node_rule = "";
    private String subnodesArePruned;
    private int max_size = 0;
    private double[] predictionProportion = null;
    private double max_deviance = 0.0;
    private double max_risk = 0.0;
    private int dend_x_val = 0;
    private int dend_y_val = 0;
    private double diversityDifference = 0.0;
    private Color myColor = null;
    private ClassificationRegressionTree crtree = null;
    private TreeCollection treeColl = null;
    private int m_preOrderPosition = 0;
    private static DecimalFormat percentFormat = new DecimalFormat("0.00");
    private static DecimalFormat ScientificFormat = new DecimalFormat("0.0");

    public ClassificationRegressionTreeNode(ClassificationRegressionTree tree, ClassificationRegressionTreeNode parent, int split_group, Vector splitOperators, String split, int splitColIndex, boolean splitColContinuous, double[] leftCatSplitVals, int size, int maxSize, double maxDeviance, double maxRisk, String subnodesPruned, double deviation, double gini, double entropy, double risk, String score, double[] yval_prob, double predProp) {
        this.crtree = tree;
        this.treeColl = tree.getTreeCollection();
        this.node_split = split;
        if (!"root".equals(split)) {
            this.node_splitColIndex = splitColIndex;
            this.isSplitColContinuous = splitColContinuous;
            this.node_splitVals = leftCatSplitVals;
        }
        this.splitGroup = split_group;
        if (parent == null) {
            this.m_preOrderPosition = 1;
        } else if (this.splitGroup == 1) {
            this.m_preOrderPosition = parent.m_preOrderPosition * 2;
        } else if (this.splitGroup == 2) {
            this.m_preOrderPosition = parent.m_preOrderPosition * 2 + 1;
        }
        if (splitOperators != null) {
            if (splitOperators.size() > 1) {
                if (Integer.parseInt((String)splitOperators.elementAt(0)) != -1 || splitOperators.size() - 1 != leftCatSplitVals.length) {
                    Object[] args = new Object[]{"Error in tree creation: unidentified CompoundPredicate operator"};
                    GuiMessageHandler.sendMessageToEngine(this.getTree().getTreeCollection().getDocID(), Integer.toString(this.getTree().getTreeCollection().getNodeID()), "printError", args);
                }
                for (int i = 1; i < splitOperators.size(); ++i) {
                    if (Integer.parseInt((String)splitOperators.elementAt(i)) == 1) continue;
                    Object[] args = new Object[]{"Error in tree creation: unidentified CompoundPredicate operator"};
                    GuiMessageHandler.sendMessageToEngine(this.getTree().getTreeCollection().getDocID(), Integer.toString(this.getTree().getTreeCollection().getNodeID()), "printError", args);
                }
                this.relationalOperator = Integer.parseInt((String)splitOperators.elementAt(1));
            } else {
                this.relationalOperator = Integer.parseInt((String)splitOperators.elementAt(0));
            }
        }
        this.node_size = size;
        this.max_size = maxSize;
        this.max_deviance = maxDeviance;
        this.max_risk = maxRisk;
        this.subnodesArePruned = subnodesPruned;
        this.node_record_ratio = (double)this.node_size / (double)this.max_size;
        this.node_deviation = deviation;
        this.node_gini = gini;
        this.node_entropy = entropy;
        this.node_risk = risk;
        this.node_score = score;
        this.node_yval_prob = new double[yval_prob.length];
        int max_index = 0;
        double max_value = 0.0;
        for (int i = 0; i < yval_prob.length; ++i) {
            this.node_yval_prob[i] = yval_prob[i];
            if (!(max_value < yval_prob[i])) continue;
            max_value = yval_prob[i];
            max_index = i;
        }
        this.predictionProportion = new double[1];
        this.predictionProportion[0] = predProp;
        this.myColor = ColorBroker.getScoreColor(max_index);
        this.setRule(parent);
    }

    public ClassificationRegressionTreeNode getChildWinner(double[] data, int[] columnIndices, CategoricalLevelMapper categoricalLevelMapper) {
        ClassificationRegressionTreeNode child1 = (ClassificationRegressionTreeNode)this.getChildAt(0);
        ClassificationRegressionTreeNode child2 = (ClassificationRegressionTreeNode)this.getChildAt(1);
        if (child1.getSplitGroup() != 1 && child2.getSplitGroup() != 2) {
            ClassificationRegressionTreeNode temp = child1;
            child1 = child2;
            child2 = temp;
        }
        int splitColInTree = child1.getSplitColIndex();
        int splitColInData = columnIndices[splitColInTree];
        double[] splitVals = child1.getSplitVals();
        if (child1.splitColContinuous()) {
            if (Double.isNaN(data[splitColInData])) {
                return null;
            }
            if (this.evaluateSplit(data[splitColInData], splitVals[0], child1.getRelationalOperator())) {
                return child1;
            }
            return child2;
        }
        for (int i = 0; i < splitVals.length; ++i) {
            double mappedDatalevel = categoricalLevelMapper.mapBufLevelToModelLevel(splitColInData, data[splitColInData]);
            if (Double.isNaN(mappedDatalevel)) {
                return null;
            }
            double treeLevel = splitVals[i];
            if (!this.evaluateSplit(treeLevel, mappedDatalevel, child1.getRelationalOperator())) continue;
            return child1;
        }
        return child2;
    }

    private boolean evaluateSplit(double value1, double value2, int relOpCode) {
        switch (relOpCode) {
            case 1: {
                return value1 == value2;
            }
            case 3: {
                return value1 < value2;
            }
            case 4: {
                return value1 <= value2;
            }
            case 5: {
                return value1 > value2;
            }
            case 6: {
                return value1 >= value2;
            }
        }
        Object[] args = new Object[]{"Error in tree creation: unidentified SimplePredicate operator"};
        GuiMessageHandler.sendMessageToEngine(this.getTree().getTreeCollection().getDocID(), Integer.toString(this.getTree().getTreeCollection().getNodeID()), "printError", args);
        return false;
    }

    private ClassificationRegressionTree getTree() {
        return this.crtree;
    }

    public String toString() {
        String node_string = " ";
        if (this.treeColl.getDisplaySplit()) {
            node_string = node_string + this.node_split + "  ";
        }
        if (this.treeColl.getDisplayScore()) {
            node_string = node_string + " " + this.node_score + "  ";
        }
        if (this.treeColl.getDisplaySize()) {
            node_string = node_string + " " + this.node_size + "  ";
        }
        if (this.treeColl.getDisplayRisk()) {
            node_string = this.isRegression() ? node_string + " " + MinerApp.formatDouble(this.node_risk) + "  " : node_string + " " + (int)this.node_risk + "  ";
        }
        if (this.treeColl.getDisplayDeviance()) {
            node_string = this.treeColl.getCriterion().equals("Gini") ? node_string + " " + MinerApp.formatDouble(this.node_gini) + "  " : node_string + " " + MinerApp.formatDouble(this.node_entropy) + "  ";
        }
        if (this.treeColl.getDisplayProbs()) {
            node_string = node_string + " [ ";
            for (int i = 0; i < this.node_yval_prob.length; ++i) {
                String d = MinerApp.formatDouble(this.node_yval_prob[i]);
                node_string = node_string + d + "  ";
            }
            node_string = node_string + "]";
        }
        return node_string;
    }

    public int getRelationalOperator() {
        return this.relationalOperator;
    }

    public int getPreOrderPosition() {
        return this.m_preOrderPosition;
    }

    public String getToolTipString() {
        String s = "colIndex=" + this.node_splitColIndex + ", cont=" + this.isSplitColContinuous + ", leftsplit=";
        if (this.node_splitVals != null) {
            s = s + "[ ";
            if (this.isSplitColContinuous) {
                s = s + MinerApp.formatDouble(this.node_splitVals[0]) + " ";
            } else {
                for (int i = 0; i < this.node_splitVals.length; ++i) {
                    s = s + this.node_splitVals[i] + " ";
                }
            }
            s = s + "]";
        }
        return s;
    }

    private String getNodeStatus() {
        String leaf = "";
        leaf = this.isLeaf() ? " NODE: LEAF" : " NODE: NON-TERMINAL";
        return leaf;
    }

    private String getNodeDetails() {
        String s = " Number items:               " + this.node_size + "  (" + this.max_size + ")" + " \n" + " Deviance:                      " + ClassificationRegressionTreeNode.doubleToFormatedString(this.node_deviation) + "  (" + this.max_deviance + ")" + " \n" + " Score:                            " + this.node_score;
        return s;
    }

    private String getNodeProbs() {
        String probs = " Probabilities:                 ";
        for (int i = 0; i < this.node_yval_prob.length; ++i) {
            probs = probs + this.node_yval_prob[i] + " ";
        }
        return " " + probs.trim();
    }

    private String getNodeLocation() {
        String level = " Node depth:                    " + this.getLevel() + "\n";
        String depth = " Number sub-nodes:         " + this.getDepth();
        return level + depth;
    }

    public int getSplitColIndex() {
        return this.node_splitColIndex;
    }

    public boolean splitColContinuous() {
        return this.isSplitColContinuous;
    }

    public double[] getSplitVals() {
        return this.node_splitVals;
    }

    public boolean isRegression() {
        return this.node_yval_prob.length == 1;
    }

    public double getRegressionValue() {
        return this.node_yval_prob[0] * Math.PI;
    }

    public double[] getYvalProb() {
        return this.node_yval_prob;
    }

    public double[] getPredictionProportion() {
        return this.predictionProportion;
    }

    public String getYvalProbStr() {
        return this.node_score;
    }

    public double getRecordRatio() {
        return this.node_record_ratio;
    }

    public double getDiversityRatio() {
        return this.node_deviation / this.max_deviance;
    }

    public double getDeviance() {
        return this.node_deviation;
    }

    public double getRisk() {
        return this.node_risk;
    }

    public double getDiversityDifference() {
        return this.diversityDifference;
    }

    public void setDiversityDifference(double d) {
        this.diversityDifference = d;
    }

    public void setRule(ClassificationRegressionTreeNode parent) {
        if (parent == null) {
            return;
        }
        this.node_rule = parent.getRule().length() == 0 ? "PATH:  " + this.node_split : parent.getRule() + ", " + this.node_split;
    }

    public String getRule() {
        return this.node_rule;
    }

    public int getNumItems() {
        return this.node_size;
    }

    public void setDendXVal(int val) {
        this.dend_x_val = val;
    }

    public void setDendYVal(int val) {
        this.dend_y_val = val;
    }

    public int getDendXVal() {
        return this.dend_x_val;
    }

    public int getDendYVal() {
        return this.dend_y_val;
    }

    public int getSplitGroup() {
        return this.splitGroup;
    }

    public String getNodeSplit() {
        return this.node_split;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public static String doubleToFormatedString(double number) {
        if (Math.abs(number) < 1000.0 && Math.abs(number) > 0.2) {
            return percentFormat.format(number);
        }
        return ScientificFormat.format(number);
    }
}

