/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.model;

import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.MinerApp;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.tree.model.CategoricalLevelMapper;
import com.insightful.miner.tree.model.ClassificationRegressionTreeNode;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.tree.TreeNode;

public class TreePredictor
implements CNKProcJavaTransformExec {
    private TreeCollection treeCollection = null;
    int[] columnMapping = null;
    private String[] dColumnNames = null;
    private Vector m_outputSpecs = null;
    private String[] m_columnNames = null;
    private int m_numRows = 0;
    private int m_numColumns = 0;
    private boolean m_isClassificationTree = true;
    private int m_numOutputs = 0;
    private int m_numTrees = 0;
    private double[][] m_outputValues = null;
    private double[][] m_predictionsAcrossTrees = null;
    private double[] m_singleRowValueSum = null;
    private double[][] m_inputData = null;
    private double[] m_dataRow = null;
    private String[] m_predictorLevels = null;
    private Hashtable m_unknownLevelBehaviors = null;
    private CategoricalLevelMapper m_categoricalLevelMapper = null;
    private String m_outputDir = "";
    private static String shome = System.getProperty("sprime.home");
    private static String path = shome + "\\examples\\Trees";

    public TreePredictor(TreeCollection treecol) {
        this.treeCollection = treecol;
    }

    public void setGenerateCCode(String outputDir) {
        this.m_outputDir = outputDir;
    }

    public void resetGenerateCCode() {
        this.m_outputDir = "";
    }

    private String verifyColumnsAgainstTree(TreeCollection treeCollection, String[] cols) {
        this.columnMapping = new int[treeCollection.getNumberColumns()];
        String dataColumnName = "";
        String xmlColumnName = "";
        String columnNotFound = null;
        boolean found = false;
        for (int i = 0; i < treeCollection.getNumberColumns(); ++i) {
            xmlColumnName = treeCollection.getColumnName(i);
            for (int j = 0; j < cols.length; ++j) {
                dataColumnName = cols[j];
                if (!xmlColumnName.equals(dataColumnName)) continue;
                found = true;
                this.columnMapping[i] = j;
                break;
            }
            if (!found) {
                columnNotFound = xmlColumnName;
                this.columnMapping[i] = -1;
            }
            found = false;
        }
        return columnNotFound;
    }

    private double[] evaluateNode(ClassificationRegressionTreeNode node, double[] data, int[] columnIndices, CategoricalLevelMapper categoricalLevelMapper) {
        return this.nrEvaluateNode(node, data, columnIndices, categoricalLevelMapper);
    }

    private double[] rEvaluateNode(ClassificationRegressionTreeNode node, double[] data, int[] columnIndices, CategoricalLevelMapper categoricalLevelMapper) {
        if (node.isLeaf()) {
            return null;
        }
        ClassificationRegressionTreeNode child = node.getChildWinner(data, columnIndices, categoricalLevelMapper);
        if (child == null) {
            return null;
        }
        if (child.isLeaf()) {
            return child.getYvalProb();
        }
        return this.rEvaluateNode(child, data, columnIndices, categoricalLevelMapper);
    }

    private double[] nrEvaluateNode(ClassificationRegressionTreeNode node, double[] data, int[] columnIndices, CategoricalLevelMapper categoricalLevelMapper) {
        ClassificationRegressionTreeNode child;
        if (node.isLeaf()) {
            return null;
        }
        for (child = node.getChildWinner(data, columnIndices, categoricalLevelMapper); child != null && !child.isLeaf(); child = child.getChildWinner(data, columnIndices, categoricalLevelMapper)) {
        }
        if (child == null) {
            return null;
        }
        return child.getYvalProb();
    }

    public void setOutputSpecs(Vector outputSpecs) {
        this.m_outputSpecs = outputSpecs;
    }

    public void initExecute() {
        this.m_columnNames = null;
    }

    public void setUnknownLevelBehaviors(Hashtable unknownLevelBehaviors) {
        this.m_unknownLevelBehaviors = unknownLevelBehaviors;
    }

    public void execute(CNKProcJavaTransform proc) {
        if (this.m_outputDir.length() == 0) {
            this.predictExecution(proc);
        } else {
            this.generateCExecution(this.m_outputDir);
        }
    }

    private void initializePredictorFromCollection() {
        int treeDepVarIndex = this.treeCollection.getDependentVarIndex();
        this.m_isClassificationTree = !this.treeCollection.isColumnContinuous(treeDepVarIndex);
        this.m_numOutputs = this.m_isClassificationTree ? this.treeCollection.getNumberLevels(treeDepVarIndex) : 1;
        this.m_numTrees = this.treeCollection.getNumberTrees();
        this.m_outputValues = new double[this.m_numOutputs][this.m_numRows];
        this.m_predictionsAcrossTrees = new double[this.m_numTrees][];
        this.m_singleRowValueSum = new double[this.m_numOutputs];
        this.m_dataRow = new double[this.m_numColumns];
        this.m_inputData = new double[this.m_numColumns][];
        this.m_predictorLevels = new String[this.m_numOutputs];
        if (this.m_isClassificationTree) {
            for (int i = 0; i < this.m_numOutputs; ++i) {
                this.m_predictorLevels[i] = this.treeCollection.getLevelName(treeDepVarIndex, i);
            }
        }
    }

    private void predictExecution(CNKProcJavaTransform proc) {
        int level;
        if (this.m_columnNames == null) {
            CNKBuf inbuf = proc.getInbuf();
            this.m_numRows = proc.getNumRows();
            this.m_numColumns = inbuf.getNumColumns();
            this.m_columnNames = inbuf.getColumnNames();
            String missingcol = this.verifyColumnsAgainstTree(this.treeCollection, this.m_columnNames);
            if (missingcol != null && !missingcol.equals(this.treeCollection.getDependentVar())) {
                String msg = "Error: column " + missingcol + " exists in tree, not in data.";
                proc.setError(msg);
                return;
            }
            this.m_categoricalLevelMapper = new CategoricalLevelMapper(inbuf);
            this.m_categoricalLevelMapper.setUnknownLevelBehaviors(this.m_unknownLevelBehaviors);
            this.m_categoricalLevelMapper.clearUnknownLevelError();
            int treeNumColumns = this.treeCollection.getNumberColumns();
            for (int treeCol = 0; treeCol < treeNumColumns; ++treeCol) {
                if (this.columnMapping[treeCol] < 0 || this.treeCollection.isColumnContinuous(treeCol)) continue;
                int numLevels = this.treeCollection.getNumberLevels(treeCol);
                Vector<String> levelNames = new Vector<String>(numLevels);
                for (level = 0; level < numLevels; ++level) {
                    levelNames.add(this.treeCollection.getLevelName(treeCol, level));
                }
                this.m_categoricalLevelMapper.setModelLevels(this.columnMapping[treeCol], levelNames);
            }
            this.initializePredictorFromCollection();
        }
        for (int i = 0; i < this.columnMapping.length; ++i) {
            int dataColumn = this.columnMapping[i];
            if (dataColumn == -1) continue;
            this.m_inputData[dataColumn] = proc.getChunkInputColumnData(0, dataColumn);
        }
        boolean printTreeErrors = proc.getChunkInputPosition(0) == 0L;
        int inputRows = proc.getChunkInputRows(0);
        for (int row = 0; row < inputRows; ++row) {
            for (int col = 0; col < this.m_numColumns; ++col) {
                if (this.m_inputData[col] == null) continue;
                this.m_dataRow[col] = this.m_inputData[col][row];
            }
            for (int i = 0; i < this.m_numOutputs; ++i) {
                this.m_singleRowValueSum[i] = 0.0;
            }
            int goodTrees = 0;
            for (int tree = 0; tree < this.m_numTrees; ++tree) {
                double[] singleRowPredictions = this.evaluateNode(this.treeCollection.getTree(tree).getRootNode(), this.m_dataRow, this.columnMapping, this.m_categoricalLevelMapper);
                if (this.m_categoricalLevelMapper.hasUnknownLevelError()) {
                    String msg = "Categorical column " + this.m_categoricalLevelMapper.getUnknownLevelBadColumn() + " contains unknown level: " + this.m_categoricalLevelMapper.getUnknownLevelBadLevel();
                    proc.setError(msg);
                    return;
                }
                if (singleRowPredictions == null) continue;
                ++goodTrees;
                for (level = 0; level < this.m_numOutputs; ++level) {
                    int n = level;
                    this.m_singleRowValueSum[n] = this.m_singleRowValueSum[n] + singleRowPredictions[level];
                }
            }
            for (int level2 = 0; level2 < this.m_numOutputs; ++level2) {
                this.m_outputValues[level2][row] = goodTrees < 1 ? Double.NaN : this.m_singleRowValueSum[level2] / (double)goodTrees;
            }
            printTreeErrors = false;
        }
        for (int i = 0; i < this.m_inputData.length; ++i) {
            this.m_inputData[i] = null;
        }
        for (int outputColNum = 0; outputColNum < this.m_outputSpecs.size(); ++outputColNum) {
            double val;
            int level3;
            int maxLevel;
            int i;
            PredictEngineNode.OutputSpec spec = (PredictEngineNode.OutputSpec)this.m_outputSpecs.get(outputColNum);
            String outputType = spec.m_glmTag;
            int inputColNum = spec.m_inputColNum;
            if (outputType.equals("copy")) {
                proc.copyColumnData(0, outputColNum, 0, 0, inputColNum, 0, inputRows);
                continue;
            }
            if (outputType.equals("category")) {
                String[] outFactorStrings = proc.getChunkOutputColumnStrings(0, outputColNum);
                for (i = 0; i < inputRows; ++i) {
                    double maxVal = 0.0;
                    maxLevel = 0;
                    boolean badProbs = false;
                    for (level3 = 0; level3 < this.m_numOutputs; ++level3) {
                        val = this.m_outputValues[level3][i];
                        if (Double.isNaN(val)) {
                            badProbs = true;
                            break;
                        }
                        if (!(val > maxVal)) continue;
                        maxVal = val;
                        maxLevel = level3;
                    }
                    outFactorStrings[i] = badProbs || maxLevel < 0 || maxLevel >= this.m_predictorLevels.length ? CNKObj.getStringNA() : this.m_predictorLevels[maxLevel];
                }
                continue;
            }
            double[] outData = proc.getChunkOutputColumnData(0, outputColNum);
            if (outputType.equals("fitted.value")) {
                double[] inData = this.m_outputValues[0];
                System.arraycopy(inData, 0, outData, 0, inputRows);
                continue;
            }
            if (outputType.equals("probability")) {
                String levelName = spec.m_varName;
                int probIndex = -1;
                for (int zz = 0; zz < this.m_predictorLevels.length; ++zz) {
                    if (!levelName.equals(this.m_predictorLevels[zz])) continue;
                    probIndex = zz;
                    break;
                }
                if (probIndex < 0) {
                    probIndex = 0;
                }
                double[] inData = this.m_outputValues[probIndex];
                System.arraycopy(inData, 0, outData, 0, inputRows);
                continue;
            }
            if (outputType.equals("residual")) {
                double[] inData = proc.getChunkInputColumnData(0, inputColNum);
                for (int i2 = 0; i2 < inputRows; ++i2) {
                    outData[i2] = this.m_outputValues[0][i2] - inData[i2];
                }
                continue;
            }
            if (!outputType.equals("agreement")) continue;
            for (i = 0; i < inputRows; ++i) {
                double maxVal = 0.0;
                maxLevel = 0;
                boolean badProbs = false;
                for (level3 = 0; level3 < this.m_numOutputs; ++level3) {
                    val = this.m_outputValues[level3][i];
                    if (Double.isNaN(val)) {
                        badProbs = true;
                        break;
                    }
                    if (!(val > maxVal)) continue;
                    maxVal = val;
                    maxLevel = level3;
                }
                outData[i] = badProbs ? Double.NaN : (double)maxLevel;
            }
            double[] inData = proc.getChunkInputColumnData(0, inputColNum);
            String[] inputLevels = proc.getInbuf().getColumnLevelStrings(inputColNum);
            for (int i3 = 0; i3 < inputRows; ++i3) {
                String outString;
                if (CNKObj.isDoubleNA(inData[i3])) {
                    outData[i3] = CNKObj.getDoubleNA();
                    continue;
                }
                String inString = inputLevels[(int)inData[i3]];
                outData[i3] = Double.isNaN(outData[i3]) ? CNKObj.getDoubleNA() : ((outString = this.m_predictorLevels[(int)outData[i3]]).equals(inString) ? 1.0 : 0.0);
            }
        }
    }

    private void generateCExecution(String outputDir) {
        ClassificationRegressionTreeNode node;
        long nLevels = 0L;
        long maxNodes = 0L;
        long maxComps = 0L;
        int depIdx = -1;
        this.initializePredictorFromCollection();
        long nTrees = this.m_numTrees;
        if (this.m_isClassificationTree) {
            String depVar = this.treeCollection.getDependentVar();
            depIdx = this.treeCollection.getColumnIndex(depVar);
            nLevels = this.treeCollection.getNumberLevels(depIdx);
        }
        long[] nNodes = new long[(int)nTrees];
        int i = 0;
        while ((long)i < nTrees) {
            nNodes[i] = this.treeCollection.getTree(i).getNodeCount();
            long numComp = -1L;
            Enumeration<TreeNode> enumeration = this.treeCollection.getTree(i).getRootNode().breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ClassificationRegressionTreeNode)enumeration.nextElement();
                double[] cmps = node.getSplitVals();
                long comp = cmps != null ? (long)cmps.length : 0L;
                if (numComp >= comp) continue;
                numComp = comp;
            }
            if (i == 0) {
                maxNodes = nNodes[i];
                maxComps = numComp;
            } else if (maxNodes < nNodes[i]) {
                maxNodes = nNodes[i];
            }
            if (maxComps < numComp) {
                maxComps = numComp;
            }
            ++i;
        }
        double[] nums = new double[(int)(nTrees * maxNodes)];
        double[] cols = new double[(int)(nTrees * maxNodes)];
        double[] ops = new double[(int)(nTrees * maxNodes)];
        double[] vals = new double[(int)(nTrees * maxNodes * maxComps)];
        double[] probs = new double[(int)(nTrees * maxNodes * nLevels)];
        double[] scores = new double[(int)(nTrees * maxNodes)];
        i = 0;
        while ((long)i < nTrees) {
            ClassificationRegressionTreeNode t = this.treeCollection.getTree(i).getRootNode();
            Enumeration<TreeNode> enumeration = t.breadthFirstEnumeration();
            int pos = (int)((long)i * maxNodes);
            while (enumeration.hasMoreElements()) {
                int k;
                node = (ClassificationRegressionTreeNode)enumeration.nextElement();
                nums[pos] = node.getPreOrderPosition();
                if (node.getChildCount() == 0) {
                    cols[pos] = -1.0;
                    ops[pos] = -1.0;
                } else {
                    ClassificationRegressionTreeNode lChild = (ClassificationRegressionTreeNode)node.getChildAt(0);
                    cols[pos] = lChild.getSplitColIndex() - 1;
                    ops[pos] = lChild.getRelationalOperator();
                    if (ops[pos] == 1.0) {
                        ops[pos] = 0.0;
                    } else if (ops[pos] > 1.0 && ops[pos] < 7.0) {
                        int n = pos;
                        ops[n] = ops[n] - 2.0;
                    }
                    int j = 0;
                    k = (int)((long)pos * maxComps);
                    while ((long)j < maxComps) {
                        vals[k] = -1.0;
                        ++j;
                        ++k;
                    }
                    double[] splVals = lChild.getSplitVals();
                    int j2 = 0;
                    int k2 = (int)((long)pos * maxComps);
                    while (splVals != null && j2 < splVals.length) {
                        vals[k2] = splVals[j2];
                        ++j2;
                        ++k2;
                    }
                }
                double[] prOutput = node.getYvalProb();
                int j = 0;
                k = (int)((long)pos * nLevels);
                while (prOutput != null && (long)j < nLevels) {
                    probs[k] = prOutput[j];
                    ++j;
                    ++k;
                }
                scores[pos] = !this.m_isClassificationTree ? prOutput[0] : (double)this.treeCollection.getLevelIndex(depIdx, node.getYvalProbStr());
                ++pos;
            }
            ++i;
        }
        int numLevs = this.treeCollection.getNumberLevels(this.treeCollection.getDependentVarIndex());
        String[] depLevels = new String[numLevs];
        for (int i2 = 0; i2 < depLevels.length; ++i2) {
            depLevels[i2] = this.treeCollection.getLevelName(this.treeCollection.getDependentVarIndex(), i2);
        }
        String[] colNames = this.treeCollection.getIndependentColNames();
        long[] numLevels = new long[colNames.length];
        long maxLevels = 0L;
        long nColumns = colNames.length;
        for (int i3 = 0; i3 < colNames.length; ++i3) {
            int colIndex = this.treeCollection.getColumnIndex(colNames[i3]);
            numLevels[i3] = this.treeCollection.isColumnContinuous(colIndex) ? 0L : (long)this.treeCollection.getNumberLevels(colIndex);
            if (i3 == 0) {
                maxLevels = numLevels[i3];
                continue;
            }
            if (maxLevels >= numLevels[i3]) continue;
            maxLevels = numLevels[i3];
        }
        String[] levelNames = new String[(int)((long)colNames.length * maxLevels)];
        int ln = 0;
        for (int i4 = 0; i4 < colNames.length; ++i4) {
            int col = this.treeCollection.getColumnIndex(colNames[i4]);
            int j = 0;
            while ((long)j < maxLevels) {
                levelNames[ln] = (long)j < numLevels[i4] ? this.treeCollection.getLevelName(col, j) : "";
                ++ln;
                ++j;
            }
        }
        String inputDir = MinerApp.getSprimeHome() + File.separator + "imcsrc";
        System.out.println("tree predictor input dir: " + inputDir);
        String cnkmisc_file = CNKObj.getLibraryFileName("cnkmisc");
        Runtime.getRuntime().load(cnkmisc_file);
        TreePredictor.output_model(outputDir, inputDir, nTrees, nLevels, maxComps, nNodes, nums, cols, ops, vals, probs, scores, depLevels, nColumns, maxLevels, colNames, numLevels, levelNames);
    }

    private static native long output_model(String var0, String var1, long var2, long var4, long var6, long[] var8, double[] var9, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14, String[] var15, long var16, long var18, String[] var20, long[] var21, String[] var22);

    public void runPredict() throws Exception {
        double[][] data = null;
        String[] colsInData = null;
        try {
            data = this.readTestData();
            colsInData = this.getColumnNames();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (data == null) {
            return;
        }
        double[][] predictions = new double[data.length][this.treeCollection.getNumberLevels(this.treeCollection.getDependentVarIndex())];
        this.verifyColumnsAgainstTree(this.treeCollection, colsInData);
        this.verifyLevelsAgainstTree(this.treeCollection);
        predictions = this.doPredict(data, predictions, this.columnMapping, this.m_categoricalLevelMapper);
        this.printArray(predictions);
    }

    public double[][] doPredict(double[][] data, double[][] predictions, int[] columnIndices, CategoricalLevelMapper categoricalLevelMapper) {
        int numTrees = this.treeCollection.getNumberTrees();
        int numLevels = this.treeCollection.getNumberLevels(this.treeCollection.getDependentVarIndex());
        double[][] predictionsAcrossTrees = new double[numTrees][numLevels];
        double[] singleRowPredictions = new double[numLevels];
        double[] singleRowAveragedPredictions = null;
        for (int row = 0; row < data.length; ++row) {
            for (int tree = 0; tree < numTrees; ++tree) {
                singleRowPredictions = this.evaluateNode(this.treeCollection.getTree(tree).getRootNode(), data[row], columnIndices, categoricalLevelMapper);
                predictionsAcrossTrees[tree] = singleRowPredictions;
            }
            this.printArray(predictionsAcrossTrees);
            singleRowAveragedPredictions = new double[numLevels];
            double maxProb = 0.0;
            for (int level = 0; level < numLevels; ++level) {
                for (int tree = 0; tree < numTrees; ++tree) {
                    maxProb += predictionsAcrossTrees[tree][level];
                }
                singleRowAveragedPredictions[level] = maxProb / (double)numTrees;
                maxProb = 0.0;
            }
            predictions[row] = singleRowAveragedPredictions;
        }
        return predictions;
    }

    private void verifyLevelsAgainstTree(TreeCollection treeCollection) throws Exception {
    }

    private double[][] readTestData() {
        double[][] data = null;
        FileReader fr = null;
        BufferedReader br = null;
        String line = "";
        Frame f = new Frame();
        f.setTitle("Open text file");
        File file = null;
        JFileChooser fc = new JFileChooser(path);
        int fcresult = fc.showOpenDialog(f);
        if (fcresult == 1) {
            System.out.println("file = null");
            return null;
        }
        file = fc.getSelectedFile();
        try {
            fr = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't find file.");
        }
        br = new BufferedReader(fr, 4096);
        StringTokenizer st = null;
        String val = "";
        int rowcount = 0;
        int datacount = 0;
        try {
            while ((line = br.readLine()) != null) {
                ++rowcount;
            }
            try {
                fr = new FileReader(file);
            }
            catch (FileNotFoundException e) {
                System.out.println("Can't find file.");
            }
            br = new BufferedReader(fr, 4096);
            this.dColumnNames = new String[6];
            line = br.readLine();
            if (line != null) {
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    this.dColumnNames[datacount] = s = s.substring(1, s.length() - 1);
                    ++datacount;
                }
            }
            data = new double[rowcount - 1][datacount];
            rowcount = 0;
            while ((line = br.readLine()) != null) {
                datacount = 0;
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    val = st.nextToken();
                    if (val.equals("\"Small\"")) {
                        val = "0.0";
                    } else if (val.equals("\"Sporty\"")) {
                        val = "1.0";
                    } else if (val.equals("\"Compact\"")) {
                        val = "2.0";
                    } else if (val.equals("\"Medium\"")) {
                        val = "3.0";
                    } else if (val.equals("\"Large\"")) {
                        val = "4.0";
                    } else if (val.equals("\"Van\"")) {
                        val = "5.0";
                    }
                    data[rowcount][datacount] = Double.parseDouble(val);
                    ++datacount;
                }
                ++rowcount;
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file");
        }
        try {
            br.close();
            fr.close();
        }
        catch (IOException e) {
            System.out.println("Error closing buffer");
        }
        return data;
    }

    private void printArray(double[][] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.print(i + 1 + " ");
            for (int j = 0; j < array[0].length; ++j) {
                System.out.print(array[i][j] + " ");
            }
            System.out.println("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        TreePredictor treepredictor;
        block17: {
            TreeCollection treeColl = null;
            treepredictor = null;
            Frame f = new Frame();
            f.setTitle("Open xml tree file");
            File file = null;
            JFileChooser fc = new JFileChooser(path);
            int fcresult = fc.showOpenDialog(f);
            if (fcresult == 1) {
                return;
            }
            file = fc.getSelectedFile();
            FileInputStream fstream = null;
            fstream = new FileInputStream(file);
            treeColl = new TreeCollection(fstream);
            treepredictor = new TreePredictor(treeColl);
            Object var10_8 = null;
            try {
                if (fstream != null) {
                    fstream.close();
                }
                break block17;
            }
            catch (Exception x2) {
                x2.printStackTrace();
            }
            break block17;
            {
                catch (IOException x) {
                    x.printStackTrace();
                    Object var10_9 = null;
                    try {
                        if (fstream != null) {
                            fstream.close();
                        }
                        break block17;
                    }
                    catch (Exception x2) {
                        x2.printStackTrace();
                    }
                    break block17;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Object var10_10 = null;
                    try {
                        if (fstream != null) {
                            fstream.close();
                        }
                        break block17;
                    }
                    catch (Exception x2) {
                        x2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (fstream != null) {
                        fstream.close();
                    }
                }
                catch (Exception x2) {
                    x2.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            treepredictor.runPredict();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private String[] getColumnNames() {
        return this.dColumnNames;
    }

    private String[] getColumnLevelStrings(int col) {
        if (col == 4) {
            String[] array = new String[]{"Small", "Sporty", "Compact", "Medium", "Large", "Van"};
            return array;
        }
        return new String[0];
    }

    public void setColumnNames(String[] val) {
        this.dColumnNames = val;
    }
}

