/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.event.AxisChangeListener;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Axis
implements AxisConstants {
    protected Plot plot;
    protected String label;
    protected Font labelFont;
    protected Paint labelPaint;
    protected Insets labelInsets;
    protected boolean tickLabelsVisible;
    protected Font tickLabelFont;
    protected Paint tickLabelPaint;
    protected Insets tickLabelInsets;
    protected boolean tickMarksVisible;
    protected Stroke tickMarkStroke;
    protected List ticks;
    protected List listeners;

    protected Axis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE);
    }

    protected Axis(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, Stroke stroke) {
        this.label = string;
        this.labelFont = font;
        this.labelPaint = paint;
        this.labelInsets = insets;
        this.tickLabelsVisible = bl;
        this.tickLabelFont = font2;
        this.tickLabelPaint = paint2;
        this.tickLabelInsets = insets2;
        this.tickMarksVisible = this.tickMarksVisible;
        this.tickMarkStroke = stroke;
        this.ticks = new ArrayList();
        this.listeners = new ArrayList();
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) throws PlotNotCompatibleException {
        if (!this.isCompatiblePlot(plot) && plot != null) {
            throw new PlotNotCompatibleException("Axis.setPlot(...): plot not compatible with axis.");
        }
        this.plot = plot;
        this.configure();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        if (string2 != null) {
            if (!string2.equals(string)) {
                this.label = string;
                this.notifyListeners(new AxisChangeEvent(this));
            }
        } else if (string != null) {
            this.label = string;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setLabelFont(...): null not permitted.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setLabelPaint(...): null not permitted.");
        }
        if (!this.labelPaint.equals(paint)) {
            this.labelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets insets) {
        if (!insets.equals(this.labelInsets)) {
            this.labelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (bl != this.tickLabelsVisible) {
            this.tickLabelsVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setTickLabelFont(...): null not permitted.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickLabelPaint(...): null not permitted.");
        }
        if (!this.tickLabelPaint.equals(paint)) {
            this.tickLabelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    public void setTickLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Axis.setTickLabelInsets(...): null not permitted.");
        }
        if (!this.tickLabelInsets.equals(insets)) {
            this.tickLabelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickMarksVisible() {
        return this.tickMarksVisible;
    }

    public void setTickMarksVisible(boolean bl) {
        if (bl != this.tickMarksVisible) {
            this.tickMarksVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Axis.setTickMarkStroke(...): null not permitted.");
        }
        if (!this.tickMarkStroke.equals(stroke)) {
            this.tickMarkStroke = stroke;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, Rectangle2D var3);

    public abstract void refreshTicks(Graphics2D var1, Rectangle2D var2, Rectangle2D var3);

    public abstract void configure();

    protected double getMaxTickLabelWidth(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
            if (!(rectangle2D2.getWidth() > d)) continue;
            d = rectangle2D2.getWidth();
        }
        return d;
    }

    protected abstract boolean isCompatiblePlot(Plot var1);

    protected void notifyListeners(AxisChangeEvent axisChangeEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AxisChangeListener axisChangeListener = (AxisChangeListener)iterator.next();
            axisChangeListener.axisChanged(axisChangeEvent);
        }
    }

    public void addChangeListener(AxisChangeListener axisChangeListener) {
        this.listeners.add(axisChangeListener);
    }

    public void removeChangeListener(AxisChangeListener axisChangeListener) {
        this.listeners.remove(axisChangeListener);
    }

    protected void drawVerticalString(String string, Graphics2D graphics2D, float f, float f2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(-1.5707963267948966, f, f2);
        graphics2D.transform(affineTransform2);
        graphics2D.drawString(string, f, f2);
        graphics2D.setTransform(affineTransform);
    }
}

