/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.DateUnit;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class DateAxis
extends ValueAxis {
    public static final Date DEFAULT_CROSSHAIR_DATE = null;
    protected Date minimumDate;
    protected Date maximumDate;
    protected Date anchorDate = new Date();
    protected Date crosshairDate;
    protected DateUnit tickUnit;
    protected SimpleDateFormat tickLabelFormatter;
    protected static long[] standardTickUnitMagnitudes = new long[]{1L, 5L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L, 30000L, 60000L, 300000L, 600000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 604800000L, 2592000000L, 7776000000L, 15552000000L, 31536000000L, 157680000000L, 315360000000L, 788400000000L, 1576800000000L, -1141367296000L};
    protected static int[][] standardTickUnits = new int[][]{{14, 1}, {14, 5}, {14, 10}, {14, 50}, {14, 100}, {14, 500}, {13, 1}, {13, 5}, {13, 10}, {13, 30}, {12, 1}, {12, 5}, {12, 10}, {12, 30}, {11, 1}, {11, 6}, {11, 12}, {5, 1}, {5, 7}, {2, 1}, {2, 3}, {2, 6}, {1, 1}, {1, 5}, {1, 10}, {1, 25}, {1, 50}, {1, 100}};
    protected static String[] standardTickFormats = new String[]{"HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss", "HH:mm:ss", "HH:mm:ss", "HH:mm:ss", "HH:mm", "HH:mm", "HH:mm", "HH:mm", "HH:mm", "d-MMM, H:mm", "d-MMM, H:mm", "d-MMM-yyyy", "d-MMM-yyyy", "MMM-yyyy", "MMM-yyyy", "MMM-yyyy", "yyyy", "yyyy", "yyyy", "yyyy", "yyyy", "yyyy"};

    public DateAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, null, null, true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    protected DateAxis(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, Stroke stroke, boolean bl3, Date date, Date date2, boolean bl4, DateUnit dateUnit, SimpleDateFormat simpleDateFormat, boolean bl5, Stroke stroke2, Paint paint3, boolean bl6, Date date3, Stroke stroke3, Paint paint4) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl2, stroke, bl3, bl4, bl5, stroke2, paint3, bl6, 0.0, stroke3, paint4);
        this.minimumDate = date;
        if (date != null) {
            this.minimumAxisValue = date.getTime();
        }
        this.maximumDate = date2;
        if (date2 != null) {
            this.maximumAxisValue = date2.getTime();
        }
        this.crosshairDate = date3;
        if (date3 != null) {
            this.crosshairValue = date3.getTime();
        }
        this.tickUnit = dateUnit;
        this.tickLabelFormatter = simpleDateFormat;
        this.anchorValue = this.anchorDate.getTime();
    }

    public Date getMinimumDate() {
        return this.minimumDate;
    }

    public void setMinimumDate(Date date) {
        this.minimumDate = date;
        double d = date.getTime();
        this.setMinimumAxisValue(d);
    }

    public Date getMaximumDate() {
        return this.maximumDate;
    }

    public void setMaximumDate(Date date) {
        this.maximumDate = date;
        double d = date.getTime();
        this.setMaximumAxisValue(d);
    }

    public void setMinimumAxisValue(double d) {
        long l = (long)d;
        this.minimumDate.setTime(l);
        super.setMinimumAxisValue(d);
    }

    public void setMaximumAxisValue(double d) {
        long l = (long)d;
        this.maximumDate.setTime(l);
        super.setMaximumAxisValue(d);
    }

    public void setAnchorValue(double d) {
        long l = (long)d;
        this.anchorDate.setTime(l);
        super.setAnchorValue(d);
    }

    public void setAxisRange(double d, double d2) {
        long l = (long)d;
        long l2 = (long)d2;
        this.minimumDate.setTime(l);
        this.maximumDate.setTime(l2);
        super.setAxisRange(d, d2);
    }

    public Date getCrosshairDate() {
        return this.crosshairDate;
    }

    public void setCrosshairDate(Date date) {
        this.crosshairDate = date;
        if (date != null) {
            double d = date.getTime();
            this.setCrosshairValue(d);
        } else {
            this.setCrosshairVisible(false);
        }
    }

    public Date getAnchorDate() {
        return this.anchorDate;
    }

    public void setAnchorDate(Date date) {
        this.anchorDate = date;
        double d = date.getTime();
        super.setAnchorValue(d);
    }

    public DateUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(DateUnit dateUnit) {
        this.tickUnit = dateUnit;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public SimpleDateFormat getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public Date calculateLowestVisibleTickValue(DateUnit dateUnit) {
        return this.nextStandardDate(this.minimumDate, dateUnit.getField(), dateUnit.getCount());
    }

    public Date calculateHighestVisibleTickValue(DateUnit dateUnit) {
        return this.previousStandardDate(this.maximumDate, dateUnit.getField(), dateUnit.getCount());
    }

    protected Date previousStandardDate(Date date, int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n3 = calendar.get(n);
        int n4 = n2 * (n3 / n2);
        switch (n) {
            case 14: {
                int n5 = calendar.get(1);
                int n6 = calendar.get(2);
                int n7 = calendar.get(5);
                int n8 = calendar.get(11);
                int n9 = calendar.get(12);
                int n10 = calendar.get(13);
                calendar.set(n5, n6, n7, n8, n9, n10);
                calendar.set(14, n4);
                return calendar.getTime();
            }
            case 13: {
                int n11 = calendar.get(1);
                int n12 = calendar.get(2);
                int n13 = calendar.get(5);
                int n14 = calendar.get(11);
                int n15 = calendar.get(12);
                calendar.clear(14);
                calendar.set(n11, n12, n13, n14, n15, n4);
                return calendar.getTime();
            }
            case 12: {
                int n16 = calendar.get(1);
                int n17 = calendar.get(2);
                int n18 = calendar.get(5);
                int n19 = calendar.get(11);
                calendar.clear(14);
                calendar.set(n16, n17, n18, n19, n4, 0);
                return calendar.getTime();
            }
            case 11: {
                int n20 = calendar.get(1);
                int n21 = calendar.get(2);
                int n22 = calendar.get(5);
                calendar.clear(14);
                calendar.set(n20, n21, n22, n4, 0, 0);
                return calendar.getTime();
            }
            case 5: {
                int n23 = calendar.get(1);
                int n24 = calendar.get(2);
                calendar.clear(14);
                calendar.set(n23, n24, n4, 0, 0, 0);
                return calendar.getTime();
            }
            case 2: {
                int n25 = calendar.get(1);
                calendar.clear(14);
                calendar.set(n25, n4, 1, 0, 0, 0);
                return calendar.getTime();
            }
            case 1: {
                calendar.clear(14);
                calendar.set(n4, 0, 1, 0, 0, 0);
                return calendar.getTime();
            }
        }
        return null;
    }

    protected Date nextStandardDate(Date date, int n, int n2) {
        Date date2 = this.previousStandardDate(date, n, n2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        calendar.add(n, n2);
        return calendar.getTime();
    }

    protected int findAxisMagnitudeIndex() {
        long l = this.maximumDate.getTime() - this.minimumDate.getTime();
        int n = 0;
        while (n < standardTickUnitMagnitudes.length - 1) {
            if (l < standardTickUnitMagnitudes[n]) break;
            ++n;
        }
        return Math.max(0, n - 1);
    }
}

