/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.xml.sax.Locator;

public class TableAndCaption
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private CommonRelativePosition commonRelativePosition;
    private int breakAfter;
    private int breakBefore;
    private int captionSide;
    private String id;
    private int intrusionDisplace;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int textAlign;
    static boolean notImplementedWarningGiven = false;
    private boolean tableCaptionFound = false;
    private boolean tableFound = false;

    public TableAndCaption(FONode parent) {
        super(parent);
        if (!notImplementedWarningGiven) {
            this.getLogger().warn("fo:table-and-caption is not yet implemented.");
            notImplementedWarningGiven = true;
        }
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = pList.getMarginBlockProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.captionSide = pList.get(60).getEnum();
        this.id = pList.get(113).getString();
        this.intrusionDisplace = pList.get(247).getEnum();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.textAlign = pList.get(223).getEnum();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
    }

    protected void endOfNode() throws FOPException {
        if (!this.tableFound) {
            this.missingChildElementError("marker* table-caption? table");
        }
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI) && localName.equals("marker")) {
            if (this.tableCaptionFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "fo:table-caption");
            } else if (this.tableFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "fo:table");
            }
        } else if (FO_URI.equals(nsURI) && localName.equals("table-caption")) {
            if (this.tableCaptionFound) {
                this.tooManyNodesError(loc, "fo:table-caption");
            } else if (this.tableFound) {
                this.nodesOutOfOrderError(loc, "fo:table-caption", "fo:table");
            } else {
                this.tableCaptionFound = true;
            }
        } else if (FO_URI.equals(nsURI) && localName.equals("table")) {
            if (this.tableFound) {
                this.tooManyNodesError(loc, "fo:table");
            } else {
                this.tableFound = true;
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return "fo:table-and-caption";
    }

    public int getNameId() {
        return 47;
    }
}

