/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.Property;

public class LengthRangeProperty
extends Property
implements CompoundDatatype {
    private Property minimum;
    private Property optimum;
    private Property maximum;
    private static final int MINSET = 1;
    private static final int OPTSET = 2;
    private static final int MAXSET = 4;
    private int bfSet = 0;
    private boolean consistent = false;

    public void setComponent(int cmpId, Property cmpnValue, boolean bIsDefault) {
        if (cmpId == 3072) {
            this.setMinimum(cmpnValue, bIsDefault);
        } else if (cmpId == 3584) {
            this.setOptimum(cmpnValue, bIsDefault);
        } else if (cmpId == 2560) {
            this.setMaximum(cmpnValue, bIsDefault);
        }
    }

    public Property getComponent(int cmpId) {
        if (cmpId == 3072) {
            return this.getMinimum();
        }
        if (cmpId == 3584) {
            return this.getOptimum();
        }
        if (cmpId == 2560) {
            return this.getMaximum();
        }
        return null;
    }

    protected void setMinimum(Property minimum, boolean bIsDefault) {
        this.minimum = minimum;
        if (!bIsDefault) {
            this.bfSet |= 1;
        }
        this.consistent = false;
    }

    protected void setMaximum(Property max, boolean bIsDefault) {
        this.maximum = max;
        if (!bIsDefault) {
            this.bfSet |= 4;
        }
        this.consistent = false;
    }

    protected void setOptimum(Property opt, boolean bIsDefault) {
        this.optimum = opt;
        if (!bIsDefault) {
            this.bfSet |= 2;
        }
        this.consistent = false;
    }

    private void checkConsistency() {
        if (this.consistent) {
            return;
        }
        if (!this.minimum.isAuto() && !this.maximum.isAuto() && this.minimum.getLength().getValue() > this.maximum.getLength().getValue()) {
            if ((this.bfSet & 1) != 0) {
                if ((this.bfSet & 4) != 0) {
                    log.error("forcing max to min in LengthRange");
                }
                this.maximum = this.minimum;
            } else {
                this.minimum = this.maximum;
            }
        }
        if (!this.optimum.isAuto() && !this.maximum.isAuto() && this.optimum.getLength().getValue() > this.maximum.getLength().getValue()) {
            if ((this.bfSet & 2) != 0) {
                if ((this.bfSet & 4) != 0) {
                    log.error("forcing opt to max in LengthRange");
                    this.optimum = this.maximum;
                } else {
                    this.maximum = this.optimum;
                }
            } else {
                this.optimum = this.maximum;
            }
        } else if (!this.optimum.isAuto() && !this.minimum.isAuto() && this.optimum.getLength().getValue() < this.minimum.getLength().getValue()) {
            if ((this.bfSet & 1) != 0) {
                if ((this.bfSet & 2) != 0) {
                    log.error("forcing opt to min in LengthRange");
                }
                this.optimum = this.minimum;
            } else {
                this.minimum = this.optimum;
            }
        }
        this.consistent = true;
    }

    public Property getMinimum() {
        this.checkConsistency();
        return this.minimum;
    }

    public Property getMaximum() {
        this.checkConsistency();
        return this.maximum;
    }

    public Property getOptimum() {
        this.checkConsistency();
        return this.optimum;
    }

    public String toString() {
        return "LengthRange[min:" + this.getMinimum().getObject() + ", max:" + this.getMaximum().getObject() + ", opt:" + this.getOptimum().getObject() + "]";
    }

    public LengthRangeProperty getLengthRange() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property makeNewProperty() {
            return new LengthRangeProperty();
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof LengthRangeProperty) {
                return p;
            }
            return super.convertProperty(p, propertyList, fo);
        }
    }
}

