/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.layout;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.layout.JGoAutoLayout;
import com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayoutLinkData;
import com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayoutNodeData;
import com.nwoods.jgo.layout.JGoNetwork;
import com.nwoods.jgo.layout.JGoNetworkLink;
import com.nwoods.jgo.layout.JGoNetworkNode;
import java.awt.Point;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class JGoLayeredDigraphAutoLayout
extends JGoAutoLayout {
    private int \u00d1;
    private int \u00d2;
    private int \u00d3;
    private int \u00d4;
    private int \u00d5;
    private int \u00d6;
    private int \u00d0;
    private int \u00d8;
    private int \u00d9;
    private int \u00da;
    private int \u00db;
    private int \u00dc;
    private int \u00dd;
    private int[] \u00de;
    private int \u00df;
    public static final int LD_DIRECTION_UP = 0;
    public static final int LD_DIRECTION_DOWN = 1;
    public static final int LD_DIRECTION_LEFT = 2;
    public static final int LD_DIRECTION_RIGHT = 3;
    public static final int LD_CYCLEREMOVE_GREEDY = 0;
    public static final int LD_CYCLEREMOVE_DFS = 1;
    public static final int LD_LAYERING_LONGESTPATHSINK = 0;
    public static final int LD_LAYERING_LONGESTPATHSOURCE = 1;
    public static final int LD_LAYERING_OPTIMALLINKLENGTH = 2;
    public static final int LD_INITIALIZE_NAIVE = 0;
    public static final int LD_INITIALIZE_DFSOUT = 1;
    public static final int LD_INITIALIZE_DFSIN = 2;
    public static final int LD_AGGRESSIVE_TRUE = 0;
    public static final int LD_AGGRESSIVE_FALSE = 1;

    public JGoLayeredDigraphAutoLayout() {
        this.\u00d1 = 50;
        this.\u00d2 = 50;
        this.\u00d3 = 0;
        this.\u00d4 = 1;
        this.\u00d5 = 2;
        this.\u00d6 = 1;
        this.\u00d0 = 4;
        this.\u00d8 = 1;
    }

    public JGoLayeredDigraphAutoLayout(JGoDocument jGoDocument) {
        super(jGoDocument);
        this.\u00d1 = 50;
        this.\u00d2 = 50;
        this.\u00d3 = 0;
        this.\u00d4 = 1;
        this.\u00d5 = 2;
        this.\u00d6 = 1;
        this.\u00d0 = 4;
        this.\u00d8 = 1;
    }

    public JGoLayeredDigraphAutoLayout(JGoDocument jGoDocument, JGoNetwork jGoNetwork) {
        super(jGoDocument, jGoNetwork);
        this.\u00d1 = 50;
        this.\u00d2 = 50;
        this.\u00d3 = 0;
        this.\u00d4 = 1;
        this.\u00d5 = 2;
        this.\u00d6 = 1;
        this.\u00d0 = 4;
        this.\u00d8 = 1;
    }

    public JGoLayeredDigraphAutoLayout(JGoDocument jGoDocument, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(jGoDocument);
        this.\u00d1 = Math.max(n, 10);
        this.\u00d2 = Math.max(n2, 10);
        this.\u00d3 = n3;
        this.\u00d4 = n4;
        this.\u00d5 = n5;
        this.\u00d6 = n6;
        this.\u00d0 = n7;
        this.\u00d8 = n8;
    }

    public JGoLayeredDigraphAutoLayout(JGoDocument jGoDocument, JGoNetwork jGoNetwork, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(jGoDocument, jGoNetwork);
        this.\u00d1 = Math.max(n, 10);
        this.\u00d2 = Math.max(n2, 10);
        this.\u00d3 = n3;
        this.\u00d4 = n4;
        this.\u00d5 = n5;
        this.\u00d6 = n6;
        this.\u00d0 = n7;
        this.\u00d8 = n8;
    }

    public void performLayout() {
        Object object;
        if (this.getNetwork() == null) {
            return;
        }
        this.progressUpdate(0.0);
        if (this.getNetwork().getNodeCount() <= 0) {
            this.progressUpdate(1.0);
            return;
        }
        this.getNetwork().deleteSelfLinks();
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkNode)iterator.next();
            ((JGoNetworkNode)object).nodeData = new JGoLayeredDigraphAutoLayoutNodeData();
        }
        iterator = this.getNetwork().getLinkIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkLink)iterator.next();
            ((JGoNetworkLink)object).linkData = new JGoLayeredDigraphAutoLayoutLinkData();
        }
        this.removeCycles();
        this.progressUpdate(0.1);
        this.assignLayers();
        this.progressUpdate(0.25);
        this.makeProper();
        this.progressUpdate(0.3);
        this.initializeIndices();
        this.progressUpdate(0.35);
        this.initializeColumns();
        this.progressUpdate(0.4);
        this.reduceCrossings();
        this.progressUpdate(0.6);
        this.straightenAndPack();
        this.progressUpdate(0.85);
        this.layoutNodesAndLinks();
        this.progressUpdate(1.0);
    }

    protected int getLinkMinLength(JGoNetworkLink jGoNetworkLink) {
        JGoNetworkNode jGoNetworkNode = jGoNetworkLink.getFromNode();
        JGoNetworkNode jGoNetworkNode2 = jGoNetworkLink.getToNode();
        int n = 0;
        LinkedList linkedList = jGoNetworkNode.getSuccLinksList();
        int n2 = 0;
        while (n2 < linkedList.size()) {
            JGoNetworkNode jGoNetworkNode3 = ((JGoNetworkLink)linkedList.get(n2)).getToNode();
            if (jGoNetworkNode3.equals(jGoNetworkNode2)) {
                ++n;
            }
            ++n2;
        }
        if (n > 1) {
            return 2;
        }
        return 1;
    }

    protected double getLinkLengthWeight(JGoNetworkLink jGoNetworkLink) {
        return 1.0;
    }

    protected double getLinkStraightenWeight(JGoNetworkLink jGoNetworkLink) {
        JGoNetworkNode jGoNetworkNode = jGoNetworkLink.getFromNode();
        JGoNetworkNode jGoNetworkNode2 = jGoNetworkLink.getToNode();
        if (jGoNetworkNode.getJGoObject() == null && jGoNetworkNode2.getJGoObject() == null) {
            return 8.0;
        }
        if (jGoNetworkNode.getJGoObject() == null || jGoNetworkNode2.getJGoObject() == null) {
            return 4.0;
        }
        return 1.0;
    }

    protected int getNodeMinLayerSpace(JGoNetworkNode jGoNetworkNode) {
        int n = 0;
        if (jGoNetworkNode.getJGoObject() != null) {
            JGoObject jGoObject = jGoNetworkNode.getJGoObject();
            switch (this.\u00d3) {
                case 0: 
                case 1: {
                    n = jGoObject.getHeight() / 2 / this.\u00d1 + 1;
                    break;
                }
                case 2: 
                case 3: {
                    n = jGoObject.getWidth() / 2 / this.\u00d1 + 1;
                    break;
                }
                default: {
                    n = jGoObject.getHeight() / 2 / this.\u00d1 + 1;
                }
            }
        }
        return n;
    }

    protected int getNodeMinColumnSpace(JGoNetworkNode jGoNetworkNode) {
        int n = 0;
        if (jGoNetworkNode.getJGoObject() != null) {
            JGoObject jGoObject = jGoNetworkNode.getJGoObject();
            switch (this.\u00d3) {
                case 0: 
                case 1: {
                    n = jGoObject.getWidth() / 2 / this.\u00d2 + 1;
                    break;
                }
                case 2: 
                case 3: {
                    n = jGoObject.getHeight() / 2 / this.\u00d2 + 1;
                    break;
                }
                default: {
                    n = jGoObject.getWidth() / 2 / this.\u00d2 + 1;
                }
            }
        }
        return n;
    }

    protected int[] saveLayout() {
        int[] nArray = new int[3 * this.getNetwork().getNodeCount()];
        int n = 0;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            nArray[n] = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
            nArray[++n] = this.nodeData((JGoNetworkNode)jGoNetworkNode).column;
            nArray[++n] = this.nodeData((JGoNetworkNode)jGoNetworkNode).index;
            ++n;
        }
        return nArray;
    }

    protected void restoreLayout(int[] nArray) {
        int n = 0;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode).layer = nArray[n];
            this.nodeData((JGoNetworkNode)jGoNetworkNode).column = nArray[++n];
            this.nodeData((JGoNetworkNode)jGoNetworkNode).index = nArray[++n];
            ++n;
        }
    }

    protected boolean equalLayout(int[] nArray, int[] nArray2) {
        boolean bl = true;
        int n = 0;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (bl && iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            bl = bl && nArray[n] == nArray2[n];
            bl = bl && nArray[++n] == nArray2[n];
            bl = bl && nArray[++n] == nArray2[n];
            ++n;
        }
        return bl;
    }

    protected int[] crossingMatrix(int n, int n2) {
        Iterator iterator = this.getNetwork().getNodeIterator();
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
            jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
        }
        int[] nArray = new int[this.\u00de[n] * this.\u00de[n]];
        int n3 = 0;
        while (n3 < this.\u00de[n]) {
            int n4;
            int n5;
            int n6;
            JGoNetworkLink jGoNetworkLink;
            Iterator iterator2;
            int n7;
            int n8;
            int n9;
            JGoNetworkLink jGoNetworkLink2;
            Iterator iterator3;
            LinkedList linkedList;
            int n10 = 0;
            if (n2 > 0 || n2 == 0) {
                linkedList = jGoNetworkNodeArray[n3].getPredLinksList();
                iterator3 = linkedList.iterator();
                while (iterator3.hasNext()) {
                    jGoNetworkLink2 = (JGoNetworkLink)iterator3.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink2).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink2.getFromNode()).layer == n) continue;
                    n9 = this.nodeData((JGoNetworkNode)jGoNetworkLink2.getFromNode()).index;
                    n8 = this.linkData((JGoNetworkLink)jGoNetworkLink2).portToPos;
                    n7 = this.linkData((JGoNetworkLink)jGoNetworkLink2).portFromPos;
                    iterator2 = linkedList.listIterator(linkedList.indexOf(jGoNetworkLink2));
                    while (iterator2.hasNext()) {
                        jGoNetworkLink = (JGoNetworkLink)iterator2.next();
                        if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).layer == n) continue;
                        n6 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).index;
                        n5 = this.linkData((JGoNetworkLink)jGoNetworkLink).portToPos;
                        n4 = this.linkData((JGoNetworkLink)jGoNetworkLink).portFromPos;
                        if (n8 < n5 && (n9 > n6 || n9 == n6 && n7 > n4)) {
                            ++n10;
                        }
                        if (n5 >= n8 || n6 <= n9 && (n6 != n9 || n4 <= n7)) continue;
                        ++n10;
                    }
                }
            }
            if (n2 < 0 || n2 == 0) {
                linkedList = jGoNetworkNodeArray[n3].getSuccLinksList();
                iterator3 = linkedList.iterator();
                while (iterator3.hasNext()) {
                    jGoNetworkLink2 = (JGoNetworkLink)iterator3.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink2).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink2.getToNode()).layer == n) continue;
                    n9 = this.nodeData((JGoNetworkNode)jGoNetworkLink2.getToNode()).index;
                    n8 = this.linkData((JGoNetworkLink)jGoNetworkLink2).portToPos;
                    n7 = this.linkData((JGoNetworkLink)jGoNetworkLink2).portFromPos;
                    iterator2 = linkedList.listIterator(linkedList.indexOf(jGoNetworkLink2) + 1);
                    while (iterator2.hasNext()) {
                        jGoNetworkLink = (JGoNetworkLink)iterator2.next();
                        if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer == n) continue;
                        n6 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).index;
                        n5 = this.linkData((JGoNetworkLink)jGoNetworkLink).portToPos;
                        n4 = this.linkData((JGoNetworkLink)jGoNetworkLink).portFromPos;
                        if (n7 < n4 && (n9 > n6 || n9 == n6 && n8 > n5)) {
                            ++n10;
                        }
                        if (n4 >= n7 || n6 <= n9 && (n6 != n9 || n5 <= n8)) continue;
                        ++n10;
                    }
                }
            }
            nArray[n3 * this.\u00de[n] + n3] = n10;
            int n11 = n3 + 1;
            while (n11 < this.\u00de[n]) {
                int n12;
                int n13;
                int n14;
                JGoNetworkLink jGoNetworkLink3;
                Iterator iterator4;
                int n15 = 0;
                n9 = 0;
                if (n2 > 0 || n2 == 0) {
                    LinkedList linkedList2 = jGoNetworkNodeArray[n3].getPredLinksList();
                    LinkedList linkedList3 = jGoNetworkNodeArray[n11].getPredLinksList();
                    iterator2 = linkedList2.iterator();
                    while (iterator2.hasNext()) {
                        jGoNetworkLink = (JGoNetworkLink)iterator2.next();
                        if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).layer == n) continue;
                        n6 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).index;
                        n5 = this.linkData((JGoNetworkLink)jGoNetworkLink).portToPos;
                        n4 = this.linkData((JGoNetworkLink)jGoNetworkLink).portFromPos;
                        iterator4 = linkedList3.iterator();
                        while (iterator4.hasNext()) {
                            jGoNetworkLink3 = (JGoNetworkLink)iterator4.next();
                            if (!this.linkData((JGoNetworkLink)jGoNetworkLink3).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink3.getFromNode()).layer == n) continue;
                            n14 = this.nodeData((JGoNetworkNode)jGoNetworkLink3.getFromNode()).index;
                            n13 = this.linkData((JGoNetworkLink)jGoNetworkLink3).portToPos;
                            n12 = this.linkData((JGoNetworkLink)jGoNetworkLink3).portFromPos;
                            if (n6 < n14 || n6 == n14 && n4 < n12) {
                                ++n9;
                            }
                            if (n14 >= n6 && (n14 != n6 || n12 >= n4)) continue;
                            ++n15;
                        }
                    }
                }
                if (n2 < 0 || n2 == 0) {
                    LinkedList linkedList4 = jGoNetworkNodeArray[n3].getSuccLinksList();
                    LinkedList linkedList5 = jGoNetworkNodeArray[n11].getSuccLinksList();
                    iterator2 = linkedList4.iterator();
                    while (iterator2.hasNext()) {
                        jGoNetworkLink = (JGoNetworkLink)iterator2.next();
                        if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer == n) continue;
                        n6 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).index;
                        n5 = this.linkData((JGoNetworkLink)jGoNetworkLink).portToPos;
                        n4 = this.linkData((JGoNetworkLink)jGoNetworkLink).portFromPos;
                        iterator4 = linkedList5.iterator();
                        while (iterator4.hasNext()) {
                            jGoNetworkLink3 = (JGoNetworkLink)iterator4.next();
                            if (!this.linkData((JGoNetworkLink)jGoNetworkLink3).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink3.getToNode()).layer == n) continue;
                            n14 = this.nodeData((JGoNetworkNode)jGoNetworkLink3.getToNode()).index;
                            n13 = this.linkData((JGoNetworkLink)jGoNetworkLink3).portToPos;
                            n12 = this.linkData((JGoNetworkLink)jGoNetworkLink3).portFromPos;
                            if (n6 < n14 || n6 == n14 && n5 < n13) {
                                ++n9;
                            }
                            if (n14 >= n6 && (n14 != n6 || n13 >= n5)) continue;
                            ++n15;
                        }
                    }
                }
                nArray[n3 * this.\u00de[n] + n11] = n15;
                nArray[n11 * this.\u00de[n] + n3] = n9;
                ++n11;
            }
            ++n3;
        }
        return nArray;
    }

    protected int countCrossings() {
        int n = 0;
        int n2 = 0;
        while (n2 <= this.\u00d9) {
            int[] nArray = this.crossingMatrix(n2, 1);
            int n3 = 0;
            while (n3 < this.\u00de[n2]) {
                int n4 = n3;
                while (n4 < this.\u00de[n2]) {
                    n += nArray[n3 * this.\u00de[n2] + n4];
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    protected double bends(int n, int n2, boolean bl) {
        Iterator iterator = this.getNetwork().getNodeIterator();
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
            jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
        }
        double d = 0.0;
        LinkedList linkedList = new LinkedList();
        int n3 = 0;
        while (n3 < this.\u00de[n]) {
            Object object;
            LinkedList linkedList2 = n2 < 0 || n2 == 0 ? jGoNetworkNodeArray[n3].getPredLinksList() : linkedList;
            LinkedList linkedList3 = n2 > 0 || n2 == 0 ? jGoNetworkNodeArray[n3].getSuccLinksList() : linkedList;
            Iterator iterator2 = linkedList2.iterator();
            while (iterator2.hasNext()) {
                object = (JGoNetworkLink)iterator2.next();
                if (!this.linkData((JGoNetworkLink)object).valid || this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).layer == n) continue;
                double d2 = this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).column + this.linkData((JGoNetworkLink)object).portFromColOffset;
                double d3 = this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getToNode()).column + this.linkData((JGoNetworkLink)object).portToColOffset;
                if (bl) {
                    d += Math.abs(d2 - d3) * this.getLinkStraightenWeight((JGoNetworkLink)object);
                    continue;
                }
                d += Math.abs(d2 - d3);
            }
            object = linkedList3.iterator();
            while (object.hasNext()) {
                JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)object.next();
                if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer == n) continue;
                double d4 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).column + this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset;
                double d5 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).column + this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset;
                if (bl) {
                    d += (Math.abs(d4 - d5) + 1.0) * this.getLinkStraightenWeight(jGoNetworkLink);
                    continue;
                }
                d += Math.abs(d4 - d5);
            }
            ++n3;
        }
        return d;
    }

    protected double countBends(boolean bl) {
        double d = 0.0;
        int n = 0;
        while (n <= this.\u00d9) {
            d += this.bends(n, 1, bl);
            ++n;
        }
        return d;
    }

    protected void normalize() {
        JGoNetworkNode jGoNetworkNode;
        int n = Integer.MAX_VALUE;
        this.\u00db = -1;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            n = Math.min(n, this.nodeData((JGoNetworkNode)jGoNetworkNode).column - this.getNodeMinColumnSpace(jGoNetworkNode));
            this.\u00db = Math.max(this.\u00db, this.nodeData((JGoNetworkNode)jGoNetworkNode).column + this.getNodeMinColumnSpace(jGoNetworkNode));
        }
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode).column -= n;
        }
        this.\u00db -= n;
    }

    protected double[] barycenters(int n, int n2) {
        Iterator iterator = this.getNetwork().getNodeIterator();
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
            jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
        }
        double[] dArray = new double[this.\u00de[n]];
        LinkedList linkedList = new LinkedList();
        int n3 = 0;
        while (n3 < this.\u00de[n]) {
            Object object;
            LinkedList linkedList2 = n2 < 0 || n2 == 0 ? jGoNetworkNodeArray[n3].getPredLinksList() : linkedList;
            LinkedList linkedList3 = n2 > 0 || n2 == 0 ? jGoNetworkNodeArray[n3].getSuccLinksList() : linkedList;
            double d = 0.0;
            int n4 = 0;
            Iterator iterator2 = linkedList2.iterator();
            while (iterator2.hasNext()) {
                object = (JGoNetworkLink)iterator2.next();
                if (!this.linkData((JGoNetworkLink)object).valid || this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).layer == n) continue;
                d += (double)(this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).column + this.linkData((JGoNetworkLink)object).portFromColOffset);
                ++n4;
            }
            object = linkedList3.iterator();
            while (object.hasNext()) {
                JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)object.next();
                if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer == n) continue;
                d += (double)(this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).column + this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset);
                ++n4;
            }
            dArray[n3] = n4 == 0 ? -1.0 : d / (double)n4;
            ++n3;
        }
        return dArray;
    }

    protected double[] medians(int n, int n2) {
        Iterator iterator = this.getNetwork().getNodeIterator();
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
            jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
        }
        double[] dArray = new double[this.\u00de[n]];
        LinkedList linkedList = new LinkedList();
        int n3 = 0;
        while (n3 < this.\u00de[n]) {
            Object object;
            ListIterator listIterator;
            LinkedList linkedList2 = n2 < 0 || n2 == 0 ? jGoNetworkNodeArray[n3].getPredLinksList() : linkedList;
            LinkedList linkedList3 = n2 > 0 || n2 == 0 ? jGoNetworkNodeArray[n3].getSuccLinksList() : linkedList;
            int n4 = 0;
            ListIterator listIterator2 = linkedList2.listIterator(0);
            while (listIterator2.hasNext()) {
                listIterator = (JGoNetworkLink)listIterator2.next();
                if (!this.linkData((JGoNetworkLink)((Object)listIterator)).valid || this.nodeData((JGoNetworkNode)((JGoNetworkLink)((Object)listIterator)).getFromNode()).layer == n) continue;
                ++n4;
            }
            listIterator = linkedList3.listIterator(0);
            while (listIterator.hasNext()) {
                object = (JGoNetworkLink)listIterator.next();
                if (!this.linkData((JGoNetworkLink)object).valid || this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getToNode()).layer == n) continue;
                ++n4;
            }
            if (n4 == 0) {
                dArray[n3] = -1.0;
            } else {
                int n5;
                JGoNetworkLink jGoNetworkLink;
                object = new int[n4];
                n4 = 0;
                listIterator2 = linkedList2.listIterator(0);
                while (listIterator2.hasNext()) {
                    jGoNetworkLink = (JGoNetworkLink)listIterator2.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).layer == n) continue;
                    object[n4] = this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).column + this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset;
                    ++n4;
                }
                listIterator = linkedList3.listIterator(0);
                while (listIterator.hasNext()) {
                    jGoNetworkLink = (JGoNetworkLink)listIterator.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer == n) continue;
                    object[n4] = this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).column + this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset;
                    ++n4;
                }
                boolean bl = true;
                while (bl) {
                    bl = false;
                    n5 = 0;
                    while (n5 < n4 - 1) {
                        if (object[n5] > object[n5 + 1]) {
                            bl = true;
                            Object object2 = object[n5 + 1];
                            object[n5 + 1] = object[n5];
                            object[n5] = object2;
                        }
                        ++n5;
                    }
                }
                n5 = n4 / 2;
                dArray[n3] = n4 % 2 == 1 ? (double)object[n5] : ((double)object[n5 - 1] + (double)object[n5]) / 2.0;
            }
            ++n3;
        }
        return dArray;
    }

    protected void tightComponent(JGoNetworkNode jGoNetworkNode, int n, boolean bl, boolean bl2) {
        if (this.nodeData((JGoNetworkNode)jGoNetworkNode).component != n) {
            int n2;
            int n3;
            JGoNetworkNode jGoNetworkNode2;
            JGoNetworkLink jGoNetworkLink;
            int n4;
            LinkedList linkedList;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).component = n;
            if (bl) {
                linkedList = jGoNetworkNode.getSuccLinksList();
                n4 = 0;
                while (n4 < linkedList.size()) {
                    jGoNetworkLink = (JGoNetworkLink)linkedList.get(n4);
                    jGoNetworkNode2 = jGoNetworkLink.getToNode();
                    n3 = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer - this.nodeData((JGoNetworkNode)jGoNetworkNode2).layer;
                    n2 = this.getLinkMinLength(jGoNetworkLink);
                    if (n3 == n2) {
                        this.tightComponent(jGoNetworkNode2, n, bl, bl2);
                    }
                    ++n4;
                }
            }
            if (bl2) {
                linkedList = jGoNetworkNode.getPredLinksList();
                n4 = 0;
                while (n4 < linkedList.size()) {
                    jGoNetworkLink = (JGoNetworkLink)linkedList.get(n4);
                    jGoNetworkNode2 = jGoNetworkLink.getFromNode();
                    n3 = this.nodeData((JGoNetworkNode)jGoNetworkNode2).layer - this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
                    n2 = this.getLinkMinLength(jGoNetworkLink);
                    if (n3 == n2) {
                        this.tightComponent(jGoNetworkNode2, n, bl, bl2);
                    }
                    ++n4;
                }
            }
        }
    }

    protected void tightComponentUnset(JGoNetworkNode jGoNetworkNode, int n, int n2, boolean bl, boolean bl2) {
        if (this.nodeData((JGoNetworkNode)jGoNetworkNode).component == n2) {
            int n3;
            int n4;
            JGoNetworkNode jGoNetworkNode2;
            JGoNetworkLink jGoNetworkLink;
            int n5;
            LinkedList linkedList;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).component = n;
            if (bl) {
                linkedList = jGoNetworkNode.getSuccLinksList();
                n5 = 0;
                while (n5 < linkedList.size()) {
                    jGoNetworkLink = (JGoNetworkLink)linkedList.get(n5);
                    jGoNetworkNode2 = jGoNetworkLink.getToNode();
                    n4 = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer - this.nodeData((JGoNetworkNode)jGoNetworkNode2).layer;
                    n3 = this.getLinkMinLength(jGoNetworkLink);
                    if (n4 == n3) {
                        this.tightComponentUnset(jGoNetworkNode2, n, n2, bl, bl2);
                    }
                    ++n5;
                }
            }
            if (bl2) {
                linkedList = jGoNetworkNode.getPredLinksList();
                n5 = 0;
                while (n5 < linkedList.size()) {
                    jGoNetworkLink = (JGoNetworkLink)linkedList.get(n5);
                    jGoNetworkNode2 = jGoNetworkLink.getFromNode();
                    n4 = this.nodeData((JGoNetworkNode)jGoNetworkNode2).layer - this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
                    n3 = this.getLinkMinLength(jGoNetworkLink);
                    if (n4 == n3) {
                        this.tightComponentUnset(jGoNetworkNode2, n, n2, bl, bl2);
                    }
                    ++n5;
                }
            }
        }
    }

    protected void component(JGoNetworkNode jGoNetworkNode, int n, boolean bl, boolean bl2) {
        if (this.nodeData((JGoNetworkNode)jGoNetworkNode).component != n) {
            JGoNetworkNode jGoNetworkNode2;
            JGoNetworkLink jGoNetworkLink;
            int n2;
            LinkedList linkedList;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).component = n;
            if (bl) {
                linkedList = jGoNetworkNode.getSuccLinksList();
                n2 = 0;
                while (n2 < linkedList.size()) {
                    jGoNetworkLink = (JGoNetworkLink)linkedList.get(n2);
                    jGoNetworkNode2 = jGoNetworkLink.getToNode();
                    this.component(jGoNetworkNode2, n, bl, bl2);
                    ++n2;
                }
            }
            if (bl2) {
                linkedList = jGoNetworkNode.getPredLinksList();
                n2 = 0;
                while (n2 < linkedList.size()) {
                    jGoNetworkLink = (JGoNetworkLink)linkedList.get(n2);
                    jGoNetworkNode2 = jGoNetworkLink.getFromNode();
                    this.component(jGoNetworkNode2, n, bl, bl2);
                    ++n2;
                }
            }
        }
    }

    protected void componentUnset(JGoNetworkNode jGoNetworkNode, int n, int n2, boolean bl, boolean bl2) {
        if (this.nodeData((JGoNetworkNode)jGoNetworkNode).component == n2) {
            JGoNetworkNode jGoNetworkNode2;
            JGoNetworkLink jGoNetworkLink;
            int n3;
            LinkedList linkedList;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).component = n;
            if (bl) {
                linkedList = jGoNetworkNode.getSuccLinksList();
                n3 = 0;
                while (n3 < linkedList.size()) {
                    jGoNetworkLink = (JGoNetworkLink)linkedList.get(n3);
                    jGoNetworkNode2 = jGoNetworkLink.getToNode();
                    this.componentUnset(jGoNetworkNode2, n, n2, bl, bl2);
                    ++n3;
                }
            }
            if (bl2) {
                linkedList = jGoNetworkNode.getPredLinksList();
                n3 = 0;
                while (n3 < linkedList.size()) {
                    jGoNetworkLink = (JGoNetworkLink)linkedList.get(n3);
                    jGoNetworkNode2 = jGoNetworkLink.getFromNode();
                    this.componentUnset(jGoNetworkNode2, n, n2, bl, bl2);
                    ++n3;
                }
            }
        }
    }

    protected void removeCycles() {
        Iterator iterator = this.getNetwork().getLinkIterator();
        while (iterator.hasNext()) {
            JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
            this.linkData((JGoNetworkLink)jGoNetworkLink).rev = false;
        }
        switch (this.\u00d4) {
            case 0: {
                this.greedyCycleRemoval();
                break;
            }
            case 1: {
                this.depthFirstSearchCycleRemoval();
                break;
            }
            default: {
                this.greedyCycleRemoval();
            }
        }
    }

    protected void greedyCycleRemoval() {
        JGoNetworkNode jGoNetworkNode;
        int n = 0;
        int n2 = this.getNetwork().getNodeCount() - 1;
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[n2 + 1];
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode).valid = true;
        }
        while (this.greedyCycleRemovalFindNode(this.getNetwork()) != null) {
            jGoNetworkNode = this.greedyCycleRemovalFindSink(this.getNetwork());
            while (jGoNetworkNode != null) {
                jGoNetworkNodeArray[n2] = jGoNetworkNode;
                --n2;
                this.nodeData((JGoNetworkNode)jGoNetworkNode).valid = false;
                jGoNetworkNode = this.greedyCycleRemovalFindSink(this.getNetwork());
            }
            jGoNetworkNode = this.greedyCycleRemovalFindSource(this.getNetwork());
            while (jGoNetworkNode != null) {
                jGoNetworkNodeArray[n] = jGoNetworkNode;
                ++n;
                this.nodeData((JGoNetworkNode)jGoNetworkNode).valid = false;
                jGoNetworkNode = this.greedyCycleRemovalFindSource(this.getNetwork());
            }
            jGoNetworkNode = this.greedyCycleRemovalFindNodeMaxDegDiff(this.getNetwork());
            if (jGoNetworkNode == null) continue;
            jGoNetworkNodeArray[n] = jGoNetworkNode;
            ++n;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).valid = false;
        }
        int n3 = 0;
        while (n3 < this.getNetwork().getNodeCount()) {
            this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).index = n3;
            ++n3;
        }
        iterator = this.getNetwork().getLinkIterator();
        while (iterator.hasNext()) {
            JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
            int n4 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).index;
            int n5 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).index;
            if (n4 <= n5) continue;
            this.getNetwork().reverseLink(jGoNetworkLink);
            this.linkData((JGoNetworkLink)jGoNetworkLink).rev = true;
        }
    }

    protected JGoNetworkNode greedyCycleRemovalFindNode(JGoNetwork jGoNetwork) {
        Iterator iterator = jGoNetwork.getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (!this.nodeData((JGoNetworkNode)jGoNetworkNode).valid) continue;
            return jGoNetworkNode;
        }
        return null;
    }

    protected JGoNetworkNode greedyCycleRemovalFindSink(JGoNetwork jGoNetwork) {
        Iterator iterator = jGoNetwork.getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (!this.nodeData((JGoNetworkNode)jGoNetworkNode).valid) continue;
            LinkedList linkedList = jGoNetworkNode.getSuccLinksList();
            boolean bl = true;
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator2.next();
                if (!this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).valid) continue;
                bl = false;
            }
            if (!bl) continue;
            return jGoNetworkNode;
        }
        return null;
    }

    protected JGoNetworkNode greedyCycleRemovalFindSource(JGoNetwork jGoNetwork) {
        Iterator iterator = jGoNetwork.getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (!this.nodeData((JGoNetworkNode)jGoNetworkNode).valid) continue;
            LinkedList linkedList = jGoNetworkNode.getPredLinksList();
            boolean bl = true;
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator2.next();
                if (!this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).valid) continue;
                bl = false;
            }
            if (!bl) continue;
            return jGoNetworkNode;
        }
        return null;
    }

    protected JGoNetworkNode greedyCycleRemovalFindNodeMaxDegDiff(JGoNetwork jGoNetwork) {
        JGoNetworkNode jGoNetworkNode = null;
        int n = 0;
        Iterator iterator = jGoNetwork.getNodeIterator();
        while (iterator.hasNext()) {
            Object object;
            JGoNetworkNode jGoNetworkNode2 = (JGoNetworkNode)iterator.next();
            if (!this.nodeData((JGoNetworkNode)jGoNetworkNode2).valid) continue;
            LinkedList linkedList = jGoNetworkNode2.getSuccLinksList();
            int n2 = 0;
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                object = (JGoNetworkLink)iterator2.next();
                if (!this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getToNode()).valid) continue;
                ++n2;
            }
            object = jGoNetworkNode2.getPredLinksList();
            int n3 = 0;
            Iterator iterator3 = ((AbstractSequentialList)object).iterator();
            while (iterator3.hasNext()) {
                JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator3.next();
                if (!this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).valid) continue;
                ++n3;
            }
            if (jGoNetworkNode != null && n >= n2 - n3) continue;
            jGoNetworkNode = jGoNetworkNode2;
            n = n2 - n3;
        }
        return jGoNetworkNode;
    }

    protected void depthFirstSearchCycleRemoval() {
        Object object;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)object).discover = -1;
            this.nodeData((JGoNetworkNode)object).finish = -1;
        }
        iterator = this.getNetwork().getLinkIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkLink)iterator.next();
            this.linkData((JGoNetworkLink)object).forest = false;
        }
        this.\u00df = 0;
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkNode)iterator.next();
            if (!((JGoNetworkNode)object).getPredLinksList().isEmpty()) continue;
            this.depthFirstSearchCycleRemovalVisit((JGoNetworkNode)object);
        }
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)object).discover != -1) continue;
            this.depthFirstSearchCycleRemovalVisit((JGoNetworkNode)object);
        }
        iterator = this.getNetwork().getLinkIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkLink)iterator.next();
            if (this.linkData((JGoNetworkLink)object).forest) continue;
            JGoNetworkNode jGoNetworkNode = ((JGoNetworkLink)object).getFromNode();
            int n = this.nodeData((JGoNetworkNode)jGoNetworkNode).discover;
            int n2 = this.nodeData((JGoNetworkNode)jGoNetworkNode).finish;
            JGoNetworkNode jGoNetworkNode2 = ((JGoNetworkLink)object).getToNode();
            int n3 = this.nodeData((JGoNetworkNode)jGoNetworkNode2).discover;
            int n4 = this.nodeData((JGoNetworkNode)jGoNetworkNode2).finish;
            if (n3 >= n || n2 >= n4) continue;
            this.getNetwork().reverseLink((JGoNetworkLink)object);
            this.linkData((JGoNetworkLink)object).rev = true;
        }
    }

    protected void depthFirstSearchCycleRemovalVisit(JGoNetworkNode jGoNetworkNode) {
        this.nodeData((JGoNetworkNode)jGoNetworkNode).discover = this.\u00df++;
        LinkedList linkedList = jGoNetworkNode.getSuccLinksList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
            JGoNetworkNode jGoNetworkNode2 = jGoNetworkLink.getToNode();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode2).discover != -1) continue;
            this.linkData((JGoNetworkLink)jGoNetworkLink).forest = true;
            this.depthFirstSearchCycleRemovalVisit(jGoNetworkNode2);
        }
        this.nodeData((JGoNetworkNode)jGoNetworkNode).finish = this.\u00df++;
    }

    protected void assignLayers() {
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode).layer = -1;
        }
        this.\u00d9 = -1;
        switch (this.\u00d5) {
            case 0: {
                this.longestPathSinkLayering();
                break;
            }
            case 1: {
                this.longestPathSourceLayering();
                break;
            }
            case 2: {
                this.optimalLinkLengthLayering();
                break;
            }
            default: {
                this.longestPathSinkLayering();
            }
        }
    }

    protected void longestPathSinkLayering() {
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            int n = this.longestPathSinkLayeringLength(jGoNetworkNode);
            this.\u00d9 = Math.max(n, this.\u00d9);
        }
    }

    protected int longestPathSinkLayeringLength(JGoNetworkNode jGoNetworkNode) {
        int n = 0;
        if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer == -1) {
            LinkedList linkedList = jGoNetworkNode.getSuccLinksList();
            if (linkedList.isEmpty()) {
                n = 0;
            } else {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    int n2 = this.getLinkMinLength(jGoNetworkLink);
                    n = Math.max(n, this.longestPathSinkLayeringLength(jGoNetworkLink.getToNode()) + n2);
                }
            }
            this.nodeData((JGoNetworkNode)jGoNetworkNode).layer = n;
        } else {
            n = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
        }
        return n;
    }

    protected void longestPathSourceLayering() {
        JGoNetworkNode jGoNetworkNode;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            int n = this.longestPathSourceLayeringLength(jGoNetworkNode);
            this.\u00d9 = Math.max(n, this.\u00d9);
        }
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode).layer = this.\u00d9 - this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
        }
    }

    protected int longestPathSourceLayeringLength(JGoNetworkNode jGoNetworkNode) {
        int n = 0;
        if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer == -1) {
            LinkedList linkedList = jGoNetworkNode.getPredLinksList();
            if (linkedList.isEmpty()) {
                n = 0;
            } else {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    int n2 = this.getLinkMinLength(jGoNetworkLink);
                    n = Math.max(n, this.longestPathSourceLayeringLength(jGoNetworkLink.getFromNode()) + n2);
                }
            }
            this.nodeData((JGoNetworkNode)jGoNetworkNode).layer = n;
        } else {
            n = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
        }
        return n;
    }

    protected void optimalLinkLengthLayering() {
        JGoNetworkNode jGoNetworkNode;
        JGoNetworkNode jGoNetworkNode2;
        this.longestPathSinkLayering();
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode2 = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode2).valid = false;
        }
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode2 = (JGoNetworkNode)iterator.next();
            if (!jGoNetworkNode2.getPredLinksList().isEmpty()) continue;
            this.optimalLinkLengthLayeringDepthFirstSearch(jGoNetworkNode2);
        }
        int n = Integer.MAX_VALUE;
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            n = Math.min(n, this.nodeData((JGoNetworkNode)jGoNetworkNode).layer);
        }
        this.\u00d9 = -1;
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode).layer -= n;
            this.\u00d9 = Math.max(this.\u00d9, this.nodeData((JGoNetworkNode)jGoNetworkNode).layer);
        }
    }

    protected void optimalLinkLengthLayeringDepthFirstSearch(JGoNetworkNode jGoNetworkNode) {
        if (!this.nodeData((JGoNetworkNode)jGoNetworkNode).valid) {
            this.nodeData((JGoNetworkNode)jGoNetworkNode).valid = true;
            LinkedList linkedList = jGoNetworkNode.getSuccLinksList();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                JGoNetworkNode jGoNetworkNode2 = ((JGoNetworkLink)iterator.next()).getToNode();
                this.optimalLinkLengthLayeringDepthFirstSearch(jGoNetworkNode2);
            }
            this.optimalLinkLengthLayeringPull(jGoNetworkNode);
            this.optimalLinkLengthLayeringPush(jGoNetworkNode);
        }
    }

    protected void optimalLinkLengthLayeringPull(JGoNetworkNode jGoNetworkNode) {
        int n;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode2 = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode2).component = -1;
        }
        LinkedList linkedList = jGoNetworkNode.getPredLinksList();
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            JGoNetworkLink jGoNetworkLink;
            n = this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).layer - this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer;
            jGoNetworkLink = (JGoNetworkLink)iterator.next();
            int n2 = this.getLinkMinLength(jGoNetworkLink);
            if (n <= n2) continue;
            this.tightComponentUnset(jGoNetworkLink.getFromNode(), 0, -1, true, false);
        }
        this.tightComponentUnset(jGoNetworkNode, 1, -1, true, true);
        while (this.nodeData((JGoNetworkNode)jGoNetworkNode).component != 0) {
            JGoNetworkNode jGoNetworkNode3;
            double d = 0.0;
            n = Integer.MAX_VALUE;
            double d2 = 0.0;
            JGoNetworkNode jGoNetworkNode4 = null;
            iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                jGoNetworkNode3 = (JGoNetworkNode)iterator.next();
                if (this.nodeData((JGoNetworkNode)jGoNetworkNode3).component != 1) continue;
                double d3 = 0.0;
                boolean bl = false;
                linkedList = jGoNetworkNode3.getPredLinksList();
                Iterator iterator2 = linkedList.iterator();
                while (iterator2.hasNext()) {
                    object2 = (JGoNetworkLink)iterator2.next();
                    object = ((JGoNetworkLink)object2).getFromNode();
                    d3 += this.getLinkLengthWeight((JGoNetworkLink)object2);
                    if (this.nodeData((JGoNetworkNode)object).component == 1) continue;
                    d += this.getLinkLengthWeight((JGoNetworkLink)object2);
                    int n3 = this.nodeData((JGoNetworkNode)object).layer - this.nodeData((JGoNetworkNode)jGoNetworkNode3).layer;
                    int n4 = this.getLinkMinLength((JGoNetworkLink)object2);
                    n = Math.min(n, n3 - n4);
                }
                object2 = jGoNetworkNode3.getSuccLinksList();
                object = ((AbstractSequentialList)object2).iterator();
                while (object.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)object.next();
                    JGoNetworkNode jGoNetworkNode5 = jGoNetworkLink.getToNode();
                    d3 -= this.getLinkLengthWeight(jGoNetworkLink);
                    if (this.nodeData((JGoNetworkNode)jGoNetworkNode5).component != 1) {
                        d -= this.getLinkLengthWeight(jGoNetworkLink);
                        continue;
                    }
                    bl = true;
                }
                if (jGoNetworkNode4 != null && !(d3 < d2) || bl) continue;
                jGoNetworkNode4 = jGoNetworkNode3;
                d2 = d3;
            }
            if (d > 0.0) {
                iterator = this.getNetwork().getNodeIterator();
                while (iterator.hasNext()) {
                    jGoNetworkNode3 = (JGoNetworkNode)iterator.next();
                    if (this.nodeData((JGoNetworkNode)jGoNetworkNode3).component != 1) continue;
                    this.nodeData((JGoNetworkNode)jGoNetworkNode3).layer += n;
                }
                this.nodeData((JGoNetworkNode)jGoNetworkNode).component = 0;
                continue;
            }
            this.nodeData(jGoNetworkNode4).component = 0;
        }
    }

    protected void optimalLinkLengthLayeringPush(JGoNetworkNode jGoNetworkNode) {
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode2 = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode2).component = -1;
        }
        this.tightComponentUnset(jGoNetworkNode, 1, -1, true, false);
        while (this.nodeData((JGoNetworkNode)jGoNetworkNode).component != 0) {
            JGoNetworkNode jGoNetworkNode3;
            double d = 0.0;
            int n = Integer.MAX_VALUE;
            double d2 = 0.0;
            JGoNetworkNode jGoNetworkNode4 = null;
            iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                jGoNetworkNode3 = (JGoNetworkNode)iterator.next();
                if (this.nodeData((JGoNetworkNode)jGoNetworkNode3).component != 1) continue;
                double d3 = 0.0;
                boolean bl = false;
                LinkedList linkedList = jGoNetworkNode3.getPredLinksList();
                Iterator iterator2 = linkedList.iterator();
                while (iterator2.hasNext()) {
                    object2 = (JGoNetworkLink)iterator2.next();
                    object = ((JGoNetworkLink)object2).getFromNode();
                    d3 += this.getLinkLengthWeight((JGoNetworkLink)object2);
                    if (this.nodeData((JGoNetworkNode)object).component != 1) {
                        d += this.getLinkLengthWeight((JGoNetworkLink)object2);
                        continue;
                    }
                    bl = true;
                }
                object2 = jGoNetworkNode3.getSuccLinksList();
                object = ((AbstractSequentialList)object2).iterator();
                while (object.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)object.next();
                    JGoNetworkNode jGoNetworkNode5 = jGoNetworkLink.getToNode();
                    d3 -= this.getLinkLengthWeight(jGoNetworkLink);
                    if (this.nodeData((JGoNetworkNode)jGoNetworkNode5).component == 1) continue;
                    d -= this.getLinkLengthWeight(jGoNetworkLink);
                    int n2 = this.nodeData((JGoNetworkNode)jGoNetworkNode3).layer - this.nodeData((JGoNetworkNode)jGoNetworkNode5).layer;
                    int n3 = this.getLinkMinLength(jGoNetworkLink);
                    n = Math.min(n, n2 - n3);
                }
                if (jGoNetworkNode4 != null && !(d3 > d2) || bl) continue;
                jGoNetworkNode4 = jGoNetworkNode3;
                d2 = d3;
            }
            if (d < 0.0) {
                iterator = this.getNetwork().getNodeIterator();
                while (iterator.hasNext()) {
                    jGoNetworkNode3 = (JGoNetworkNode)iterator.next();
                    if (this.nodeData((JGoNetworkNode)jGoNetworkNode3).component != 1) continue;
                    this.nodeData((JGoNetworkNode)jGoNetworkNode3).layer -= n;
                }
                this.nodeData((JGoNetworkNode)jGoNetworkNode).component = 0;
                continue;
            }
            this.nodeData(jGoNetworkNode4).component = 0;
        }
    }

    protected void makeProper() {
        Object object;
        Iterator iterator = this.getNetwork().getLinkIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkLink)iterator.next();
            this.linkData((JGoNetworkLink)object).valid = false;
        }
        object = this.getNetwork().getLinkArray();
        int n = 0;
        while (n < ((Object[])object).length) {
            JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)object[n];
            if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid) {
                Object object2;
                Object object3;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (jGoNetworkLink.getJGoObject() != null) {
                    Point point;
                    Point point2;
                    object3 = jGoNetworkLink.getFromNode().getCenter();
                    object2 = jGoNetworkLink.getToNode().getCenter();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).rev) {
                        point2 = ((JGoLink)jGoNetworkLink.getJGoObject()).getFromPort().getFromLinkPoint();
                        point = ((JGoLink)jGoNetworkLink.getJGoObject()).getToPort().getToLinkPoint();
                    } else {
                        point2 = ((JGoLink)jGoNetworkLink.getJGoObject()).getToPort().getToLinkPoint();
                        point = ((JGoLink)jGoNetworkLink.getJGoObject()).getFromPort().getFromLinkPoint();
                    }
                    switch (this.\u00d3) {
                        case 0: 
                        case 1: {
                            n5 = (int)Math.round((double)(point2.x - ((Point)object3).x) / (double)this.\u00d2);
                            n3 = point2.x;
                            n4 = (int)Math.round((double)(point.x - ((Point)object2).x) / (double)this.\u00d2);
                            n2 = point.x;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n5 = (int)Math.round((double)(point2.y - ((Point)object3).y) / (double)this.\u00d2);
                            n3 = point2.y;
                            n4 = (int)Math.round((double)(point.y - ((Point)object2).y) / (double)this.\u00d2);
                            n2 = point.y;
                            break;
                        }
                        default: {
                            n5 = (int)Math.round((double)(point2.x - ((Point)object3).x) / (double)this.\u00d2);
                            n3 = point2.x;
                            n4 = (int)Math.round((double)(point.x - ((Point)object2).x) / (double)this.\u00d2);
                            n2 = point.x;
                        }
                    }
                    this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset = n5;
                    this.linkData((JGoNetworkLink)jGoNetworkLink).portFromPos = n3;
                    this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset = n4;
                    this.linkData((JGoNetworkLink)jGoNetworkLink).portToPos = n2;
                } else {
                    this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset = 0;
                    this.linkData((JGoNetworkLink)jGoNetworkLink).portFromPos = 0;
                    this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset = 0;
                    this.linkData((JGoNetworkLink)jGoNetworkLink).portToPos = 0;
                }
                object3 = jGoNetworkLink.getFromNode();
                object2 = jGoNetworkLink.getToNode();
                int n6 = this.nodeData((JGoNetworkNode)object3).layer;
                int n7 = this.nodeData((JGoNetworkNode)object2).layer;
                if (n6 - n7 > 1) {
                    this.linkData((JGoNetworkLink)jGoNetworkLink).valid = false;
                    JGoNetworkNode jGoNetworkNode = new JGoNetworkNode(this.getNetwork(), null);
                    jGoNetworkNode.nodeData = new JGoLayeredDigraphAutoLayoutNodeData();
                    this.nodeData((JGoNetworkNode)jGoNetworkNode).layer = n6 - 1;
                    this.getNetwork().addNode(jGoNetworkNode);
                    JGoNetworkLink jGoNetworkLink2 = this.getNetwork().linkNodes((JGoNetworkNode)object3, jGoNetworkNode, jGoNetworkLink.getJGoObject());
                    jGoNetworkLink2.linkData = new JGoLayeredDigraphAutoLayoutLinkData();
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).valid = true;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).rev = this.linkData((JGoNetworkLink)jGoNetworkLink).rev;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).portFromColOffset = n5;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).portToColOffset = 0;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).portFromPos = n3;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).portToPos = 0;
                    object3 = jGoNetworkNode;
                    --n6;
                    while (n6 - n7 > 1) {
                        jGoNetworkNode = new JGoNetworkNode(this.getNetwork(), null);
                        jGoNetworkNode.nodeData = new JGoLayeredDigraphAutoLayoutNodeData();
                        this.nodeData((JGoNetworkNode)jGoNetworkNode).layer = n6 - 1;
                        this.getNetwork().addNode(jGoNetworkNode);
                        jGoNetworkLink2 = this.getNetwork().linkNodes((JGoNetworkNode)object3, jGoNetworkNode, jGoNetworkLink.getJGoObject());
                        jGoNetworkLink2.linkData = new JGoLayeredDigraphAutoLayoutLinkData();
                        this.linkData((JGoNetworkLink)jGoNetworkLink2).valid = true;
                        this.linkData((JGoNetworkLink)jGoNetworkLink2).rev = this.linkData((JGoNetworkLink)jGoNetworkLink).rev;
                        this.linkData((JGoNetworkLink)jGoNetworkLink2).portFromColOffset = 0;
                        this.linkData((JGoNetworkLink)jGoNetworkLink2).portToColOffset = 0;
                        this.linkData((JGoNetworkLink)jGoNetworkLink2).portFromPos = 0;
                        this.linkData((JGoNetworkLink)jGoNetworkLink2).portToPos = 0;
                        object3 = jGoNetworkNode;
                        --n6;
                    }
                    jGoNetworkLink2 = this.getNetwork().linkNodes(jGoNetworkNode, (JGoNetworkNode)object2, jGoNetworkLink.getJGoObject());
                    jGoNetworkLink2.linkData = new JGoLayeredDigraphAutoLayoutLinkData();
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).valid = true;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).rev = this.linkData((JGoNetworkLink)jGoNetworkLink).rev;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).portFromColOffset = 0;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).portToColOffset = n4;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).portFromPos = 0;
                    this.linkData((JGoNetworkLink)jGoNetworkLink2).portToPos = n2;
                } else {
                    this.linkData((JGoNetworkLink)jGoNetworkLink).valid = true;
                }
            }
            ++n;
        }
    }

    protected void initializeIndices() {
        this.\u00de = new int[this.\u00d9 + 1];
        int n = 0;
        while (n <= this.\u00d9) {
            this.\u00de[n] = 0;
            ++n;
        }
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode).index = -1;
        }
        switch (this.\u00d6) {
            case 0: {
                this.naiveInitializeIndices();
                break;
            }
            case 1: {
                this.depthFirstOutInitializeIndices();
                break;
            }
            case 2: {
                this.depthFirstInInitializeIndices();
                break;
            }
            default: {
                this.naiveInitializeIndices();
            }
        }
        this.\u00da = -1;
        this.\u00dc = 0;
        this.\u00dd = 0;
        n = 0;
        while (n <= this.\u00d9) {
            if (this.\u00de[n] > this.\u00de[this.\u00dd]) {
                this.\u00da = this.\u00de[n] - 1;
                this.\u00dd = n;
            }
            if (this.\u00de[n] < this.\u00de[this.\u00dc]) {
                this.\u00dc = n;
            }
            ++n;
        }
    }

    protected void naiveInitializeIndices() {
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            int n = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).index = this.\u00de[n];
            int n2 = n;
            this.\u00de[n2] = this.\u00de[n2] + 1;
        }
    }

    protected void depthFirstOutInitializeIndices() {
        int n = this.\u00d9;
        while (n >= 0) {
            Iterator iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
                if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n || this.nodeData((JGoNetworkNode)jGoNetworkNode).index != -1) continue;
                this.depthFirstOutInitializeIndicesVisit(jGoNetworkNode);
            }
            --n;
        }
    }

    protected void depthFirstOutInitializeIndicesVisit(JGoNetworkNode jGoNetworkNode) {
        Object object;
        JGoNetworkLink jGoNetworkLink;
        int n;
        int n2 = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
        this.nodeData((JGoNetworkNode)jGoNetworkNode).index = this.\u00de[n2];
        int n3 = n2;
        this.\u00de[n3] = this.\u00de[n3] + 1;
        LinkedList linkedList = jGoNetworkNode.getSuccLinksList();
        Object[] objectArray = linkedList.toArray();
        boolean bl = true;
        while (bl) {
            bl = false;
            n = 0;
            while (n < objectArray.length - 1) {
                jGoNetworkLink = (JGoNetworkLink)objectArray[n];
                object = (JGoNetworkLink)objectArray[n + 1];
                if (this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset > this.linkData((JGoNetworkLink)object).portFromColOffset) {
                    bl = true;
                    objectArray[n] = object;
                    objectArray[n + 1] = jGoNetworkLink;
                }
                ++n;
            }
        }
        n = 0;
        while (n < objectArray.length) {
            jGoNetworkLink = (JGoNetworkLink)objectArray[n];
            if (this.linkData((JGoNetworkLink)jGoNetworkLink).valid) {
                object = jGoNetworkLink.getToNode();
                if (this.nodeData((JGoNetworkNode)object).index == -1) {
                    this.depthFirstOutInitializeIndicesVisit((JGoNetworkNode)object);
                }
            }
            ++n;
        }
    }

    protected void depthFirstInInitializeIndices() {
        int n = 0;
        while (n <= this.\u00d9) {
            Iterator iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
                if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n || this.nodeData((JGoNetworkNode)jGoNetworkNode).index != -1) continue;
                this.depthFirstInInitializeIndicesVisit(jGoNetworkNode);
            }
            ++n;
        }
    }

    protected void depthFirstInInitializeIndicesVisit(JGoNetworkNode jGoNetworkNode) {
        Object object;
        JGoNetworkLink jGoNetworkLink;
        int n;
        int n2 = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
        this.nodeData((JGoNetworkNode)jGoNetworkNode).index = this.\u00de[n2];
        int n3 = n2;
        this.\u00de[n3] = this.\u00de[n3] + 1;
        LinkedList linkedList = jGoNetworkNode.getPredLinksList();
        Object[] objectArray = linkedList.toArray();
        boolean bl = true;
        while (bl) {
            bl = false;
            n = 0;
            while (n < objectArray.length - 1) {
                jGoNetworkLink = (JGoNetworkLink)objectArray[n];
                object = (JGoNetworkLink)objectArray[n + 1];
                if (this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset > this.linkData((JGoNetworkLink)object).portToColOffset) {
                    bl = true;
                    objectArray[n] = object;
                    objectArray[n + 1] = jGoNetworkLink;
                }
                ++n;
            }
        }
        n = 0;
        while (n < objectArray.length) {
            jGoNetworkLink = (JGoNetworkLink)objectArray[n];
            if (this.linkData((JGoNetworkLink)jGoNetworkLink).valid) {
                object = jGoNetworkLink.getFromNode();
                if (this.nodeData((JGoNetworkNode)object).index == -1) {
                    this.depthFirstInInitializeIndicesVisit((JGoNetworkNode)object);
                }
            }
            ++n;
        }
    }

    protected void initializeColumns() {
        this.\u00db = -1;
        int n = 0;
        while (n <= this.\u00d9) {
            JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
            Iterator iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
                if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
                jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.\u00de[n]) {
                int n4 = this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3]);
                n2 += n4;
                this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column = n2++;
                n2 += n4;
                ++n3;
            }
            this.\u00db = Math.max(this.\u00db, n2 - 1);
            ++n;
        }
    }

    protected void reduceCrossings() {
        int n;
        int n2;
        int n3 = this.countCrossings();
        int[] nArray = this.saveLayout();
        int n4 = 0;
        while (n4 < this.\u00d0) {
            n2 = 0;
            while (n2 <= this.\u00d9) {
                this.medianBarycenterCrossingReduction(n2, 1);
                this.adjacentExchangeCrossingReductionBendStraighten(n2, 1, false, 1);
                ++n2;
            }
            n = this.countCrossings();
            if (n < n3) {
                n3 = n;
                nArray = this.saveLayout();
            }
            n2 = this.\u00d9;
            while (n2 >= 0) {
                this.medianBarycenterCrossingReduction(n2, -1);
                this.adjacentExchangeCrossingReductionBendStraighten(n2, -1, false, -1);
                --n2;
            }
            n = this.countCrossings();
            if (n < n3) {
                n3 = n;
                nArray = this.saveLayout();
            }
            ++n4;
        }
        this.restoreLayout(nArray);
        n4 = 0;
        while (n4 < this.\u00d0) {
            n2 = 0;
            while (n2 <= this.\u00d9) {
                this.medianBarycenterCrossingReduction(n2, 0);
                this.adjacentExchangeCrossingReductionBendStraighten(n2, 0, false, 0);
                ++n2;
            }
            n = this.countCrossings();
            if (n < n3) {
                n3 = n;
                nArray = this.saveLayout();
            }
            n2 = this.\u00d9;
            while (n2 >= 0) {
                this.medianBarycenterCrossingReduction(n2, 0);
                this.adjacentExchangeCrossingReductionBendStraighten(n2, 0, false, 0);
                --n2;
            }
            n = this.countCrossings();
            if (n < n3) {
                n3 = n;
                nArray = this.saveLayout();
            }
            ++n4;
        }
        this.restoreLayout(nArray);
        switch (this.\u00d8) {
            case 0: {
                int n5 = n3 + 1;
                while (this.countCrossings() < n5) {
                    n5 = this.countCrossings();
                    int n6 = this.\u00d9;
                    while (n6 >= 0) {
                        int n7 = 0;
                        while (n7 <= n6) {
                            boolean bl = true;
                            while (bl) {
                                bl = false;
                                n2 = n6;
                                while (n2 >= n7) {
                                    bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, -1, false, -1) || bl;
                                    --n2;
                                }
                            }
                            n = this.countCrossings();
                            if (n >= n3) {
                                this.restoreLayout(nArray);
                            } else {
                                n3 = n;
                                nArray = this.saveLayout();
                            }
                            bl = true;
                            while (bl) {
                                bl = false;
                                n2 = n6;
                                while (n2 >= n7) {
                                    bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, 1, false, 1) || bl;
                                    --n2;
                                }
                            }
                            n = this.countCrossings();
                            if (n >= n3) {
                                this.restoreLayout(nArray);
                            } else {
                                n3 = n;
                                nArray = this.saveLayout();
                            }
                            bl = true;
                            while (bl) {
                                bl = false;
                                n2 = n7;
                                while (n2 <= n6) {
                                    bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, 1, false, 1) || bl;
                                    ++n2;
                                }
                            }
                            if (n >= n3) {
                                this.restoreLayout(nArray);
                            } else {
                                n3 = n;
                                nArray = this.saveLayout();
                            }
                            bl = true;
                            while (bl) {
                                bl = false;
                                n2 = n7;
                                while (n2 <= n6) {
                                    bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, -1, false, -1) || bl;
                                    ++n2;
                                }
                            }
                            if (n >= n3) {
                                this.restoreLayout(nArray);
                            } else {
                                n3 = n;
                                nArray = this.saveLayout();
                            }
                            bl = true;
                            while (bl) {
                                bl = false;
                                n2 = n6;
                                while (n2 >= n7) {
                                    bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, 0, false, 0) || bl;
                                    --n2;
                                }
                            }
                            if (n >= n3) {
                                this.restoreLayout(nArray);
                            } else {
                                n3 = n;
                                nArray = this.saveLayout();
                            }
                            bl = true;
                            while (bl) {
                                bl = false;
                                n2 = n7;
                                while (n2 <= n6) {
                                    bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, 0, false, 0) || bl;
                                    ++n2;
                                }
                            }
                            if (n >= n3) {
                                this.restoreLayout(nArray);
                            } else {
                                n3 = n;
                                nArray = this.saveLayout();
                            }
                            ++n7;
                        }
                        --n6;
                    }
                }
                break;
            }
            case 1: {
                int n8 = this.\u00d9;
                int n9 = 0;
                int n10 = n3 + 1;
                while (this.countCrossings() < n10) {
                    n10 = this.countCrossings();
                    boolean bl = true;
                    while (bl) {
                        bl = false;
                        n2 = n8;
                        while (n2 >= n9) {
                            bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, -1, false, -1) || bl;
                            --n2;
                        }
                    }
                    n = this.countCrossings();
                    if (n >= n3) {
                        this.restoreLayout(nArray);
                    } else {
                        n3 = n;
                        nArray = this.saveLayout();
                    }
                    bl = true;
                    while (bl) {
                        bl = false;
                        n2 = n8;
                        while (n2 >= n9) {
                            bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, 1, false, 1) || bl;
                            --n2;
                        }
                    }
                    n = this.countCrossings();
                    if (n >= n3) {
                        this.restoreLayout(nArray);
                    } else {
                        n3 = n;
                        nArray = this.saveLayout();
                    }
                    bl = true;
                    while (bl) {
                        bl = false;
                        n2 = n9;
                        while (n2 <= n8) {
                            bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, 1, false, 1) || bl;
                            ++n2;
                        }
                    }
                    if (n >= n3) {
                        this.restoreLayout(nArray);
                    } else {
                        n3 = n;
                        nArray = this.saveLayout();
                    }
                    bl = true;
                    while (bl) {
                        bl = false;
                        n2 = n9;
                        while (n2 <= n8) {
                            bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, -1, false, -1) || bl;
                            ++n2;
                        }
                    }
                    if (n >= n3) {
                        this.restoreLayout(nArray);
                    } else {
                        n3 = n;
                        nArray = this.saveLayout();
                    }
                    bl = true;
                    while (bl) {
                        bl = false;
                        n2 = n8;
                        while (n2 >= n9) {
                            bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, 0, false, 0) || bl;
                            --n2;
                        }
                    }
                    if (n >= n3) {
                        this.restoreLayout(nArray);
                    } else {
                        n3 = n;
                        nArray = this.saveLayout();
                    }
                    bl = true;
                    while (bl) {
                        bl = false;
                        n2 = n9;
                        while (n2 <= n8) {
                            bl = this.adjacentExchangeCrossingReductionBendStraighten(n2, 0, false, 0) || bl;
                            ++n2;
                        }
                    }
                    if (n >= n3) {
                        this.restoreLayout(nArray);
                        continue;
                    }
                    n3 = n;
                    nArray = this.saveLayout();
                }
                break;
            }
        }
        this.restoreLayout(nArray);
    }

    protected boolean medianBarycenterCrossingReduction(int n, int n2) {
        JGoNetworkNode jGoNetworkNode;
        boolean bl = false;
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
            jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
        }
        double[] dArray = this.medians(n, n2);
        double[] dArray2 = this.barycenters(n, n2);
        int n3 = 0;
        while (n3 < this.\u00de[n]) {
            if (dArray2[n3] == -1.0) {
                dArray2[n3] = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column;
            }
            if (dArray[n3] == -1.0) {
                dArray[n3] = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column;
            }
            ++n3;
        }
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            n3 = 0;
            while (n3 < this.\u00de[n] - 1) {
                if (dArray[n3 + 1] < dArray[n3] || dArray[n3 + 1] == dArray[n3] && dArray2[n3 + 1] < dArray2[n3]) {
                    bl = true;
                    bl2 = true;
                    double d = dArray[n3];
                    dArray[n3] = dArray[n3 + 1];
                    dArray[n3 + 1] = d;
                    double d2 = dArray2[n3];
                    dArray2[n3] = dArray2[n3 + 1];
                    dArray2[n3 + 1] = d2;
                    jGoNetworkNode = jGoNetworkNodeArray[n3];
                    jGoNetworkNodeArray[n3] = jGoNetworkNodeArray[n3 + 1];
                    jGoNetworkNodeArray[n3 + 1] = jGoNetworkNode;
                }
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < this.\u00de[n]) {
            this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).index = n3;
            ++n3;
        }
        int n4 = 0;
        n3 = 0;
        while (n3 < this.\u00de[n]) {
            int n5 = this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3]);
            n4 += n5;
            this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column = n4++;
            n4 += n5;
            ++n3;
        }
        return bl;
    }

    protected boolean adjacentExchangeCrossingReductionBendStraighten(int n, int n2, boolean bl, int n3) {
        int n4;
        JGoNetworkNode jGoNetworkNode;
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
            jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
        }
        int[] nArray = this.crossingMatrix(n, n2);
        double[] dArray = this.barycenters(n, -1);
        if (!bl || n3 > 0) {
            int n5 = 0;
            while (n5 < this.\u00de[n]) {
                dArray[n5] = -1.0;
                ++n5;
            }
        }
        double[] dArray2 = this.barycenters(n, 1);
        if (!bl || n3 < 0) {
            int n6 = 0;
            while (n6 < this.\u00de[n]) {
                dArray2[n6] = -1.0;
                ++n6;
            }
        }
        LinkedList linkedList = new LinkedList();
        boolean bl2 = false;
        boolean bl3 = true;
        while (bl3) {
            bl3 = false;
            n4 = 0;
            while (n4 < this.\u00de[n] - 1) {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                Object object;
                int n12 = nArray[this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4]).index * this.\u00de[n] + this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4 + 1]).index];
                int n13 = nArray[this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4 + 1]).index * this.\u00de[n] + this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4]).index];
                int n14 = 0;
                int n15 = 0;
                int n16 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4]).column;
                int n17 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4 + 1]).column;
                int n18 = n16 - this.getNodeMinColumnSpace(jGoNetworkNodeArray[n4]) + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n4 + 1]);
                int n19 = n17 - this.getNodeMinColumnSpace(jGoNetworkNodeArray[n4]) + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n4 + 1]);
                double d = 0.0;
                double d2 = 0.0;
                LinkedList linkedList2 = bl && (n3 < 0 || n3 == 0) ? jGoNetworkNodeArray[n4].getPredLinksList() : linkedList;
                iterator = linkedList2.iterator();
                while (iterator.hasNext()) {
                    object = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)object).valid || this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).layer == n) continue;
                    double d3 = this.getLinkStraightenWeight((JGoNetworkLink)object);
                    n11 = this.linkData((JGoNetworkLink)object).portFromColOffset;
                    n10 = this.linkData((JGoNetworkLink)object).portToColOffset;
                    n9 = this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).column;
                    d += (double)(Math.abs(n16 + n10 - (n9 + n11)) + 1) * d3;
                    d2 += (double)(Math.abs(n19 + n10 - (n9 + n11)) + 1) * d3;
                }
                linkedList2 = jGoNetworkNodeArray[n4].getPredLinksList();
                iterator = linkedList2.iterator();
                while (iterator.hasNext()) {
                    object = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)object).valid || this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).layer != n) continue;
                    JGoNetworkNode jGoNetworkNode2 = ((JGoNetworkLink)object).getFromNode();
                    int n20 = 0;
                    while (jGoNetworkNodeArray[n20] != jGoNetworkNode2) {
                        ++n20;
                    }
                    if (n20 < n4) {
                        n14 += 2 * (n4 - n20);
                        n15 += 2 * (n4 + 1 - n20);
                    }
                    if (n20 == n4 + 1) {
                        ++n14;
                    }
                    if (n20 <= n4 + 1) continue;
                    n14 += 4 * (n20 - n4);
                    n15 += 4 * (n20 - (n4 + 1));
                }
                object = bl && (n3 > 0 || n3 == 0) ? jGoNetworkNodeArray[n4].getSuccLinksList() : linkedList;
                iterator = ((AbstractSequentialList)object).iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer == n) continue;
                    double d4 = this.getLinkStraightenWeight(jGoNetworkLink);
                    n10 = this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset;
                    n9 = this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset;
                    n8 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).column;
                    d += (double)(Math.abs(n16 + n10 - (n8 + n9)) + 1) * d4;
                    d2 += (double)(Math.abs(n19 + n10 - (n8 + n9)) + 1) * d4;
                }
                object = jGoNetworkNodeArray[n4].getSuccLinksList();
                iterator = ((AbstractSequentialList)object).iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer != n) continue;
                    JGoNetworkNode jGoNetworkNode3 = jGoNetworkLink.getToNode();
                    n11 = 0;
                    while (jGoNetworkNodeArray[n11] != jGoNetworkNode3) {
                        ++n11;
                    }
                    if (n11 != n4 + 1) continue;
                    ++n15;
                }
                LinkedList linkedList3 = bl && (n3 < 0 || n3 == 0) ? jGoNetworkNodeArray[n4 + 1].getPredLinksList() : linkedList;
                iterator = linkedList3.iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).layer == n) continue;
                    double d5 = this.getLinkStraightenWeight(jGoNetworkLink);
                    n9 = this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset;
                    n8 = this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset;
                    n7 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).column;
                    d += (double)(Math.abs(n17 + n8 - (n7 + n9)) + 1) * d5;
                    d2 += (double)(Math.abs(n18 + n8 - (n7 + n9)) + 1) * d5;
                }
                linkedList3 = jGoNetworkNodeArray[n4 + 1].getPredLinksList();
                iterator = linkedList3.iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getFromNode()).layer != n) continue;
                    JGoNetworkNode jGoNetworkNode4 = jGoNetworkLink.getFromNode();
                    n10 = 0;
                    while (jGoNetworkNodeArray[n10] != jGoNetworkNode4) {
                        ++n10;
                    }
                    if (n10 < n4) {
                        n14 += 2 * (n4 + 1 - n10);
                        n15 += 2 * (n4 - n10);
                    }
                    if (n10 == n4) {
                        ++n15;
                    }
                    if (n10 <= n4 + 1) continue;
                    n14 += 4 * (n10 - (n4 + 1));
                    n15 += 4 * (n10 - n4);
                }
                LinkedList linkedList4 = bl && (n3 > 0 || n3 == 0) ? jGoNetworkNodeArray[n4 + 1].getSuccLinksList() : linkedList;
                iterator = linkedList4.iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer == n) continue;
                    double d6 = this.getLinkStraightenWeight(jGoNetworkLink);
                    n8 = this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset;
                    n7 = this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset;
                    int n21 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).column;
                    d += (double)(Math.abs(n17 + n8 - (n21 + n7)) + 1) * d6;
                    d2 += (double)(Math.abs(n18 + n8 - (n21 + n7)) + 1) * d6;
                }
                linkedList4 = jGoNetworkNodeArray[n4 + 1].getSuccLinksList();
                iterator = linkedList4.iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer != n) continue;
                    JGoNetworkNode jGoNetworkNode5 = jGoNetworkLink.getToNode();
                    n9 = 0;
                    while (jGoNetworkNodeArray[n9] != jGoNetworkNode5) {
                        ++n9;
                    }
                    if (n9 != n4) continue;
                    ++n14;
                }
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = dArray[this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4]).index];
                double d10 = dArray2[this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4]).index];
                double d11 = dArray[this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4 + 1]).index];
                double d12 = dArray2[this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4 + 1]).index];
                if (d9 != -1.0) {
                    d7 += Math.abs(d9 - (double)n16);
                    d8 += Math.abs(d9 - (double)n19);
                }
                if (d10 != -1.0) {
                    d7 += Math.abs(d10 - (double)n16);
                    d8 += Math.abs(d10 - (double)n19);
                }
                if (d11 != -1.0) {
                    d7 += Math.abs(d11 - (double)n17);
                    d8 += Math.abs(d11 - (double)n18);
                }
                if (d12 != -1.0) {
                    d7 += Math.abs(d12 - (double)n17);
                    d8 += Math.abs(d12 - (double)n18);
                }
                if (n15 < n14 || n15 == n14 && n13 < n12 || n15 == n14 && n13 == n12 && d2 < d || n15 == n14 && n13 == n12 && d2 == d && d8 < d7) {
                    bl2 = true;
                    bl3 = true;
                    this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4]).column = n19;
                    this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4 + 1]).column = n18;
                    jGoNetworkNode = jGoNetworkNodeArray[n4];
                    jGoNetworkNodeArray[n4] = jGoNetworkNodeArray[n4 + 1];
                    jGoNetworkNodeArray[n4 + 1] = jGoNetworkNode;
                }
                ++n4;
            }
        }
        n4 = 0;
        while (n4 < this.\u00de[n]) {
            this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n4]).index = n4;
            ++n4;
        }
        return bl2;
    }

    protected void straightenAndPack() {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[this.\u00d9 + 1];
        int n4 = 0;
        while (n4 <= this.\u00d9) {
            nArray[n4] = 0;
            ++n4;
        }
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            n3 = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
            n2 = this.nodeData((JGoNetworkNode)jGoNetworkNode).column;
            n = this.getNodeMinColumnSpace(jGoNetworkNode);
            nArray[n3] = Math.max(nArray[n3], n2 + n);
        }
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            n3 = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
            n = this.nodeData((JGoNetworkNode)jGoNetworkNode).column;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).column = (this.\u00db - nArray[n3]) * 8 / 2 + n * 8;
        }
        this.\u00db *= 8;
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            n3 = this.\u00dd + 1;
            while (n3 <= this.\u00d9) {
                n2 = this.bendStraighten(n3, 1) || n2 != 0 ? 1 : 0;
                ++n3;
            }
            n3 = this.\u00dd - 1;
            while (n3 >= 0) {
                n2 = this.bendStraighten(n3, -1) || n2 != 0 ? 1 : 0;
                --n3;
            }
            int n5 = n2 = this.bendStraighten(this.\u00dd, 0) || n2 != 0 ? 1 : 0;
        }
        n3 = this.\u00dd + 1;
        while (n3 <= this.\u00d9) {
            this.medianStraighten(n3, 1);
            ++n3;
        }
        n3 = this.\u00dd - 1;
        while (n3 >= 0) {
            this.medianStraighten(n3, -1);
            --n3;
        }
        this.medianStraighten(this.\u00dd, 0);
        double d = this.countBends(true);
        double d2 = d + 1.0;
        while (d < d2) {
            d2 = d;
            this.componentPack(-1);
            this.componentPack(1);
            n2 = 1;
            while (n2 != 0) {
                n2 = 0;
                n2 = this.bendStraighten(this.\u00dd, 0) || n2 != 0 ? 1 : 0;
                n3 = this.\u00dd + 1;
                while (n3 <= this.\u00d9) {
                    n2 = this.bendStraighten(n3, 0) || n2 != 0 ? 1 : 0;
                    ++n3;
                }
                n3 = this.\u00dd - 1;
                while (n3 >= 0) {
                    n2 = this.bendStraighten(n3, 0) || n2 != 0 ? 1 : 0;
                    --n3;
                }
            }
            d = this.countBends(true);
        }
    }

    protected boolean bendStraighten(int n, int n2) {
        boolean bl = false;
        while (this.shiftBendStraighten(n, n2) || this.adjacentExchangeCrossingReductionBendStraighten(n, 0, true, n2)) {
            bl = true;
        }
        return bl;
    }

    protected boolean shiftBendStraighten(int n, int n2) {
        int n3;
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
            jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
        }
        double[] dArray = this.barycenters(n, -1);
        if (n2 > 0) {
            n3 = 0;
            while (n3 < this.\u00de[n]) {
                dArray[n3] = -1.0;
                ++n3;
            }
        }
        double[] dArray2 = this.barycenters(n, 1);
        if (n2 < 0) {
            n3 = 0;
            while (n3 < this.\u00de[n]) {
                dArray2[n3] = -1.0;
                ++n3;
            }
        }
        LinkedList linkedList = new LinkedList();
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            n3 = 0;
            while (n3 < this.\u00de[n]) {
                int n4;
                int n5;
                double d;
                Object object;
                int n6 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column;
                int n7 = this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3]);
                int n8 = n3 - 1 < 0 || n6 - this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 - 1]).column - 1 > n7 + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 - 1]) ? n6 - 1 : n6;
                int n9 = n3 + 1 >= this.\u00de[n] || this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 + 1]).column - n6 - 1 > n7 + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 + 1]) ? n6 + 1 : n6;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                LinkedList linkedList2 = n2 < 0 || n2 == 0 ? jGoNetworkNodeArray[n3].getPredLinksList() : linkedList;
                iterator = linkedList2.iterator();
                while (iterator.hasNext()) {
                    object = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)object).valid || this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).layer == n) continue;
                    d = this.getLinkStraightenWeight((JGoNetworkLink)object);
                    int n10 = this.linkData((JGoNetworkLink)object).portFromColOffset;
                    n5 = this.linkData((JGoNetworkLink)object).portToColOffset;
                    n4 = this.nodeData((JGoNetworkNode)((JGoNetworkLink)object).getFromNode()).column;
                    d2 += (double)(Math.abs(n6 + n5 - (n4 + n10)) + 1) * d;
                    d3 += (double)(Math.abs(n8 + n5 - (n4 + n10)) + 1) * d;
                    d4 += (double)(Math.abs(n9 + n5 - (n4 + n10)) + 1) * d;
                }
                object = n2 > 0 || n2 == 0 ? jGoNetworkNodeArray[n3].getSuccLinksList() : linkedList;
                iterator = ((AbstractSequentialList)object).iterator();
                while (iterator.hasNext()) {
                    JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
                    if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid || this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).layer == n) continue;
                    double d5 = this.getLinkStraightenWeight(jGoNetworkLink);
                    n5 = this.linkData((JGoNetworkLink)jGoNetworkLink).portFromColOffset;
                    n4 = this.linkData((JGoNetworkLink)jGoNetworkLink).portToColOffset;
                    int n11 = this.nodeData((JGoNetworkNode)jGoNetworkLink.getToNode()).column;
                    d2 += (double)(Math.abs(n6 + n5 - (n11 + n4)) + 1) * d5;
                    d3 += (double)(Math.abs(n8 + n5 - (n11 + n4)) + 1) * d5;
                    d4 += (double)(Math.abs(n9 + n5 - (n11 + n4)) + 1) * d5;
                }
                d = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = dArray[this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).index];
                double d9 = dArray2[this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).index];
                if (d8 != -1.0) {
                    d += Math.abs(d8 - (double)n6);
                    d6 += Math.abs(d8 - (double)n8);
                    d7 += Math.abs(d8 - (double)n9);
                }
                if (d9 != -1.0) {
                    d += Math.abs(d9 - (double)n6);
                    d6 += Math.abs(d9 - (double)n8);
                    d7 += Math.abs(d9 - (double)n9);
                }
                if (d3 < d2 || d3 == d2 && d6 < d) {
                    bl = true;
                    bl2 = true;
                    this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column = n8;
                }
                if (d4 < d2 || d4 == d2 && d7 < d) {
                    bl = true;
                    bl2 = true;
                    this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column = n9;
                }
                ++n3;
            }
        }
        this.normalize();
        return bl;
    }

    protected boolean medianStraighten(int n, int n2) {
        JGoNetworkNode[] jGoNetworkNodeArray = new JGoNetworkNode[this.\u00de[n]];
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).layer != n) continue;
            jGoNetworkNodeArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).index] = jGoNetworkNode;
        }
        double[] dArray = this.medians(n, n2);
        int[] nArray = new int[this.\u00de[n]];
        int n3 = 0;
        while (n3 < this.\u00de[n]) {
            nArray[n3] = (int)dArray[n3];
            ++n3;
        }
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            n3 = 0;
            while (n3 < this.\u00de[n]) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column;
                int n9 = this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3]);
                int n10 = 0;
                if (nArray[n3] == -1) {
                    if (n3 == 0 && n3 == this.\u00de[n] - 1) {
                        n10 = n8;
                    } else if (n3 == 0) {
                        n7 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 + 1]).column;
                        n10 = n7 - n8 == n9 + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 + 1]) ? n8 - 1 : n8;
                    } else if (n3 == this.\u00de[n] - 1) {
                        n7 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 - 1]).column;
                        n10 = n8 - n7 == n9 + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 - 1]) ? n8 + 1 : n8;
                    } else {
                        n7 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 - 1]).column;
                        n6 = n7 + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 - 1]) + n9 + 1;
                        n5 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 + 1]).column;
                        n4 = n5 - this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 + 1]) - n9 - 1;
                        n10 = (n6 + n4) / 2;
                    }
                } else if (n3 == 0 && n3 == this.\u00de[n] - 1) {
                    n10 = nArray[n3];
                } else if (n3 == 0) {
                    n7 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 + 1]).column;
                    n6 = n7 - this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 + 1]) - n9 - 1;
                    n10 = Math.min(nArray[n3], n6);
                } else if (n3 == this.\u00de[n] - 1) {
                    n7 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 - 1]).column;
                    n6 = n7 + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 - 1]) + n9 + 1;
                    n10 = Math.max(nArray[n3], n6);
                } else {
                    n7 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 - 1]).column;
                    n6 = n7 + this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 - 1]) + n9 + 1;
                    n5 = this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3 + 1]).column;
                    n4 = n5 - this.getNodeMinColumnSpace(jGoNetworkNodeArray[n3 + 1]) - n9 - 1;
                    if (n6 < nArray[n3] && nArray[n3] < n4) {
                        n10 = nArray[n3];
                    } else if (n6 >= nArray[n3]) {
                        n10 = n6;
                    } else if (n4 <= nArray[n3]) {
                        n10 = n4;
                    }
                }
                if (n10 != n8) {
                    bl = true;
                    bl2 = true;
                    this.nodeData((JGoNetworkNode)jGoNetworkNodeArray[n3]).column = n10;
                }
                ++n3;
            }
        }
        this.normalize();
        return bl;
    }

    protected void pack() {
        int n = 0;
        while (n <= this.\u00db) {
            while (this.packAux(n, 1)) {
            }
            ++n;
        }
        this.normalize();
    }

    protected boolean packAux(int n, int n2) {
        boolean bl = true;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            int n3 = this.getNodeMinColumnSpace(jGoNetworkNode);
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column - n3 > n || this.nodeData((JGoNetworkNode)jGoNetworkNode).column + n3 < n) continue;
            bl = false;
        }
        boolean bl2 = false;
        if (bl) {
            if (n2 > 0) {
                iterator = this.getNetwork().getNodeIterator();
                while (iterator.hasNext()) {
                    JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
                    if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column <= n) continue;
                    --this.nodeData((JGoNetworkNode)jGoNetworkNode).column;
                    bl2 = true;
                }
            }
            if (n2 < 0) {
                iterator = this.getNetwork().getNodeIterator();
                while (iterator.hasNext()) {
                    JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
                    if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column >= n) continue;
                    ++this.nodeData((JGoNetworkNode)jGoNetworkNode).column;
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    protected void tightPack() {
        this.pack();
        int n = 0;
        while (n < this.\u00db) {
            while (this.tightPackAux(n, 1)) {
            }
            ++n;
        }
        this.normalize();
    }

    protected boolean tightPackAux(int n, int n2) {
        int n3;
        int n4 = n;
        if (n2 > 0) {
            n4 = n + 1;
        }
        if (n2 < 0) {
            n4 = n - 1;
        }
        boolean[] blArray = new boolean[this.\u00d9 + 1];
        boolean[] blArray2 = new boolean[this.\u00d9 + 1];
        int n5 = 0;
        while (n5 <= this.\u00d9) {
            blArray[n5] = false;
            blArray2[n5] = false;
            ++n5;
        }
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            n3 = this.getNodeMinColumnSpace(jGoNetworkNode);
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column - n3 <= n && this.nodeData((JGoNetworkNode)jGoNetworkNode).column + n3 >= n) {
                blArray[this.nodeData((JGoNetworkNode)jGoNetworkNode).layer] = true;
            }
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column - n3 > n4 || this.nodeData((JGoNetworkNode)jGoNetworkNode).column + n3 < n4) continue;
            blArray2[this.nodeData((JGoNetworkNode)jGoNetworkNode).layer] = true;
        }
        boolean bl = true;
        n3 = 0;
        n5 = 0;
        while (n5 <= this.\u00d9) {
            bl = bl && (!blArray[n5] || !blArray2[n5]);
            ++n5;
        }
        if (bl) {
            JGoNetworkNode jGoNetworkNode;
            if (n2 > 0) {
                iterator = this.getNetwork().getNodeIterator();
                while (iterator.hasNext()) {
                    jGoNetworkNode = (JGoNetworkNode)iterator.next();
                    if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column <= n) continue;
                    --this.nodeData((JGoNetworkNode)jGoNetworkNode).column;
                    n3 = 1;
                }
            }
            if (n2 < 0) {
                iterator = this.getNetwork().getNodeIterator();
                while (iterator.hasNext()) {
                    jGoNetworkNode = (JGoNetworkNode)iterator.next();
                    if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column >= n) continue;
                    ++this.nodeData((JGoNetworkNode)jGoNetworkNode).column;
                    n3 = 1;
                }
            }
        }
        return n3 != 0;
    }

    protected void componentPack(int n) {
        double d;
        double d2;
        double d3;
        int[] nArray;
        int n2;
        this.tightPack();
        if (n > 0) {
            n2 = 0;
            while (n2 <= this.\u00db) {
                nArray = this.saveLayout();
                d3 = this.countBends(true);
                d2 = d3 + 1.0;
                while (d3 < d2) {
                    d2 = d3;
                    this.componentPackAux(n2, 1);
                    d = this.countBends(true);
                    if (d > d3) {
                        this.restoreLayout(nArray);
                        continue;
                    }
                    d3 = d;
                    nArray = this.saveLayout();
                }
                ++n2;
            }
        }
        if (n < 0) {
            n2 = this.\u00db;
            while (n2 >= 0) {
                nArray = this.saveLayout();
                d3 = this.countBends(true);
                d2 = d3 + 1.0;
                while (d3 < d2) {
                    d2 = d3;
                    this.componentPackAux(n2, -1);
                    d = this.countBends(true);
                    if (d > d3) {
                        this.restoreLayout(nArray);
                        continue;
                    }
                    d3 = d;
                    nArray = this.saveLayout();
                }
                --n2;
            }
        }
        this.normalize();
    }

    protected boolean componentPackAux(int n, int n2) {
        int n3;
        int n4;
        JGoNetworkNode jGoNetworkNode;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode2 = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode2).component = -1;
        }
        int n5 = 0;
        if (n2 > 0) {
            iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                jGoNetworkNode = (JGoNetworkNode)iterator.next();
                if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column - this.getNodeMinColumnSpace(jGoNetworkNode) > n) continue;
                this.nodeData((JGoNetworkNode)jGoNetworkNode).component = n5;
            }
        }
        if (n2 < 0) {
            iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                jGoNetworkNode = (JGoNetworkNode)iterator.next();
                if (this.nodeData((JGoNetworkNode)jGoNetworkNode).column + this.getNodeMinColumnSpace(jGoNetworkNode) < n) continue;
                this.nodeData((JGoNetworkNode)jGoNetworkNode).component = n5;
            }
        }
        ++n5;
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            jGoNetworkNode = (JGoNetworkNode)iterator.next();
            if (this.nodeData((JGoNetworkNode)jGoNetworkNode).component != -1) continue;
            this.componentUnset(jGoNetworkNode, n5, -1, true, true);
            ++n5;
        }
        boolean[] blArray = new boolean[n5 * n5];
        int n6 = 0;
        while (n6 < n5 * n5) {
            blArray[n6] = false;
            ++n6;
        }
        int[] nArray = new int[(this.\u00d9 + 1) * (this.\u00db + 1)];
        n6 = 0;
        while (n6 < (this.\u00d9 + 1) * (this.\u00db + 1)) {
            nArray[n6] = -1;
            ++n6;
        }
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode3 = (JGoNetworkNode)iterator.next();
            n4 = this.nodeData((JGoNetworkNode)jGoNetworkNode3).layer;
            int n7 = this.getNodeMinColumnSpace(jGoNetworkNode3);
            n3 = Math.max(0, this.nodeData((JGoNetworkNode)jGoNetworkNode3).column - n7);
            int n8 = Math.min(this.\u00db, this.nodeData((JGoNetworkNode)jGoNetworkNode3).column + n7);
            int n9 = n3;
            while (n9 <= n8) {
                nArray[n4 * (this.\u00db + 1) + n9] = this.nodeData((JGoNetworkNode)jGoNetworkNode3).component;
                ++n9;
            }
        }
        int n10 = 0;
        while (n10 <= this.\u00d9) {
            if (n2 > 0) {
                n4 = 0;
                while (n4 < this.\u00db) {
                    if (nArray[n10 * (this.\u00db + 1) + n4] != -1 && nArray[n10 * (this.\u00db + 1) + n4 + 1] != -1 && nArray[n10 * (this.\u00db + 1) + n4] != nArray[n10 * (this.\u00db + 1) + n4 + 1]) {
                        blArray[nArray[n10 * (this.\u00db + 1) + n4] * n5 + nArray[n10 * (this.\u00db + 1) + n4 + 1]] = true;
                    }
                    ++n4;
                }
            }
            if (n2 < 0) {
                n4 = this.\u00db;
                while (n4 > 0) {
                    if (nArray[n10 * (this.\u00db + 1) + n4] != -1 && nArray[n10 * (this.\u00db + 1) + n4 - 1] != -1 && nArray[n10 * (this.\u00db + 1) + n4] != nArray[n10 * (this.\u00db + 1) + n4 - 1]) {
                        blArray[nArray[n10 * (this.\u00db + 1) + n4] * n5 + nArray[n10 * (this.\u00db + 1) + n4 - 1]] = true;
                    }
                    --n4;
                }
            }
            ++n10;
        }
        boolean[] blArray2 = new boolean[n5];
        n6 = 0;
        while (n6 < n5) {
            blArray2[n6] = true;
            ++n6;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.addFirst(new Integer(0));
        n3 = 0;
        while (n3 == 0) {
            try {
                int n11 = (Integer)linkedList.removeLast();
                if (!blArray2[n11]) continue;
                blArray2[n11] = false;
                n6 = 0;
                while (n6 < n5) {
                    if (blArray[n11 * n5 + n6]) {
                        linkedList.addFirst(new Integer(n6));
                    }
                    ++n6;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                n3 = 1;
            }
        }
        boolean bl = false;
        if (n2 > 0) {
            iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                JGoNetworkNode jGoNetworkNode4 = (JGoNetworkNode)iterator.next();
                if (!blArray2[this.nodeData((JGoNetworkNode)jGoNetworkNode4).component]) continue;
                --this.nodeData((JGoNetworkNode)jGoNetworkNode4).column;
                bl = true;
            }
        }
        if (n2 < 0) {
            iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                JGoNetworkNode jGoNetworkNode5 = (JGoNetworkNode)iterator.next();
                if (!blArray2[this.nodeData((JGoNetworkNode)jGoNetworkNode5).component]) continue;
                ++this.nodeData((JGoNetworkNode)jGoNetworkNode5).column;
                bl = true;
            }
        }
        return bl;
    }

    protected void layoutNodesAndLinks() {
        this.getDocument().fireForedate(18, 0, null);
        this.getDocument().setSuspendUpdates(true);
        this.layoutNodes();
        this.layoutLinks();
        this.getDocument().setSuspendUpdates(false);
        this.getDocument().fireUpdate(18, 0, null, 0, null);
    }

    protected void layoutNodes() {
        int n;
        Object object;
        int[] nArray = new int[this.\u00d9 + 1];
        int n2 = 0;
        while (n2 <= this.\u00d9) {
            nArray[n2] = 0;
            ++n2;
        }
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkNode)iterator.next();
            n2 = this.nodeData((JGoNetworkNode)object).layer;
            n = this.getNodeMinLayerSpace((JGoNetworkNode)object);
            nArray[n2] = Math.max(nArray[n2], n);
        }
        object = new int[this.\u00d9 + 1];
        n = 0;
        n2 = 0;
        while (n2 <= this.\u00d9) {
            object[n2] = n += nArray[n2];
            ++n;
            n += nArray[n2];
            ++n2;
        }
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode = (JGoNetworkNode)iterator.next();
            n2 = this.nodeData((JGoNetworkNode)jGoNetworkNode).layer;
            int n3 = this.nodeData((JGoNetworkNode)jGoNetworkNode).column;
            Point point = new Point();
            switch (this.\u00d3) {
                case 0: {
                    point.x = this.\u00d2 * (n3 + 1);
                    point.y = this.\u00d1 * (object[n2] + true);
                    break;
                }
                case 1: {
                    point.x = this.\u00d2 * (n3 + 1);
                    point.y = this.\u00d1 * (n - object[n2]);
                    break;
                }
                case 2: {
                    point.x = this.\u00d1 * (object[n2] + true);
                    point.y = this.\u00d2 * (n3 + 1);
                    break;
                }
                case 3: {
                    point.x = this.\u00d1 * (n - object[n2]);
                    point.y = this.\u00d2 * (n3 + 1);
                    break;
                }
                default: {
                    point.x = this.\u00d2 * (n3 + 1);
                    point.y = this.\u00d1 * (object[n2] + true);
                }
            }
            jGoNetworkNode.setCenter(point);
            jGoNetworkNode.commitPosition();
        }
    }

    protected void layoutLinks() {
        Iterator iterator = this.getNetwork().getLinkIterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator iterator2;
            Cloneable cloneable;
            boolean bl;
            JGoNetworkNode jGoNetworkNode;
            JGoNetworkNode jGoNetworkNode2;
            JGoNetworkNode jGoNetworkNode3;
            JGoPort jGoPort;
            JGoPort jGoPort2;
            JGoLink jGoLink;
            JGoNetworkLink jGoNetworkLink = (JGoNetworkLink)iterator.next();
            if (this.linkData((JGoNetworkLink)jGoNetworkLink).valid) {
                // empty if block
            }
            if (!this.linkData((JGoNetworkLink)jGoNetworkLink).valid && !this.linkData((JGoNetworkLink)jGoNetworkLink).rev) {
                jGoLink = (JGoLink)jGoNetworkLink.getJGoObject();
                jGoPort2 = jGoLink.getFromPort();
                jGoPort = jGoLink.getToPort();
                jGoLink.removeAllPoints();
                jGoNetworkNode3 = jGoNetworkLink.getFromNode();
                jGoNetworkNode2 = jGoNetworkLink.getToNode();
                jGoNetworkNode = new JGoNetworkNode();
                bl = true;
                while (jGoNetworkNode3 != jGoNetworkNode2) {
                    cloneable = jGoNetworkNode3.getSuccLinksList();
                    iterator2 = ((AbstractSequentialList)((Object)cloneable)).iterator();
                    while (iterator2.hasNext()) {
                        object = (JGoNetworkLink)iterator2.next();
                        if (((JGoNetworkLink)object).getJGoObject() != jGoNetworkLink.getJGoObject()) continue;
                        jGoNetworkNode = ((JGoNetworkLink)object).getToNode();
                    }
                    if (jGoNetworkNode != jGoNetworkNode2) {
                        if (bl) {
                            bl = false;
                            object = jGoPort2.getFromLinkPoint();
                            jGoLink.addPoint((Point)object);
                        }
                        jGoLink.addPoint(jGoNetworkNode.getCenter());
                    }
                    jGoNetworkNode3 = jGoNetworkNode;
                }
                cloneable = jGoPort.getToLinkPoint();
                jGoLink.addPoint((Point)cloneable);
            }
            if (this.linkData((JGoNetworkLink)jGoNetworkLink).valid || !this.linkData((JGoNetworkLink)jGoNetworkLink).rev) continue;
            jGoLink = (JGoLink)jGoNetworkLink.getJGoObject();
            jGoPort2 = jGoLink.getFromPort();
            jGoPort = jGoLink.getToPort();
            jGoLink.removeAllPoints();
            jGoNetworkNode3 = jGoNetworkLink.getFromNode();
            jGoNetworkNode2 = jGoNetworkLink.getToNode();
            jGoNetworkNode = new JGoNetworkNode();
            bl = true;
            while (jGoNetworkNode3 != jGoNetworkNode2) {
                cloneable = jGoNetworkNode2.getPredLinksList();
                iterator2 = ((AbstractSequentialList)((Object)cloneable)).iterator();
                while (iterator2.hasNext()) {
                    object = (JGoNetworkLink)iterator2.next();
                    if (((JGoNetworkLink)object).getJGoObject() != jGoNetworkLink.getJGoObject()) continue;
                    jGoNetworkNode = ((JGoNetworkLink)object).getFromNode();
                }
                if (jGoNetworkNode != jGoNetworkNode3) {
                    if (bl) {
                        bl = false;
                        object = jGoPort2.getFromLinkPoint();
                        jGoLink.addPoint((Point)object);
                    }
                    jGoLink.addPoint(jGoNetworkNode.getCenter());
                }
                jGoNetworkNode2 = jGoNetworkNode;
            }
            cloneable = jGoPort.getToLinkPoint();
            jGoLink.addPoint((Point)cloneable);
        }
    }

    protected JGoLayeredDigraphAutoLayoutNodeData nodeData(JGoNetworkNode jGoNetworkNode) {
        return (JGoLayeredDigraphAutoLayoutNodeData)jGoNetworkNode.nodeData;
    }

    protected JGoLayeredDigraphAutoLayoutLinkData linkData(JGoNetworkLink jGoNetworkLink) {
        return (JGoLayeredDigraphAutoLayoutLinkData)jGoNetworkLink.linkData;
    }

    /*
     * Loose catch block
     */
    protected void printNetworkData() {
        block21: {
            Object object;
            RandomAccessFile randomAccessFile = null;
            randomAccessFile = new RandomAccessFile("javaout.txt", "rw");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.writeBytes("Link Data\r\n\r\n");
            Iterator iterator = this.getNetwork().getLinkIterator();
            while (iterator.hasNext()) {
                object = (JGoNetworkLink)iterator.next();
                if (this.linkData((JGoNetworkLink)object).valid) {
                    randomAccessFile.writeBytes("1,");
                } else {
                    randomAccessFile.writeBytes("0,");
                }
                if (this.linkData((JGoNetworkLink)object).rev) {
                    randomAccessFile.writeBytes("1,");
                } else {
                    randomAccessFile.writeBytes("0,");
                }
                if (this.linkData((JGoNetworkLink)object).forest) {
                    randomAccessFile.writeBytes("1,");
                } else {
                    randomAccessFile.writeBytes("0,");
                }
                randomAccessFile.writeBytes(this.linkData((JGoNetworkLink)object).portFromColOffset + "," + this.linkData((JGoNetworkLink)object).portToColOffset + "\r\n");
            }
            randomAccessFile.writeBytes("\r\n\r\nNode Data\r\n\r\n");
            iterator = this.getNetwork().getNodeIterator();
            while (iterator.hasNext()) {
                object = (JGoNetworkNode)iterator.next();
                randomAccessFile.writeBytes(this.nodeData((JGoNetworkNode)object).layer + "," + this.nodeData((JGoNetworkNode)object).column + "," + this.nodeData((JGoNetworkNode)object).index);
                if (this.nodeData((JGoNetworkNode)object).valid) {
                    randomAccessFile.writeBytes(",1,");
                } else {
                    randomAccessFile.writeBytes(",0,");
                }
                randomAccessFile.writeBytes(this.nodeData((JGoNetworkNode)object).discover + "," + this.nodeData((JGoNetworkNode)object).finish + "," + this.nodeData((JGoNetworkNode)object).component + "\r\n");
            }
            randomAccessFile.writeBytes("\r\n\r\n");
            Object var5_5 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                break block21;
            }
            catch (Exception exception) {}
            break block21;
            {
                catch (IOException iOException) {
                    Object var5_6 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        break block21;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public int getLayerSpacing() {
        return this.\u00d1;
    }

    public int getColumnSpacing() {
        return this.\u00d2;
    }

    public int getDirectionOption() {
        return this.\u00d3;
    }

    public int getCycleremoveOption() {
        return this.\u00d4;
    }

    public int getLayereingOption() {
        return this.\u00d5;
    }

    public int getInitializeOption() {
        return this.\u00d6;
    }

    public int getIterations() {
        return this.\u00d0;
    }

    public int getAggressiveOption() {
        return this.\u00d8;
    }

    public int getMaxLayer() {
        return this.\u00d9;
    }

    public int getMaxIndex() {
        return this.\u00da;
    }

    public int getMaxColumn() {
        return this.\u00db;
    }

    public int getMinIndexLayer() {
        return this.\u00dc;
    }

    public int getMaxIndexLayer() {
        return this.\u00dd;
    }

    public int[] getIndices() {
        return this.\u00de;
    }
}

