/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.fo.Constants;
import org.apache.fop.util.CommandLineLogger;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CommandLineOptions
implements Constants {
    private Boolean showConfiguration = Boolean.FALSE;
    private Boolean suppressLowLevelAreas = Boolean.FALSE;
    private File userConfigFile = null;
    private File fofile = null;
    private File xsltfile = null;
    private File xmlfile = null;
    private File outfile = null;
    private int inputmode = 0;
    private int outputmode = 0;
    private FOUserAgent foUserAgent;
    private Log log;
    private Vector xsltParams = null;
    static /* synthetic */ Class class$org$apache$fop$util$CommandLineLogger;

    public CommandLineOptions() {
        LogFactory logFactory = LogFactory.getFactory();
        if (System.getProperty("org.apache.commons.logging.Log") == null) {
            logFactory.setAttribute("org.apache.commons.logging.Log", (class$org$apache$fop$util$CommandLineLogger == null ? (class$org$apache$fop$util$CommandLineLogger = CommandLineOptions.class$("org.apache.fop.util.CommandLineLogger")) : class$org$apache$fop$util$CommandLineLogger).getName());
            this.setLogLevel("info");
        }
        this.log = LogFactory.getLog("FOP");
    }

    public void parse(String[] args) throws FOPException, IOException {
        boolean optionsParsed = true;
        this.foUserAgent = new FOUserAgent();
        try {
            optionsParsed = this.parseOptions(args);
            if (optionsParsed) {
                if (this.showConfiguration == Boolean.TRUE) {
                    this.dumpConfiguration();
                }
                this.checkSettings();
                this.createUserConfig();
            }
        }
        catch (FOPException e) {
            CommandLineOptions.printUsage();
            throw e;
        }
        catch (FileNotFoundException e) {
            CommandLineOptions.printUsage();
            throw e;
        }
        this.foUserAgent.setInputHandler(this.createInputHandler());
    }

    public Log getLogger() {
        return this.log;
    }

    private boolean parseOptions(String[] args) throws FOPException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-x") || args[i].equals("--dump-config")) {
                this.showConfiguration = Boolean.TRUE;
                continue;
            }
            if (args[i].equals("-c")) {
                i += this.parseConfigurationOption(args, i);
                continue;
            }
            if (args[i].equals("-l")) {
                i += this.parseLanguageOption(args, i);
                continue;
            }
            if (args[i].equals("-s")) {
                this.suppressLowLevelAreas = Boolean.TRUE;
                continue;
            }
            if (args[i].equals("-d")) {
                this.setLogLevel("debug");
                continue;
            }
            if (args[i].equals("-r")) {
                this.foUserAgent.setStrictValidation(false);
                continue;
            }
            if (args[i].equals("-dpi")) {
                i += this.parseResolution(args, i);
                continue;
            }
            if (args[i].equals("-q") || args[i].equals("--quiet")) {
                this.setLogLevel("error");
                continue;
            }
            if (args[i].equals("-fo")) {
                i += this.parseFOInputOption(args, i);
                continue;
            }
            if (args[i].equals("-xsl")) {
                i += this.parseXSLInputOption(args, i);
                continue;
            }
            if (args[i].equals("-xml")) {
                i += this.parseXMLInputOption(args, i);
                continue;
            }
            if (args[i].equals("-awt")) {
                i += this.parseAWTOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-pdf")) {
                i += this.parsePDFOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-mif")) {
                i += this.parseMIFOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-rtf")) {
                i += this.parseRTFOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-tiff")) {
                i += this.parseTIFFOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-png")) {
                i += this.parsePNGOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-print")) {
                if ((i += this.parsePrintOutputOption(args, i)) + 1 >= args.length || !args[i + 1].equals("help")) continue;
                this.printUsagePrintOutput();
                return false;
            }
            if (args[i].equals("-pcl")) {
                i += this.parsePCLOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-ps")) {
                i += this.parsePostscriptOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-txt")) {
                i += this.parseTextOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-svg")) {
                i += this.parseSVGOutputOption(args, i);
                continue;
            }
            if (args[i].charAt(0) != '-') {
                i += this.parseUnknownOption(args, i);
                continue;
            }
            if (args[i].equals("-at")) {
                i += this.parseAreaTreeOption(args, i);
                continue;
            }
            if (args[i].equals("-v")) {
                System.out.println("FOP Version " + Fop.getVersion());
                continue;
            }
            if (args[i].equals("-param")) {
                if (i + 2 < args.length) {
                    if (this.xsltParams == null) {
                        this.xsltParams = new Vector();
                    }
                    String name = args[++i];
                    this.xsltParams.addElement(name);
                    String expression = args[++i];
                    this.xsltParams.addElement(expression);
                    continue;
                }
                throw new FOPException("invalid param usage: use -param <name> <value>");
            }
            CommandLineOptions.printUsage();
            return false;
        }
        return true;
    }

    private int parseConfigurationOption(String[] args, int i) throws FOPException {
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("if you use '-c', you must specify the name of the configuration file");
        }
        this.userConfigFile = new File(args[i + 1]);
        return 1;
    }

    private int parseLanguageOption(String[] args, int i) throws FOPException {
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("if you use '-l', you must specify a language");
        }
        Locale.setDefault(new Locale(args[i + 1], ""));
        return 1;
    }

    private int parseResolution(String[] args, int i) throws FOPException {
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("if you use '-dpi', you must specify a resolution (dots per inch)");
        }
        this.foUserAgent.setResolution(Integer.parseInt(args[i + 1]));
        return 1;
    }

    private int parseFOInputOption(String[] args, int i) throws FOPException {
        this.inputmode = 1;
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the fo file for the '-fo' option");
        }
        this.fofile = new File(args[i + 1]);
        return 1;
    }

    private int parseXSLInputOption(String[] args, int i) throws FOPException {
        this.inputmode = 2;
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the stylesheet file for the '-xsl' option");
        }
        this.xsltfile = new File(args[i + 1]);
        return 1;
    }

    private int parseXMLInputOption(String[] args, int i) throws FOPException {
        this.inputmode = 2;
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the input file for the '-xml' option");
        }
        this.xmlfile = new File(args[i + 1]);
        return 1;
    }

    private int parseAWTOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(2);
        return 0;
    }

    private int parsePDFOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(1);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the pdf output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseMIFOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(3);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the mif output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseRTFOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(10);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the rtf output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseTIFFOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(11);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the tiff output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parsePNGOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(12);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the png output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parsePrintOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(4);
        return 0;
    }

    private int parsePCLOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(5);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the pdf output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parsePostscriptOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(6);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the PostScript output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseTextOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(7);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the text output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseSVGOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode(8);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the svg output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseUnknownOption(String[] args, int i) throws FOPException {
        if (this.inputmode == 0) {
            this.inputmode = 1;
            this.fofile = new File(args[i]);
        } else if (this.outputmode == 0) {
            this.outputmode = 1;
            this.outfile = new File(args[i]);
        } else {
            throw new FOPException("Don't know what to do with " + args[i]);
        }
        return 0;
    }

    private int parseAreaTreeOption(String[] args, int i) throws FOPException {
        this.setOutputMode(9);
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the area-tree output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private void setOutputMode(int mode) throws FOPException {
        if (this.outputmode != 0) {
            throw new FOPException("you can only set one output method");
        }
        this.outputmode = mode;
    }

    private void setLogLevel(String level) {
        LogFactory.getFactory().setAttribute("level", level);
        if (this.log instanceof CommandLineLogger) {
            ((CommandLineLogger)this.log).setLogLevel(level);
        }
    }

    private void checkSettings() throws FOPException, FileNotFoundException {
        if (this.inputmode == 0) {
            throw new FOPException("No input file specified");
        }
        if (this.outputmode == 0) {
            throw new FOPException("No output file specified");
        }
        if ((this.outputmode == 2 || this.outputmode == 4) && this.outfile != null) {
            throw new FOPException("Output file may not be specified for AWT or PRINT output");
        }
        if (this.inputmode == 2) {
            if (this.xmlfile == null) {
                throw new FOPException("XML file must be specified for the transform mode");
            }
            if (this.xsltfile == null) {
                throw new FOPException("XSLT file must be specified for the transform mode");
            }
            if (this.fofile != null) {
                this.log.warn("Can't use fo file with transform mode! Ignoring.\nYour input is \n xmlfile: " + this.xmlfile.getAbsolutePath() + "\nxsltfile: " + this.xsltfile.getAbsolutePath() + "\n  fofile: " + this.fofile.getAbsolutePath());
            }
            if (!this.xmlfile.exists()) {
                throw new FileNotFoundException("Error: xml file " + this.xmlfile.getAbsolutePath() + " not found ");
            }
            if (!this.xsltfile.exists()) {
                throw new FileNotFoundException("Error: xsl file " + this.xsltfile.getAbsolutePath() + " not found ");
            }
        } else if (this.inputmode == 1) {
            if (this.xmlfile != null || this.xsltfile != null) {
                this.log.warn("fo input mode, but xmlfile or xslt file are set:");
                this.log.error("xml file: " + this.xmlfile.toString());
                this.log.error("xslt file: " + this.xsltfile.toString());
            }
            if (!this.fofile.exists()) {
                throw new FileNotFoundException("Error: fo file " + this.fofile.getAbsolutePath() + " not found ");
            }
        }
    }

    private void createUserConfig() throws FOPException, IOException {
        if (this.userConfigFile == null) {
            return;
        }
        XMLReader parser = this.createParser();
        DefaultConfigurationBuilder configBuilder = new DefaultConfigurationBuilder(parser);
        Configuration userConfig = null;
        try {
            userConfig = configBuilder.buildFromFile(this.userConfigFile);
        }
        catch (SAXException e) {
            throw new FOPException(e);
        }
        catch (ConfigurationException e) {
            throw new FOPException(e);
        }
        this.foUserAgent.setUserConfig(userConfig);
    }

    protected int getRenderer() throws FOPException {
        switch (this.outputmode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                return this.outputmode;
            }
            case 9: {
                this.foUserAgent.getRendererOptions().put("fineDetail", this.isCoarseAreaXml());
                return 9;
            }
            case 0: {
                throw new FOPException("Renderer has not been set!");
            }
        }
        throw new FOPException("Invalid Renderer setting!");
    }

    private InputHandler createInputHandler() throws IllegalArgumentException {
        switch (this.inputmode) {
            case 1: {
                return new InputHandler(this.fofile);
            }
            case 2: {
                return new InputHandler(this.xmlfile, this.xsltfile, this.xsltParams);
            }
        }
        throw new IllegalArgumentException("Error creating InputHandler object.");
    }

    protected FOUserAgent getFOUserAgent() {
        return this.foUserAgent;
    }

    public int getOutputMode() {
        return this.outputmode;
    }

    public File getFOFile() {
        return this.fofile;
    }

    public File getXMLFile() {
        return this.xmlfile;
    }

    public File getXSLFile() {
        return this.xsltfile;
    }

    public File getOutputFile() {
        return this.outfile;
    }

    public File getUserConfigFile() {
        return this.userConfigFile;
    }

    public Boolean isCoarseAreaXml() {
        return this.suppressLowLevelAreas;
    }

    public File getInputFile() {
        switch (this.inputmode) {
            case 1: {
                return this.fofile;
            }
            case 2: {
                return this.xmlfile;
            }
        }
        return this.fofile;
    }

    public static void printUsage() {
        System.err.println("\nUSAGE\nFop [options] [-fo|-xml] infile [-xsl file] [-awt|-pdf|-mif|-rtf|-tiff|-png|-pcl|-ps|-txt|-at|-print] <outfile>\n [OPTIONS]  \n  -d          debug mode   \n  -x          dump configuration settings  \n  -q          quiet mode  \n  -c cfg.xml  use additional configuration file cfg.xml\n  -l lang     the language to use for user information \n  -r          relaxed/less strict validation (where available)\n  -dpi xxx    resolution in dots per inch (dpi) where xxx is a number\n  -s          for area tree XML, down to block areas only\n  -v          to show FOP version being used\n\n [INPUT]  \n  infile            xsl:fo input file (the same as the next) \n  -fo  infile       xsl:fo input file  \n  -xml infile       xml input file, must be used together with -xsl \n  -xsl stylesheet   xslt stylesheet \n \n  -param name value <value> to use for parameter <name> in xslt stylesheet\n                    (repeat '-param name value' for each parameter)\n \n [OUTPUT] \n  outfile           input will be rendered as pdf file into outfile \n  -pdf outfile      input will be rendered as pdf file (outfile req'd) \n  -awt              input will be displayed on screen \n  -mif outfile      input will be rendered as mif file (outfile req'd)\n  -rtf outfile      input will be rendered as rtf file (outfile req'd)\n  -tiff outfile     input will be rendered as tiff file (outfile req'd)\n  -png outfile      input will be rendered as png file (outfile req'd)\n  -pcl outfile      input will be rendered as pcl file (outfile req'd) \n  -ps outfile       input will be rendered as PostScript file (outfile req'd) \n  -txt outfile      input will be rendered as text file (outfile req'd) \n  -svg outfile      input will be rendered as an svg slides file (outfile req'd) \n  -at outfile       representation of area tree as XML (outfile req'd) \n  -print            input file will be rendered and sent to the printer \n                    see options with \"-print help\" \n\n [Examples]\n  Fop foo.fo foo.pdf \n  Fop -fo foo.fo -pdf foo.pdf (does the same as the previous line)\n  Fop -xml foo.xml -xsl foo.xsl -pdf foo.pdf\n  Fop foo.fo -mif foo.mif\n  Fop foo.fo -rtf foo.rtf\n  Fop foo.fo -print or Fop -print foo.fo \n  Fop foo.fo -awt \n");
    }

    private void printUsagePrintOutput() {
        System.err.println("USAGE: -print [-Dstart=i] [-Dend=i] [-Dcopies=i] [-Deven=true|false]  org.apache.fop.apps.Fop (..) -print \nExample:\njava -Dstart=1 -Dend=2 org.apache.Fop.apps.Fop infile.fo -print ");
    }

    private void dumpConfiguration() {
        this.log.info("Input mode: ");
        switch (this.inputmode) {
            case 0: {
                this.log.info("not set");
                break;
            }
            case 1: {
                this.log.info("FO ");
                this.log.info("fo input file: " + this.fofile.toString());
                break;
            }
            case 2: {
                this.log.info("xslt transformation");
                this.log.info("xml input file: " + this.xmlfile.toString());
                this.log.info("xslt stylesheet: " + this.xsltfile.toString());
                break;
            }
            default: {
                this.log.info("unknown input type");
            }
        }
        this.log.info("Output mode: ");
        switch (this.outputmode) {
            case 0: {
                this.log.info("not set");
                break;
            }
            case 1: {
                this.log.info("pdf");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            case 2: {
                this.log.info("awt on screen");
                if (this.outfile == null) break;
                this.log.error("awt mode, but outfile is set:");
                this.log.info("out file: " + this.outfile.toString());
                break;
            }
            case 3: {
                this.log.info("mif");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            case 10: {
                this.log.info("rtf");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            case 11: {
                this.log.info("tiff");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            case 12: {
                this.log.info("png");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            case 4: {
                this.log.info("print directly");
                if (this.outfile == null) break;
                this.log.error("print mode, but outfile is set:");
                this.log.error("out file: " + this.outfile.toString());
                break;
            }
            case 5: {
                this.log.info("pcl");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            case 6: {
                this.log.info("PostScript");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            case 7: {
                this.log.info("txt");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            case 8: {
                this.log.info("svg");
                this.log.info("output file: " + this.outfile.toString());
                break;
            }
            default: {
                this.log.info("unknown input type");
            }
        }
        this.log.info("OPTIONS");
        if (this.userConfigFile != null) {
            this.log.info("user configuration file: " + this.userConfigFile.toString());
        } else {
            this.log.info("no user configuration file is used [default]");
        }
    }

    private XMLReader createParser() throws FOPException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new FOPException("Couldn't create XMLReader", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

