/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class Table
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private CommonRelativePosition commonRelativePosition;
    private LengthRangeProperty blockProgressionDimension;
    private int borderCollapse;
    private LengthPairProperty borderSeparation;
    private int breakAfter;
    private int breakBefore;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private int intrusionDisplace;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int tableLayout;
    private int tableOmitFooterAtBreak;
    private int tableOmitHeaderAtBreak;
    private int writingMode;
    private static final int MINCOLWIDTH = 10000;
    protected List columns = null;
    private TableBody tableHeader = null;
    private TableBody tableFooter = null;
    private boolean tableColumnFound = false;
    private boolean tableHeaderFound = false;
    private boolean tableFooterFound = false;
    private boolean tableBodyFound = false;
    private TableColumn defaultColumn;

    public Table(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = pList.getMarginBlockProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.borderCollapse = pList.get(31).getEnum();
        this.borderSeparation = pList.get(45).getLengthPair();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.intrusionDisplace = pList.get(247).getEnum();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.tableLayout = pList.get(217).getEnum();
        this.tableOmitFooterAtBreak = pList.get(218).getEnum();
        this.tableOmitHeaderAtBreak = pList.get(219).getEnum();
        this.writingMode = pList.get(244).getEnum();
        this.defaultColumn = new TableColumn(this);
        StaticPropertyList colPList = new StaticPropertyList(this.defaultColumn, pList);
        colPList.setWritingMode();
        this.defaultColumn.bind(colPList);
        if (this.borderCollapse != 129 && this.commonBorderPaddingBackground.hasPadding()) {
            this.getLogger().error("Table may not have padding when using the collapsing border model.");
        }
        if (this.borderCollapse != 129) {
            this.getLogger().warn("The collapsing border model on an fo:table is currently not supported by FOP");
        }
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().startTable(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI)) {
            if (localName.equals("marker")) {
                if (this.tableColumnFound || this.tableHeaderFound || this.tableFooterFound || this.tableBodyFound) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "(table-column*,table-header?,table-footer?,table-body+)");
                }
            } else if (localName.equals("table-column")) {
                this.tableColumnFound = true;
                if (this.tableHeaderFound || this.tableFooterFound || this.tableBodyFound) {
                    this.nodesOutOfOrderError(loc, "fo:table-column", "(table-header?,table-footer?,table-body+)");
                }
            } else if (localName.equals("table-header")) {
                if (this.tableHeaderFound) {
                    this.tooManyNodesError(loc, "table-header");
                } else {
                    this.tableHeaderFound = true;
                    if (this.tableFooterFound || this.tableBodyFound) {
                        this.nodesOutOfOrderError(loc, "fo:table-header", "(table-footer?,table-body+)");
                    }
                }
            } else if (localName.equals("table-footer")) {
                if (this.tableFooterFound) {
                    this.tooManyNodesError(loc, "table-footer");
                } else {
                    this.tableFooterFound = true;
                    if (this.tableBodyFound) {
                        this.nodesOutOfOrderError(loc, "fo:table-footer", "(table-body+)");
                    }
                }
            } else if (localName.equals("table-body")) {
                this.tableBodyFound = true;
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void endOfNode() throws FOPException {
        if (!this.tableBodyFound) {
            this.missingChildElementError("(marker*,table-column*,table-header?,table-footer?,table-body+)");
        }
        this.getFOEventHandler().endTable(this);
    }

    protected void addChildNode(FONode child) throws FOPException {
        if (child.getName().equals("fo:table-column")) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add((TableColumn)child);
        } else if (child.getName().equals("fo:table-footer")) {
            this.tableFooter = (TableBody)child;
        } else if (child.getName().equals("fo:table-header")) {
            this.tableHeader = (TableBody)child;
        } else {
            super.addChildNode(child);
        }
    }

    public boolean isAutoLayout() {
        return this.tableLayout != 51;
    }

    public TableColumn getDefaultColumn() {
        return this.defaultColumn;
    }

    public List getColumns() {
        return this.columns;
    }

    public TableBody getBody(int index) {
        return (TableBody)this.childNodes.get(index);
    }

    public TableBody getTableHeader() {
        return this.tableHeader;
    }

    public TableBody getTableFooter() {
        return this.tableFooter;
    }

    public boolean omitHeaderAtBreak() {
        return this.tableOmitHeaderAtBreak == 149;
    }

    public boolean omitFooterAtBreak() {
        return this.tableOmitFooterAtBreak == 149;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().getWithinPage().isAuto() || !this.getKeepTogether().getWithinColumn().isAuto();
    }

    public int getBorderCollapse() {
        return this.borderCollapse;
    }

    public boolean isSeparateBorderModel() {
        return this.getBorderCollapse() == 129;
    }

    public LengthPairProperty getBorderSeparation() {
        return this.borderSeparation;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return "fo:table";
    }

    public int getNameId() {
        return 46;
    }
}

