/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.Iterator;
import java.util.List;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;

public class CommonTextDecoration {
    private static final int UNDERLINE = 1;
    private static final int OVERLINE = 2;
    private static final int LINE_THROUGH = 4;
    private static final int BLINK = 8;
    private int decoration;
    private ColorType underColor;
    private ColorType overColor;
    private ColorType throughColor;

    public static CommonTextDecoration createFromPropertyList(PropertyList pList) throws PropertyException {
        return CommonTextDecoration.calcTextDecoration(pList);
    }

    private static CommonTextDecoration calcTextDecoration(PropertyList pList) throws PropertyException {
        CommonTextDecoration deco = null;
        PropertyList parentList = pList.getParentPropertyList();
        if (parentList != null) {
            deco = CommonTextDecoration.calcTextDecoration(parentList);
        }
        List list = pList.get(226).getList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Property prop = (Property)i.next();
            int prop_enum = prop.getEnum();
            if (prop_enum == 95) {
                if (deco != null) {
                    deco.decoration = 0;
                }
                return deco;
            }
            if (prop_enum == 153) {
                if (deco == null) {
                    deco = new CommonTextDecoration();
                }
                deco.decoration |= 1;
                deco.underColor = pList.get(66).getColorType();
                continue;
            }
            if (prop_enum == 92) {
                if (deco == null) continue;
                deco.decoration &= 0xE;
                deco.underColor = pList.get(66).getColorType();
                continue;
            }
            if (prop_enum == 103) {
                if (deco == null) {
                    deco = new CommonTextDecoration();
                }
                deco.decoration |= 2;
                deco.overColor = pList.get(66).getColorType();
                continue;
            }
            if (prop_enum == 91) {
                if (deco == null) continue;
                deco.decoration &= 0xD;
                deco.overColor = pList.get(66).getColorType();
                continue;
            }
            if (prop_enum == 77) {
                if (deco == null) {
                    deco = new CommonTextDecoration();
                }
                deco.decoration |= 4;
                deco.throughColor = pList.get(66).getColorType();
                continue;
            }
            if (prop_enum == 90) {
                if (deco == null) continue;
                deco.decoration &= 0xB;
                deco.throughColor = pList.get(66).getColorType();
                continue;
            }
            if (prop_enum == 17) {
                if (deco == null) {
                    deco = new CommonTextDecoration();
                }
                deco.decoration |= 8;
                continue;
            }
            if (prop_enum == 86) {
                if (deco == null) continue;
                deco.decoration &= 7;
                continue;
            }
            throw new PropertyException("Illegal value encountered: " + prop.getString());
        }
        return deco;
    }

    public boolean hasUnderline() {
        return (this.decoration & 1) != 0;
    }

    public boolean hasOverline() {
        return (this.decoration & 2) != 0;
    }

    public boolean hasLineThrough() {
        return (this.decoration & 4) != 0;
    }

    public boolean isBlinking() {
        return (this.decoration & 8) != 0;
    }

    public ColorType getUnderlineColor() {
        return this.underColor;
    }

    public ColorType getOverlineColor() {
        return this.overColor;
    }

    public ColorType getLineThroughColor() {
        return this.throughColor;
    }
}

