/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.Hyphenator;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LineLayoutPossibilities;
import org.apache.fop.traits.MinOptMax;

public class LineLayoutManager
extends InlineStackingLayoutManager
implements BlockLevelLayoutManager {
    private Block fobj;
    private List vecInlineBreaks = new ArrayList();
    private int bTextAlignment = 70;
    private int bTextAlignmentLast;
    private int effectiveAlignment;
    private Length textIndent;
    private int iIndents = 0;
    private CommonHyphenation hyphProps;
    private int lineHeight;
    private int lead;
    private int follow;
    private int middleShift;
    private List knuthParagraphs = null;
    private int iReturnedLBP = 0;
    private int iStartElement = 0;
    private int iEndElement = 0;
    private int flaggedPenalty = 50;
    private LineLayoutPossibilities lineLayouts;
    private List lineLayoutsList;
    private int iLineWidth = 0;
    public static final int DEFAULT_SPACE_WIDTH = 3336;
    private int constantLineHeight = 12000;

    private void initialize() {
        this.bTextAlignment = this.fobj.getTextAlign();
        this.bTextAlignmentLast = this.fobj.getTextAlignLast();
        this.textIndent = this.fobj.getTextIndent();
        this.hyphProps = this.fobj.getCommonHyphenation();
        this.effectiveAlignment = this.bTextAlignment != 70 && this.bTextAlignmentLast == 70 ? 0 : this.bTextAlignment;
    }

    public LineLayoutManager(Block block, int lh, int l, int f, int ms) {
        super(block);
        this.fobj = block;
        this.fobjIter = null;
        this.lineHeight = lh;
        this.lead = l;
        this.follow = f;
        this.middleShift = ms;
        this.initialize();
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        MinOptMax availIPD = context.getStackLimit();
        this.clearPrevIPD();
        int iPrevLineEnd = this.vecInlineBreaks.size();
        if (iPrevLineEnd == 0 && this.bTextAlignment == 135) {
            availIPD.subtract(new MinOptMax(this.textIndent.getValue()));
        }
        if (this.knuthParagraphs == null) {
            this.knuthParagraphs = new ArrayList();
            this.collectInlineKnuthElements(context, availIPD);
        }
        if (this.knuthParagraphs.size() == 0) {
            this.setFinished(true);
            return null;
        }
        return this.createLineBreaks(context.getBPAlignment());
    }

    private void collectInlineKnuthElements(LayoutContext context, MinOptMax availIPD) {
        InlineLevelLayoutManager curLM;
        LayoutContext inlineLC = new LayoutContext(context);
        LinkedList returnedList = null;
        this.iLineWidth = context.getStackLimit().opt;
        boolean bPrevWasKnuthBox = false;
        StringBuffer trace = new StringBuffer("LineLM:");
        Paragraph lastPar = null;
        while ((curLM = (InlineLevelLayoutManager)this.getChildLM()) != null) {
            returnedList = curLM.getNextKnuthElements(inlineLC, this.effectiveAlignment);
            if (returnedList == null || returnedList.size() == 0) continue;
            if (lastPar != null) {
                KnuthElement thisElement;
                Object obj = returnedList.getFirst();
                if (obj instanceof KnuthElement) {
                    thisElement = (KnuthElement)obj;
                } else {
                    KnuthSequence firstSeq = (KnuthSequence)obj;
                    if (!firstSeq.isInlineSequence()) {
                        log.error("Expect inline sequence as first sequence when last paragraph is not null");
                    }
                    thisElement = (KnuthElement)firstSeq.get(0);
                }
                if (thisElement.isBox() && !thisElement.isAuxiliary() && bPrevWasKnuthBox) {
                    lastPar.addALetterSpace();
                }
            }
            ListIterator iter = returnedList.listIterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                KnuthElement singleElement = null;
                KnuthSequence sequence = null;
                if (obj instanceof KnuthElement) {
                    singleElement = (KnuthElement)obj;
                } else {
                    sequence = (KnuthSequence)obj;
                }
                if (singleElement != null || sequence.isInlineSequence()) {
                    KnuthElement lastElement;
                    if (singleElement != null) {
                        lastElement = singleElement;
                    } else {
                        lastElement = sequence.getLast();
                        if (lastElement == null) {
                            throw new NullPointerException("Sequence was empty! lastElement is null");
                        }
                    }
                    bPrevWasKnuthBox = lastElement.isBox();
                    if (lastPar == null) {
                        lastPar = new Paragraph(this, this.bTextAlignment, this.bTextAlignmentLast, this.textIndent.getValue());
                        lastPar.startParagraph(availIPD.opt);
                        if (log.isTraceEnabled()) {
                            trace.append(" [");
                        }
                    } else if (log.isTraceEnabled()) {
                        trace.append(" +");
                    }
                    if (singleElement != null) {
                        lastPar.add(singleElement);
                    } else {
                        lastPar.addAll(sequence);
                    }
                    if (log.isTraceEnabled()) {
                        trace.append(" I");
                    }
                    if (!lastElement.isPenalty() || ((KnuthPenalty)lastElement).getP() != -1000) continue;
                    lastPar.removeLast();
                    if (lastPar.size() == 0) {
                        lastPar.add(new KnuthInlineBox(0, 0, 0, 0, null, false));
                    }
                    lastPar.endParagraph();
                    ElementListObserver.observe(lastPar, "line", null);
                    lastPar = null;
                    if (log.isTraceEnabled()) {
                        trace.append(" ]");
                    }
                    bPrevWasKnuthBox = false;
                    continue;
                }
                this.knuthParagraphs.add(sequence);
                if (!log.isTraceEnabled()) continue;
                trace.append(" B");
            }
        }
        if (lastPar != null) {
            lastPar.endParagraph();
            ElementListObserver.observe(lastPar, "line", null);
            if (log.isTraceEnabled()) {
                trace.append(" ]");
            }
        }
        log.trace(trace);
    }

    private LinkedList createLineBreaks(int alignment) {
        ListIterator paragraphsIterator = this.knuthParagraphs.listIterator(this.knuthParagraphs.size());
        this.lineLayoutsList = new ArrayList(this.knuthParagraphs.size());
        while (paragraphsIterator.hasPrevious()) {
            KnuthSequence seq = (KnuthSequence)paragraphsIterator.previous();
            this.lineLayouts = !seq.isInlineSequence() ? this.createBlockLineBreak(seq) : this.findOptimalBreakingPoints(alignment, (Paragraph)seq);
            this.lineLayoutsList.add(0, this.lineLayouts);
        }
        this.setFinished(true);
        return this.postProcessLineBreaks(alignment);
    }

    private LineLayoutPossibilities createBlockLineBreak(KnuthSequence seq) {
        this.lineLayouts = new LineLayoutPossibilities();
        this.lineLayouts.addPossibility(1, 0.0);
        int lineHeight = 0;
        int lineStretch = 0;
        int lineShrink = 0;
        ListIterator seqIterator = seq.listIterator();
        while (seqIterator.hasNext()) {
            KnuthElement element = (KnuthElement)seqIterator.next();
            lineHeight += element.getW();
            if (!element.isGlue()) continue;
            lineStretch += element.getY();
            lineShrink += element.getZ();
        }
        LineBreakPosition lbp = new LineBreakPosition(this, this.knuthParagraphs.indexOf(seq), seq.size() - 1, lineShrink, lineStretch, 0, 0.0, 0.0, 0, lineHeight, this.iLineWidth, 0, 0, 0);
        this.lineLayouts.addBreakPosition(lbp, 0);
        return this.lineLayouts;
    }

    private LineLayoutPossibilities findOptimalBreakingPoints(int alignment, Paragraph currPar) {
        this.lineLayouts = new LineLayoutPossibilities();
        double maxAdjustment = 1.0;
        int iBPcount = 0;
        LineBreakingAlgorithm alg = new LineBreakingAlgorithm(alignment, this.bTextAlignment, this.bTextAlignmentLast, this.textIndent.getValue(), ((Paragraph)currPar).lineFiller.opt, this.lineHeight, this.lead, this.follow, this.middleShift, this.knuthParagraphs.indexOf(currPar) == 0, this);
        if (this.hyphProps.hyphenate == 149) {
            this.findHyphenationPoints(currPar);
        }
        boolean bHyphenationAllowed = false;
        alg.setConstantLineWidth(this.iLineWidth);
        iBPcount = alg.findBreakingPoints(currPar, maxAdjustment, false, bHyphenationAllowed);
        if (iBPcount == 0 || alignment == 70) {
            if (iBPcount > 0) {
                alg.resetAlgorithm();
                this.lineLayouts.savePossibilities(false);
            } else {
                log.debug("No set of breaking points found with maxAdjustment = " + maxAdjustment);
            }
            log.debug("Hyphenation possible? " + (this.hyphProps.hyphenate == 149));
            if (this.hyphProps.hyphenate == 149) {
                bHyphenationAllowed = true;
            } else {
                maxAdjustment = 5.0;
            }
            iBPcount = alg.findBreakingPoints(currPar, maxAdjustment, false, bHyphenationAllowed);
            if (iBPcount == 0) {
                log.debug("No set of breaking points found with maxAdjustment = " + maxAdjustment + (this.hyphProps.hyphenate == 149 ? " and hyphenation" : ""));
                maxAdjustment = 20.0;
                iBPcount = alg.findBreakingPoints(currPar, maxAdjustment, true, bHyphenationAllowed);
            }
            this.lineLayouts.restorePossibilities();
        }
        return this.lineLayouts;
    }

    private LinkedList postProcessLineBreaks(int alignment) {
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        for (int p = 0; p < this.knuthParagraphs.size(); ++p) {
            LeafPosition returnPosition;
            if (p > 0 && !((BlockLevelLayoutManager)this.parentLM).mustKeepTogether()) {
                returnList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
            }
            this.lineLayouts = (LineLayoutPossibilities)this.lineLayoutsList.get(p);
            KnuthSequence seq = (KnuthSequence)this.knuthParagraphs.get(p);
            if (!seq.isInlineSequence()) {
                LinkedList<KnuthElement> targetList = new LinkedList<KnuthElement>();
                ListIterator listIter = seq.listIterator();
                while (listIter.hasNext()) {
                    KnuthElement tempElement = (KnuthElement)listIter.next();
                    if (tempElement.getLayoutManager() != this) {
                        tempElement.setPosition(new NonLeafPosition(this, tempElement.getPosition()));
                    }
                    targetList.add(tempElement);
                }
                returnList.addAll(targetList);
                continue;
            }
            if (seq.isInlineSequence() && alignment == 70) {
                returnPosition = new LeafPosition(this, p);
                this.createElements(returnList, this.lineLayouts, returnPosition);
                continue;
            }
            returnPosition = new LeafPosition(this, p);
            int startIndex = 0;
            for (int i = 0; i < this.lineLayouts.getChosenLineCount(); ++i) {
                if (!((BlockLevelLayoutManager)this.parentLM).mustKeepTogether() && i >= this.fobj.getOrphans() && i <= this.lineLayouts.getChosenLineCount() - this.fobj.getWidows() && returnList.size() > 0) {
                    returnList.add(new KnuthPenalty(0, 0, false, returnPosition, false));
                }
                int endIndex = ((LineBreakPosition)this.lineLayouts.getChosenPosition(i)).getLeafPos();
                LinkedList<FootnoteBodyLayoutManager> footnoteList = new LinkedList<FootnoteBodyLayoutManager>();
                ListIterator elementIterator = seq.listIterator(startIndex);
                while (elementIterator.nextIndex() <= endIndex) {
                    KnuthElement element = (KnuthElement)elementIterator.next();
                    if (element instanceof KnuthInlineBox && ((KnuthInlineBox)element).isAnchor()) {
                        footnoteList.add(((KnuthInlineBox)element).getFootnoteBodyLM());
                        continue;
                    }
                    if (!(element instanceof KnuthBlockBox)) continue;
                    footnoteList.addAll(((KnuthBlockBox)element).getFootnoteBodyLMs());
                }
                startIndex = endIndex + 1;
                LineBreakPosition lbp = (LineBreakPosition)this.lineLayouts.getChosenPosition(i);
                returnList.add(new KnuthBlockBox(lbp.lineHeight, footnoteList, lbp, false));
            }
        }
        return returnList;
    }

    private void createElements(List list, LineLayoutPossibilities lineLayouts, Position elementPosition) {
        int i;
        int nInnerLines = 0;
        int nOptionalLines = 0;
        int nConditionalOptionalLines = 0;
        int nEliminableLines = 0;
        int nConditionalEliminableLines = 0;
        int nFirstLines = this.fobj.getOrphans();
        int nLastLines = this.fobj.getWidows();
        LinkedList<KnuthElement> breaker = new LinkedList<KnuthElement>();
        if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayouts.getMinLineCount()) {
            nInnerLines = lineLayouts.getMinLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            nOptionalLines = lineLayouts.getMaxLineCount() - lineLayouts.getOptLineCount();
            nEliminableLines = lineLayouts.getOptLineCount() - lineLayouts.getMinLineCount();
        } else if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayouts.getOptLineCount()) {
            nOptionalLines = lineLayouts.getMaxLineCount() - lineLayouts.getOptLineCount();
            nEliminableLines = lineLayouts.getOptLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            nConditionalEliminableLines = this.fobj.getOrphans() + this.fobj.getWidows() - lineLayouts.getMinLineCount();
        } else if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayouts.getMaxLineCount()) {
            nOptionalLines = lineLayouts.getMaxLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            nConditionalOptionalLines = this.fobj.getOrphans() + this.fobj.getWidows() - lineLayouts.getOptLineCount();
            nConditionalEliminableLines = lineLayouts.getOptLineCount() - lineLayouts.getMinLineCount();
            nFirstLines -= nConditionalOptionalLines;
        } else {
            nConditionalOptionalLines = lineLayouts.getMaxLineCount() - lineLayouts.getOptLineCount();
            nConditionalEliminableLines = lineLayouts.getOptLineCount() - lineLayouts.getMinLineCount();
            nFirstLines = lineLayouts.getOptLineCount();
            nLastLines = 0;
        }
        if (nLastLines != 0 && (nConditionalOptionalLines > 0 || nConditionalEliminableLines > 0)) {
            breaker.add(new KnuthPenalty(0, 1000, false, elementPosition, false));
            breaker.add(new KnuthGlue(0, -nConditionalOptionalLines * this.constantLineHeight, -nConditionalEliminableLines * this.constantLineHeight, 2, elementPosition, false));
            breaker.add(new KnuthPenalty(nConditionalOptionalLines * this.constantLineHeight, 0, false, elementPosition, false));
            breaker.add(new KnuthGlue(0, nConditionalOptionalLines * this.constantLineHeight, nConditionalEliminableLines * this.constantLineHeight, 2, elementPosition, false));
        } else if (nLastLines != 0) {
            breaker.add(new KnuthPenalty(0, 0, false, elementPosition, false));
        }
        list.add(new KnuthBox(nFirstLines * this.constantLineHeight, elementPosition, nLastLines == 0 && nConditionalOptionalLines == 0 && nConditionalEliminableLines == 0));
        if (nConditionalOptionalLines > 0 || nConditionalEliminableLines > 0) {
            list.add(new KnuthPenalty(0, 1000, false, elementPosition, false));
            list.add(new KnuthGlue(0, nConditionalOptionalLines * this.constantLineHeight, nConditionalEliminableLines * this.constantLineHeight, 2, elementPosition, false));
            list.add(new KnuthBox(0, elementPosition, nLastLines == 0));
        }
        for (i = 0; i < nOptionalLines; ++i) {
            list.addAll(breaker);
            list.add(new KnuthBox(0, elementPosition, false));
            list.add(new KnuthPenalty(0, 1000, false, elementPosition, false));
            list.add(new KnuthGlue(0, 1 * this.constantLineHeight, 0, 2, elementPosition, false));
            list.add(new KnuthBox(0, elementPosition, false));
        }
        for (i = 0; i < nEliminableLines; ++i) {
            list.addAll(breaker);
            list.add(new KnuthBox(1 * this.constantLineHeight, elementPosition, false));
            list.add(new KnuthPenalty(0, 1000, false, elementPosition, false));
            list.add(new KnuthGlue(0, 0, 1 * this.constantLineHeight, 2, elementPosition, false));
            list.add(new KnuthBox(0, elementPosition, false));
        }
        for (i = 0; i < nInnerLines; ++i) {
            list.addAll(breaker);
            list.add(new KnuthBox(1 * this.constantLineHeight, elementPosition, false));
        }
        if (nLastLines > 0) {
            list.addAll(breaker);
            list.add(new KnuthBox(nLastLines * this.constantLineHeight, elementPosition, true));
        }
    }

    public boolean mustKeepTogether() {
        return false;
    }

    public boolean mustKeepWithPrevious() {
        return false;
    }

    public boolean mustKeepWithNext() {
        return false;
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        LeafPosition pos = (LeafPosition)lastElement.getPosition();
        int totalAdj = adj;
        int lineNumberDifference = (int)Math.round((double)totalAdj / (double)this.constantLineHeight + (adj > 0 ? -0.4 : 0.4));
        this.lineLayouts = (LineLayoutPossibilities)this.lineLayoutsList.get(pos.getLeafPos());
        lineNumberDifference = this.lineLayouts.applyLineCountAdjustment(lineNumberDifference);
        return lineNumberDifference * this.constantLineHeight;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        for (int p = 0; p < this.knuthParagraphs.size(); ++p) {
            this.lineLayouts = (LineLayoutPossibilities)this.lineLayoutsList.get(p);
            for (int i = 0; i < this.lineLayouts.getChosenLineCount(); ++i) {
                if (!((BlockLevelLayoutManager)this.parentLM).mustKeepTogether() && i >= this.fobj.getOrphans() && i <= this.lineLayouts.getChosenLineCount() - this.fobj.getWidows()) {
                    returnList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
                LineBreakPosition lbp = (LineBreakPosition)this.lineLayouts.getChosenPosition(i);
                MinOptMax contentIPD = alignment == 70 ? new MinOptMax(lbp.lineWidth - lbp.difference - lbp.availableShrink, lbp.lineWidth - lbp.difference, lbp.lineWidth - lbp.difference + lbp.availableStretch) : (alignment == 23 ? new MinOptMax(lbp.lineWidth - 2 * lbp.startIndent) : (alignment == 39 ? new MinOptMax(lbp.lineWidth - lbp.startIndent) : new MinOptMax(lbp.lineWidth - lbp.difference + lbp.startIndent)));
                returnList.add(new KnuthBlockBox(lbp.lineHeight, contentIPD, lbp.ipdAdjust != 0.0 ? lbp.lineWidth - lbp.difference : 0, lbp, false));
            }
        }
        return returnList;
    }

    private void findHyphenationPoints(Paragraph currPar) {
        ListIterator currParIterator = currPar.listIterator(currPar.ignoreAtStart);
        LinkedList<Update> updateList = new LinkedList<Update>();
        KnuthElement firstElement = null;
        KnuthElement nextElement = null;
        InlineLevelLayoutManager currLM = null;
        StringBuffer sbChars = null;
        while (currParIterator.hasNext()) {
            int i;
            firstElement = (KnuthElement)currParIterator.next();
            if (firstElement.getLayoutManager() != currLM) {
                currLM = (InlineLevelLayoutManager)firstElement.getLayoutManager();
                if (currLM == null) break;
                updateList.add(new Update(currLM, currParIterator.previousIndex()));
            }
            if (!firstElement.isBox() || firstElement.isAuxiliary()) continue;
            int boxCount = 1;
            int auxCount = 0;
            sbChars = new StringBuffer();
            currLM.getWordChars(sbChars, firstElement.getPosition());
            while (currParIterator.hasNext()) {
                nextElement = (KnuthElement)currParIterator.next();
                if (nextElement.isBox() && !nextElement.isAuxiliary()) {
                    if (currLM != nextElement.getLayoutManager()) {
                        currLM = (InlineLevelLayoutManager)nextElement.getLayoutManager();
                        updateList.add(new Update(currLM, currParIterator.previousIndex()));
                    }
                    ++boxCount;
                    currLM.getWordChars(sbChars, nextElement.getPosition());
                    continue;
                }
                if (!nextElement.isAuxiliary()) {
                    currParIterator.previous();
                    break;
                }
                ++auxCount;
            }
            log.trace(" Word to hyphenate: " + sbChars.toString());
            HyphContext hc = this.getHyphenContext(sbChars);
            if (hc == null) continue;
            KnuthElement element = null;
            for (i = 0; i < boxCount + auxCount; ++i) {
                currParIterator.previous();
            }
            for (i = 0; i < boxCount + auxCount; ++i) {
                element = (KnuthElement)currParIterator.next();
                if (!element.isBox() || element.isAuxiliary()) continue;
                ((InlineLevelLayoutManager)element.getLayoutManager()).hyphenate(element.getPosition(), hc);
            }
        }
        ListIterator updateListIterator = updateList.listIterator();
        Update currUpdate = null;
        int iAddedElements = 0;
        while (updateListIterator.hasNext()) {
            int toIndex;
            currUpdate = (Update)updateListIterator.next();
            int fromIndex = currUpdate.iFirstIndex;
            if (updateListIterator.hasNext()) {
                Update nextUpdate = (Update)updateListIterator.next();
                toIndex = nextUpdate.iFirstIndex;
                updateListIterator.previous();
            } else {
                toIndex = currPar.size() - currPar.ignoreAtEnd - iAddedElements;
            }
            if (!currUpdate.inlineLM.applyChanges(currPar.subList(fromIndex + iAddedElements, toIndex + iAddedElements))) continue;
            LinkedList newElements = null;
            newElements = currUpdate.inlineLM.getChangedKnuthElements(currPar.subList(fromIndex + iAddedElements, toIndex + iAddedElements), this.effectiveAlignment);
            currPar.subList(fromIndex + iAddedElements, toIndex + iAddedElements).clear();
            currPar.addAll(fromIndex + iAddedElements, newElements);
            iAddedElements += newElements.size() - (toIndex - fromIndex);
        }
        updateListIterator = null;
        updateList.clear();
    }

    protected boolean hasLeadingFence(boolean bNotFirst) {
        return true;
    }

    protected boolean hasTrailingFence(boolean bNotLast) {
        return true;
    }

    private HyphContext getHyphenContext(StringBuffer sbChars) {
        Hyphenation hyph = Hyphenator.hyphenate(this.hyphProps.language, this.hyphProps.country, sbChars.toString(), this.hyphProps.hyphenationRemainCharacterCount, this.hyphProps.hyphenationPushCharacterCount);
        if (hyph != null) {
            return new HyphContext(hyph.getHyphenationPoints());
        }
        return null;
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.setFinished(false);
            this.iReturnedLBP = 0;
        } else {
            if (this.isFinished()) {
                this.setFinished(false);
                --this.iReturnedLBP;
            }
            while ((LineBreakPosition)this.lineLayouts.getChosenPosition(this.iReturnedLBP) != (LineBreakPosition)resetPos) {
                --this.iReturnedLBP;
            }
            ++this.iReturnedLBP;
        }
    }

    public void addAreas(PositionIterator parentIter, LayoutContext context) {
        LayoutContext lc = new LayoutContext(0);
        while (parentIter.hasNext()) {
            LayoutManager childLM;
            LayoutManager lastLM;
            Position pos = (Position)parentIter.next();
            if (pos instanceof LineBreakPosition) {
                ListIterator seqIterator = null;
                KnuthElement tempElement = null;
                lastLM = null;
                LineBreakPosition lbp = (LineBreakPosition)pos;
                LineArea lineArea = new LineArea();
                lineArea.setStartIndent(lbp.startIndent);
                lineArea.setBPD(lbp.lineHeight);
                lineArea.setIPD(lbp.lineWidth);
                lc.setBaseline(lbp.baseline);
                lc.setLineHeight(lbp.lineHeight);
                lc.setMiddleShift(this.middleShift);
                lc.setTopShift(lbp.topShift);
                lc.setBottomShift(lbp.bottomShift);
                int iCurrParIndex = lbp.iParIndex;
                KnuthSequence seq = (KnuthSequence)this.knuthParagraphs.get(iCurrParIndex);
                this.iEndElement = lbp.getLeafPos();
                if (seq instanceof Paragraph) {
                    Paragraph currPar = (Paragraph)seq;
                    this.iStartElement += this.iStartElement == 0 ? currPar.ignoreAtStart : 0;
                    this.iEndElement -= this.iEndElement == currPar.size() - 1 ? currPar.ignoreAtEnd : 0;
                }
                if ((tempElement = (KnuthElement)(seqIterator = seq.listIterator(this.iEndElement)).next()).isGlue()) {
                    --this.iEndElement;
                    seqIterator.previous();
                    tempElement = (KnuthElement)seqIterator.previous();
                }
                lastLM = tempElement.getLayoutManager();
                seqIterator = seq.listIterator(this.iStartElement);
                tempElement = (KnuthElement)seqIterator.next();
                while (!tempElement.isBox() && seqIterator.hasNext()) {
                    tempElement = (KnuthElement)seqIterator.next();
                    ++this.iStartElement;
                }
                KnuthPossPosIter inlinePosIter = new KnuthPossPosIter(seq, this.iStartElement, this.iEndElement + 1);
                this.iStartElement = lbp.getLeafPos() + 1;
                if (this.iStartElement == seq.size()) {
                    this.iStartElement = 0;
                }
                lc.setSpaceAdjust(lbp.dAdjust);
                lc.setIPDAdjust(lbp.ipdAdjust);
                lc.setLeadingSpace(new SpaceSpecifier(true));
                lc.setTrailingSpace(new SpaceSpecifier(false));
                lc.setFlags(256, true);
                this.setCurrentArea(lineArea);
                this.setChildContext(lc);
                while ((childLM = inlinePosIter.getNextChildLM()) != null) {
                    lc.setFlags(128, childLM == lastLM);
                    childLM.addAreas(inlinePosIter, lc);
                    lc.setLeadingSpace(lc.getTrailingSpace());
                    lc.setTrailingSpace(new SpaceSpecifier(false));
                }
                if (context.getSpaceAfter() > 0 && (!context.isLastArea() || parentIter.hasNext())) {
                    lineArea.setBPD(lineArea.getBPD() + context.getSpaceAfter());
                }
                this.parentLM.addChildArea(lineArea);
                continue;
            }
            if (!(pos instanceof NonLeafPosition)) continue;
            LinkedList<Position> positionList = new LinkedList<Position>();
            Position innerPosition = ((NonLeafPosition)pos).getPosition();
            positionList.add(innerPosition);
            while (parentIter.hasNext() && (pos = (Position)parentIter.peekNext()) instanceof NonLeafPosition) {
                pos = (Position)parentIter.next();
                innerPosition = ((NonLeafPosition)pos).getPosition();
                positionList.add(innerPosition);
            }
            lastLM = null;
            if (!parentIter.hasNext()) {
                lastLM = innerPosition.getLM();
            }
            LineArea lineArea = new LineArea();
            this.setCurrentArea(lineArea);
            this.setChildContext(lc);
            InlineStackingLayoutManager.StackingIter childPosIter = new InlineStackingLayoutManager.StackingIter(positionList.listIterator());
            LayoutContext blocklc = new LayoutContext(0);
            blocklc.setLeadingSpace(new SpaceSpecifier(true));
            blocklc.setTrailingSpace(new SpaceSpecifier(false));
            blocklc.setFlags(256, true);
            while ((childLM = childPosIter.getNextChildLM()) != null) {
                blocklc.setFlags(128, context.isLastArea() && childLM == lastLM);
                blocklc.setStackLimit(context.getStackLimit());
                childLM.addAreas(childPosIter, blocklc);
                blocklc.setLeadingSpace(blocklc.getTrailingSpace());
                blocklc.setTrailingSpace(new SpaceSpecifier(false));
            }
            lineArea.updateExtentsFromChildren();
            this.parentLM.addChildArea(lineArea);
        }
        this.setCurrentArea(null);
    }

    public void addChildArea(Area childArea) {
        if (childArea instanceof InlineArea) {
            Area parent = this.getCurrentArea();
            if (this.getContext().resolveLeadingSpace()) {
                this.addSpace(parent, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
            }
            parent.addChildArea(childArea);
        }
    }

    private class LineBreakingAlgorithm
    extends BreakingAlgorithm {
        private LineLayoutManager thisLLM;
        private int pageAlignment;
        private int activePossibility;
        private int addedPositions;
        private int textIndent;
        private int fillerMinWidth;
        private int lineHeight;
        private int lead;
        private int follow;
        private int middleshift;
        private int maxDiff;
        private static final double MAX_DEMERITS = 1.0E7;

        public LineBreakingAlgorithm(int pageAlign, int textAlign, int textAlignLast, int indent, int fillerWidth, int lh, int ld, int fl, int ms, boolean first, LineLayoutManager llm) {
            super(textAlign, textAlignLast, first, false);
            this.pageAlignment = pageAlign;
            this.textIndent = indent;
            this.fillerMinWidth = fillerWidth;
            this.lineHeight = lh;
            this.lead = ld;
            this.follow = fl;
            this.middleshift = ms;
            this.thisLLM = llm;
            this.activePossibility = -1;
            this.maxDiff = LineLayoutManager.this.fobj.getWidows() >= LineLayoutManager.this.fobj.getOrphans() ? LineLayoutManager.this.fobj.getWidows() : LineLayoutManager.this.fobj.getOrphans();
        }

        public void updateData1(int lineCount, double demerits) {
            LineLayoutManager.this.lineLayouts.addPossibility(lineCount, demerits);
            log.trace("Layout possibility in " + lineCount + " lines; break at position:");
        }

        public void updateData2(BreakingAlgorithm.KnuthNode bestActiveNode, KnuthSequence par, int total) {
            double ratio;
            int textAlign;
            int indent = 0;
            int difference = bestActiveNode.line < total ? bestActiveNode.difference : bestActiveNode.difference + this.fillerMinWidth;
            int n = textAlign = bestActiveNode.line < total ? this.alignment : this.alignmentLast;
            indent += textAlign == 23 ? difference / 2 : (textAlign == 39 ? difference : 0);
            indent += bestActiveNode.line == 1 && this.bFirst ? this.textIndent : 0;
            double d = ratio = textAlign == 70 || bestActiveNode.adjustRatio < 0.0 ? bestActiveNode.adjustRatio : 0.0;
            if (this.activePossibility == -1) {
                this.activePossibility = 0;
                this.addedPositions = 0;
            }
            if (this.addedPositions == LineLayoutManager.this.lineLayouts.getLineCount(this.activePossibility)) {
                ++this.activePossibility;
                this.addedPositions = 0;
            }
            LineLayoutManager.this.lineLayouts.addBreakPosition(this.makeLineBreakPosition(par, bestActiveNode.line > 1 ? bestActiveNode.previous.position + 1 : 0, bestActiveNode.position, bestActiveNode.availableShrink - (this.addedPositions > 0 ? 0 : ((Paragraph)((Paragraph)par)).lineFiller.opt - ((Paragraph)((Paragraph)par)).lineFiller.min), bestActiveNode.availableStretch, difference, ratio, indent), this.activePossibility);
            ++this.addedPositions;
        }

        public void resetAlgorithm() {
            this.activePossibility = -1;
        }

        private LineBreakPosition makeLineBreakPosition(KnuthSequence par, int firstElementIndex, int lastElementIndex, int availableShrink, int availableStretch, int difference, double ratio, int indent) {
            boolean bZeroHeightLine;
            int maxtb;
            int halfLeading = (this.lineHeight - this.lead - this.follow) / 2;
            int lineLead = this.lead;
            int middlefollow = maxtb = this.follow;
            boolean bl = bZeroHeightLine = difference == LineLayoutManager.this.iLineWidth;
            if (LineLayoutManager.this.fobj.getLineStackingStrategy() != 52) {
                ListIterator inlineIterator = par.listIterator(firstElementIndex);
                for (int j = firstElementIndex; j <= lastElementIndex; ++j) {
                    KnuthElement element = (KnuthElement)inlineIterator.next();
                    if (!element.isBox()) continue;
                    if (((KnuthInlineBox)element).getLead() > lineLead) {
                        lineLead = ((KnuthInlineBox)element).getLead();
                    }
                    if (((KnuthInlineBox)element).getTotal() > maxtb) {
                        maxtb = ((KnuthInlineBox)element).getTotal();
                    }
                    if (((KnuthInlineBox)element).getMiddle() > lineLead + LineLayoutManager.this.middleShift) {
                        lineLead += ((KnuthInlineBox)element).getMiddle() - lineLead - LineLayoutManager.this.middleShift;
                    }
                    if (((KnuthInlineBox)element).getMiddle() > middlefollow - LineLayoutManager.this.middleShift) {
                        middlefollow += ((KnuthInlineBox)element).getMiddle() - middlefollow + LineLayoutManager.this.middleShift;
                    }
                    if (!bZeroHeightLine || element.isAuxiliary() && ((KnuthInlineBox)element).getTotal() <= 0 && ((KnuthInlineBox)element).getLead() <= 0 && ((KnuthInlineBox)element).getMiddle() <= 0) continue;
                    bZeroHeightLine = false;
                }
                if (maxtb - lineLead > middlefollow) {
                    middlefollow = maxtb - lineLead;
                }
            }
            LineLayoutManager.this.constantLineHeight = lineLead + middlefollow + (this.lineHeight - this.lead - this.follow);
            if (bZeroHeightLine) {
                return new LineBreakPosition(this.thisLLM, LineLayoutManager.this.knuthParagraphs.indexOf(par), lastElementIndex, availableShrink, availableStretch, difference, ratio, 0.0, indent, 0, LineLayoutManager.this.iLineWidth, 0, 0, 0);
            }
            return new LineBreakPosition(this.thisLLM, LineLayoutManager.this.knuthParagraphs.indexOf(par), lastElementIndex, availableShrink, availableStretch, difference, ratio, 0.0, indent, lineLead + middlefollow + (this.lineHeight - this.lead - this.follow), LineLayoutManager.this.iLineWidth, lineLead + halfLeading, -lineLead, middlefollow);
        }

        public int findBreakingPoints(Paragraph par, double threshold, boolean force, boolean hyphenationAllowed) {
            return super.findBreakingPoints(par, threshold, force, hyphenationAllowed);
        }

        protected int filterActiveNodes() {
            BreakingAlgorithm.KnuthNode bestActiveNode = null;
            if (this.pageAlignment == 70) {
                BreakingAlgorithm.KnuthNode node;
                int i;
                for (i = this.startLine; i < this.endLine; ++i) {
                    node = this.getNode(i);
                    while (node != null) {
                        bestActiveNode = this.compareNodes(bestActiveNode, node);
                        node = node.next;
                    }
                }
                for (i = this.startLine; i < this.endLine; ++i) {
                    node = this.getNode(i);
                    while (node != null) {
                        if (node.line != bestActiveNode.line && node.totalDemerits > 1.0E7) {
                            this.removeNode(i, node);
                        }
                        node = node.next;
                    }
                }
            } else {
                for (int i = this.startLine; i < this.endLine; ++i) {
                    BreakingAlgorithm.KnuthNode node = this.getNode(i);
                    while (node != null) {
                        if (node != (bestActiveNode = this.compareNodes(bestActiveNode, node))) {
                            this.removeNode(i, node);
                        }
                        node = node.next;
                    }
                }
            }
            return bestActiveNode.line;
        }
    }

    private class Paragraph
    extends KnuthSequence {
        private MinOptMax lineFiller;
        private int textAlignment;
        private int textAlignmentLast;
        private int textIndent;
        private int lineWidth;
        private LineLayoutManager layoutManager;

        public Paragraph(LineLayoutManager llm, int alignment, int alignmentLast, int indent) {
            super(true);
            this.layoutManager = llm;
            this.textAlignment = alignment;
            this.textAlignmentLast = alignmentLast;
            this.textIndent = indent;
        }

        public void startParagraph(int lw) {
            this.lineWidth = lw;
            this.startSequence();
        }

        public void startSequence() {
            this.lineFiller = LineLayoutManager.this.bTextAlignment == 23 ? new MinOptMax(0) : new MinOptMax(0, this.lineWidth / 12, this.lineWidth);
            if (LineLayoutManager.this.bTextAlignment == 23 && LineLayoutManager.this.bTextAlignmentLast != 70) {
                this.add(new KnuthGlue(0, 10008, 0, null, false));
                ++this.ignoreAtStart;
            }
            if (LineLayoutManager.this.knuthParagraphs.size() == 0 && LineLayoutManager.this.fobj.getTextIndent().getValue() != 0) {
                this.add(new KnuthInlineBox(LineLayoutManager.this.fobj.getTextIndent().getValue(), 0, 0, 0, null, false));
                ++this.ignoreAtStart;
            }
        }

        public void endParagraph() {
            KnuthSequence finishedPar = this.endSequence();
            if (finishedPar != null) {
                LineLayoutManager.this.knuthParagraphs.add(finishedPar);
            }
        }

        public KnuthSequence endSequence() {
            while (this.size() > this.ignoreAtStart && !((KnuthElement)this.get(this.size() - 1)).isBox()) {
                this.remove(this.size() - 1);
            }
            if (this.size() > this.ignoreAtStart) {
                if (LineLayoutManager.this.bTextAlignment == 23 && LineLayoutManager.this.bTextAlignmentLast != 70) {
                    this.add(new KnuthGlue(0, 10008, 0, null, false));
                    this.add(new KnuthPenalty(0, -1000, false, null, false));
                    this.ignoreAtEnd = 2;
                } else if (LineLayoutManager.this.bTextAlignmentLast != 70) {
                    this.add(new KnuthPenalty(0, 1000, false, null, false));
                    this.add(new KnuthGlue(this.lineFiller.opt, this.lineFiller.max - this.lineFiller.opt, this.lineFiller.opt - this.lineFiller.min, null, false));
                    this.add(new KnuthPenalty(0, -1000, false, null, false));
                    this.ignoreAtEnd = 3;
                } else {
                    this.add(new KnuthPenalty(0, -1000, false, null, false));
                    this.ignoreAtEnd = 1;
                }
                return this;
            }
            this.clear();
            return null;
        }

        private void addALetterSpace() {
            KnuthBox prevBox = (KnuthBox)this.removeLast();
            LinkedList<KnuthElement> oldList = new LinkedList<KnuthElement>();
            if (!prevBox.isAuxiliary()) {
                oldList.add(prevBox);
            } else {
                oldList.add(prevBox);
                oldList.addFirst((KnuthGlue)this.removeLast());
                oldList.addFirst((KnuthPenalty)this.removeLast());
                oldList.addFirst((KnuthBox)this.removeLast());
            }
            this.addAll(((InlineLevelLayoutManager)prevBox.getLayoutManager()).addALetterSpaceTo(oldList));
            if (((KnuthInlineBox)prevBox).isAnchor()) {
                KnuthInlineBox newBox = (KnuthInlineBox)this.getLast();
                newBox.setFootnoteBodyLM(((KnuthInlineBox)prevBox).getFootnoteBodyLM());
            }
        }
    }

    private class Update {
        private InlineLevelLayoutManager inlineLM;
        private int iFirstIndex;

        public Update(InlineLevelLayoutManager lm, int index) {
            this.inlineLM = lm;
            this.iFirstIndex = index;
        }
    }

    private static class LineBreakPosition
    extends LeafPosition {
        int iParIndex;
        int availableShrink;
        int availableStretch;
        int difference;
        double dAdjust;
        double ipdAdjust;
        int startIndent;
        int lineHeight;
        int lineWidth;
        int baseline;
        int topShift;
        int bottomShift;

        LineBreakPosition(LayoutManager lm, int index, int iBreakIndex, int shrink, int stretch, int diff, double ipdA, double adjust, int ind, int lh, int lw, int bl, int ts, int bs) {
            super(lm, iBreakIndex);
            this.availableShrink = shrink;
            this.availableStretch = stretch;
            this.difference = diff;
            this.iParIndex = index;
            this.ipdAdjust = ipdA;
            this.dAdjust = adjust;
            this.startIndent = ind;
            this.lineHeight = lh;
            this.lineWidth = lw;
            this.baseline = bl;
            this.topShift = ts;
            this.bottomShift = bs;
        }
    }
}

