/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class Java2DFontMetrics {
    public static final int FONT_SIZE = 1;
    public static final int FONT_FACTOR = 1000000;
    private int[] width = null;
    private int xHeight = 0;
    private Font f1 = null;
    private String family = "";
    private int style = 0;
    private float size = 0.0f;
    private FontMetrics fmt = null;
    private Graphics2D graphics;

    public Java2DFontMetrics(Graphics2D graphics) {
        this.graphics = graphics;
    }

    public int getAscender(String family, int style, int size) {
        this.setFont(family, style, size);
        int realAscent = this.fmt.getAscent() - (this.fmt.getDescent() + this.fmt.getLeading());
        return 1000000 * realAscent;
    }

    public int getCapHeight(String family, int style, int size) {
        return this.getAscender(family, style, size);
    }

    public int getDescender(String family, int style, int size) {
        this.setFont(family, style, size);
        return -1000000 * this.fmt.getDescent();
    }

    public int getXHeight(String family, int style, int size) {
        this.setFont(family, style, size);
        return 1000000 * this.xHeight;
    }

    public int width(int i, String family, int style, int size) {
        this.setFont(family, style, size);
        int w = i <= 32 ? (int)(1.4 * (double)this.fmt.charWidth(i) * 1000000.0) : this.fmt.charWidth(i) * 1000000;
        return w;
    }

    public int[] getWidths(String family, int style, int size) {
        if (this.width == null) {
            this.width = new int[256];
        }
        this.setFont(family, style, size);
        for (int i = 0; i < 256; ++i) {
            this.width[i] = 1000000 * this.fmt.charWidth(i);
        }
        return this.width;
    }

    private boolean setFont(String family, int style, int size) {
        boolean changed = false;
        int s = (int)((float)size / 1000.0f);
        if (this.f1 == null) {
            this.f1 = new Font(family, style, s);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            changed = true;
        } else if (this.style != style || !this.family.equals(family) || this.size != (float)s) {
            this.f1 = family.equals(this.family) ? this.f1.deriveFont(style, s) : new Font(family, style, s);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            changed = true;
        }
        if (changed) {
            TextLayout layout = new TextLayout("m", this.f1, this.graphics.getFontRenderContext());
            Rectangle2D rect = layout.getBounds();
            this.xHeight = (int)rect.getHeight();
        }
        this.family = family;
        this.style = style;
        this.size = s;
        return changed;
    }

    public Font getFont(String family, int style, int size) {
        this.setFont(family, style, size);
        return this.f1;
    }
}

