/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCanvasListener;
import com.insightful.gdevice.SCanvasPoint;
import com.insightful.gdevice.SGraphClear;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.SGraphicsDevice;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class SCanvas
extends SCanvasAWT {
    private transient Vector m_canvasListeners = new Vector();
    private transient SGraphicsDevice m_graphicsDevice = null;

    public void addCanvasListener(SCanvasListener sCanvasListener) {
        this.m_canvasListeners.addElement(sCanvasListener);
    }

    public void removeCanvasListener(SCanvasListener sCanvasListener) {
        this.m_canvasListeners.removeElement(sCanvasListener);
    }

    public float[][] readPen(int n, SGraphCommand sGraphCommand) {
        int n2 = this.m_canvasListeners.size();
        for (int i = 0; i < n2; ++i) {
            SCanvasListener sCanvasListener = (SCanvasListener)this.m_canvasListeners.elementAt(i);
            Point[] pointArray = sCanvasListener.canvasReadPen(this, n);
            if (pointArray == null) continue;
            int n3 = pointArray.length;
            float[][] fArray = new float[2][n3];
            for (int j = 0; j < n3; ++j) {
                SCanvasPoint sCanvasPoint = this.getValueFromPoint(sGraphCommand, pointArray[j].x, pointArray[j].y);
                fArray[0][j] = sCanvasPoint.getX();
                fArray[1][j] = sCanvasPoint.getY();
            }
            return fArray;
        }
        return null;
    }

    public void wrap() {
        int n = this.m_canvasListeners.size();
        for (int i = 0; i < n; ++i) {
            SCanvasListener sCanvasListener = (SCanvasListener)this.m_canvasListeners.elementAt(i);
            sCanvasListener.canvasWrap(this);
        }
    }

    public void setTitle(String string) {
        String string2 = this.getTitle();
        super.setTitle(string);
        if (string == null && string2 != null || string != null && !string.equals(string2)) {
            this.notifyCanvasChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SGraphCommand sGraphCommand) {
        if (sGraphCommand instanceof SGraphClear) {
            SGraphClear sGraphClear = (SGraphClear)sGraphCommand;
            boolean bl = sGraphClear.m_newTopLevelExpr;
            boolean bl2 = sGraphClear.m_setBackground;
            if (bl2) {
                this.setBackgroundRGBA(sGraphClear.m_bgColorR, sGraphClear.m_bgColorG, sGraphClear.m_bgColorB, sGraphClear.m_bgColorA);
                return;
            }
            boolean bl3 = true;
            int n = this.m_canvasListeners.size();
            for (int i = 0; i < n; ++i) {
                SCanvasListener sCanvasListener = (SCanvasListener)this.m_canvasListeners.elementAt(i);
                boolean bl4 = sCanvasListener.canvasCleared(this, bl);
                bl3 = bl3 && bl4;
            }
            if (bl3) {
                this.clearBackgroundRGBA();
                this.clear();
            }
        } else {
            SCanvas sCanvas = this;
            synchronized (sCanvas) {
                super.add(sGraphCommand);
            }
            this.notifyCanvasChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Vector vector) {
        SCanvas sCanvas = this;
        synchronized (sCanvas) {
            super.add(vector);
        }
        this.notifyCanvasChanged();
    }

    void notifyCanvasChanged() {
        int n = this.m_canvasListeners.size();
        for (int i = 0; i < n; ++i) {
            SCanvasListener sCanvasListener = (SCanvasListener)this.m_canvasListeners.elementAt(i);
            sCanvasListener.canvasChanged(this);
        }
    }

    public void setColorScheme(ColorScheme colorScheme) {
        super.setColorScheme(colorScheme);
        this.notifyCanvasChanged();
    }

    public SGraphicsDevice getGraphicsDevice() {
        return this.m_graphicsDevice;
    }

    public void setGraphicsDevice(SGraphicsDevice sGraphicsDevice) {
        this.m_graphicsDevice = sGraphicsDevice;
    }

    public void setNewActiveCanvas(SCanvas sCanvas) {
        if (this.m_graphicsDevice != null) {
            try {
                this.m_graphicsDevice.addCanvas(sCanvas);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void unlinkGraphicsDevice() {
        if (this.m_graphicsDevice != null) {
            try {
                this.m_graphicsDevice.removeCanvas(this);
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace(System.out);
            }
            this.m_graphicsDevice = null;
        }
    }

    public int getDeviceNumber() {
        try {
            return this.m_graphicsDevice != null ? this.m_graphicsDevice.getDeviceNumber() : 0;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return 0;
        }
    }

    public SCanvasAWT getAWT() {
        SCanvasAWT sCanvasAWT = new SCanvasAWT();
        sCanvasAWT.setSize(this.getWidth(), this.getHeight());
        sCanvasAWT.setColorScheme(this.getColorScheme());
        sCanvasAWT.setTitle(this.getTitle());
        sCanvasAWT.setTag(this.getTag());
        int n = this.m_displayList.size();
        for (int i = 0; i < n; ++i) {
            SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
            SGraphCommand sGraphCommand2 = sGraphCommand.getAWT();
            sCanvasAWT.add(sGraphCommand2);
        }
        return sCanvasAWT;
    }

    public void printString(Graphics graphics, String string, int n, int n2) {
        graphics.drawString(string, n, n2);
    }

    public static SCanvas createSCanvas(SCanvasAWT sCanvasAWT) {
        SCanvas sCanvas = new SCanvas();
        sCanvas.setTag(sCanvasAWT.getTag());
        sCanvas.setTitle(sCanvasAWT.getTitle());
        sCanvas.setSize(sCanvasAWT.getWidth(), sCanvasAWT.getHeight());
        sCanvas.add(sCanvasAWT.m_displayList);
        if (sCanvasAWT.m_bgColor != null) {
            sCanvas.setBackgroundRGBA(sCanvasAWT.m_bgColorR, sCanvasAWT.m_bgColorG, sCanvasAWT.m_bgColorB, sCanvasAWT.m_bgColorA);
        }
        return sCanvas;
    }

    public void setSelectedTagArray(String[] stringArray) {
        super.setSelectedTagArray(stringArray);
        this.notifyCanvasChanged();
    }
}

