/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.gdevice.SGraphicsDeviceReceiver;
import com.insightful.splus.SplusGui;
import com.insightful.splus.SybaseInit;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;

public class SplusExecGui {
    private static Runnable g_mainThreadRequest = null;
    private static Object g_mainThreadResult = null;
    private static Object g_mainThreadWaitObject = null;
    private static Object g_mainThreadRequestWaitObject = null;

    public static void main(String[] stringArray) {
        boolean bl;
        if (!SGraphicsDeviceReceiver.checkServerDisplay()) {
            System.out.println(SGraphicsDeviceReceiver.BAD_DISPLAY_MSG);
            return;
        }
        InputStream inputStream = System.in;
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        String string = System.getProperty("splus.config.file", "");
        try {
            if (string.length() > 0) {
                System.getProperties().load(new FileInputStream(string));
            }
        }
        catch (Exception exception) {
            System.out.println("Error reading splus.config.file");
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            Thread thread = new Thread(new SplusGui(inputStream, printStream, printStream2, stringArray));
            thread.setName("S-PLUS: SplusGui thread");
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl2 = bl = System.getProperty("os.name").toLowerCase().indexOf("sunos") >= 0;
        if (bl) {
            SplusExecGui.handleMainThreadRequests();
        }
    }

    public static void initSybaseServer(String string) {
        final String string2 = string;
        SplusExecGui.runInMainThread(new Runnable(){

            public void run() {
                SybaseInit.initServer(string2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMainThreadRequests() {
        Thread.currentThread().setPriority(1);
        g_mainThreadRequest = null;
        g_mainThreadWaitObject = new Object();
        g_mainThreadRequestWaitObject = new Object();
        while (true) {
            Object object = g_mainThreadWaitObject;
            synchronized (object) {
                if (g_mainThreadRequest == null) {
                    try {
                        g_mainThreadWaitObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (g_mainThreadRequest == null) continue;
            g_mainThreadResult = SplusExecGui.runReturningException(g_mainThreadRequest);
            object = g_mainThreadRequestWaitObject;
            synchronized (object) {
                g_mainThreadRequest = null;
                g_mainThreadRequestWaitObject.notify();
            }
        }
    }

    private static Object runReturningException(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            return exception;
        }
        catch (Error error) {
            return error;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runInMainThread(Runnable runnable) {
        if (g_mainThreadRequestWaitObject == null || g_mainThreadWaitObject == null) {
            return SplusExecGui.runReturningException(runnable);
        }
        Object object = g_mainThreadRequestWaitObject;
        synchronized (object) {
            if (g_mainThreadRequest != null) {
                return SplusExecGui.runReturningException(runnable);
            }
            g_mainThreadRequest = runnable;
            Object object2 = g_mainThreadWaitObject;
            synchronized (object2) {
                g_mainThreadWaitObject.notify();
            }
            while (g_mainThreadRequest != null) {
                try {
                    g_mainThreadRequestWaitObject.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return g_mainThreadResult;
        }
    }

    static {
        String string = System.getProperty("os.name", "unknown").toLowerCase();
        if (string.indexOf("windows") < 0 && !string.startsWith("mac")) {
            try {
                if (!System.getProperty("splus.client.mode", "").equals("true")) {
                    System.loadLibrary("SplusExecGui");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

