/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class SplusProfileHandler {
    private static SplusProfileHandler g_instance = null;
    private DefaultMutableTreeNode m_root = new DefaultMutableTreeNode();
    private DefaultTreeModel m_functions = new DefaultTreeModel(this.m_root);
    private DefaultMutableTreeNode m_addTo = this.m_root;
    private HashMap m_numFunctionCalls = new HashMap();
    private HashMap m_functionCallTimes = new HashMap();
    private Vector m_allocations = new Vector();
    private Vector m_listeners = new Vector();
    private static Object m_syncLock = new Object();

    private SplusProfileHandler() {
    }

    private static SplusProfileHandler getInstance() {
        if (g_instance == null) {
            g_instance = new SplusProfileHandler();
        }
        return g_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeFunctionCall(String string) {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            FunctionCall functionCall = new FunctionCall(string);
            defaultMutableTreeNode.setUserObject(functionCall);
            splusProfileHandler.m_addTo.add(defaultMutableTreeNode);
            splusProfileHandler.m_addTo = defaultMutableTreeNode;
            SplusProfileHandler.incrementHashMapCount(splusProfileHandler.m_numFunctionCalls, functionCall.getName(), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endFunctionCall(String string) {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            if (splusProfileHandler.m_addTo != splusProfileHandler.m_root) {
                ((FunctionCall)splusProfileHandler.m_addTo.getUserObject()).endFunctionCall();
                splusProfileHandler.m_addTo = (DefaultMutableTreeNode)splusProfileHandler.m_addTo.getParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumFunctionCalls() {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            return splusProfileHandler.m_numFunctionCalls.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getFunctionCallSet() {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            return splusProfileHandler.m_numFunctionCalls.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFunctionCallCount(Object object) {
        Object object2 = m_syncLock;
        synchronized (object2) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            Long l = (Long)splusProfileHandler.m_numFunctionCalls.get(object);
            if (l == null) {
                return 0;
            }
            return l.intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFunctionCallTime(Object object) {
        Object object2 = m_syncLock;
        synchronized (object2) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            Long l = (Long)splusProfileHandler.m_functionCallTimes.get(object);
            if (l == null) {
                return 0;
            }
            return l.intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeModel getFunctionTreeModel() {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            return splusProfileHandler.m_functions;
        }
    }

    public static String getTreeNodeName(DefaultMutableTreeNode defaultMutableTreeNode) {
        FunctionCall functionCall = (FunctionCall)defaultMutableTreeNode.getUserObject();
        return functionCall.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetFunctionCalls() {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            splusProfileHandler.m_root.removeAllChildren();
            splusProfileHandler.m_functions.setRoot(null);
            splusProfileHandler.m_numFunctionCalls.clear();
            splusProfileHandler.m_functionCallTimes.clear();
            splusProfileHandler.m_root = new DefaultMutableTreeNode();
            splusProfileHandler.m_functions = new DefaultTreeModel(splusProfileHandler.m_root);
            splusProfileHandler.m_addTo = splusProfileHandler.m_root;
            splusProfileHandler.m_numFunctionCalls = new HashMap();
            splusProfileHandler.m_functionCallTimes = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endAllFunctionCalls() {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            while (splusProfileHandler.m_addTo != splusProfileHandler.m_root) {
                ((FunctionCall)splusProfileHandler.m_addTo.getUserObject()).endFunctionCall();
                splusProfileHandler.m_addTo = (DefaultMutableTreeNode)splusProfileHandler.m_addTo.getParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addByteAllocation(long l) {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            splusProfileHandler.m_allocations.add(new Allocation(splusProfileHandler.m_addTo, (int)l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTypeAllocation(String string, long l) {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            splusProfileHandler.m_allocations.add(new Allocation(splusProfileHandler.m_addTo, string, (int)l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumAllocations() {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            return splusProfileHandler.m_allocations.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTotalAllocation(String string) {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            Long l = (Long)Allocation.g_totAmtByType.get(string);
            if (l == null) {
                return 0L;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getTypesAllocated() {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            Set set = Allocation.g_totAmtByType.keySet();
            String[] stringArray = new String[set.size()];
            set.toArray(stringArray);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Allocation getAllocation(int n) {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            return (Allocation)splusProfileHandler.m_allocations.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAllocations() {
        Object object = m_syncLock;
        synchronized (object) {
            SplusProfileHandler splusProfileHandler = SplusProfileHandler.getInstance();
            splusProfileHandler.m_allocations.clear();
            Allocation.g_totAmtByType.clear();
            Allocation.g_totAmt = 0L;
        }
    }

    private static void incrementHashMapCount(HashMap hashMap, Object object, long l) {
        Long l2 = (Long)hashMap.get(object);
        if (l2 == null) {
            hashMap.put(object, new Long(l));
        } else {
            hashMap.remove(object);
            hashMap.put(object, new Long(l2 + l));
        }
    }

    public static void startProfiling() {
        SplusProfileHandler.doStartProfiling();
    }

    public static void stopProfiling() {
        SplusProfileHandler.doStopProfiling();
    }

    private static native void doStartProfiling();

    private static native void doStopProfiling();

    public static class Allocation {
        private static HashMap g_totAmtByType = new HashMap();
        private static long g_totAmt = 0L;
        private String m_type = "Bytes";
        private int m_amt = 0;

        public Allocation(DefaultMutableTreeNode defaultMutableTreeNode, String string, int n) {
            this.m_type = string;
            this.m_amt = n;
            SplusProfileHandler.incrementHashMapCount(Allocation.g_totAmtByType, string, n);
        }

        public Allocation(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
            this(defaultMutableTreeNode, "Bytes", n);
        }

        public static long getTotalAmount() {
            return g_totAmt;
        }

        public String getType() {
            return this.m_type;
        }

        public int getAmount() {
            return this.m_amt;
        }

        public String toString() {
            return Integer.toString(this.m_amt) + " " + this.getType() + "(s)";
        }
    }

    public static class FunctionCall {
        private String m_name;
        private long m_start;
        private long m_end;

        public FunctionCall(String string) {
            this.m_name = string;
            this.m_end = this.m_start = System.currentTimeMillis();
        }

        public void endFunctionCall() {
            this.m_end = System.currentTimeMillis();
            HashMap hashMap = SplusProfileHandler.getInstance().m_functionCallTimes;
            SplusProfileHandler.incrementHashMapCount(hashMap, this.getName(), this.getDuration());
        }

        public String toString() {
            String string = this.getDuration() == 0L ? "<1" : Long.toString(this.getDuration());
            return this.getName() + " (" + string + " ms)";
        }

        public long getDuration() {
            return this.m_end - this.m_start;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

