/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.graph;

import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.SCanvasListener;
import com.insightful.gdevice.SCanvasPaneController;
import com.insightful.gdevice.SCanvasPaneView2;
import com.insightful.gdevice.SCanvasPoint;
import com.insightful.gdevice.STreeNode;
import com.insightful.gdevice.XMLElement;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.GraphColorsDialog;
import com.insightful.splus.graph.GraphOptionsDialog;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class CanvasTabbedPane
extends JPanel
implements SCanvasPaneView2,
SCanvasPaneController.ContextMenuAccess {
    JScrollBar m_hscroll = new JScrollBar(0);
    JScrollBar m_vscroll = new JScrollBar(1);
    JPanel m_pagePanel = new JPanel(new BorderLayout());
    JComponent m_pageCanvas = new JComponent(){

        public void paint(Graphics graphics) {
            CanvasTabbedPane.this.m_controller.paintCanvas(graphics);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    };
    JComponent m_tabCanvas = new JComponent(){
        int m_desiredHeight = 15;
        boolean m_gotDesiredHeight = false;

        public Dimension getPreferredSize() {
            if (!this.m_gotDesiredHeight) {
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    this.m_desiredHeight = fontMetrics.getHeight() + 3;
                }
                this.m_gotDesiredHeight = true;
            }
            return new Dimension(100, this.m_desiredHeight);
        }

        public void paint(Graphics graphics) {
            CanvasTabbedPane.this.m_controller.paintTabs(graphics);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    };
    SCanvasPaneController m_controller = null;
    SCanvas m_activeCanvas = null;
    private GWSCListener m_canvasListener = null;
    private JPopupMenu m_popupMenu = null;
    private ActionListener m_popupMenuListener = null;
    public static final int TAB_IN_EXPRESSION_ON_NEW_GRAPH = 0;
    public static final int TAB_ON_NEW_GRAPH = 1;
    public static final int CLEAR_ON_NEW_GRAPH = 2;
    private static int m_clearReaction = 0;
    boolean m_closeOnWrap = true;
    int m_lastCanvasTab = -1;
    static ReadPenDialog m_readPenDialog = null;
    int m_screenPopupX = 0;
    int m_screenPopupY = 0;
    JPopupMenu m_screenPopupMenu = null;
    JPopupMenu m_canvasContextMenu = null;
    Point m_canvasContextMenuPoint = null;
    String m_canvasContextPropertiesAction = "";

    public CanvasTabbedPane() {
        this(true);
    }

    public CanvasTabbedPane(boolean bl) {
        super(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.m_closeOnWrap = bl;
        this.m_pagePanel.add("Center", this.m_pageCanvas);
        this.m_pagePanel.add("East", this.m_vscroll);
        this.m_pagePanel.add("South", this.m_hscroll);
        this.add("Center", this.m_pagePanel);
        this.add("South", this.m_tabCanvas);
        this.m_canvasListener = new GWSCListener();
        TabPaneContextMenu tabPaneContextMenu = new TabPaneContextMenu();
        this.m_tabCanvas.addMouseListener(tabPaneContextMenu);
        this.m_controller = new SCanvasPaneController(this);
    }

    public Component getCanvasComponent() {
        return this.m_pageCanvas;
    }

    public Component getTabComponent() {
        return this.m_tabCanvas;
    }

    public Adjustable getScrollAdjustable(int n) {
        return this.getScrollbar(n);
    }

    JScrollBar getScrollbar(int n) {
        return n == 0 ? this.m_hscroll : this.m_vscroll;
    }

    public boolean getScrollVisible(int n) {
        return this.getScrollbar(n).isVisible();
    }

    public void setScrollVisible(int n, boolean bl) {
        if (bl != this.getScrollVisible(n)) {
            this.getScrollbar(n).setVisible(bl);
            this.validate();
        }
    }

    public void doHitURL(String string, String string2) {
        String string3 = "In an applet, this would show the URL:\n" + string + "\n(target=" + string2 + ")";
        JOptionPane.showMessageDialog(this, string3, "Warning", 2);
    }

    public void doHitError(String string, String string2) {
        String string3 = "Error: " + string2 + "\nin action:\n" + string;
        JOptionPane.showMessageDialog(this, string3, "Error in Action", 0);
    }

    public void doExec(String string, String string2) {
        block8: {
            if (string == null || string.trim().equals("") || string2 == null) {
                return;
            }
            try {
                if (string2.equalsIgnoreCase("splus")) {
                    boolean bl;
                    boolean bl2 = bl = SplusSystem.getEngineQueryHandler() != null;
                    if (!bl) {
                        throw new Exception("can't call into Splus");
                    }
                    String string3 = "{{" + string + "};NULL}";
                    SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string3);
                    if (splusDataResult.hasError()) {
                        throw new Exception("Splus error: " + splusDataResult.getError());
                    }
                    break block8;
                }
                if (string2.equalsIgnoreCase("java")) {
                    int n = string.indexOf(",");
                    int n2 = string.indexOf(",", n < 0 ? 0 : n + 1);
                    if (n < 0 || n2 < 0) {
                        throw new Exception("action doesn't have form \"classname,methodname,string\"");
                    }
                    String string4 = string.substring(0, n);
                    String string5 = string.substring(n + 1, n2);
                    String string6 = string.substring(n2 + 1);
                    Class<?> clazz = Class.forName(string4);
                    Method method = clazz.getMethod(string5, String.class);
                    method.invoke(null, string6);
                    break block8;
                }
                throw new Exception("Unsupported action language");
            }
            catch (Exception exception) {
                String string7 = "Error while executing action (language=" + string2 + "):\n   " + exception + "\n\n   code: " + (string != null && string.length() > 100 ? string.substring(0, 90) + "..." : string);
                JOptionPane.showMessageDialog(this, string7, "Error in Action", 0);
            }
        }
    }

    public static void showMessage(String string) {
        JOptionPane.showMessageDialog(null, string, "Message", 1);
    }

    public boolean doHitQueryWebService(XMLElement xMLElement, STreeNode sTreeNode, STreeNode sTreeNode2, boolean bl) throws Exception {
        String string = "In an applet, this would query a web service.";
        JOptionPane.showMessageDialog(this, string, "Warning", 0);
        return false;
    }

    public void doHitMenu(String string, String[] stringArray, String[] stringArray2, int n, int n2) {
        if (stringArray == null || stringArray2 == null) {
            return;
        }
        int n3 = Math.min(stringArray.length, stringArray2.length);
        if (n3 < 1) {
            return;
        }
        JPopupMenu jPopupMenu = null;
        jPopupMenu = string == null || string.length() < 1 ? new JPopupMenu() : new JPopupMenu(string);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string != null && CanvasTabbedPane.this.m_controller != null) {
                    CanvasTabbedPane.this.m_controller.doHitAction(string);
                }
            }
        };
        for (int i = 0; i < n3; ++i) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.setActionCommand(stringArray2[i]);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
        }
        this.showPopupMenu(jPopupMenu, this.m_pageCanvas, n, n2);
    }

    public void doHitMenu(STreeNode sTreeNode, STreeNode sTreeNode2, int n, int n2) {
        if (sTreeNode == null || sTreeNode2 == null) {
            return;
        }
        if (sTreeNode.getChildCount() < 1 || sTreeNode2.getChildCount() < 1) {
            return;
        }
        if (this.m_popupMenu == null) {
            this.m_popupMenu = new JPopupMenu();
            this.m_popupMenuListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string != null && CanvasTabbedPane.this.m_controller != null) {
                        CanvasTabbedPane.this.m_controller.doHitAction(string);
                    }
                }
            };
        }
        this.m_popupMenu.removeAll();
        this.constructPopupMenu(this.m_popupMenu, this.m_popupMenuListener, sTreeNode, sTreeNode2);
        this.showPopupMenu(this.m_popupMenu, this.m_pageCanvas, n, n2);
    }

    protected void constructPopupMenu(JPopupMenu jPopupMenu, ActionListener actionListener, STreeNode sTreeNode, STreeNode sTreeNode2) {
        jPopupMenu.setLabel((String)sTreeNode.getUserObject());
        int n = Math.min(sTreeNode.getChildCount(), sTreeNode2.getChildCount());
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem;
            STreeNode sTreeNode3 = sTreeNode.getChildAt(i);
            STreeNode sTreeNode4 = sTreeNode2.getChildAt(i);
            if (sTreeNode3.isLeaf() || sTreeNode4.isLeaf()) {
                jMenuItem = new JMenuItem((String)sTreeNode3.getUserObject());
                String string = (String)sTreeNode4.getUserObject();
                if (string != null && string.length() > 0) {
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener(actionListener);
                } else {
                    jMenuItem.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = new JMenu();
            this.constructSubMenu((JMenu)jMenuItem, actionListener, sTreeNode3, sTreeNode4);
            jPopupMenu.add(jMenuItem);
        }
    }

    protected void constructSubMenu(JMenu jMenu, ActionListener actionListener, STreeNode sTreeNode, STreeNode sTreeNode2) {
        jMenu.setText((String)sTreeNode.getUserObject());
        int n = Math.min(sTreeNode.getChildCount(), sTreeNode2.getChildCount());
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem;
            STreeNode sTreeNode3 = sTreeNode.getChildAt(i);
            STreeNode sTreeNode4 = sTreeNode2.getChildAt(i);
            if (sTreeNode3.isLeaf() || sTreeNode4.isLeaf()) {
                jMenuItem = new JMenuItem((String)sTreeNode3.getUserObject());
                String string = (String)sTreeNode4.getUserObject();
                if (string != null && string.length() > 0) {
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener(actionListener);
                } else {
                    jMenuItem.setEnabled(false);
                }
                jMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = new JMenu();
            this.constructSubMenu((JMenu)jMenuItem, actionListener, sTreeNode3, sTreeNode4);
            jMenu.add(jMenuItem);
        }
    }

    public static void setClearReaction(int n) {
        if (n >= 0 && n <= 2) {
            m_clearReaction = n;
        }
    }

    public static int getClearReaction() {
        return m_clearReaction;
    }

    public int getTabCount() {
        return this.m_controller.getTabCount();
    }

    public void removeAllTabs() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SCanvas sCanvas = this.getCanvas(i);
            if (sCanvas == null) continue;
            sCanvas.unlinkGraphicsDevice();
        }
        this.m_controller.removeAllPages();
    }

    public void removeTabAt(int n) {
        SCanvas sCanvas = this.getCanvas(n);
        if (sCanvas != null) {
            sCanvas.unlinkGraphicsDevice();
        }
        this.m_controller.removeTabAt(n);
    }

    public void zoom(double d) {
        this.m_controller.zoom(d);
    }

    public void zoomToRect() {
        this.m_controller.zoomToRect();
    }

    public void zoomToFrame() {
        this.m_controller.setAutoZoom(true);
    }

    public void selectRect() {
        this.m_controller.selectRect();
    }

    public void addCanvasTab(SCanvas sCanvas, int n) {
        this.m_controller.addCanvas(sCanvas, n);
    }

    public void addCanvasTab(SCanvas sCanvas) {
        this.m_controller.addCanvas(sCanvas);
    }

    public SCanvas getCanvas() {
        return (SCanvas)this.m_controller.getCanvas();
    }

    public SCanvas getCanvas(int n) {
        return (SCanvas)this.m_controller.getCanvas(n);
    }

    public Vector getAllCanvases() {
        Vector<SCanvas> vector = new Vector<SCanvas>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            SCanvas sCanvas = this.getCanvas(i);
            if (sCanvas == null) continue;
            vector.addElement(sCanvas);
        }
        return vector;
    }

    public SCanvas setActiveCanvas(SCanvas sCanvas) {
        if (this.m_activeCanvas != null) {
            this.m_activeCanvas.setNewActiveCanvas(sCanvas);
        }
        this.m_activeCanvas = sCanvas;
        this.m_activeCanvas.addCanvasListener(this.m_canvasListener);
        return this.m_activeCanvas;
    }

    int canvasToTab(SCanvas sCanvas) {
        if (this.m_lastCanvasTab < 0 || sCanvas != this.m_controller.getCanvas(this.m_lastCanvasTab)) {
            this.m_lastCanvasTab = -1;
            if (sCanvas != null) {
                int n = this.m_controller.getTabCount();
                for (int i = 0; i < n; ++i) {
                    if (sCanvas != this.m_controller.getCanvas(i)) continue;
                    this.m_lastCanvasTab = i;
                    break;
                }
            }
        }
        return this.m_lastCanvasTab;
    }

    SCanvas createNewActiveCanvas() {
        return this.setActiveCanvas(new SCanvas());
    }

    void canvasWrap(SCanvas sCanvas) {
        if (!this.m_closeOnWrap) {
            return;
        }
        this.unlinkCanvases();
        for (Container container = this; container != null; container = container.getParent()) {
            if (container instanceof Window) {
                ((Window)container).dispose();
            }
            if (!(container instanceof JInternalFrame)) continue;
            ((JInternalFrame)container).dispose();
        }
    }

    JFrame getParentJFrame() {
        Container container = this;
        while (container != null) {
            if (container instanceof JFrame) {
                return (JFrame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public void unlinkCanvases() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SCanvas sCanvas = this.getCanvas(i);
            sCanvas.unlinkGraphicsDevice();
        }
    }

    public int getDeviceNumber() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SCanvas sCanvas = this.getCanvas(i);
            int n = sCanvas.getDeviceNumber();
            if (n <= 0) continue;
            return n;
        }
        return 0;
    }

    Point[] canvasReadPen(SCanvas sCanvas, int n) {
        int n2 = -1;
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (sCanvas != this.getCanvas(i)) continue;
            n2 = i;
            break;
        }
        if (n2 < 0 || n < 1) {
            return null;
        }
        this.m_controller.setSelectedTab(n2);
        if (m_readPenDialog == null) {
            m_readPenDialog = new ReadPenDialog(SplusSystem.getDefaultFrame());
        }
        Point[] pointArray = m_readPenDialog.runReadPen(this, n);
        return pointArray;
    }

    void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        Point point = component.getLocationOnScreen();
        this.m_screenPopupX = n + point.x;
        this.m_screenPopupY = n2 + point.y;
        this.m_screenPopupMenu = jPopupMenu;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Container container;
                for (container = CanvasTabbedPane.this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
                }
                if (container == null) {
                    System.out.println("CanvasTabbedPane.showPopupMenu: no window");
                    return;
                }
                Window window = (Window)container;
                Point point = window.getLocationOnScreen();
                if (CanvasTabbedPane.this.m_screenPopupMenu == null) {
                    return;
                }
                CanvasTabbedPane.this.m_screenPopupMenu.show(window, CanvasTabbedPane.this.m_screenPopupX - point.x, CanvasTabbedPane.this.m_screenPopupY - point.y);
            }
        });
    }

    public boolean doContextMenu(int n, int n2) {
        this.m_canvasContextMenuPoint = new Point(n, n2);
        String string = this.getPropertiesAction();
        if (this.m_canvasContextMenu == null || !this.m_canvasContextPropertiesAction.equals(string)) {
            this.m_canvasContextPropertiesAction = string;
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Zoom In");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.m_controller.zoom(1.5);
                }
            });
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Zoom Out");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.m_controller.zoom(0.6666666865348816);
                }
            });
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Zoom to Rectangle");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.m_controller.zoomToRect();
                }
            });
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Original View");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.m_controller.setAutoZoom(true);
                }
            });
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Select In Rectangle");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.m_controller.selectRect();
                }
            });
            jPopupMenu.add(jMenuItem);
            if (this.m_canvasContextPropertiesAction.length() > 0) {
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Properties");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object;
                        int n = 100;
                        int n2 = 100;
                        if (CanvasTabbedPane.this.m_canvasContextMenuPoint != null) {
                            n = CanvasTabbedPane.this.m_canvasContextMenuPoint.x;
                            n2 = CanvasTabbedPane.this.m_canvasContextMenuPoint.y;
                        }
                        if ((object = actionEvent.getSource()) != null && object instanceof Component) {
                            Component component = (Component)object;
                            n += component.getX();
                            n2 += component.getY();
                        }
                        CanvasTabbedPane.this.showProperties(n, n2);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
            this.m_pageCanvas.add(jPopupMenu);
            this.m_canvasContextMenu = jPopupMenu;
        }
        this.m_canvasContextMenu.show(this.m_pageCanvas, n, n2);
        return true;
    }

    public void showProperties(int n, int n2) {
        String string = this.getPropertiesAction();
        if (this.m_controller != null && string.length() > 0) {
            this.m_controller.doHitAction(string, n, n2, false, false);
        }
    }

    public String getPropertiesAction() {
        SCanvas sCanvas = this.getCanvas();
        if (sCanvas == null) {
            return "";
        }
        String string = sCanvas.getPropertyAction();
        if (string == null || string.length() < 1) {
            return "";
        }
        return string;
    }

    class PagePropertiesDialog
    extends JDialog
    implements ActionListener {
        JTextField m_tfPageTitle;
        JTextField m_tfPageTag;
        JButton m_okButton;
        JButton m_cancelButton;
        SCanvas m_canvas;

        PagePropertiesDialog(JFrame jFrame, int n) {
            super(jFrame, "Page Properties", true);
            this.m_tfPageTitle = new JTextField(15);
            this.m_tfPageTag = new JTextField(15);
            this.m_okButton = new JButton("OK");
            this.m_cancelButton = new JButton("Cancel");
            this.m_canvas = null;
            this.m_canvas = CanvasTabbedPane.this.getCanvas(n);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setAlignmentX(0.0f);
            jPanel.add(this.makeLabeledPanel("Properties for Page " + (n + 1), null));
            jPanel.add(Box.createVerticalStrut(5));
            jPanel.add(this.makeLabeledPanel("Page Title:  ", this.m_tfPageTitle));
            jPanel.add(Box.createVerticalStrut(5));
            jPanel.add(this.makeLabeledPanel("Page Tag:  ", this.m_tfPageTag));
            this.m_tfPageTitle.setText(this.m_canvas.getTitle());
            this.m_tfPageTag.setText(this.m_canvas.getTag());
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.m_okButton);
            jPanel2.add(this.m_cancelButton);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)jPanel2, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.m_okButton) {
                this.m_canvas.setTitle(this.m_tfPageTitle.getText());
                this.m_canvas.setTag(this.m_tfPageTag.getText());
                CanvasTabbedPane.this.repaint(1000L);
                this.dispose();
            } else if (jButton == this.m_cancelButton) {
                this.dispose();
            }
        }

        JPanel makeLabeledPanel(String string, JComponent jComponent) {
            JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
            jPanel.add(new JLabel(string));
            if (jComponent != null) {
                jPanel.add(jComponent);
            }
            return jPanel;
        }
    }

    class TabPaneContextMenu
    extends MouseAdapter {
        JPopupMenu m_menu = new JPopupMenu();
        int m_tabSelected;

        TabPaneContextMenu() {
            JMenuItem jMenuItem = new JMenuItem("Zoom In");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.zoom(1.5);
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Zoom Out");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.zoom(0.6666666865348816);
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Zoom to Rectangle");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.zoomToRect();
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Fit in Window");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.zoomToFrame();
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Select Rectangle");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.selectRect();
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Set Graph Colors...");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = SplusSystem.getEngineQueryHandler() != null;
                    SCanvas sCanvas = CanvasTabbedPane.this.getCanvas();
                    GraphColorsDialog graphColorsDialog = new GraphColorsDialog((Frame)CanvasTabbedPane.this.getParentJFrame(), sCanvas, bl);
                    graphColorsDialog.show();
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Graph Options...");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GraphOptionsDialog graphOptionsDialog = new GraphOptionsDialog(CanvasTabbedPane.this.getParentJFrame());
                    graphOptionsDialog.show();
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Page Properties...");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TabPaneContextMenu.this.m_tabSelected < 0 || CanvasTabbedPane.this.getCanvas(TabPaneContextMenu.this.m_tabSelected) == null) {
                        return;
                    }
                    PagePropertiesDialog pagePropertiesDialog = new PagePropertiesDialog(CanvasTabbedPane.this.getParentJFrame(), TabPaneContextMenu.this.m_tabSelected);
                    pagePropertiesDialog.show();
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Insert Page");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SCanvas sCanvas = CanvasTabbedPane.this.createNewActiveCanvas();
                    CanvasTabbedPane.this.addCanvasTab(sCanvas, TabPaneContextMenu.this.m_tabSelected < 0 ? CanvasTabbedPane.this.m_controller.getTabCount() : TabPaneContextMenu.this.m_tabSelected + 1);
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete Page");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TabPaneContextMenu.this.m_tabSelected < 0) {
                        return;
                    }
                    CanvasTabbedPane.this.removeTabAt(TabPaneContextMenu.this.m_tabSelected);
                    if (CanvasTabbedPane.this.getTabCount() < 1) {
                        SCanvas sCanvas = CanvasTabbedPane.this.createNewActiveCanvas();
                        CanvasTabbedPane.this.addCanvasTab(sCanvas);
                    }
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Clear Page");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasTabbedPane.this.getCanvas().clear();
                    CanvasTabbedPane.this.m_controller.updateCanvas();
                }
            });
            this.m_menu.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete All Pages");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SCanvas sCanvas = CanvasTabbedPane.this.createNewActiveCanvas();
                    CanvasTabbedPane.this.removeAllTabs();
                    CanvasTabbedPane.this.addCanvasTab(sCanvas);
                }
            });
            this.m_menu.add(jMenuItem);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if ((mouseEvent.getModifiers() & 8) != 0 || (mouseEvent.getModifiers() & 4) != 0) {
                this.m_tabSelected = CanvasTabbedPane.this.m_controller.getTabNumber(n, n2);
                CanvasTabbedPane.this.showPopupMenu(this.m_menu, CanvasTabbedPane.this.m_tabCanvas, n, n2);
            }
        }
    }

    class GWSCListener
    implements SCanvasListener {
        GWSCListener() {
        }

        public boolean canvasCleared(SCanvas sCanvas, boolean bl) {
            SCanvas sCanvas2 = null;
            switch (CanvasTabbedPane.getClearReaction()) {
                case 0: {
                    sCanvas2 = CanvasTabbedPane.this.createNewActiveCanvas();
                    if (bl) {
                        CanvasTabbedPane.this.removeAllTabs();
                    }
                    CanvasTabbedPane.this.addCanvasTab(sCanvas2);
                    return false;
                }
                case 1: {
                    sCanvas2 = CanvasTabbedPane.this.createNewActiveCanvas();
                    CanvasTabbedPane.this.addCanvasTab(sCanvas2);
                    return false;
                }
                case 2: {
                    if (CanvasTabbedPane.this.getTabCount() < 1) {
                        sCanvas2 = CanvasTabbedPane.this.createNewActiveCanvas();
                        CanvasTabbedPane.this.addCanvasTab(sCanvas2);
                    }
                    CanvasTabbedPane.this.repaint(1000L);
                    return true;
                }
            }
            return true;
        }

        public void canvasChanged(SCanvas sCanvas) {
            int n = CanvasTabbedPane.this.canvasToTab(sCanvas);
            if (n >= 0) {
                CanvasTabbedPane.this.m_controller.updateCanvas(n);
                CanvasTabbedPane.this.m_controller.updateTabs();
            }
        }

        public void canvasWrap(SCanvas sCanvas) {
            CanvasTabbedPane.this.canvasWrap(sCanvas);
        }

        public Point[] canvasReadPen(SCanvas sCanvas, int n) {
            return CanvasTabbedPane.this.canvasReadPen(sCanvas, n);
        }
    }

    static class ReadPenDialog
    extends JDialog {
        int m_readPenMaxPoints = 0;
        int m_readPenPointsRead = 0;
        Point[] m_readPenPoints = null;
        boolean m_readPenDone = true;
        JLabel m_clickInfo;
        JLabel m_mouseInfoX;
        JLabel m_mouseInfoY;
        SCanvas m_canvas;
        CanvasTabbedPane m_tabbedPane;
        Component m_canvasPanel;
        boolean m_firstAppearance = true;
        MouseInputAdapter readPenMouse = new MouseInputAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                ReadPenDialog.this.showMousePosition(null);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                ReadPenDialog.this.showMousePosition(n, n2);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.endReadPen();
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Point point = ReadPenDialog.this.m_tabbedPane.m_controller.getCanvasPointFromMouse(new Point(n, n2));
                ReadPenDialog.this.m_readPenPoints[ReadPenDialog.this.m_readPenPointsRead++] = point;
                if (ReadPenDialog.this.m_readPenPointsRead >= ReadPenDialog.this.m_readPenMaxPoints) {
                    this.endReadPen();
                    return;
                }
                ReadPenDialog.this.updateReadPenString();
                this.mouseMoved(mouseEvent);
            }

            void endReadPen() {
                ReadPenDialog.this.m_readPenDone = true;
            }
        };

        ReadPenDialog(Frame frame) {
            super(frame, "Select Points", false);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setAlignmentX(0.0f);
            this.m_clickInfo = new JLabel("Left-click to select points");
            JLabel jLabel = new JLabel("Right-click or press OK button to end.");
            this.m_mouseInfoX = new JLabel("       ");
            this.m_mouseInfoY = new JLabel("       ");
            jPanel.add(this.m_clickInfo);
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalStrut(3));
            jPanel.add(this.m_mouseInfoX);
            jPanel.add(Box.createHorizontalStrut(3));
            jPanel.add(this.m_mouseInfoY);
            jPanel.add(Box.createHorizontalStrut(3));
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ReadPenDialog.this.m_readPenDone = true;
                }
            });
            jPanel2.add(jButton);
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)jPanel2, "South");
            this.pack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Point[] runReadPen(CanvasTabbedPane canvasTabbedPane, int n) {
            int n2;
            this.m_tabbedPane = canvasTabbedPane;
            this.m_canvas = canvasTabbedPane.getCanvas();
            if (this.m_canvas == null || n < 1) {
                return null;
            }
            this.m_readPenMaxPoints = n;
            this.m_readPenPointsRead = 0;
            this.m_readPenPoints = new Point[this.m_readPenMaxPoints];
            this.m_readPenDone = false;
            this.updateReadPenString();
            this.showMousePosition(null);
            try {
                if (this.m_firstAppearance) {
                    this.m_firstAppearance = false;
                    Point point = this.m_tabbedPane.getLocationOnScreen();
                    this.setLocation(Math.max(0, point.x), Math.max(0, point.y - this.getHeight() - 50));
                }
                this.setVisible(true);
                this.toFront();
                canvasTabbedPane.m_pageCanvas.addMouseListener(this.readPenMouse);
                canvasTabbedPane.m_pageCanvas.addMouseMotionListener(this.readPenMouse);
                int n3 = 200;
                int n4 = 300000 / n3;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (this.m_readPenDone) {
                        break;
                    }
                    Thread.sleep(n3);
                }
            }
            catch (Exception exception) {
            }
            finally {
                canvasTabbedPane.m_pageCanvas.removeMouseListener(this.readPenMouse);
                canvasTabbedPane.m_pageCanvas.removeMouseMotionListener(this.readPenMouse);
                this.setVisible(false);
            }
            int n5 = this.m_readPenPointsRead;
            Point[] pointArray = new Point[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                pointArray[n2] = this.m_readPenPoints[n2];
            }
            return pointArray;
        }

        void showMousePosition(int n, int n2) {
            this.showMousePosition(new Point(n, n2));
        }

        void showMousePosition(Point point) {
            Point point2 = this.m_tabbedPane.m_controller.getCanvasPointFromMouse(point);
            SCanvasPoint sCanvasPoint = this.m_canvas.getValueFromPoint(point2);
            this.m_mouseInfoX.setText(sCanvasPoint != null ? "  x: " + sCanvasPoint.getX() : "    ");
            this.m_mouseInfoY.setText(sCanvasPoint != null ? "  y: " + sCanvasPoint.getY() : "    ");
        }

        void updateReadPenString() {
            this.toFront();
        }
    }
}

