/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.controls.SplusWideTextField;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWideFormulaField;
import com.insightful.splus.statdlg.MixedEffectsCorrelationGroup;
import com.insightful.splus.statdlg.MixedEffectsVarianceGroup;
import com.insightful.splus.statdlg.RandomEffectsFormulaDialog;
import com.insightful.splus.statdlg.RegressionFormulaDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LinearMixedEffectsDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataSetComboBox predictSaveIn;
    SplusDataSetComboBox predictAugSaveIn;
    SplusDataSetComboBox predictNewData;
    SplusDataSetComboBox predictAugNewData;
    SplusDataColumnComboBox dependentColumn;
    SplusDataColumnComboBox groupVariables;
    SplusDataColumnComboBox randomTerms;
    SplusDataColumnComboBox plotGroupColumn;
    SplusDataColumnComboBox plotAugPredColumn;
    SplusDataColumnComboBox predictAugColumn;
    SplusDataColumnListBox independentColumnList;
    SplusWideFormulaField formulaField;
    SplusWideTextField randomFormula;
    SplusWideTextField plotFormulaField;
    SplusButton formulaButton;
    SplusButton advancedButton;
    SplusCheckBox plotAugPred;
    SplusCheckBox plotVariogram;
    SplusCheckBox plotRandomDot;
    SplusCheckBox plotRandomScatter;
    SplusCheckBox plotRandomQQ;
    SplusCheckBox plotSpecifiedFormula;
    SplusCheckBox predictSavePredictions;
    SplusCheckBox predictAugSavePredictions;
    SplusTextField plotAugPredMin;
    SplusTextField plotAugPredMax;
    SplusTextField plotAugPredLength;
    SplusTextField plotVariogramFormula;
    SplusTextField predictAugMin;
    SplusTextField predictAugMax;
    SplusTextField predictAugLength;
    SplusComboBox plotAugPredLevels;
    SplusComboBox plotRandomLevels;
    SplusComboBox predictAugLevels;
    SplusComboBox predictLevels;
    MixedEffectsVarianceGroup varGroup;
    MixedEffectsCorrelationGroup corGroup;
    PlotRandomActionListener randomListener;

    public LinearMixedEffectsDialog() {
        super("Linear Mixed Effects Models");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuLme");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(1);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.dataSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray;
                String string = LinearMixedEffectsDialog.this.dataSet.getValue().trim();
                String string2 = "javaGuiLmeFormula(\"" + string + "\")";
                try {
                    SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string2);
                    stringArray = splusDataResult.getStringData();
                }
                catch (Exception exception) {
                    stringArray = new String[]{"", ""};
                }
                LinearMixedEffectsDialog.this.formulaField.setValue(stringArray[0]);
                LinearMixedEffectsDialog.this.randomFormula.setValue(stringArray[1]);
            }
        });
        SplusSubsetField splusSubsetField = new SplusSubsetField();
        splusGroupPanel.add(splusSubsetField);
        splusFunctionInfo.add(splusSubsetField, "subset");
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "na.omit.p");
        box4.add(new SplusBoxFiller(8));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel2);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel2.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Random Effects");
        box2.add(splusGroupPanel3);
        Box box5 = new Box(0);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        splusGroupPanel3.add(box5);
        box5.add(box6);
        box5.add(box7);
        this.groupVariables = new SplusDataColumnComboBox("Group Variable", 'G', (SplusDataColumnListProvider)this.dataSet);
        this.groupVariables.setValue("");
        box6.add(this.groupVariables);
        splusFunctionInfo.add(this.groupVariables, "");
        this.groupVariables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LinearMixedEffectsDialog.this.groupVariables.getValue().trim().length() > 0) {
                    LinearMixedEffectsDialog.this.buildRandomFormula();
                }
            }
        });
        this.randomTerms = new SplusDataColumnComboBox("Random Term", 'T', (SplusDataColumnListProvider)this.dataSet);
        this.randomTerms.setValue("");
        box6.add(this.randomTerms);
        splusFunctionInfo.add(this.randomTerms, "");
        this.randomTerms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LinearMixedEffectsDialog.this.randomTerms.getValue().trim().length() > 0) {
                    LinearMixedEffectsDialog.this.buildRandomFormula();
                }
            }
        });
        this.randomFormula = new SplusWideTextField("Random Formula", 'O');
        splusGroupPanel3.add(this.randomFormula);
        splusFunctionInfo.add(this.randomFormula, "random");
        this.advancedButton = new SplusButton("Advanced", 'N');
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RandomEffectsFormulaDialog(LinearMixedEffectsDialog.this.randomFormula, LinearMixedEffectsDialog.this.dataSet).show();
            }
        });
        Box box8 = new Box(0);
        box8.add(Box.createHorizontalStrut(5));
        box8.add(this.advancedButton);
        box8.add(Box.createHorizontalGlue());
        box7.add(Box.createVerticalStrut(5));
        box7.add(box8);
        box7.add(Box.createVerticalStrut(5));
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Fixed Effects");
        box2.add(splusGroupPanel4);
        this.dependentColumn = new SplusDataColumnComboBox("Dependent", 'E', (SplusDataColumnListProvider)this.dataSet);
        this.dependentColumn.setValue("");
        splusGroupPanel4.add(this.dependentColumn);
        splusFunctionInfo.add(this.dependentColumn, "");
        this.independentColumnList = new SplusDataColumnListBox("Independent", 'I', (SplusDataColumnListProvider)this.dataSet);
        this.independentColumnList.setPrepend(new String[]{"<ALL>"});
        splusGroupPanel4.add(this.independentColumnList);
        splusFunctionInfo.add(this.independentColumnList, "");
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel4.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "fixed");
        this.dependentColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = LinearMixedEffectsDialog.this.dependentColumn.getValue().trim();
                if (string.length() > 0) {
                    LinearMixedEffectsDialog.this.formulaField.setDependentValue(string);
                }
            }
        });
        this.independentColumnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = LinearMixedEffectsDialog.this.independentColumnList.getValue().trim();
                if (string.length() > 0) {
                    LinearMixedEffectsDialog.this.formulaField.setIndependentValue(string);
                }
            }
        });
        this.formulaButton = new SplusButton("Create Formula", 'C');
        this.formulaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RegressionFormulaDialog(LinearMixedEffectsDialog.this.formulaField, LinearMixedEffectsDialog.this.dataSet, 2).show();
            }
        });
        Box box9 = new Box(0);
        box9.add(Box.createHorizontalStrut(5));
        box9.add(this.formulaButton);
        box9.add(Box.createHorizontalGlue());
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        splusGroupPanel4.add(box9);
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box10 = new Box(1);
        Box box11 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box10);
        jPanel2.add(box11);
        this.varGroup = new MixedEffectsVarianceGroup("Within-Group Variance", this.dataSet);
        box10.add(this.varGroup);
        this.varGroup.registerControls(splusFunctionInfo);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Optimization Options");
        box10.add(splusGroupPanel5);
        SplusComboBox splusComboBox = new SplusComboBox("Method", 'M', new String[]{"REML", "ML"});
        splusComboBox.setValue("REML");
        splusComboBox.setEditable(false);
        splusGroupPanel5.add(splusComboBox);
        splusFunctionInfo.add(splusComboBox, "method", true);
        SplusTextField splusTextField2 = new SplusTextField("Control", 'N');
        splusGroupPanel5.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "control", false, true);
        box10.add(new SplusBoxFiller());
        this.corGroup = new MixedEffectsCorrelationGroup("Within-Group Correlation", this.dataSet);
        box11.add(this.corGroup);
        this.corGroup.registerControls(splusFunctionInfo);
        box11.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Results", jPanel3);
        Box box12 = new Box(1);
        Box box13 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box12);
        jPanel3.add(box13);
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Printed Results");
        box12.add(splusGroupPanel6);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Short Output", 'S');
        splusGroupPanel6.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.short.p");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Long Output", 'L');
        splusCheckBox3.setValue("T");
        splusGroupPanel6.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "print.long.p");
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("ANOVA Table", 'A');
        splusGroupPanel6.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "print.anova.p");
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Confidence Intervals", 'C');
        splusGroupPanel6.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "print.intervals.p");
        box12.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Saved Results");
        box13.add(splusGroupPanel7);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel7.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "save.name", true);
        SplusComboBox splusComboBox2 = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        splusComboBox2.setValue("");
        splusGroupPanel7.add(splusComboBox2);
        splusFunctionInfo.add(splusComboBox2, "save.level", false, true);
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("Fitted Values", 'F');
        splusGroupPanel7.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "save.fit.p");
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Pearson Residuals", 'P');
        splusGroupPanel7.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "save.pearson.p");
        SplusCheckBox splusCheckBox8 = new SplusCheckBox("Normalized Residuals", 'N');
        splusGroupPanel7.add(splusCheckBox8);
        splusFunctionInfo.add(splusCheckBox8, "save.normalized.p");
        SplusCheckBox splusCheckBox9 = new SplusCheckBox("Response Residuals", 'R');
        splusGroupPanel7.add(splusCheckBox9);
        splusFunctionInfo.add(splusCheckBox9, "save.response.p");
        box13.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel4);
        Box box14 = new Box(0);
        Box box15 = new Box(1);
        Box box16 = new Box(1);
        Box box17 = new Box(1);
        box14.add(box16);
        box14.add(box17);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(box14);
        jPanel4.add(box15);
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Plots");
        box16.add(splusGroupPanel8);
        SplusCheckBox splusCheckBox10 = new SplusCheckBox("Residuals vs Fit", 'R');
        splusGroupPanel8.add(splusCheckBox10);
        splusFunctionInfo.add(splusCheckBox10, "plotResidVsFit.p");
        SplusCheckBox splusCheckBox11 = new SplusCheckBox("Sqrt Abs Residuals vs Fit", 'Q');
        splusGroupPanel8.add(splusCheckBox11);
        splusFunctionInfo.add(splusCheckBox11, "plotSqrtAbsResid.p");
        SplusCheckBox splusCheckBox12 = new SplusCheckBox("Response vs Fit", 'P');
        splusGroupPanel8.add(splusCheckBox12);
        splusFunctionInfo.add(splusCheckBox12, "plotResponseVsFit.p");
        SplusCheckBox splusCheckBox13 = new SplusCheckBox("Residuals Normal QQ", 'Q');
        splusGroupPanel8.add(splusCheckBox13);
        splusFunctionInfo.add(splusCheckBox13, "plotQQ.p");
        this.plotAugPred = new SplusCheckBox("Augmented Predictions", 'Q');
        splusGroupPanel8.add(this.plotAugPred);
        splusFunctionInfo.add(this.plotAugPred, "plotAugPred.p");
        SplusCheckBox splusCheckBox14 = new SplusCheckBox("Autocorrelation of Residuals", 'U');
        splusGroupPanel8.add(splusCheckBox14);
        splusFunctionInfo.add(splusCheckBox14, "plotAcf.p");
        this.plotVariogram = new SplusCheckBox("Variogram of Residuals", 'O');
        splusGroupPanel8.add(this.plotVariogram);
        splusFunctionInfo.add(this.plotVariogram, "plotVariogram.p");
        this.plotRandomDot = new SplusCheckBox("Random Effects Dot", 'D');
        splusGroupPanel8.add(this.plotRandomDot);
        splusFunctionInfo.add(this.plotRandomDot, "plotRandomEffectsDot.p");
        this.plotRandomScatter = new SplusCheckBox("Random Effects Scatter", 'E');
        splusGroupPanel8.add(this.plotRandomScatter);
        splusFunctionInfo.add(this.plotRandomScatter, "plotRandomEffectsScatter.p");
        this.plotRandomQQ = new SplusCheckBox("Random Effects Normal QQ", 'T');
        splusGroupPanel8.add(this.plotRandomQQ);
        splusFunctionInfo.add(this.plotRandomQQ, "plotRandomEffectsQQ.p");
        this.plotSpecifiedFormula = new SplusCheckBox("Specified Formula", 'E');
        splusGroupPanel8.add(this.plotSpecifiedFormula);
        splusFunctionInfo.add(this.plotSpecifiedFormula, "plotFormula.p");
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Specified Formula Options");
        box15.add(splusGroupPanel9);
        this.plotFormulaField = new SplusWideTextField("Plot Formula", 'F');
        this.plotFormulaField.setEnabled(false);
        splusGroupPanel9.add(this.plotFormulaField);
        splusFunctionInfo.add(this.plotFormulaField, "plotFormulaString", true);
        this.plotSpecifiedFormula.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LinearMixedEffectsDialog.this.plotSpecifiedFormula.getValue().equals("T");
                LinearMixedEffectsDialog.this.plotFormulaField.setEnabled(bl);
            }
        });
        box15.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("General Options");
        box17.add(splusGroupPanel10);
        this.plotGroupColumn = new SplusDataColumnComboBox("Group Variable", 'G', (SplusDataColumnListProvider)this.dataSet);
        this.plotGroupColumn.setValue("");
        splusGroupPanel10.add(this.plotGroupColumn);
        splusFunctionInfo.add(this.plotGroupColumn, "plotGroupVars", true, true);
        SplusCheckBox splusCheckBox15 = new SplusCheckBox("Include Grid", 'I');
        splusGroupPanel10.add(splusCheckBox15);
        splusFunctionInfo.add(splusCheckBox15, "plotGrid.p");
        SplusGroupPanel splusGroupPanel11 = new SplusGroupPanel("Augmented Predictions Options");
        box17.add(splusGroupPanel11);
        this.plotAugPredLevels = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        this.plotAugPredLevels.setValue("");
        this.plotAugPredLevels.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredLevels);
        splusFunctionInfo.add(this.plotAugPredLevels, "plotAugLevel", false, true);
        this.plotAugPredColumn = new SplusDataColumnComboBox("Primary Covariate", 'C', (SplusDataColumnListProvider)this.dataSet);
        this.plotAugPredColumn.setValue("");
        this.plotAugPredColumn.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredColumn);
        splusFunctionInfo.add(this.plotAugPredColumn, "plotAugPrimary", true);
        this.plotAugPredMin = new SplusTextField("Minimum", 'M');
        this.plotAugPredMin.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredMin);
        splusFunctionInfo.add(this.plotAugPredMin, "plotAugMin");
        this.plotAugPredMax = new SplusTextField("Maximum", 'X');
        this.plotAugPredMax.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredMax);
        splusFunctionInfo.add(this.plotAugPredMax, "plotAugMax");
        this.plotAugPredLength = new SplusTextField("Number of Values", 'N');
        this.plotAugPredLength.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredLength);
        splusFunctionInfo.add(this.plotAugPredLength, "plotAugLength");
        this.plotAugPred.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LinearMixedEffectsDialog.this.plotAugPred.getValue().equals("T");
                LinearMixedEffectsDialog.this.plotAugPredColumn.setEnabled(bl);
                LinearMixedEffectsDialog.this.plotAugPredLevels.setEnabled(bl);
                LinearMixedEffectsDialog.this.plotAugPredMin.setEnabled(bl);
                LinearMixedEffectsDialog.this.plotAugPredMax.setEnabled(bl);
                LinearMixedEffectsDialog.this.plotAugPredLength.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel12 = new SplusGroupPanel("Variogram Options");
        box17.add(splusGroupPanel12);
        this.plotVariogramFormula = new SplusTextField("Formula", 'O');
        this.plotVariogramFormula.setEnabled(false);
        splusGroupPanel12.add(this.plotVariogramFormula);
        splusFunctionInfo.add(this.plotVariogramFormula, "plotVariogramFormula");
        this.plotVariogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LinearMixedEffectsDialog.this.plotVariogram.getValue().equals("T");
                LinearMixedEffectsDialog.this.plotVariogramFormula.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel13 = new SplusGroupPanel("Random Effects Options");
        box17.add(splusGroupPanel13);
        this.plotRandomLevels = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        this.plotRandomLevels.setValue("");
        this.plotRandomLevels.setEnabled(false);
        splusGroupPanel13.add(this.plotRandomLevels);
        splusFunctionInfo.add(this.plotRandomLevels, "plotRandomEffectsLevel", false, true);
        this.randomListener = new PlotRandomActionListener();
        this.plotRandomDot.addActionListener(this.randomListener);
        this.plotRandomScatter.addActionListener(this.randomListener);
        this.plotRandomQQ.addActionListener(this.randomListener);
        box17.add(new SplusBoxFiller());
        JPanel jPanel5 = new JPanel();
        jTabbedPane.addTab("Predict", jPanel5);
        Box box18 = new Box(1);
        Box box19 = new Box(1);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(box18);
        jPanel5.add(box19);
        SplusGroupPanel splusGroupPanel14 = new SplusGroupPanel("Standard Predictions");
        box18.add(splusGroupPanel14);
        this.predictSavePredictions = new SplusCheckBox("Save Predictions", 'P');
        splusGroupPanel14.add(this.predictSavePredictions);
        splusFunctionInfo.add(this.predictSavePredictions, "predict.p");
        this.predictSaveIn = new SplusDataSetComboBox("Save In", 'I');
        this.predictSaveIn.setValue("");
        this.predictSaveIn.setEnabled(false);
        splusGroupPanel14.add(this.predictSaveIn);
        splusFunctionInfo.add(this.predictSaveIn, "predName", true);
        this.predictLevels = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        this.predictLevels.setValue("");
        this.predictLevels.setEnabled(false);
        splusGroupPanel14.add(this.predictLevels);
        splusFunctionInfo.add(this.predictLevels, "predLevel", false, true);
        this.predictNewData = new SplusDataSetComboBox("New Data", 'N');
        this.predictNewData.setValue("");
        this.predictNewData.setEnabled(false);
        splusGroupPanel14.add(this.predictNewData);
        splusFunctionInfo.add(this.predictNewData, "predNewdata");
        this.predictSavePredictions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LinearMixedEffectsDialog.this.predictSavePredictions.getValue().equals("T");
                LinearMixedEffectsDialog.this.predictSaveIn.setEnabled(bl);
                LinearMixedEffectsDialog.this.predictLevels.setEnabled(bl);
                LinearMixedEffectsDialog.this.predictNewData.setEnabled(bl);
            }
        });
        box18.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel15 = new SplusGroupPanel("Augmented Predictions");
        box19.add(splusGroupPanel15);
        this.predictAugSavePredictions = new SplusCheckBox("Save Augmented Predictions", 'A');
        splusGroupPanel15.add(this.predictAugSavePredictions);
        splusFunctionInfo.add(this.predictAugSavePredictions, "augPred.p");
        this.predictAugSaveIn = new SplusDataSetComboBox("Save In", 'E');
        this.predictAugSaveIn.setValue("");
        this.predictAugSaveIn.setEnabled(false);
        splusGroupPanel15.add(this.predictAugSaveIn);
        splusFunctionInfo.add(this.predictAugSaveIn, "augPredName", true);
        this.predictAugLevels = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        this.predictAugLevels.setValue("");
        this.predictAugLevels.setEnabled(false);
        splusGroupPanel15.add(this.predictAugLevels);
        splusFunctionInfo.add(this.predictAugLevels, "augPredLevel", false, true);
        this.predictAugColumn = new SplusDataColumnComboBox("Primary Covariate", 'C', (SplusDataColumnListProvider)this.dataSet);
        this.predictAugColumn.setValue("");
        this.predictAugColumn.setEnabled(false);
        splusGroupPanel15.add(this.predictAugColumn);
        splusFunctionInfo.add(this.predictAugColumn, "augPredPrimary", true);
        this.predictAugMin = new SplusTextField("Minimum", 'M');
        this.predictAugMin.setEnabled(false);
        splusGroupPanel15.add(this.predictAugMin);
        splusFunctionInfo.add(this.predictAugMin, "augPredMin");
        this.predictAugMax = new SplusTextField("Maximum", 'X');
        this.predictAugMax.setEnabled(false);
        splusGroupPanel15.add(this.predictAugMax);
        splusFunctionInfo.add(this.predictAugMax, "augPredMax");
        this.predictAugLength = new SplusTextField("Number of Values", 'U');
        this.predictAugLength.setEnabled(false);
        splusGroupPanel15.add(this.predictAugLength);
        splusFunctionInfo.add(this.predictAugLength, "augPredLength");
        this.predictAugSavePredictions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LinearMixedEffectsDialog.this.predictAugSavePredictions.getValue().equals("T");
                LinearMixedEffectsDialog.this.predictAugSaveIn.setEnabled(bl);
                LinearMixedEffectsDialog.this.predictAugColumn.setEnabled(bl);
                LinearMixedEffectsDialog.this.predictAugLevels.setEnabled(bl);
                LinearMixedEffectsDialog.this.predictAugMin.setEnabled(bl);
                LinearMixedEffectsDialog.this.predictAugMax.setEnabled(bl);
                LinearMixedEffectsDialog.this.predictAugLength.setEnabled(bl);
            }
        });
        box19.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    private void buildRandomFormula() {
        String string;
        String string2 = this.groupVariables.getValue().trim();
        String string3 = this.randomTerms.getValue().trim();
        if (string2.length() == 0) {
            string = string3.length() == 0 ? "" : "~ " + string3;
        } else {
            if (string3.length() == 0) {
                string3 = "1";
            }
            string = "~ " + string3 + "| " + string2;
        }
        this.randomFormula.setValue(string);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet);
    }

    private class PlotRandomActionListener
    implements ActionListener {
        private PlotRandomActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = LinearMixedEffectsDialog.this.plotRandomDot.getValue().equals("T") || LinearMixedEffectsDialog.this.plotRandomScatter.getValue().equals("T") || LinearMixedEffectsDialog.this.plotRandomQQ.getValue().equals("T");
            LinearMixedEffectsDialog.this.plotRandomLevels.setEnabled(bl);
        }
    }
}

