/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.webDAV;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.webdav.lib.WebdavResource;

public class WebDAVClient {
    private static WebdavResource getWebdavRootAsResource(String string, String string2, String string3) {
        WebdavResource webdavResource = null;
        try {
            HttpURL httpURL = new HttpURL(string);
            httpURL.setUserinfo(string2, string3);
            webdavResource = new WebdavResource(httpURL);
        }
        catch (URIException uRIException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, uRIException.getMessage(), uRIException);
        }
        catch (NullPointerException nullPointerException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, nullPointerException.getMessage(), nullPointerException);
        }
        catch (HttpException httpException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, httpException.getMessage(), httpException);
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return webdavResource;
    }

    public static boolean downloadFile(String string, String string2, String string3, String string4, String string5) {
        boolean bl = false;
        try {
            WebdavResource webdavResource = WebDAVClient.getWebdavRootAsResource(string4, string2, string3);
            if (webdavResource != null) {
                File file = new File(string5);
                bl = webdavResource.getMethod(file);
                webdavResource.close();
            }
        }
        catch (HttpException httpException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, httpException.getMessage(), httpException);
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return bl;
    }

    public static boolean uploadFile(String string, String string2, String string3, String string4, String string5) {
        boolean bl = false;
        try {
            WebdavResource webdavResource = WebDAVClient.getWebdavRootAsResource(string4, string2, string3);
            if (webdavResource != null) {
                File file = new File(string5);
                bl = webdavResource.putMethod(file);
                webdavResource.close();
            }
        }
        catch (HttpException httpException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, httpException.getMessage(), httpException);
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return bl;
    }

    public static boolean isFolder(String string, String string2, String string3, String string4) {
        boolean bl = false;
        try {
            WebdavResource webdavResource = WebDAVClient.getWebdavRootAsResource(string4, string2, string3);
            if (webdavResource != null) {
                bl = webdavResource.isCollection();
                webdavResource.close();
            }
        }
        catch (HttpException httpException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, httpException.getMessage(), httpException);
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return bl;
    }

    public static boolean exists(String string, String string2, String string3, String string4) {
        boolean bl = false;
        try {
            WebdavResource webdavResource = WebDAVClient.getWebdavRootAsResource(string4, string2, string3);
            if (webdavResource != null) {
                bl = webdavResource.exists();
                webdavResource.close();
            }
        }
        catch (HttpException httpException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, httpException.getMessage(), httpException);
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return bl;
    }

    public static String[] getFolderContents(String string, String string2, String string3, String string4) {
        String[] stringArray = null;
        try {
            WebdavResource webdavResource = WebDAVClient.getWebdavRootAsResource(string4, string2, string3);
            if (webdavResource != null) {
                stringArray = webdavResource.list();
                webdavResource.close();
            }
        }
        catch (HttpException httpException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, httpException.getMessage(), httpException);
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger(WebDAVClient.class.toString());
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        String string = "http://atlantic:8080";
        String string2 = string + "/SplusServer/webdav";
        boolean bl = WebDAVClient.exists(string, "admin", "admin", string2);
        boolean bl2 = WebDAVClient.isFolder(string, "test", "test", string2);
        String[] stringArray2 = WebDAVClient.getFolderContents(string, "test", "test", string2);
        String string3 = string2 + "/foo.txt";
        String string4 = "d:/fooey.txt";
        boolean bl3 = WebDAVClient.uploadFile(string, "test", "test", string3, string4);
        boolean bl4 = WebDAVClient.exists(string, "admin", "admin", string3);
        stringArray2 = WebDAVClient.getFolderContents(string, "test", "test", string2);
        boolean bl5 = WebDAVClient.downloadFile(string, "test", "test", string3, string4);
        boolean bl6 = false;
    }
}

