/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.StandardLegend;
import com.jrefinery.chart.event.LegendChangeEvent;
import com.jrefinery.chart.event.LegendChangeListener;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Legend {
    public static final int WEST = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    protected static final int INVERTED = 2;
    protected static final int HORIZONTAL = 1;
    protected int _anchor = 3;
    protected JFreeChart chart;
    protected int outerGap;
    protected List listeners;

    public static Legend createInstance(JFreeChart jFreeChart) {
        return new StandardLegend(jFreeChart);
    }

    public Legend(JFreeChart jFreeChart, int n) {
        this.chart = jFreeChart;
        this.outerGap = n;
        this.listeners = new ArrayList();
    }

    public abstract Rectangle2D draw(Graphics2D var1, Rectangle2D var2);

    public void addChangeListener(LegendChangeListener legendChangeListener) {
        this.listeners.add(legendChangeListener);
    }

    public void removeChangeListener(LegendChangeListener legendChangeListener) {
        this.listeners.remove(legendChangeListener);
    }

    protected void notifyListeners(LegendChangeEvent legendChangeEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            LegendChangeListener legendChangeListener = (LegendChangeListener)iterator.next();
            legendChangeListener.legendChanged(legendChangeEvent);
        }
    }

    public int getAnchor() {
        return this._anchor;
    }

    public void setAnchor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this._anchor = n;
                this.notifyListeners(new LegendChangeEvent(this));
                break;
            }
        }
    }
}

