/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalLogarithmicAxis
extends VerticalNumberAxis {
    public VerticalLogarithmicAxis() {
        this(null);
    }

    public VerticalLogarithmicAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 1.0, 10.0);
        this.autoRange = true;
    }

    public VerticalLogarithmicAxis(String string, Font font, double d, double d2) {
        this(string, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, d, d2, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public VerticalLogarithmicAxis(String string, Font font, Paint paint, Insets insets, boolean bl, boolean bl2, Font font2, Paint paint2, Insets insets2, boolean bl3, Stroke stroke, boolean bl4, boolean bl5, Number number, double d, double d2, boolean bl6, boolean bl7, NumberTickUnit numberTickUnit, boolean bl8, Stroke stroke2, Paint paint3, boolean bl9, double d3, Stroke stroke3, Paint paint4) {
        super(string, font, paint, insets, bl, bl2, font2, paint2, insets2, bl3, stroke, bl4, bl5, false, number, d, d2, bl6, bl7, numberTickUnit, bl8, stroke2, paint3, bl9, d3, stroke3, paint4);
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        double d2 = this.minimumAxisValue;
        double d3 = this.maximumAxisValue;
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D.getMinY();
        if (d != 0.0) {
            d = Math.log(d) / Math.log(10.0);
        }
        if (d2 != 0.0) {
            d2 = Math.log(d2) / Math.log(10.0);
        }
        if (d3 != 0.0) {
            d3 = Math.log(d3) / Math.log(10.0);
        }
        if (this.inverted) {
            return d5 + (d - d2) / (d3 - d2) * (d4 - d5);
        }
        return d4 - (d - d2) / (d3 - d2) * (d4 - d5);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        double d = this.minimumAxisValue;
        double d2 = this.maximumAxisValue;
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getMaxY();
        if (d != 0.0) {
            d = Math.log(d) / Math.log(10.0);
        }
        if (d2 != 0.0) {
            d2 = Math.log(d2) / Math.log(10.0);
        }
        if (this.inverted) {
            return d + Math.pow(10.0, ((double)f - d3) / (d4 - d3) * (d2 - d));
        }
        return d2 - Math.pow(10.0, ((double)f - d3) / (d4 - d3) * (d2 - d));
    }

    public void autoAdjustRange() {
        if (this.plot != null && this.plot instanceof VerticalValuePlot) {
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)this.plot);
            Number number = verticalValuePlot.getMaximumVerticalDataValue();
            double d = 1.0;
            if (number != null) {
                d = number.doubleValue();
            }
            d = this.computeLogCeil(d);
            Number number2 = verticalValuePlot.getMinimumVerticalDataValue();
            double d2 = 0.0;
            if (number2 != null) {
                d2 = number2.doubleValue();
            }
            this.minimumAxisValue = d2 = this.computeLogFloor(d2);
            this.maximumAxisValue = d;
        }
    }

    private double computeLogCeil(double d) {
        double d2 = Math.log(d) / Math.log(10.0);
        d2 = Math.ceil(d2);
        d2 = Math.pow(10.0, d2);
        return d2;
    }

    private double computeLogFloor(double d) {
        double d2 = Math.log(d) / Math.log(10.0);
        d2 = Math.floor(d2);
        d2 = Math.pow(10.0, d2);
        return d2;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (this.label != null) {
            double d;
            double d2;
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            Rectangle2D rectangle2D3 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            if (this.verticalLabel) {
                d2 = rectangle2D.getX() + (double)this.labelInsets.left + rectangle2D3.getHeight();
                d = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 + rectangle2D3.getWidth() / 2.0;
                this.drawVerticalString(this.label, graphics2D, (float)d2, (float)d);
            } else {
                d2 = rectangle2D.getX() + (double)this.labelInsets.left;
                d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - rectangle2D3.getHeight() / 2.0;
                graphics2D.drawString(this.label, (float)d2, (float)d);
            }
        }
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
        double d = rectangle2D2.getX();
        graphics2D.setFont(this.tickLabelFont);
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Line2D.Double double_;
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
            if (this.tickLabelsVisible) {
                graphics2D.setPaint(this.tickLabelPaint);
                graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
            }
            if (this.tickMarksVisible) {
                graphics2D.setStroke(this.getTickMarkStroke());
                double_ = new Line2D.Double(rectangle2D2.getX() - 2.0, f, rectangle2D2.getX() + 2.0, f);
                graphics2D.draw(double_);
            }
            if (!this.gridLinesVisible) continue;
            graphics2D.setStroke(this.gridStroke);
            graphics2D.setPaint(this.gridPaint);
            double_ = new Line2D.Double(d, f, rectangle2D2.getMaxX(), f);
            graphics2D.draw(double_);
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (this.minimumAxisValue == 0.0) {
            this.minimumAxisValue = 1.0;
        }
        this.ticks.clear();
        int n = (int)Math.rint(Math.log(this.minimumAxisValue) / Math.log(10.0));
        int n2 = (int)Math.rint(Math.log(this.maximumAxisValue) / Math.log(10.0));
        int n3 = n;
        while (n3 <= n2) {
            int n4 = 10;
            if (n3 == n2) {
                n4 = 1;
            }
            int n5 = 0;
            while (n5 < n4) {
                Double d = new Double(Math.pow(10.0, n3) + Math.pow(10.0, n3) * (double)n5);
                double d2 = this.translateValueToJava2D(d, rectangle2D2);
                String string = "";
                if (n5 == 0) {
                    string = String.valueOf(((Number)d).intValue());
                }
                Rectangle2D rectangle2D3 = this.tickLabelFont.getStringBounds(string, graphics2D.getFontRenderContext());
                float f = (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.tickLabelInsets.left - (double)this.tickLabelInsets.right);
                float f2 = (float)(d2 + rectangle2D3.getHeight() / 2.0);
                Tick tick = new Tick(d, string, f, f2);
                this.ticks.add(tick);
                ++n5;
            }
            ++n3;
        }
    }
}

