/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.combination;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.combination.AxisRange;
import com.jrefinery.chart.combination.CombinableAxis;
import com.jrefinery.chart.combination.DateAxisRange;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.Iterator;

public class CombinedHorizontalDateAxis
extends HorizontalDateAxis
implements CombinableAxis {
    private HorizontalDateAxis parentAxis = null;
    private boolean visible = false;
    private double reserveHeight = 0.0;

    public CombinedHorizontalDateAxis(HorizontalDateAxis horizontalDateAxis, boolean bl) {
        super(horizontalDateAxis.getLabel(), horizontalDateAxis.getLabelFont(), horizontalDateAxis.getLabelPaint(), horizontalDateAxis.getLabelInsets(), horizontalDateAxis.isTickLabelsVisible(), horizontalDateAxis.getTickLabelFont(), horizontalDateAxis.getTickLabelPaint(), horizontalDateAxis.getTickLabelInsets(), horizontalDateAxis.getVerticalTickLabels(), horizontalDateAxis.isTickMarksVisible(), horizontalDateAxis.getTickMarkStroke(), horizontalDateAxis.isAutoRange(), horizontalDateAxis.getMinimumDate(), horizontalDateAxis.getMaximumDate(), horizontalDateAxis.isAutoTickUnitSelection(), horizontalDateAxis.getTickUnit(), horizontalDateAxis.getTickLabelFormatter(), horizontalDateAxis.isGridLinesVisible(), horizontalDateAxis.getGridStroke(), horizontalDateAxis.getGridPaint(), horizontalDateAxis.isCrosshairVisible(), horizontalDateAxis.getCrosshairDate(), horizontalDateAxis.getCrosshairStroke(), horizontalDateAxis.getCrosshairPaint());
        this.parentAxis = horizontalDateAxis;
        this.visible = bl;
        this.setCrosshairVisible(horizontalDateAxis.isCrosshairVisible());
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (this.visible) {
            this.parentAxis.draw(graphics2D, rectangle2D, rectangle2D2);
        } else if (this.gridLinesVisible) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
            graphics2D.setStroke(this.gridStroke);
            graphics2D.setPaint(this.gridPaint);
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
                Line2D.Float float_ = new Line2D.Float(f, (float)rectangle2D2.getMaxY(), f, (float)rectangle2D2.getMinY());
                graphics2D.draw(float_);
            }
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        if (this.reserveHeight > 0.0) {
            return this.reserveHeight;
        }
        return this.parentAxis.reserveHeight(graphics2D, plot, rectangle2D);
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        if (this.visible) {
            return this.parentAxis.reserveAxisArea(graphics2D, plot, rectangle2D, d);
        }
        return new Rectangle2D.Double();
    }

    public Axis getParentAxis() {
        return this.parentAxis;
    }

    public AxisRange getRange() {
        DateAxisRange dateAxisRange = null;
        if (this.visible) {
            this.parentAxis.autoAdjustRange();
            dateAxisRange = new DateAxisRange(this.parentAxis.getMinimumDate(), this.parentAxis.getMaximumDate());
        } else {
            this.autoAdjustRange();
            dateAxisRange = new DateAxisRange(this.getMinimumDate(), this.getMaximumDate());
        }
        return dateAxisRange;
    }

    public void setRange(AxisRange axisRange) {
        this.setAutoRange(false);
        this.setMinimumDate((Date)axisRange.getMin());
        this.setMaximumDate((Date)axisRange.getMax());
        if (this.visible) {
            this.parentAxis.setAutoRange(false);
            this.parentAxis.setMinimumDate((Date)axisRange.getMin());
            this.parentAxis.setMaximumDate((Date)axisRange.getMax());
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setReserveDimension(double d) {
        this.reserveHeight = d;
    }
}

