/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.combination;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalSymbolicAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.combination.AxisRange;
import com.jrefinery.chart.combination.CombinableAxis;
import com.jrefinery.chart.combination.NumberAxisRange;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class CombinedHorizontalSymbolicAxis
extends HorizontalSymbolicAxis
implements CombinableAxis {
    private HorizontalSymbolicAxis parentAxis = null;
    private boolean visible = false;
    private double reserveHeight = 0.0;

    public CombinedHorizontalSymbolicAxis(HorizontalSymbolicAxis horizontalSymbolicAxis, boolean bl) {
        this(horizontalSymbolicAxis, true, bl);
    }

    public CombinedHorizontalSymbolicAxis(HorizontalSymbolicAxis horizontalSymbolicAxis, boolean bl, boolean bl2) {
        super(horizontalSymbolicAxis.getLabel(), horizontalSymbolicAxis.getSymbolicValue(), horizontalSymbolicAxis.getLabelFont(), horizontalSymbolicAxis.getLabelPaint(), horizontalSymbolicAxis.getLabelInsets(), horizontalSymbolicAxis.isTickLabelsVisible(), horizontalSymbolicAxis.getTickLabelFont(), horizontalSymbolicAxis.getTickLabelPaint(), horizontalSymbolicAxis.getTickLabelInsets(), horizontalSymbolicAxis.getVerticalTickLabels(), horizontalSymbolicAxis.isTickMarksVisible(), horizontalSymbolicAxis.getTickMarkStroke(), horizontalSymbolicAxis.isAutoRange(), horizontalSymbolicAxis.autoRangeIncludesZero(), horizontalSymbolicAxis.autoRangeStickyZero(), horizontalSymbolicAxis.getAutoRangeMinimumSize(), horizontalSymbolicAxis.getMinimumAxisValue(), horizontalSymbolicAxis.getMaximumAxisValue(), horizontalSymbolicAxis.isInverted(), horizontalSymbolicAxis.isAutoTickUnitSelection(), horizontalSymbolicAxis.getTickUnit(), horizontalSymbolicAxis.isGridLinesVisible(), horizontalSymbolicAxis.getGridStroke(), horizontalSymbolicAxis.getGridPaint(), horizontalSymbolicAxis.isCrosshairVisible(), horizontalSymbolicAxis.getCrosshairValue(), horizontalSymbolicAxis.getCrosshairStroke(), horizontalSymbolicAxis.getCrosshairPaint(), bl2, horizontalSymbolicAxis.getSymbolicGridPaint());
        this.parentAxis = horizontalSymbolicAxis;
        this.visible = bl;
        this.setCrosshairVisible(horizontalSymbolicAxis.isCrosshairVisible());
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (this.visible) {
            this.parentAxis.draw(graphics2D, rectangle2D, rectangle2D2);
        } else if (this.symbolicGridLinesVisible) {
            this.parentAxis.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2);
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        if (this.reserveHeight > 0.0) {
            return this.reserveHeight;
        }
        return this.parentAxis.reserveHeight(graphics2D, plot, rectangle2D);
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        if (this.visible) {
            return this.parentAxis.reserveAxisArea(graphics2D, plot, rectangle2D, d);
        }
        return new Rectangle2D.Double();
    }

    public Axis getParentAxis() {
        return this.parentAxis;
    }

    public AxisRange getRange() {
        this.autoAdjustRange();
        return new NumberAxisRange(new Double(this.getMinimumAxisValue()), new Double(this.getMaximumAxisValue()));
    }

    public void setRange(AxisRange axisRange) {
        this.setAutoRange(false);
        Number number = (Number)axisRange.getMin();
        Number number2 = (Number)axisRange.getMax();
        this.setMinimumAxisValue(number.doubleValue());
        this.setMaximumAxisValue(number2.doubleValue());
        if (this.visible) {
            HorizontalNumberAxis horizontalNumberAxis = (HorizontalNumberAxis)this.getParentAxis();
            horizontalNumberAxis.setAutoRange(false);
            horizontalNumberAxis.setMinimumAxisValue(number.doubleValue());
            horizontalNumberAxis.setMaximumAxisValue(number2.doubleValue());
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setReserveDimension(double d) {
        this.reserveHeight = d;
    }
}

