/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.JFreeChartFrame;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalSymbolicAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.combination.CombinedChart;
import com.jrefinery.chart.combination.CombinedPlot;
import com.jrefinery.chart.combination.OverlaidPlot;
import com.jrefinery.chart.demo.SampleYSymbolicDataset;
import com.jrefinery.chart.tooltips.SymbolicXYToolTipGenerator;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.YisSymbolic;
import com.jrefinery.ui.JRefineryUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Window;
import javax.swing.JFrame;

public class SymbolicYPlotDemo {
    private static void displayYSymbolic(XYDataset xYDataset, String string, String string2, String string3) {
        JFreeChart jFreeChart = SymbolicYPlotDemo.createYSymbolicPlot(string, string2, string3, xYDataset, true);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        JFreeChartFrame jFreeChartFrame = new JFreeChartFrame("Y Symbolic", jFreeChart);
        jFreeChartFrame.pack();
        JRefineryUtilities.positionFrameRandomly((JFrame)jFreeChartFrame);
        jFreeChartFrame.show();
    }

    private static void displayYSymbolicCombinedVertically(SampleYSymbolicDataset sampleYSymbolicDataset, SampleYSymbolicDataset sampleYSymbolicDataset2) {
        Object object;
        String string = "Animals Horizontally Combined";
        String string2 = "Miles";
        String string3 = "Animal";
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add((SeriesDataset)sampleYSymbolicDataset);
        combinedDataset.add((SeriesDataset)sampleYSymbolicDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        SubSeriesDataset subSeriesDataset3 = new SubSeriesDataset((SeriesDataset)combinedDataset, 2);
        SubSeriesDataset subSeriesDataset4 = new SubSeriesDataset((SeriesDataset)combinedDataset, 3);
        SubSeriesDataset subSeriesDataset5 = new SubSeriesDataset((SeriesDataset)combinedDataset, 4);
        SubSeriesDataset subSeriesDataset6 = new SubSeriesDataset((SeriesDataset)combinedDataset, 5);
        SubSeriesDataset subSeriesDataset7 = new SubSeriesDataset((SeriesDataset)combinedDataset, 6);
        SubSeriesDataset subSeriesDataset8 = new SubSeriesDataset((SeriesDataset)combinedDataset, 7);
        JFreeChart jFreeChart = null;
        try {
            object = new HorizontalNumberAxis(string2);
            VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string3, sampleYSymbolicDataset.getYSymbolicValues());
            VerticalSymbolicAxis verticalSymbolicAxis2 = new VerticalSymbolicAxis(string3, sampleYSymbolicDataset2.getYSymbolicValues());
            verticalSymbolicAxis.setCrosshairVisible(false);
            verticalSymbolicAxis2.setCrosshairVisible(false);
            ((ValueAxis)object).setCrosshairVisible(false);
            CombinedPlot combinedPlot = new CombinedPlot((Axis)object, 1);
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset2, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset3, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset4, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis2, (Dataset)subSeriesDataset5, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis2, (Dataset)subSeriesDataset6, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis2, (Dataset)subSeriesDataset7, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis2, (Dataset)subSeriesDataset8, 0));
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
        }
        catch (AxisNotCompatibleException axisNotCompatibleException) {
            System.err.println("axis not compatible: " + axisNotCompatibleException);
        }
        catch (PlotNotCompatibleException plotNotCompatibleException) {
            System.err.println("axis not compatible: " + plotNotCompatibleException);
        }
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        object = new JFreeChartFrame("XYPlot", jFreeChart);
        ((Window)object).pack();
        JRefineryUtilities.positionFrameRandomly((JFrame)object);
        ((Window)object).show();
    }

    private static void displayYSymbolicCombinedHorizontally(SampleYSymbolicDataset sampleYSymbolicDataset, SampleYSymbolicDataset sampleYSymbolicDataset2) {
        Object object;
        String string = "Animals Horizontally Combined";
        String string2 = "Miles";
        String string3 = "Animal";
        String[] stringArray = SampleYSymbolicDataset.combineYSymbolicDataset(sampleYSymbolicDataset, sampleYSymbolicDataset2);
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add((SeriesDataset)sampleYSymbolicDataset);
        combinedDataset.add((SeriesDataset)sampleYSymbolicDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        SubSeriesDataset subSeriesDataset3 = new SubSeriesDataset((SeriesDataset)combinedDataset, 2);
        SubSeriesDataset subSeriesDataset4 = new SubSeriesDataset((SeriesDataset)combinedDataset, 3);
        SubSeriesDataset subSeriesDataset5 = new SubSeriesDataset((SeriesDataset)combinedDataset, 4);
        SubSeriesDataset subSeriesDataset6 = new SubSeriesDataset((SeriesDataset)combinedDataset, 5);
        SubSeriesDataset subSeriesDataset7 = new SubSeriesDataset((SeriesDataset)combinedDataset, 6);
        SubSeriesDataset subSeriesDataset8 = new SubSeriesDataset((SeriesDataset)combinedDataset, 7);
        JFreeChart jFreeChart = null;
        try {
            object = new HorizontalNumberAxis(string2);
            HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
            VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string3, stringArray);
            verticalSymbolicAxis.setCrosshairVisible(false);
            ((ValueAxis)object).setCrosshairVisible(false);
            horizontalNumberAxis.setCrosshairVisible(false);
            CombinedPlot combinedPlot = new CombinedPlot((Axis)verticalSymbolicAxis, 0);
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset2, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset3, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset4, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart(horizontalNumberAxis, verticalSymbolicAxis, (Dataset)subSeriesDataset5, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart(horizontalNumberAxis, verticalSymbolicAxis, (Dataset)subSeriesDataset6, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart(horizontalNumberAxis, verticalSymbolicAxis, (Dataset)subSeriesDataset7, 0));
            combinedPlot.add(SymbolicYPlotDemo.createCombinableXYChart(horizontalNumberAxis, verticalSymbolicAxis, (Dataset)subSeriesDataset8, 0));
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
        }
        catch (AxisNotCompatibleException axisNotCompatibleException) {
            System.err.println("axis not compatible: " + axisNotCompatibleException);
        }
        catch (PlotNotCompatibleException plotNotCompatibleException) {
            System.err.println("axis not compatible: " + plotNotCompatibleException);
        }
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        object = new JFreeChartFrame("XYPlot", jFreeChart);
        ((Window)object).pack();
        JRefineryUtilities.positionFrameRandomly((JFrame)object);
        ((Window)object).show();
    }

    private static void displayYSymbolicOverlaid(XYDataset xYDataset, XYDataset xYDataset2) {
        Object object;
        String string = "Animals Overlaid";
        String string2 = "Miles";
        String string3 = "Animal";
        String[] stringArray = SampleYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)xYDataset, (YisSymbolic)xYDataset2);
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add((SeriesDataset)xYDataset);
        combinedDataset.add((SeriesDataset)xYDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        SubSeriesDataset subSeriesDataset3 = new SubSeriesDataset((SeriesDataset)combinedDataset, 2);
        SubSeriesDataset subSeriesDataset4 = new SubSeriesDataset((SeriesDataset)combinedDataset, 3);
        SubSeriesDataset subSeriesDataset5 = new SubSeriesDataset((SeriesDataset)combinedDataset, 4);
        SubSeriesDataset subSeriesDataset6 = new SubSeriesDataset((SeriesDataset)combinedDataset, 5);
        SubSeriesDataset subSeriesDataset7 = new SubSeriesDataset((SeriesDataset)combinedDataset, 6);
        SubSeriesDataset subSeriesDataset8 = new SubSeriesDataset((SeriesDataset)combinedDataset, 7);
        JFreeChart jFreeChart = null;
        try {
            object = new HorizontalNumberAxis(string2);
            VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string3, stringArray);
            verticalSymbolicAxis.setCrosshairVisible(false);
            ((ValueAxis)object).setCrosshairVisible(false);
            OverlaidPlot overlaidPlot = new OverlaidPlot((Axis)object, verticalSymbolicAxis);
            overlaidPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset, 0));
            overlaidPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset2, 0));
            overlaidPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset3, 0));
            overlaidPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset4, 0));
            overlaidPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset5, 0));
            overlaidPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset6, 0));
            overlaidPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset7, 0));
            overlaidPlot.add(SymbolicYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset8, 0));
            overlaidPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, overlaidPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
        }
        catch (AxisNotCompatibleException axisNotCompatibleException) {
            System.err.println("axis not compatible: " + axisNotCompatibleException);
        }
        catch (PlotNotCompatibleException plotNotCompatibleException) {
            System.err.println("axis not compatible: " + plotNotCompatibleException);
        }
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        object = new JFreeChartFrame("XYPlot", jFreeChart);
        ((Window)object).pack();
        JRefineryUtilities.positionFrameRandomly((JFrame)object);
        ((Window)object).show();
    }

    public static JFreeChart createYSymbolicPlot(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string3, ((YisSymbolic)xYDataset).getYSymbolicValues());
        XYPlot xYPlot = new XYPlot(horizontalNumberAxis, verticalSymbolicAxis);
        xYPlot.setXYItemRenderer(new StandardXYItemRenderer(1));
        xYPlot.setToolTipGenerator(new SymbolicXYToolTipGenerator());
        JFreeChart jFreeChart = new JFreeChart((Dataset)xYDataset, xYPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, bl);
        return jFreeChart;
    }

    public static CombinedChart createCombinableXYChart(ValueAxis valueAxis, ValueAxis valueAxis2, Dataset dataset, int n) {
        XYPlot xYPlot = new XYPlot(valueAxis, valueAxis2);
        xYPlot.setXYItemRenderer(new StandardXYItemRenderer(1));
        return ChartFactory.createCombinableChart(dataset, xYPlot);
    }

    public static SampleYSymbolicDataset createYSymbolicSample1() {
        String[] stringArray = new String[]{"Lion", "Elephant", "Monkey", "Hippopotamus", "Giraffe"};
        SampleYSymbolicDataset sampleYSymbolicDataset = new SampleYSymbolicDataset("AY Sample", 20, stringArray, 4, 20, new String[]{"A Fall", "A Spring", "A Summer", "A Winter"});
        return sampleYSymbolicDataset;
    }

    public static SampleYSymbolicDataset createYSymbolicSample2() {
        String[] stringArray = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset sampleYSymbolicDataset = new SampleYSymbolicDataset("BY Sample", 40, stringArray, 4, 20, new String[]{"B Fall", "B Spring", "B Summer", "B Winter"});
        return sampleYSymbolicDataset;
    }

    public static void main(String[] stringArray) {
        SampleYSymbolicDataset sampleYSymbolicDataset = SymbolicYPlotDemo.createYSymbolicSample1();
        SampleYSymbolicDataset sampleYSymbolicDataset2 = SymbolicYPlotDemo.createYSymbolicSample2();
        SymbolicYPlotDemo.displayYSymbolic(sampleYSymbolicDataset, "Animal A", "Miles", "Animal");
        SymbolicYPlotDemo.displayYSymbolic(sampleYSymbolicDataset2, "Animal B", "Miles", "Animal");
        SymbolicYPlotDemo.displayYSymbolicCombinedVertically((SampleYSymbolicDataset)((Object)sampleYSymbolicDataset.clone()), (SampleYSymbolicDataset)((Object)sampleYSymbolicDataset2.clone()));
        SymbolicYPlotDemo.displayYSymbolicCombinedHorizontally((SampleYSymbolicDataset)((Object)sampleYSymbolicDataset.clone()), (SampleYSymbolicDataset)((Object)sampleYSymbolicDataset2.clone()));
        SymbolicYPlotDemo.displayYSymbolicOverlaid((SampleYSymbolicDataset)((Object)sampleYSymbolicDataset.clone()), (SampleYSymbolicDataset)((Object)sampleYSymbolicDataset2.clone()));
    }
}

