/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.cnkjava;

import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKProc;

public class CNKProcNNet
extends CNKProc {
    public void createPeerObject() {
        this.createCNKObject("cnkmisc", new String[]{"CNKProcNNet", "CNKProc", "CNKObj"});
    }

    public CNKProcNNet() {
    }

    public CNKProcNNet(CNKBuf inbuf, int numRows) {
        this();
        this.setInbuf(inbuf);
        this.setNumRows(numRows);
    }

    public void setModel(String modelXML) {
        this.setProp("model.imml", modelXML);
    }

    public String getModel() {
        String xml = this.getStringProp("fitted.model.pmml", null);
        return xml;
    }

    public void setOptParameters(int epocs, double accuracy, int layers, int nodes, String method, double learnRate, double momentum, double weightDecay, int finalModel) {
        this.setProp("epochs", new Integer(epocs));
        this.setProp("accuracy", new Double(accuracy));
        this.setProp("hidden.layers", new Integer(layers));
        this.setProp("nodes.per.layer", new Integer(nodes));
        this.setProp("training.method", method);
        this.setProp("learning.rate", new Double(learnRate));
        this.setProp("momentum", new Double(momentum));
        this.setProp("weight.decay", new Double(weightDecay));
        this.setProp("final.model", new Integer(finalModel));
    }

    public void setMaxEpochs(int epocs) {
        this.setProp("epochs", new Integer(epocs));
    }

    public void setConvergenceTol(double tol) {
        this.setProp("accuracy", new Double(tol));
    }

    public void setTrainingMethod(String method) {
        this.setProp("training.method", method);
    }

    public void setLearningRate(double learnRate) {
        this.setProp("learning.rate", new Double(learnRate));
    }

    public void setMomentum(double momentum) {
        this.setProp("momentum", new Double(momentum));
    }

    public void setWeightDecay(double weightDecay) {
        this.setProp("weight.decay", new Double(weightDecay));
    }

    public void setSeed(int seed) {
        this.setProp("seed", new Integer(seed));
    }

    public void setUserStop(int option, String file) {
        this.setProp("user.stop", new Object[]{new Integer(option), file});
    }

    public boolean getUserStop() {
        int val = this.getIntProp("user.stop", null);
        return val != 0;
    }

    public void setConfigData(String file) {
        this.setProp("load.NNet.fit", file);
    }

    public void getCurrentConfig(String file) {
        this.setProp("save.NNet.fit", new Object[]{file, new Integer(2)});
    }

    public void getConfigWithBestWeights(String file) {
        this.setProp("save.NNet.fit", new Object[]{file, new Integer(1)});
    }

    public void setValidationPercent(int percent) {
        this.setProp("validation.percent", new Integer(percent));
    }

    public int getEpoch() {
        int val = this.getIntProp("epoch", null);
        return val;
    }

    public double getEpochDev() {
        double val = this.getDoubleProp("epoch.dev", null);
        return val;
    }

    public double getEpochValidateDev() {
        double val = this.getDoubleProp("epoch.validate.dev", null);
        return val;
    }

    public int getEpochNumberOfBestWeights() {
        int val = this.getIntProp("epoch.best.weights", null);
        return val;
    }

    public double getEpochDeltaDev() {
        double val = this.getDoubleProp("epoch.delta.dev", null);
        return val;
    }

    public double getEpochAccuracy() {
        double val = this.getDoubleProp("epoch.accuracy", null);
        return val;
    }

    public double[] getCurrentWeights() {
        int nw = this.getIntProp("number.weights", null);
        if (nw <= 0) {
            return null;
        }
        double[] wts = new double[nw];
        this.setProp("get.current.weights", wts);
        return wts;
    }

    public boolean isSearchComplete() {
        int b = this.getIntProp("search.complete", null);
        return b == 1;
    }

    public void setJitterWeights(int percent) {
        this.setProp("jitter.weights", new Integer(percent));
    }

    public void setProgressNotification(int iter) {
        this.setProp("progress.notification", new Integer(iter));
    }
}

