/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeConfigured;
import com.insightful.miner.ActivityNodeState;
import com.insightful.miner.CommentUtilities;
import com.insightful.miner.DefaultNodeDialog;
import com.insightful.miner.ExtensionManager;
import com.insightful.miner.GridDataSource;
import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.HelpManager;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerFrame;
import com.insightful.miner.NodeViewer;
import com.insightful.miner.PMMLExportable;
import com.insightful.miner.PMMLImportable;
import com.insightful.miner.PredictNodeModel;
import com.insightful.miner.StateVisualCueImage;
import com.insightful.miner.UnknownNodeModel;
import com.insightful.miner.Viewable;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;

public class ActivityNodeModel
implements ChangeListener,
Serializable,
Viewable {
    private int m_id = -1;
    private XMLTree m_comments = null;
    private ActivityNodeState m_state;
    protected Vector m_inputs = null;
    Vector m_modelInputs = null;
    private Vector m_listeners = null;
    Vector m_modelListeners = null;
    private WorksheetDocument m_document = null;
    protected XTNetwork.NodeInfo m_nodeInfo = null;
    private GridDataSource[] dataSources = null;
    static String UNKNOWN_NODE_MODEL = "UnknownNodeModel";
    static String UNKNOWN_NODE_LARGE_ICON = "unknown_large.gif";
    static String UNKNOWN_NODE_SMALL_ICON = "unknown_small.gif";

    public ActivityNodeModel() {
        this.setNodeModelContents(new XTNetwork.NodeInfo());
    }

    public void initializeNodeModel() {
    }

    protected static ActivityNodeModel createActivityNodeModel(String className, XTNetwork.NodeInfo info, Element elt) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Constructor constructor = null;
        ActivityNodeModel model = null;
        String badClassMsg = null;
        for (int i = 0; model == null && i < 2; ++i) {
            try {
                if (i > 0) {
                    badClassMsg = "Class " + className + " not found";
                    MinerApp.outputText("Error creating NodeModel: " + badClassMsg, 4, true);
                }
                Class toCreate = i == 0 ? ExtensionManager.getClassForName(className) : UnknownNodeModel.class;
                try {
                    constructor = toCreate.getConstructor(new Class[0]);
                    model = (ActivityNodeModel)constructor.newInstance(new Object[0]);
                    if (elt != null) {
                        model.setNodeModelContents(elt);
                    } else {
                        model.setNodeModelContents(info);
                    }
                    model.initializeNodeModel();
                }
                catch (NoSuchMethodException ex) {
                    if (elt != null) {
                        constructor = toCreate.getConstructor(Element.class);
                        model = (ActivityNodeModel)constructor.newInstance(elt);
                        continue;
                    }
                    constructor = toCreate.getConstructor(XTNetwork.NodeInfo.class);
                    model = (ActivityNodeModel)constructor.newInstance(info);
                }
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                if (i != 1) continue;
                throw cnfe;
            }
        }
        if (badClassMsg != null && model instanceof UnknownNodeModel) {
            ((UnknownNodeModel)model).setBadClassMessage(badClassMsg);
        }
        return model;
    }

    protected static ActivityNodeModel createActivityNodeModel(String className, XTNetwork.NodeInfo info) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        return ActivityNodeModel.createActivityNodeModel(className, info, null);
    }

    protected static ActivityNodeModel createActivityNodeModel(String className, Element elt) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        return ActivityNodeModel.createActivityNodeModel(className, null, elt);
    }

    protected ActivityNodeModel(XTNetwork.NodeInfo info) {
        this();
        this.setNodeModelContents(info);
        this.initializeNodeModel();
    }

    protected void setNodeModelContents(XTNetwork.NodeInfo info) {
        XMLTree comment;
        this.m_inputs = new Vector();
        this.m_modelInputs = new Vector();
        this.m_listeners = new Vector();
        this.m_modelListeners = new Vector();
        if (info == null) {
            throw new IllegalArgumentException("Node cannot be created.");
        }
        if (info.comments == null) {
            info.comments = new XTNetwork.XMLInfo();
        }
        if ((comment = info.comments.tree) == null) {
            try {
                String user = MinerApp.getUserName();
                Date now = new Date(System.currentTimeMillis());
                SimpleDateFormat df = new SimpleDateFormat("MMMMMMMMM dd, yyyy");
                this.m_comments = info.comments.tree = new XMLTree(CommentUtilities.createNewComments(null, user, df.format(now)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.m_comments = info.comments.tree;
        }
        this.m_nodeInfo = info;
        this.setState(ActivityNodeState.initiateState(this));
    }

    protected ActivityNodeModel(Element elt) {
        this();
        this.setNodeModelContents(elt);
        this.initializeNodeModel();
    }

    protected void setNodeModelContents(Element elt) {
        this.m_inputs = new Vector();
        this.m_modelInputs = new Vector();
        this.m_listeners = new Vector();
        this.m_modelListeners = new Vector();
        if (!elt.getNodeName().equals(XTNetwork.ACTIVITY_NODE_NODE_TAG)) {
            throw new IllegalArgumentException("XML Element is not an " + XTNetwork.ACTIVITY_NODE_NODE_TAG);
        }
        this.m_nodeInfo = new XTNetwork.NodeInfo();
        this.m_nodeInfo.convertFromXML(elt);
        this.m_comments = this.m_nodeInfo.comments.tree;
        this.setState(ActivityNodeState.initiateState(this));
    }

    public void showHelp() {
        String str = this.getDefaultLabel();
        if (str == null || str.equals("")) {
            str = "Welcome";
        }
        MinerApp.getHelpManager().showTopic(str);
    }

    public void setNumPorts(int numInputs, int numOutputs) {
        this.m_nodeInfo.numInputs = numInputs;
        this.m_nodeInfo.numOutputs = numOutputs;
        this.firePortsChangedEvent();
    }

    public int getNumInputs() {
        return this.m_nodeInfo.numInputs;
    }

    public int getNumInputLinks() {
        int inputs = this.m_nodeInfo.numInputs;
        if (inputs < 0) {
            inputs = this.m_inputs.size();
        }
        return inputs;
    }

    public int getNumOutputs() {
        return this.m_nodeInfo.numOutputs;
    }

    public String getLabelText() {
        return this.m_nodeInfo.labelText.replaceAll("\n", "");
    }

    public void setLabelText(String newLabel) {
        this.m_nodeInfo.labelText = newLabel.replaceAll("\n", "");
    }

    public String getDefaultLabel() {
        return this.m_nodeInfo.defaultLabelText;
    }

    public void setDefaultLabel(String newLabel) {
        this.m_nodeInfo.defaultLabelText = newLabel;
    }

    public void setLargeIconName(String newName) {
        if (!newName.equals(this.m_nodeInfo.largeIcon)) {
            this.m_nodeInfo.largeIcon = newName;
            this.fireIconsChangedEvent();
        }
    }

    public String getLargeIconName() {
        String fileName = this.m_nodeInfo.largeIcon;
        String fullFileName = MinerApp.getResourceManager().findImageFile(fileName);
        if (fullFileName == null) {
            fullFileName = MinerApp.getResourceManager().findImageFile(UNKNOWN_NODE_LARGE_ICON);
        }
        return fullFileName;
    }

    public void setSmallIconName(String newName) {
        if (!newName.equals(this.m_nodeInfo.smallIcon)) {
            this.m_nodeInfo.smallIcon = newName;
            this.fireIconsChangedEvent();
        }
    }

    public String getSmallIconName() {
        String fileName = this.m_nodeInfo.smallIcon;
        String fullFileName = MinerApp.getResourceManager().findImageFile(fileName);
        if (fullFileName == null) {
            fullFileName = MinerApp.getResourceManager().findImageFile(UNKNOWN_NODE_SMALL_ICON);
        }
        return fullFileName;
    }

    public Element getComments() {
        if (this.m_comments == null) {
            return null;
        }
        return this.m_comments.getXML();
    }

    public void setComments(Element elt) {
        try {
            this.m_comments = new XMLTree(elt);
            if (this.m_nodeInfo.comments == null) {
                this.m_nodeInfo.comments = new XTNetwork.XMLInfo(this.m_comments);
            } else {
                this.m_nodeInfo.comments.tree = this.m_comments;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    XTNetwork.NodeInfo getNodeInfo() {
        return this.m_nodeInfo;
    }

    public XTProps getXTProps() {
        if (this.m_nodeInfo.properties == null) {
            try {
                XTProps props;
                this.m_nodeInfo.properties = props = new XTProps();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_nodeInfo.properties;
    }

    public void setXTProps(XTProps props) {
        this.m_nodeInfo.properties = (XTProps)props.copy();
    }

    public boolean postDialogEqualityCheck(XTProps oldProps, XTProps newProps) {
        return oldProps.equals(newProps);
    }

    void setID(int id) {
        this.m_id = id;
        this.m_nodeInfo.nodeID = Integer.toString(id);
    }

    public int getID() {
        return this.m_id;
    }

    StateVisualCueImage getStateVisualCue() {
        return this.getState().getStateVisualCue();
    }

    void setXPos(int x) {
        this.m_nodeInfo.x = x;
    }

    void setYPos(int y) {
        this.m_nodeInfo.y = y;
    }

    public String getToolTipText() {
        return this.getLabelText();
    }

    public String toString() {
        return this.getLabelText();
    }

    public void showPropertiesDialog() {
        this.showPropertiesDialog(false);
    }

    public void showPropertiesDialog(boolean modality) {
        DefaultNodeDialog dialog = DefaultNodeDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public void showView(Frame frame) {
        this.showDataViewer(0);
    }

    boolean hasSpecializedViewer() {
        Class<?> modelClass = this.getClass();
        try {
            Class<?> anmClass = modelClass;
            while (!anmClass.equals(ActivityNodeModel.class)) {
                anmClass = anmClass.getSuperclass();
            }
            Method thisMethod = modelClass.getMethod("showView", Frame.class);
            Method anmMethod = anmClass.getMethod("showView", Frame.class);
            boolean specializedViewer = !thisMethod.equals(anmMethod);
            return specializedViewer;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return false;
        }
    }

    void showHTMLViewer() {
        try {
            boolean output;
            boolean bl = output = this.getNumOutputs() > 0;
            if (output) {
                new HtmlFrame(this.getHtmlMetaDataString(this.getOutputMetaDataArray(), output));
            } else {
                new HtmlFrame(this.getHtmlMetaDataString(this.getInputMetaDataArray(), output));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String createHtmlCssString(XTMetaData[] metaDataArray, boolean isInput, String title) {
        int numOutputs = metaDataArray.length;
        StringBuffer htmlBuf = new StringBuffer();
        String colInfo = MinerApp.getText("NodeViewer_columnInformation");
        htmlBuf.append("<HTML>\n<TITLE>" + colInfo + ": " + title + " </TITLE>\n<BODY>\n<DIV>\n<H1>\n" + colInfo + ": " + title + "\n</H1>\n</DIV>\n");
        htmlBuf.append("<style type=\"text/css\">" + XMLTree.getCSSText() + "</style>");
        if (numOutputs == 1) {
            htmlBuf.append(metaDataArray[0].getHtmlString(XMLTree.META_DATA_XSL_FILE));
        } else {
            String io = (isInput ? MinerApp.getText("NodeViewer_inputText") : MinerApp.getText("NodeViewer_outputText")) + " ";
            for (int i = 0; i < numOutputs; ++i) {
                htmlBuf.append("<DIV>\n<H2>\n" + io + (i + 1) + " of " + numOutputs + "\n</H2>\n</DIV>\n");
                htmlBuf.append(metaDataArray[i].getHtmlString(XMLTree.META_DATA_XSL_FILE));
            }
        }
        htmlBuf.append("\n</BODY>\n</HTML>");
        return htmlBuf.toString();
    }

    public void showDataViewer(int initialPortSelected) {
        MinerFrame frame = MinerApp.getMainFrame();
        Component comp = frame.getGlassPane();
        Cursor oldCursor = comp.getCursor();
        comp.setCursor(Cursor.getPredefinedCursor(3));
        comp.setVisible(true);
        if (this.getNumOutputs() > 0) {
            new NodeViewer(this.getLabelText(), this.getID(), this, this.getOutputMetaDataArray(), false, initialPortSelected).show();
        } else if (this.getNumInputLinks() > 0) {
            new NodeViewer(this.getLabelText(), this.getID(), this, this.getInputMetaDataArray(), true, initialPortSelected).show();
        } else {
            AcceleratorOptionPane.showOKDialog(frame, MinerApp.getText("ActivityNodeModel_message_nodehasnoOutputs"), MinerApp.getText("ActivityNodeModel_message_noDataViewer"), 2);
        }
        comp.setCursor(oldCursor);
        comp.setVisible(false);
    }

    public String getNodeID(boolean isInput, int portIndex) {
        return Integer.toString(this.getID());
    }

    public boolean isComputed() {
        return this.getState().isPresentStateAtLeastAsAdvancedAsTestState(ActivityNodeComputed.instance());
    }

    public String getPortToolTip(boolean isInput, int portIndex) {
        int numPorts;
        String[] portTTs = isInput ? this.m_nodeInfo.inputPortToolTips : this.m_nodeInfo.outputPortToolTips;
        int n = numPorts = isInput ? this.m_nodeInfo.numInputs : this.m_nodeInfo.numOutputs;
        if (portTTs != null) {
            if (numPorts == -1) {
                return portTTs[0] + " " + Integer.toString(portIndex + 1);
            }
            if (portTTs.length > portIndex && portTTs[portIndex].length() > 0) {
                return portTTs[portIndex];
            }
        }
        String portType = "";
        portType = isInput ? MinerApp.getText("NodeViewer_inputText") + " " : MinerApp.getText("NodeViewer_outputText") + " ";
        return portType + Integer.toString(portIndex + 1);
    }

    public GridDataSource getDataSource(int portIndex, boolean isInput) {
        if (this.dataSources == null) {
            this.dataSources = new GridDataSource[isInput ? this.getNumInputLinks() : this.getNumOutputs()];
        }
        if (portIndex < this.dataSources.length) {
            try {
                this.dataSources[portIndex] = new GridDataSource(MinerApp.getCurrentWorksheetID(this.getDocument()), Integer.toString(this.getID()), portIndex, isInput);
                return this.dataSources[portIndex];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    ActivityNodeState getState() {
        return this.m_state;
    }

    protected void setState(ActivityNodeState state) {
        this.m_state = state;
        MinerApp.nodeStateChanged(this);
        this.fireStateChangedEvent();
    }

    ActivityNodeState getMinInputState() {
        int totalInputs = this.getExistingNumberInputs();
        if (totalInputs == 0) {
            return ActivityNodeConfigured.instance();
        }
        ActivityNodeState minState = null;
        for (int i = 0; i < totalInputs; ++i) {
            ActivityNodeModel inputModel = this.getAParentModel(i);
            if (inputModel == null) continue;
            ActivityNodeState inputState = inputModel.getState();
            if (minState == null) {
                minState = inputState;
                continue;
            }
            if (inputState.isPresentStateAtLeastAsAdvancedAsTestState(minState)) continue;
            minState = inputState;
        }
        return minState;
    }

    void firePortsChangedEvent() {
        int totalOutputs = this.getExistingNumberOutputs();
        for (int i = totalOutputs - 1; i >= 0; --i) {
            ChangeListener listener = (ChangeListener)this.m_listeners.elementAt(i);
            if (listener == null) continue;
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    void fireStateChangedEvent() {
        int i;
        int totalOutputs = this.getExistingNumberOutputs();
        for (i = 0; i < totalOutputs; ++i) {
            ChangeListener listener = (ChangeListener)this.m_listeners.elementAt(i);
            if (listener == null) continue;
            listener.stateChanged(new ChangeEvent(this.getState()));
        }
        for (i = 0; i < this.m_modelListeners.size(); ++i) {
            PMMLImportable pnm = (PMMLImportable)this.m_modelListeners.get(i);
            if (pnm == null) continue;
            pnm.stateChanged(new ChangeEvent(this.getState()));
        }
    }

    void fireIconsChangedEvent() {
        for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
            Object listener = this.m_listeners.elementAt(i);
            if (!(listener instanceof ActivityNodeArea)) continue;
            ((ActivityNodeArea)listener).stateChanged(new ChangeEvent(this));
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (ActivityNodeState.isDeepMode() && e.getSource() instanceof ActivityNodeState) {
            this.getState().changeState(this);
        }
    }

    public ActivityNodeModel getAParentModel(int index) {
        if (this.m_inputs == null) {
            return null;
        }
        return (ActivityNodeModel)this.m_inputs.get(index);
    }

    public int getExistingNumberInputs() {
        if (this.m_inputs == null) {
            return 0;
        }
        return this.m_inputs.size();
    }

    public int getExistingNumberOutputs() {
        if (this.m_listeners == null) {
            return 0;
        }
        return this.m_listeners.size();
    }

    void addParentModel(ActivityNodeModel model) {
        if (this.getNumInputs() == this.m_inputs.size()) {
            return;
        }
        if (this.getNumInputs() != 1 || !this.m_inputs.contains(model)) {
            this.m_inputs.add(model);
        }
    }

    boolean removeParentModel(ActivityNodeModel model) {
        return this.m_inputs.remove(model);
    }

    void addModelParentModel(PMMLExportable model) {
        if (!this.m_modelInputs.contains(model)) {
            this.m_modelInputs.add(model);
        }
    }

    boolean removeModelParentModel(PMMLExportable model) {
        return this.m_modelInputs.remove(model);
    }

    void addChangeListener(ChangeListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    boolean removeChangeListener(ChangeListener listener) {
        return this.m_listeners.remove(listener);
    }

    void addModelChangeListener(PMMLImportable listener) {
        if (!this.m_modelListeners.contains(listener)) {
            this.m_modelListeners.add(listener);
        }
    }

    boolean removeModelChangeListener(PMMLImportable listener) {
        return this.m_modelListeners.remove(listener);
    }

    boolean isChild(ActivityNodeModel test) {
        for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
            Object listener = this.m_listeners.get(i);
            if (!(listener instanceof ActivityNodeModel)) continue;
            if (listener == test) {
                return true;
            }
            if (!((ActivityNodeModel)listener).isChild(test)) continue;
            return true;
        }
        return false;
    }

    public boolean isPropertiesValid() {
        return true;
    }

    public boolean isInputValid() {
        if (this.m_inputs == null) {
            return false;
        }
        int total = this.getNumInputs();
        int actual = this.m_inputs.size();
        if (total == -1 && actual > 0) {
            return true;
        }
        return actual == total;
    }

    public ActivityNodeModel copy() throws IllegalAccessException {
        ActivityNodeModel newobj = null;
        try {
            XMLTree fitTree;
            XTNetwork.NodeInfo copyInfo = this.m_nodeInfo.copy();
            newobj = ActivityNodeModel.createActivityNodeModel(this.getClass().getName(), copyInfo);
            if (this instanceof PMMLImportable && (copyInfo.model == null || copyInfo.model.modelString == null) && (fitTree = PredictNodeModel.getFittedModel(this)) != null) {
                newobj.m_nodeInfo.model = new XTNetwork.ModelInfo(fitTree.copy());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        newobj.m_inputs = new Vector();
        newobj.m_listeners = new Vector();
        newobj.m_modelInputs = new Vector();
        newobj.m_modelListeners = new Vector();
        newobj.setState(ActivityNodeState.initiateState(newobj));
        return newobj;
    }

    public XTMetaData getOutputMetaData(int output) throws Exception {
        if (this.isDummyEngineConnection()) {
            try {
                return new XTMetaData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.saveGuiNetworkToEngine();
        XTMetaData md = (XTMetaData)this.sendMessageToEngine("getOutputMetaData", new Object[]{new Integer(output)});
        return md;
    }

    public XTMetaData getInputMetaData(int input) throws Exception {
        if (this.isDummyEngineConnection()) {
            try {
                return new XTMetaData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.saveGuiNetworkToEngine();
        XTMetaData md = (XTMetaData)this.sendMessageToEngine("getInputMetaData", new Object[]{new Integer(input)});
        return md;
    }

    XTMetaData[] getOutputMetaDataArray() {
        XTMetaData[] metaDataArray = null;
        try {
            int numOutputs = this.getNumOutputs();
            metaDataArray = new XTMetaData[this.getNumOutputs()];
            for (int i = 0; i < numOutputs; ++i) {
                metaDataArray[i] = this.getOutputMetaData(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metaDataArray;
    }

    XTMetaData[] getInputMetaDataArray() {
        XTMetaData[] metaDataArray = null;
        try {
            int numInputs = this.getNumInputLinks();
            metaDataArray = new XTMetaData[numInputs];
            for (int i = 0; i < numInputs; ++i) {
                metaDataArray[i] = this.getInputMetaData(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metaDataArray;
    }

    private String getHtmlMetaDataString(XTMetaData[] metaDataArray, boolean output) {
        StringBuffer htmlBuf = new StringBuffer();
        htmlBuf.append("<HTML>\n<TITLE> Column Information: " + this.getLabelText() + " </TITLE>\n" + "<BODY>\n<DIV>\n<H1>\nColumn Information: " + this.getLabelText() + "\n</H1>\n</DIV>\n");
        htmlBuf.append("<style type=\"text/css\">" + XMLTree.getCSSText() + "</style>");
        if (metaDataArray.length == 1) {
            htmlBuf.append(metaDataArray[0].getHtmlString(XMLTree.META_DATA_XSL_FILE));
        } else {
            int num = metaDataArray.length;
            for (int i = 0; i < num; ++i) {
                String io = output ? "Output " : "Input ";
                htmlBuf.append("<DIV>\n<H2>\n" + io + (i + 1) + " of " + num + "\n</H2>\n</DIV>\n");
                htmlBuf.append(metaDataArray[i].getHtmlString(XMLTree.META_DATA_XSL_FILE));
            }
        }
        htmlBuf.append("\n</BODY>\n</HTML>");
        return htmlBuf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_nodeInfo);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_nodeInfo = (XTNetwork.NodeInfo)in.readObject();
        this.m_comments = this.m_nodeInfo != null && this.m_nodeInfo.comments != null ? this.m_nodeInfo.comments.tree : null;
        this.m_document = null;
    }

    void setDocument(WorksheetDocument doc) {
        this.m_document = doc;
    }

    public WorksheetDocument getWorksheetDocument() {
        return this.m_document;
    }

    WorksheetDocument getDocument() {
        return this.m_document;
    }

    private boolean isDummyEngineConnection() {
        WorksheetDocument doc = this.getDocument();
        if (doc == null) {
            return true;
        }
        return doc.isDummyEngineConnection();
    }

    protected Object sendMessageToEngine(String nodeID, String msg, Object[] args) throws Exception {
        if (this.isDummyEngineConnection()) {
            return null;
        }
        return GuiMessageHandler.sendMessageToEngine(MinerApp.getCurrentWorksheetID(this.getDocument()), nodeID, msg, args);
    }

    protected Object sendMessageToEngine(String msg, Object[] args) throws Exception {
        return this.sendMessageToEngine(Integer.toString(this.getID()), msg, args);
    }

    protected void saveGuiNetworkToEngine() throws Exception {
        MinerApp.saveGuiNetworkToEngine(this.getDocument());
    }

    public XTProps getNodeCacheXTProps(String cachename) {
        if (this.isDummyEngineConnection()) {
            return null;
        }
        XTProps val = null;
        try {
            this.saveGuiNetworkToEngine();
            val = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{cachename});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public XTMetaData getNodeCacheXTMetaData(String cachename) {
        if (this.isDummyEngineConnection()) {
            return null;
        }
        XTMetaData val = null;
        try {
            this.saveGuiNetworkToEngine();
            val = (XTMetaData)this.sendMessageToEngine("getNodeCacheXTMetaData", new Object[]{cachename});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public XMLTree getNodeCache(String cachename) {
        if (this.isDummyEngineConnection()) {
            return null;
        }
        XMLTree val = null;
        try {
            this.saveGuiNetworkToEngine();
            val = (XMLTree)this.sendMessageToEngine("getNodeCache", new Object[]{cachename});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public XMLTree callEngineNode(String str, XMLTree arg) {
        if (this.isDummyEngineConnection()) {
            return null;
        }
        XMLTree val = null;
        try {
            this.saveGuiNetworkToEngine();
            val = (XMLTree)this.sendMessageToEngine("handleCallEngineNode", new Object[]{str, arg});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public void printDebug(String msg) {
        MinerApp.outputText(msg, 0, false);
    }

    public void printlnDebug(String msg) {
        MinerApp.outputText(msg, 0, true);
    }

    public void printVerbose(String msg) {
        MinerApp.outputText(msg, 1, false);
    }

    public void printlnVerbose(String msg) {
        MinerApp.outputText(msg, 1, true);
    }

    public void printInformation(String msg) {
        MinerApp.outputText(msg, 2, false);
    }

    public void printlnInformation(String msg) {
        MinerApp.outputText(msg, 2, true);
    }

    public void printWarning(String msg) {
        MinerApp.outputText(msg, 3, false);
    }

    public void printlnWarning(String msg) {
        MinerApp.outputText(msg, 3, true);
    }

    public void printError(String msg) {
        MinerApp.outputText(msg, 4, false);
    }

    public void printlnError(String msg) {
        MinerApp.outputText(msg, 4, true);
    }

    public WorksheetPropertiesManager getWorksheetPropertiesManager() {
        return MinerApp.getWorksheetPropertiesManager();
    }

    public String getAbsolutePath(String fileName) {
        return MinerApp.getAbsolutePath(fileName);
    }

    public boolean doesEngineFileExist(String fileName) {
        return MinerApp.doesEngineFileExist(fileName);
    }

    public HelpManager getHelpManager() {
        return MinerApp.getHelpManager();
    }
}

