/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeConfigured;
import com.insightful.miner.ActivityNodeCreated;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.MinerApp;
import com.insightful.miner.StateVisualCueImage;
import java.awt.Component;
import java.awt.Cursor;
import java.io.Serializable;

public abstract class ActivityNodeState
implements Serializable {
    private static boolean m_isDeep = true;

    public static ActivityNodeState initiateState(ActivityNodeModel model) {
        ActivityNodeCreated state = ActivityNodeCreated.instance();
        return state.changeState(model);
    }

    public static void setComputed(ActivityNodeModel model) {
        ActivityNodeComputed state = ActivityNodeComputed.instance();
        if (model.getState() == state) {
            return;
        }
        model.setState(state);
    }

    public void showView(ActivityNodeModel model) {
        Component comp = MinerApp.getMainFrame().getGlassPane();
        Cursor oldCursor = comp.getCursor();
        comp.setCursor(Cursor.getPredefinedCursor(3));
        comp.setVisible(true);
        try {
            model.showView(MinerApp.getMainFrame());
        }
        catch (Exception e) {
            String msg = MinerApp.getText("ActivityNodeState_message_errorOccuredWhileViewing") + " " + model.getLabelText() + ":\n\n" + e.toString() + "\n";
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), msg, MinerApp.getText("ActivityNodeState_message_viewerError"), 0);
            e.printStackTrace();
        }
        catch (OutOfMemoryError err) {
            String msg = MinerApp.getText("ActivityNodeState_message_ranOutofMemory") + " " + model.getLabelText() + ".";
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), msg, MinerApp.getText("ActivityNodeState_message_viewerMemoryError"), 0);
            err.printStackTrace();
        }
        comp.setCursor(oldCursor);
        comp.setVisible(false);
    }

    public void showDialog(ActivityNodeModel model) {
        if (MinerApp.waitingOnSplus()) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), "Cannot open dialog while evaluating an S-PLUS expression.");
            return;
        }
        Component comp = MinerApp.getMainFrame().getGlassPane();
        Cursor oldCursor = comp.getCursor();
        comp.setCursor(Cursor.getPredefinedCursor(3));
        comp.setVisible(true);
        model.showPropertiesDialog();
        comp.setCursor(oldCursor);
        comp.setVisible(false);
    }

    protected void propertiesNotSame(ActivityNodeModel model) {
        ActivityNodeState nextState = this.findMaxState(model);
        if (nextState instanceof ActivityNodeComputed) {
            model.setState(ActivityNodeConfigured.instance());
        } else {
            model.setState(nextState);
        }
    }

    public ActivityNodeState changeState(ActivityNodeModel model) {
        ActivityNodeState nextState = this.findMaxState(model);
        model.setState(nextState);
        return nextState;
    }

    protected ActivityNodeState findMaxState(ActivityNodeModel model) {
        if (!model.isInputValid()) {
            return ActivityNodeCreated.instance();
        }
        ActivityNodeState maxState = model.getMinInputState();
        while (!(maxState instanceof ActivityNodeCreated)) {
            if (maxState.isModelReadyForThisState(model)) {
                return maxState;
            }
            maxState = maxState.getPrevState();
        }
        return ActivityNodeCreated.instance();
    }

    protected StateVisualCueImage initializeVisualCue(String filename) {
        return new StateVisualCueImage(BaseNodeArea.DEFAULT_POINT, BaseNodeArea.DEFAULT_SIZE, filename);
    }

    public static boolean isDeepMode() {
        return m_isDeep;
    }

    public static void setDeepMode(boolean deep) {
        m_isDeep = deep;
    }

    public abstract ActivityNodeState getNextState();

    public abstract ActivityNodeState getPrevState();

    public abstract StateVisualCueImage getStateVisualCue();

    public abstract void onDoubleClick(ActivityNodeModel var1);

    public abstract boolean isModelReadyForThisState(ActivityNodeModel var1);

    public abstract boolean isPresentStateAtLeastAsAdvancedAsTestState(ActivityNodeState var1);
}

