/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeConfigured;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.XTNetwork;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import java.awt.Point;
import java.awt.Rectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseLink
extends JGoLabeledLink {
    public BaseLink() {
    }

    public BaseLink(JGoPort from, JGoPort to) {
        super(from, to);
    }

    public WorksheetDocument getDoc() {
        return (WorksheetDocument)this.getDocument();
    }

    public BaseNodeArea getFromNode() {
        try {
            return (BaseNodeArea)super.getFromPort().getParent();
        }
        catch (Exception e) {
            return null;
        }
    }

    public BaseNodeArea getToNode() {
        try {
            return (BaseNodeArea)super.getToPort().getParent();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setOrthogonal(boolean bOrtho) {
        if (bOrtho != this.isOrthogonal()) {
            this.removeAllPoints();
        }
        super.setOrthogonal(bOrtho);
    }

    protected void calculateStroke() {
        if (this.isOrthogonal()) {
            super.calculateStroke();
        } else {
            JGoPort fromPort = this.getFromPort();
            JGoPort toPort = this.getToPort();
            if (fromPort == null) {
                return;
            }
            if (toPort == null) {
                return;
            }
            if (fromPort.getFromSpot() == -1 && toPort.getToSpot() == -1) {
                super.calculateStroke();
                return;
            }
            Point fromPoint = new Point();
            if (fromPort.getFromSpot() != -1) {
                fromPoint = fromPort.getFromLinkPoint(fromPoint);
            }
            Point toPoint = new Point();
            if (toPort.getToSpot() != -1) {
                toPoint = toPort.getToLinkPoint(toPoint);
            }
            if (fromPort.getFromSpot() == -1) {
                fromPoint = fromPort.getLinkPointFromPoint(toPoint.x, toPoint.y, fromPoint);
            }
            if (toPort.getToSpot() == -1) {
                toPoint = toPort.getLinkPointFromPoint(fromPoint.x, fromPoint.y, toPoint);
            }
            int n = this.getNumPoints() - 1;
            this.foredate(110);
            this.setSuspendUpdates(true);
            if (n <= 0) {
                this.removeAllPoints();
                this.addPoint(fromPoint);
                this.addPoint(toPoint);
            } else {
                Point oldFromPt = this.getPoint(0);
                int dFx = fromPoint.x - oldFromPt.x;
                int dFy = fromPoint.y - oldFromPt.y;
                Point oldToPt = this.getPoint(n);
                int dTx = toPoint.x - oldToPt.x;
                int dTy = toPoint.y - oldToPt.y;
                for (int i = 0; i <= n; ++i) {
                    Point pt = this.getPoint(i);
                    this.setPoint(i, pt.x + (int)Math.rint(((n - i) * dFx + i * dTx) / n), pt.y + (int)Math.rint(((n - i) * dFy + i * dTy) / n));
                }
            }
            this.setSuspendUpdates(false);
            this.update(110, 0, null);
        }
    }

    public int getFromPortIndex() {
        return this.getFromNode().getOutputPorts().indexOf(this.getFromPort());
    }

    public int getToPortIndex() {
        return this.getToNode().getInputPorts().indexOf(this.getToPort());
    }

    public XTNetwork.LinkInfo createLinkInfo(XTNetwork net) {
        XTNetwork.LinkInfo info = new XTNetwork.LinkInfo();
        info.setFromInfo(Integer.toString(this.getFromNode().getID()), this.getFromPortIndex());
        info.setToInfo(Integer.toString(this.getToNode().getID()), this.getToPortIndex());
        info.isOrthog = this.isOrthogonal();
        return info;
    }

    public Element createXMLElement(Document document) {
        Element flow = document.createElement(XTNetwork.LINK_NODE_TAG);
        flow.setAttribute(XTNetwork.FROM_NODE_ATTRIBUTE_TAG, Integer.toString(this.getFromNode().getID()));
        flow.setAttribute(XTNetwork.FROM_PORT_ATTRIBUTE_TAG, Integer.toString(this.getFromPortIndex()));
        flow.setAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG, Integer.toString(this.getToNode().getID()));
        flow.setAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG, Integer.toString(this.getToPortIndex()));
        return flow;
    }

    public static BaseLink buildLinkFromInfo(XTNetwork.LinkInfo info, WorksheetDocument doc) {
        BaseLink blink = null;
        int fromNode = Integer.parseInt(info.getFromNodeID());
        int fromPort = info.getFromOutputPort();
        int toNode = Integer.parseInt(info.getToNodeID());
        int toPort = info.getToInputPort();
        BaseNodeArea from = doc.findNodeByID(fromNode);
        BaseNodeArea to = doc.findNodeByID(toNode);
        boolean nodesExist = false;
        if (from != null && to != null) {
            nodesExist = true;
        }
        boolean portsExist = false;
        if (nodesExist && from.getOutputPorts() != null && to.getInputPorts() != null && from.getOutputPorts().size() != 0 && to.getInputPorts().size() != 0) {
            portsExist = true;
        }
        if (nodesExist && portsExist) {
            blink = doc.newLink((JGoPort)from.getOutputPorts().elementAt(fromPort), (JGoPort)to.getInputPorts().elementAt(toPort), false);
            blink.setOrthogonal(info.isOrthog);
        }
        return blink;
    }

    public static BaseLink buildLinkFromXML(Element link, WorksheetDocument doc) {
        BaseLink blink = null;
        int fromNode = Integer.parseInt(link.getAttribute(XTNetwork.FROM_NODE_ATTRIBUTE_TAG));
        int fromPort = Integer.parseInt(link.getAttribute(XTNetwork.FROM_PORT_ATTRIBUTE_TAG));
        int toNode = Integer.parseInt(link.getAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG));
        int toPort = Integer.parseInt(link.getAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG));
        BaseNodeArea from = doc.findNodeByID(fromNode);
        BaseNodeArea to = doc.findNodeByID(toNode);
        boolean nodesExist = false;
        if (from != null && to != null) {
            nodesExist = true;
        }
        boolean portsExist = false;
        if (nodesExist && from.getOutputPorts() != null && to.getInputPorts() != null && from.getOutputPorts().size() != 0 && to.getInputPorts().size() != 0) {
            portsExist = true;
        }
        if (nodesExist && portsExist) {
            blink = doc.newLink((JGoPort)from.getOutputPorts().elementAt(fromPort), (JGoPort)to.getInputPorts().elementAt(toPort), false);
        }
        return blink;
    }

    public void ownerChange(Object oldOwner, Object newOwner) {
        this.ownerChange(oldOwner, newOwner, false);
    }

    public void ownerChange(Object oldOwner, Object newOwner, boolean forceStateChange) {
        if (oldOwner != null && newOwner == null) {
            BaseNodeArea outputArea = this.getToNode();
            BaseNodeArea inputArea = this.getFromNode();
            if (outputArea != null && inputArea != null) {
                WorksheetDocument doc = (WorksheetDocument)((Object)oldOwner);
                if (doc.isCollapsing()) {
                    return;
                }
                doc.setEngineNetworkDirty();
                if (outputArea instanceof ActivityNodeArea && inputArea instanceof ActivityNodeArea) {
                    ActivityNodeModel outputModel = ((ActivityNodeArea)outputArea).getNodeModel();
                    ActivityNodeModel inputModel = ((ActivityNodeArea)inputArea).getNodeModel();
                    inputModel.removeChangeListener(outputModel);
                    outputModel.removeParentModel(inputModel);
                    if (forceStateChange || doc.findObject((JGoObject)outputArea) != null) {
                        outputModel.getState().changeState(outputModel);
                    }
                    if (outputModel.getNumInputs() == -1 && outputModel.getState() == ActivityNodeComputed.instance()) {
                        outputModel.setState(ActivityNodeConfigured.instance());
                    }
                }
            }
        } else if (oldOwner == null && newOwner != null) {
            BaseNodeArea outputArea = this.getToNode();
            BaseNodeArea inputArea = this.getFromNode();
            if (outputArea != null && inputArea != null) {
                WorksheetDocument doc = (WorksheetDocument)((Object)newOwner);
                if (doc.isCollapsing()) {
                    return;
                }
                doc.setEngineNetworkDirty();
                if (outputArea instanceof ActivityNodeArea && inputArea instanceof ActivityNodeArea) {
                    ActivityNodeModel outputModel = ((ActivityNodeArea)outputArea).getNodeModel();
                    ActivityNodeModel inputModel = ((ActivityNodeArea)inputArea).getNodeModel();
                    inputModel.addChangeListener(outputModel);
                    outputModel.addParentModel(inputModel);
                    outputModel.getState().changeState(outputModel);
                    if (outputModel.getNumInputs() == -1 && outputModel.getState() == ActivityNodeComputed.instance()) {
                        outputModel.setState(ActivityNodeConfigured.instance());
                    }
                }
            }
        }
        super.ownerChange(oldOwner, newOwner);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        BaseLink obj = (BaseLink)super.copyObject(env);
        JGoPort fromPort = (JGoPort)env.get((Object)this.getFromPort());
        JGoPort toPort = (JGoPort)env.get((Object)this.getToPort());
        if (fromPort != null && toPort != null) {
            obj.setToPort(toPort);
            obj.setFromPort(fromPort);
            env.removeDelayed((Object)this);
        }
        return obj;
    }

    public void setToPort(JGoPort port) {
        super.setToPort(port);
    }

    public void setFromPort(JGoPort port) {
        super.setFromPort(port);
    }

    public int getSegmentNearPoint(Point pnt) {
        return BaseLink.getSegmentNearPoint((JGoLink)this, pnt);
    }

    public static int getSegmentNearPoint(JGoLink link, Point pnt) {
        int line_width;
        Rectangle rect = link.getBoundingRect();
        int n = line_width = link.getPen() != null ? link.getPen().getWidth() : 1;
        if (pnt.x < rect.x - line_width || pnt.x > rect.x + rect.width + line_width || pnt.y < rect.y - line_width || pnt.y > rect.y + rect.height + line_width) {
            return -1;
        }
        if (link.getNumPoints() <= 1) {
            return -1;
        }
        line_width = rect.width < 15 ? (line_width += 50) : (line_width += 10);
        for (int i = 0; i < link.getNumPoints() - 1; ++i) {
            int guess_y;
            Point start = link.getPoint(i);
            Point end = link.getPoint(i + 1);
            int xrange_high = Math.max(start.x, end.x) + line_width;
            int xrange_low = Math.min(start.x, end.x) - line_width;
            if (xrange_low > pnt.x || pnt.x > xrange_high) continue;
            if (start.x != end.x) {
                double slope = -((double)(start.y - end.y)) / (double)(start.x - end.x);
                guess_y = (int)(slope * (double)(-pnt.x + start.x) + (double)start.y);
            } else {
                guess_y = pnt.y;
            }
            int minY = guess_y - line_width;
            int maxY = guess_y + line_width;
            if (minY >= pnt.y || pnt.y >= maxY) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        String physical = "Physical link (" + this.getFromNode().getID() + ", " + this.getToNode().getID() + ")\n";
        return physical;
    }
}

