/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.BaseNodeLabel;
import com.insightful.miner.BaseNodePort;
import com.insightful.miner.MinerApp;
import com.insightful.miner.StateVisualCueImage;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.dndtree.DragOverData;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Vector;

public abstract class BaseNodeArea
extends JGoArea
implements Transferable,
DragOverData {
    public static final Dimension DEFAULT_SIZE = new Dimension(35, 35);
    public static final Point DEFAULT_POINT = new Point();
    public static DataFlavor nodeFlavor = BaseNodeArea.setDataFlavor();
    protected StateVisualCueImage m_stateVisualCue = null;
    private JGoText m_label;
    private JGoImage m_icon;
    private Vector m_InputPorts = null;
    private Vector m_OutputPorts = null;
    private int m_currentEffect;
    private Rectangle myHitTestRect = new Rectangle();

    public BaseNodeArea() {
    }

    public BaseNodeArea(String labelText, String imageName, int numInputs, int numOutputs) {
        this.initialize(labelText, imageName, numInputs, numOutputs);
    }

    public void initialize(String labelText, String imageName, int numInputs, int numOutputs) {
        this.setSelectable(false);
        this.setGrabChildSelection(true);
        this.setDraggable(true);
        this.setResizable(false);
        this.set4ResizeHandles(true);
        this.m_icon = new JGoImage(DEFAULT_POINT, DEFAULT_SIZE);
        this.loadIconImage(imageName, true);
        this.m_icon.setBoundingRect(DEFAULT_POINT, DEFAULT_SIZE);
        this.m_icon.setSelectable(false);
        this.addObjectAtTail((JGoObject)this.m_icon);
        if (labelText != null) {
            this.m_label = new BaseNodeLabel(labelText, this);
        }
        this.createPorts(numInputs, true);
        this.createPorts(numOutputs, false);
        this.layoutChildren();
        this.setTopLeft(DEFAULT_POINT);
    }

    public void setBoundingRect(int x, int y, int width, int height) {
        Dimension minSize = this.getMinimumSize();
        height = Math.max(height, minSize.height);
        width = Math.max(width, minSize.width);
        super.setBoundingRect(x, y, width, height);
        int extraWidth = 2 * BaseNodePort.DEFAULT_RECTANGLE.width;
        this.myHitTestRect = new Rectangle(x - BaseNodePort.DEFAULT_RECTANGLE.width, y, width + extraWidth, height);
    }

    public boolean isPointInObj(Point pnt) {
        return this.myHitTestRect.contains(pnt.x, pnt.y);
    }

    protected void createPorts(int numPorts, boolean input) {
        block7: {
            block5: {
                BaseNodePort inputPort;
                block6: {
                    if (!input) break block5;
                    inputPort = null;
                    if (this.m_InputPorts == null) {
                        this.m_InputPorts = new Vector();
                    }
                    if (numPorts >= 0) break block6;
                    inputPort = new BaseNodePort(true, false, this);
                    this.m_InputPorts.addElement(inputPort);
                    break block7;
                }
                if (numPorts == 0) break block7;
                for (int i = 0; i < numPorts; ++i) {
                    inputPort = new BaseNodePort(true, true, this);
                    this.m_InputPorts.addElement(inputPort);
                }
                break block7;
            }
            BaseNodePort outputPort = null;
            if (this.m_OutputPorts == null) {
                this.m_OutputPorts = new Vector();
            }
            if (numPorts > 0) {
                for (int i = 0; i < numPorts; ++i) {
                    outputPort = new BaseNodePort(false, false, this);
                    this.m_OutputPorts.addElement(outputPort);
                }
            }
        }
    }

    public static DataFlavor setDataFlavor() {
        return WorksheetDocument.getStandardDataFlavor();
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] fl = new DataFlavor[]{nodeFlavor};
        return fl;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(nodeFlavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(nodeFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public static BaseNodeArea convertTransferToArea(Transferable transfer) {
        try {
            JGoObject firstobj;
            JGoObjectSimpleCollection sel;
            JGoListPosition pos;
            Object obj;
            boolean local = transfer.isDataFlavorSupported(WorksheetDocument.getLocalJVMDataFlavor());
            Object object = obj = local ? transfer.getTransferData(WorksheetDocument.getLocalJVMDataFlavor()) : transfer.getTransferData(WorksheetDocument.getStandardDataFlavor());
            if (obj instanceof BaseNodeArea) {
                return (BaseNodeArea)obj;
            }
            if (obj instanceof JGoObjectSimpleCollection && (pos = (sel = (JGoObjectSimpleCollection)obj).getFirstObjectPos()) != null && (firstobj = sel.getObjectAtPos(pos)) instanceof BaseNodeArea) {
                return (BaseNodeArea)firstobj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setCurrentEffect(int eff) {
        this.m_currentEffect = eff;
    }

    public int getCurrentEffect() {
        return this.m_currentEffect;
    }

    public void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
        int i;
        BaseNodeArea newobj = (BaseNodeArea)newarea;
        if (this.m_icon != null) {
            newobj.m_icon = (JGoImage)this.m_icon.copyObject(env);
            newobj.addObjectAtTail((JGoObject)newobj.m_icon);
        }
        if (this.m_label != null) {
            newobj.m_label = (JGoText)this.m_label.copyObject(env);
            newobj.addObjectAtHead((JGoObject)newobj.m_label);
        }
        if (this.m_InputPorts != null) {
            newobj.m_InputPorts = new Vector(this.m_InputPorts.size());
            for (i = 0; i < this.m_InputPorts.size(); ++i) {
                newobj.m_InputPorts.add(((JGoPort)this.m_InputPorts.elementAt(i)).copyObject(env));
                newobj.addObjectAtTail((JGoObject)((JGoPort)newobj.m_InputPorts.elementAt(i)));
            }
        }
        if (this.m_OutputPorts != null) {
            newobj.m_OutputPorts = new Vector(this.m_OutputPorts.size());
            for (i = 0; i < this.m_OutputPorts.size(); ++i) {
                newobj.m_OutputPorts.add(((JGoPort)this.m_OutputPorts.elementAt(i)).copyObject(env));
                newobj.addObjectAtTail((JGoObject)((JGoPort)newobj.m_OutputPorts.elementAt(i)));
            }
        }
    }

    protected StateVisualCueImage getStateIcon() {
        return null;
    }

    public void addStateVisualCue() {
        Point loc = null;
        if (this.m_stateVisualCue != null) {
            loc = this.m_stateVisualCue.getLocation();
            this.removeObject((JGoObject)this.m_stateVisualCue);
        }
        this.m_stateVisualCue = this.getStateIcon();
        if (this.m_stateVisualCue == null) {
            return;
        }
        if (loc != null) {
            this.m_stateVisualCue.setLocation(loc);
        }
        boolean gotIcon = this.getIcon() != null;
        this.m_stateVisualCue.setVisible(gotIcon);
        this.addObjectAtTail((JGoObject)this.m_stateVisualCue);
        this.m_stateVisualCue.setVisible(gotIcon);
        if (gotIcon) {
            this.m_stateVisualCue.setSpotLocation(6, this.getIcon(), 3);
        } else {
            this.m_stateVisualCue.setSpotLocation(6, (JGoObject)this, 3);
        }
        this.m_stateVisualCue.setVisible(gotIcon);
    }

    public void layoutChildren() {
        if (this.m_icon != null) {
            this.m_icon.setSpotLocation(2, (JGoObject)this, 2);
            this.m_icon.setSize(DEFAULT_SIZE);
            if (this.m_label != null) {
                this.m_label.setSpotLocation(2, (JGoObject)this.m_icon, 6);
            }
        } else if (this.m_label != null) {
            this.m_label.setSpotLocation(6, (JGoObject)this, 6);
        }
        this.addStateVisualCue();
        this.layoutPorts(true);
        this.layoutPorts(false);
    }

    protected void layoutPorts(boolean input) {
        Vector ports = input ? this.m_InputPorts : this.m_OutputPorts;
        int location = input ? 8 : 4;
        int y_location = 0;
        int x_offset = 1;
        for (int i = 0; ports != null && i < ports.size(); ++i) {
            JGoPort port = (JGoPort)ports.elementAt(i);
            if (port == null) continue;
            if (i == 0 && input) {
                x_offset = -(port.getWidth() + x_offset);
            }
            if (!this.isPortVisible(port)) {
                if (this.findObject((JGoObject)port) == null) continue;
                this.removeObject((JGoObject)port);
                continue;
            }
            JGoObject icon = this.getIcon();
            if (this.findObject((JGoObject)port) == null) {
                this.addObjectAtTail((JGoObject)port);
            }
            if (icon != null) {
                Point p = icon.getSpotLocation(location);
                port.setLocationOffset(p.x + x_offset, p.y - 5, 0, y_location);
                y_location += 10;
                continue;
            }
            port.setSpotLocation(location, (JGoObject)this, location);
        }
    }

    protected boolean isPortVisible(JGoPort port) {
        return true;
    }

    public void geometryChange(Rectangle prevRect) {
        if (this.getWidth() != prevRect.width || this.getHeight() != prevRect.height) {
            if (this.m_icon != null) {
                double maxratio;
                int oldw = this.m_icon.getWidth();
                int oldh = this.m_icon.getHeight();
                if (oldw <= 0) {
                    oldw = 1;
                }
                double ratio = (double)oldh / (double)oldw;
                int iconw = this.getWidth();
                int iconh = this.getHeight();
                if (this.m_InputPorts != null && this.m_InputPorts.size() > 0) {
                    iconw -= ((JGoPort)this.m_InputPorts.elementAt(0)).getWidth();
                }
                if (this.m_OutputPorts != null && this.m_OutputPorts.size() > 0) {
                    iconw -= ((JGoPort)this.m_OutputPorts.elementAt(0)).getWidth();
                }
                if (this.m_label != null) {
                    iconh -= this.m_label.getHeight();
                }
                if (ratio < (maxratio = (double)iconh / (double)iconw)) {
                    iconh = (int)Math.rint(ratio * (double)iconw);
                } else {
                    iconw = (int)Math.rint((double)iconh / ratio);
                }
                this.m_icon.setSize(iconw, iconh);
            }
            this.layoutChildren();
        } else {
            super.geometryChange(prevRect);
        }
    }

    public Dimension getMinimumIconSize() {
        return new Dimension(20, 20);
    }

    public Dimension getMinimumSize() {
        int w = 0;
        int h = 0;
        if (this.m_InputPorts != null && this.m_InputPorts.size() > 0) {
            w -= ((JGoPort)this.m_InputPorts.elementAt(0)).getWidth();
        }
        if (this.m_OutputPorts != null && this.m_OutputPorts.size() > 0) {
            w -= ((JGoPort)this.m_OutputPorts.elementAt(0)).getWidth();
        }
        if (this.m_label != null) {
            h += this.m_label.getHeight();
        }
        Dimension minIconSize = this.getMinimumIconSize();
        return new Dimension(w += minIconSize.width, h += minIconSize.height);
    }

    protected Rectangle handleResize(Graphics2D g, JGoView view, Rectangle prevRect, Point newPoint, int whichHandle, int event, int minWidth, int minHeight) {
        Dimension minSize = this.getMinimumSize();
        Rectangle newRect = super.handleResize(g, view, prevRect, newPoint, whichHandle, event, minSize.width, minSize.height);
        if (event == 2) {
            this.setBoundingRect(newRect);
        }
        return null;
    }

    public boolean doMouseClick(int modifiers, Point dc, Point vc, JGoView view) {
        JGoObject obj;
        JGoText lab = this.getLabel();
        if (lab != null && lab.isEditable() && lab.isEditOnSingleClick() && (obj = view.pickDocObject(dc, false)) == lab && obj.getLayer() != null && obj.getLayer().isModifiable()) {
            lab.doStartEdit(view, vc);
            return true;
        }
        return false;
    }

    public JGoPort addPort(boolean input) {
        BaseNodePort port = null;
        if (input) {
            port = new BaseNodePort(true, true, this);
            this.getInputPorts().addElement(port);
        } else {
            port = new BaseNodePort(false, false, this);
            this.getOutputPorts().addElement(port);
        }
        this.layoutChildren();
        return port;
    }

    public void forceOwnershipChange(Object oldOwner, Object newOwner) {
        this.ownerChange(oldOwner, newOwner);
    }

    public WorksheetDocument getDoc() {
        return (WorksheetDocument)this.getDocument();
    }

    public JGoText getLabel() {
        return this.m_label;
    }

    public JGoObject getIcon() {
        return this.m_icon;
    }

    public Vector getInputPorts() {
        return this.m_InputPorts;
    }

    public Vector getOutputPorts() {
        return this.m_OutputPorts;
    }

    public String getText() {
        if (this.getLabel() != null) {
            String str = this.getLabel().getText();
            return str;
        }
        return "";
    }

    public void setText(String s) {
        if (this.getLabel() != null) {
            this.getLabel().setText(s);
        }
    }

    public void loadIconImage(String fileName, boolean wait) {
        if (!MinerApp.isHeadless()) {
            this.m_icon.loadImage(MinerApp.getResourceManager().findImageFile(fileName), wait);
        }
    }

    public void rename() {
        this.getLabel().doStartEdit((JGoView)MinerApp.getCurrentView(), this.getLabel().getSpotLocation(0));
    }

    public String toString() {
        return this.getText();
    }

    public abstract int getID();

    public abstract void setID(int var1);
}

