/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.ClassificationAgreementEngineNode;
import com.insightful.miner.ClassificationAssessmentEngineNode;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.ModelEvaluationDialog;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.util.Vector;
import org.w3c.dom.Element;

public class ClassificationAgreementNodeModel
extends ActivityNodeModel {
    public ClassificationAgreementNodeModel(Element elt) {
        super(elt);
    }

    public ClassificationAgreementNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public void showPropertiesDialog(boolean modality) {
        ModelEvaluationDialog dialog = ModelEvaluationDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public void showView(Frame frame) {
        XTProps props = this.getXTProps();
        XTProps xt = null;
        try {
            xt = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{ClassificationAgreementEngineNode.CLASSIFICATION_AGREEMENT_CACHE});
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String[] path = new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG, "", ""};
        String[] titlePath = new String[]{"", ClassificationAssessmentEngineNode.TITLE_ATTRIBUTE_TAG};
        Vector inputs = xt.getFirstLevelProperties();
        int numInputs = inputs.size();
        StringBuffer html = new StringBuffer();
        for (int i = 0; i < numInputs; ++i) {
            Vector depColumnList;
            String inputNumStr;
            titlePath[0] = path[1] = (inputNumStr = (String)inputs.get(i));
            path[2] = ClassificationAssessmentEngineNode.USE_ROLE_INFO_ATTRIBUTE_TAG;
            boolean useRoles = props.getBoolean(path, true);
            String predColName = "PREDICT.class";
            if (!useRoles) {
                path[2] = ClassificationAssessmentEngineNode.EVAL_COLUMN_ATTRIBUTE_TAG;
                predColName = props.getValue(path);
            }
            String inputName = xt.getValue(titlePath, "Input #" + Integer.toString(i));
            if (!inputNumStr.startsWith(ClassificationAssessmentEngineNode.INPUT_PREFIX_TAG)) {
                BaseNodeArea area = this.getDocument().findFlatNodeByID(Integer.parseInt(inputNumStr));
                if (area == null) continue;
                inputName = ((ActivityNodeArea)area).getNodeModel().getLabelText();
            }
            if ((depColumnList = xt.getSubProperties(inputNumStr)).size() > 0 && depColumnList.get(0).equals(titlePath[1])) {
                depColumnList.remove(0);
            }
            if (depColumnList.size() < 1) continue;
            String depColumn = (String)depColumnList.get(0);
            XTMetaData md = null;
            try {
                md = this.getInputMetaData(i);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            Vector depLevels = md.getCategoricalDataFieldLevels(depColumn);
            Vector predLevels = md.getCategoricalDataFieldLevels(predColName);
            this.createHTMLTable(inputNumStr, inputName, depColumn, depLevels, predLevels, xt, html, md);
        }
        String title = this.getLabelText();
        StringBuffer output = new StringBuffer();
        output.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        output.append("<HTML>\n<TITLE>" + title + " Summary</TITLE>");
        output.append("<style type=\"text/css\">" + XMLTree.getCSSText() + "</style>");
        output.append("<P><H1 class=\"title\">" + title + "</H1>\n</P><BR>");
        output.append(html.toString());
        output.append("</HTML>\n");
        new HtmlFrame(output.toString());
    }

    private void createHTMLTable(String inputID, String inputName, String depColumn, Vector depLevels, Vector predLevels, XTProps props, StringBuffer buffer, XTMetaData md) {
        buffer.append("\t<table width=\"85%\" align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\">");
        buffer.append("\t\t<tr>");
        buffer.append("\t\t\t<td class=\"tableBG\">");
        buffer.append("\t\t\t\t\t<p><b><font size=\"4\" class=\"tableHead\">Input Node - " + inputName + "</font></b></p>");
        buffer.append("\t\t\t\t\t\t<table width=\"100%\" border=\"0\" class=\"content\" cellspacing=\"1\">");
        buffer.append("\t\t\t\t\t\t\t<tbody>");
        int extraCols = 2;
        int numDepLevels = depLevels.size();
        int[] colTotals = new int[numDepLevels];
        int[] rowTotals = new int[numDepLevels];
        int[] agreeTotals = new int[numDepLevels];
        int total = 0;
        String[] path = new String[4];
        path[0] = inputID;
        path[1] = depColumn;
        String[] classStr = new String[]{"blueBG", "whiteBG", "greyBG"};
        for (int i = 0; i < numDepLevels + extraCols; ++i) {
            buffer.append("\t\t\t\t\t\t\t\t<TR>\n");
            if (i >= extraCols) {
                path[2] = Integer.toString(i - extraCols);
            }
            String str = classStr[i % 2 == 0 ? 1 : 2];
            for (int j = 0; j < numDepLevels + extraCols; ++j) {
                if (j >= extraCols) {
                    int predIndex = predLevels.indexOf(depLevels.get(j - extraCols));
                    path[3] = Integer.toString(predIndex);
                }
                if (i < 2 && j < extraCols) {
                    buffer.append("\t\t\t\t\t\t\t\t\t<TD></TD>\n");
                } else {
                    if (i == 0 && j == extraCols) {
                        buffer.append("\t\t\t\t\t\t\t\t\t<TD class=\"" + classStr[0] + "\" COLSPAN=");
                        buffer.append(numDepLevels);
                        buffer.append("><CENTER><B><FONT SIZE=4>");
                        buffer.append("Predicted");
                        buffer.append("</FONT></B></CENTER></TD>\n");
                        buffer.append("\t\t\t\t\t\t\t\t\t<TD class=\"" + classStr[0] + "\" ROWSPAN=");
                        buffer.append("2><CENTER><B><FONT SIZE=3>Totals</FONT></B></CENTER></TD>\n");
                        break;
                    }
                    if (i == 1 && j >= extraCols) {
                        buffer.append("\t\t\t\t\t\t\t\t\t<TD class=\"" + classStr[0] + "\"><CENTER><I><FONT SIZE=3>");
                        buffer.append((String)depLevels.get(j - extraCols));
                        buffer.append("</FONT></I></CENTER></TD>\n");
                    } else if (i == 2 && j == 0) {
                        buffer.append("\t\t\t\t\t\t\t\t\t<TD class=\"" + classStr[0] + "\" ROWSPAN=");
                        buffer.append(numDepLevels);
                        buffer.append("><CENTER><B><FONT SIZE=4>");
                        buffer.append("Observed");
                        buffer.append("</FONT></B></CENTER></TD>\n");
                    } else if (i > 1 && j == 1) {
                        buffer.append("\t\t\t\t\t\t\t\t\t<TD class=\"" + classStr[0] + "\"><CENTER><I><FONT SIZE=3>");
                        buffer.append(depLevels.get(i - extraCols));
                        buffer.append("</FONT></I></CENTER></TD>\n");
                    } else if (i > 1 && j >= extraCols) {
                        int count = (int)props.getDouble(path, 0.0);
                        if (i == j) {
                            int n = i - extraCols;
                            agreeTotals[n] = agreeTotals[n] + count;
                        }
                        int n = i - 2;
                        rowTotals[n] = rowTotals[n] + count;
                        int n2 = j - extraCols;
                        colTotals[n2] = colTotals[n2] + count;
                        buffer.append("\t\t\t\t\t\t\t\t\t<TD align=\"right\" class=\"" + str + "\">");
                        buffer.append(count);
                        buffer.append("</TD>\n");
                        if (j == numDepLevels + extraCols - 1) {
                            buffer.append("\t\t\t\t\t\t\t\t\t<TD align=\"right\" class=\"" + str + "\">");
                            buffer.append(rowTotals[i - 2]);
                            buffer.append("</TD>\n");
                        }
                    }
                }
                if (i != numDepLevels + extraCols - 1 || j != numDepLevels + extraCols - 1) continue;
                String str2 = classStr[i % 2 == 0 ? 2 : 1];
                buffer.append("\t\t\t\t\t\t\t\t</TR>\n");
                buffer.append("\t\t\t\t\t\t\t\t<TR>\n");
                buffer.append("\t\t\t\t\t\t\t\t\t<TD class=\"" + classStr[0] + "\" COLSPAN=2>");
                buffer.append("<CENTER><B><FONT SIZE=3>Totals</FONT></B></CENTER></TD>\n");
                total = 0;
                for (int k = 0; k < numDepLevels; ++k) {
                    buffer.append("\t\t\t\t\t\t\t\t\t<TD align=\"right\" class=\"" + str2 + "\">");
                    buffer.append(colTotals[k]);
                    buffer.append("</TD>\n");
                    total += colTotals[k];
                }
                buffer.append("\t\t\t\t\t\t\t\t\t<TD align=\"right\" class=\"" + str2 + "\">");
                buffer.append(total);
                buffer.append("</TD>\n");
            }
            buffer.append("\t\t\t\t\t\t\t\t</TR>\n");
        }
        buffer.append("\t\t\t\t\t\t\t</tbody>");
        buffer.append("\t\t\t\t\t\t</table>");
        buffer.append("\t\t\t</td>");
        buffer.append("\t\t</tr>");
        buffer.append("\t</table>");
        buffer.append("<BR>\n");
        DecimalFormat df = new DecimalFormat("#0.0%");
        buffer.append("\t<table width=\"85%\" align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\">");
        buffer.append("\t\t<tr>");
        buffer.append("\t\t\t<td class=\"tableBG\">");
        buffer.append("\t\t\t\t\t\t<table width=\"100%\" border=\"0\" class=\"content\" cellspacing=\"1\">");
        buffer.append("\t\t\t\t\t\t\t<tbody>");
        int agreeTotal = 0;
        for (int i = 0; i < 3; ++i) {
            buffer.append("\t\t<TR>\n");
            for (int j = 0; j < numDepLevels + 2; ++j) {
                double percent;
                if (i == 0 && j == 1) {
                    buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" COLSPAN=");
                    buffer.append(numDepLevels);
                    buffer.append("><CENTER><B><FONT SIZE=4>");
                    buffer.append("Observed");
                    buffer.append("</FONT></B></CENTER></TD>\n");
                    buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" ROWSPAN=2><CENTER><B><FONT SIZE=3>");
                    buffer.append("Overall");
                    buffer.append("</FONT></B></CENTER></TD>\n");
                    break;
                }
                if (i < 2 && j == 0) {
                    buffer.append("\t\t\t<TD></TD>\n");
                    continue;
                }
                if (i == 1 && j < numDepLevels + 1) {
                    buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\"><CENTER><I><FONT SIZE=3>");
                    buffer.append((String)depLevels.get(j - 1));
                    buffer.append("</FONT></I></CENTER></TD>\n");
                    continue;
                }
                if (i == 1 && j == numDepLevels + 1) continue;
                if (i == 2 && j == 0) {
                    buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\"><CENTER><B><FONT SIZE=3>");
                    buffer.append("% Agree");
                    buffer.append("</FONT></B></CENTER></TD>\n");
                    continue;
                }
                if (i == 2 && j < numDepLevels + 1) {
                    buffer.append("\t\t\t<TD align=\"right\" class=\"" + classStr[1] + "\"><I><FONT SIZE=3>");
                    percent = (double)agreeTotals[j - 1] / (double)rowTotals[j - 1];
                    agreeTotal += agreeTotals[j - 1];
                    buffer.append(df.format(percent));
                    buffer.append("</FONT></I></TD>\n");
                    continue;
                }
                buffer.append("\t\t\t<TD align=\"right\" class=\"" + classStr[1] + "\"><I><FONT SIZE=3>");
                percent = (double)agreeTotal / (double)total;
                buffer.append(df.format(percent));
                buffer.append("</FONT></I></TD>\n");
            }
            buffer.append("\t\t</TR>\n");
        }
        buffer.append("\t\t\t\t\t\t\t</tbody>");
        buffer.append("\t\t\t\t\t\t</table>");
        buffer.append("\t\t\t</td>");
        buffer.append("\t\t</tr>");
        buffer.append("\t</table>");
        buffer.append("<BR>\n");
        String pLev = props.getValue(new String[]{path[0], path[1]});
        buffer.append("\t<table width=\"85%\" align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\">");
        buffer.append("\t\t<tr>");
        buffer.append("\t\t\t<td class=\"tableBG\">");
        buffer.append("\t\t\t\t\t<p><b><font size=\"4\" class=\"tableHead\">Positive Category - " + pLev + "</font></b></p>");
        buffer.append("\t\t\t\t\t\t<table width=\"100%\" border=\"0\" class=\"content\" cellspacing=\"1\">");
        buffer.append("\t\t\t\t\t\t\t<tbody>");
        path[3] = Integer.toString(predLevels.indexOf(pLev));
        double fp = 0.0;
        double tp = 0.0;
        double recall = 0.0;
        double precision = 0.0;
        double fWeightSquared = 0.0;
        double fMeasure = 0.0;
        double sp = Double.parseDouble(md.getLevelCount(path[1], pLev));
        for (int i = 0; i < depLevels.size(); ++i) {
            String oLev = (String)depLevels.get(i);
            path[2] = Integer.toString(depLevels.indexOf(oLev));
            if (oLev.equals(pLev)) {
                tp += props.getDouble(path, 0.0);
                continue;
            }
            fp += props.getDouble(path, 0.0);
        }
        recall = sp == 0.0 ? 1.0 : tp / sp;
        precision = tp / (tp + fp);
        fWeightSquared = 1.0;
        fMeasure = (fWeightSquared + 1.0) * (recall * precision) / (fWeightSquared * recall + precision);
        if (Double.isNaN(precision)) {
            precision = 0.0;
        }
        if (Double.isNaN(fMeasure)) {
            fMeasure = 0.0;
        }
        buffer.append("\t\t<TR>\n");
        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" ><CENTER><B><FONT SIZE=3>");
        buffer.append("Recall");
        buffer.append("</FONT></B></CENTER></TD>\n");
        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" ><CENTER><B><FONT SIZE=3>");
        buffer.append("Precision");
        buffer.append("</FONT></B></CENTER></TD>\n");
        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" ><CENTER><B><FONT SIZE=3>");
        buffer.append("F-Measure");
        buffer.append("</FONT></B></CENTER></TD>\n");
        buffer.append("\t\t</TR>\n");
        buffer.append("\t\t<TR>\n");
        buffer.append("\t\t\t<TD align=\"right\" class=\"" + classStr[1] + "\"><I><FONT SIZE=3>");
        buffer.append(df.format(recall));
        buffer.append("</FONT></I></TD>\n");
        buffer.append("\t\t\t<TD align=\"right\" class=\"" + classStr[1] + "\"><I><FONT SIZE=3>");
        buffer.append(df.format(precision));
        buffer.append("</FONT></I></TD>\n");
        buffer.append("\t\t\t<TD align=\"right\" class=\"" + classStr[1] + "\"><I><FONT SIZE=3>");
        buffer.append(df.format(fMeasure));
        buffer.append("</FONT></I></TD>\n");
        buffer.append("\t\t</TR>\n");
        buffer.append("\t\t\t\t\t\t\t</tbody>");
        buffer.append("\t\t\t\t\t\t</table>");
        buffer.append("\t\t\t</td>");
        buffer.append("\t\t</tr>");
        buffer.append("\t</table>");
        buffer.append("<BR><BR><BR><BR>\n");
    }

    public static XTProps getBDLOutput(XTProps dialogProps, XTProps nodeCacheProps, XTMetaData[] md) {
        XTProps outputProps = null;
        try {
            outputProps = new XTProps();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String[] path = new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG, "", ""};
        String[] titlePath = new String[]{"", ClassificationAssessmentEngineNode.TITLE_ATTRIBUTE_TAG};
        Vector inputs = nodeCacheProps.getFirstLevelProperties();
        int numInputs = inputs.size();
        for (int i = 0; i < numInputs; ++i) {
            String inputNumStr;
            titlePath[0] = path[1] = (inputNumStr = (String)inputs.get(i));
            path[2] = ClassificationAssessmentEngineNode.USE_ROLE_INFO_ATTRIBUTE_TAG;
            boolean useRoles = dialogProps.getBoolean(path, true);
            String predColName = "PREDICT.class";
            if (!useRoles) {
                path[2] = ClassificationAssessmentEngineNode.EVAL_COLUMN_ATTRIBUTE_TAG;
                predColName = dialogProps.getValue(path);
            }
            String inputName = "Input" + Integer.toString(i + 1);
            Vector depColumnList = nodeCacheProps.getSubProperties(inputNumStr);
            if (depColumnList.size() > 0 && depColumnList.get(0).equals(titlePath[1])) {
                depColumnList.remove(0);
            }
            if (depColumnList.size() < 1) continue;
            String depColumn = (String)depColumnList.get(0);
            Vector depLevels = md[i].getCategoricalDataFieldLevels(depColumn);
            Vector predLevels = md[i].getCategoricalDataFieldLevels(predColName);
            ClassificationAgreementNodeModel.createBDLHTMLTableList(inputNumStr, inputName, depColumn, depLevels, predLevels, nodeCacheProps, md[i], outputProps);
        }
        return outputProps;
    }

    private static void createBDLHTMLTableList(String inputID, String inputName, String depColumn, Vector depLevels, Vector predLevels, XTProps props, XTMetaData md, XTProps outputProps) {
        String[] tablePath = new String[]{inputName, "Counts", "Observed", "", "Predicted", ""};
        String[] percentPath = new String[]{inputName, "Percents", ""};
        String[] statsPath = new String[]{inputName, "Statistics", ""};
        int extraCols = 2;
        int numDepLevels = depLevels.size();
        int[] colTotals = new int[numDepLevels];
        int[] rowTotals = new int[numDepLevels];
        int[] agreeTotals = new int[numDepLevels];
        boolean total = false;
        String[] path = new String[4];
        path[0] = inputID;
        path[1] = depColumn;
        block0: for (int i = 0; i < numDepLevels + extraCols; ++i) {
            if (i >= extraCols) {
                path[2] = Integer.toString(i - extraCols);
            }
            for (int j = 0; j < numDepLevels + extraCols; ++j) {
                if (j >= extraCols) {
                    int predIndex = predLevels.indexOf(depLevels.get(j - extraCols));
                    path[3] = Integer.toString(predIndex);
                }
                if (i < 2 && j < extraCols) continue;
                if (i == 0 && j == extraCols) continue block0;
                if (i == 1 && j >= extraCols || i == 2 && j == 0 || i > 1 && j == 1 || i <= 1 || j < extraCols) continue;
                int count = (int)props.getDouble(path, 0.0);
                if (i == j) {
                    int n = i - extraCols;
                    agreeTotals[n] = agreeTotals[n] + count;
                }
                int n = i - 2;
                rowTotals[n] = rowTotals[n] + count;
                int n2 = j - extraCols;
                colTotals[n2] = colTotals[n2] + count;
                tablePath[3] = (String)depLevels.get(i - extraCols);
                tablePath[5] = (String)depLevels.get(j - extraCols);
                outputProps.set(tablePath, Integer.toString(count));
            }
        }
        int agreeTotal = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < numDepLevels + 2 && (i != 0 || j != 1); ++j) {
                if (i < 2 && j == 0 || i == 1 && j < numDepLevels + 1 || i == 1 && j == numDepLevels + 1 || i == 2 && j == 0 || i != 2 || j >= numDepLevels + 1) continue;
                percentPath[2] = (String)depLevels.get(j - 1);
                double percent = (double)agreeTotals[j - 1] / (double)rowTotals[j - 1];
                agreeTotal += agreeTotals[j - 1];
                outputProps.set(percentPath, Double.toString(percent));
            }
        }
        String pLev = props.getValue(new String[]{path[0], path[1]});
        path[3] = Integer.toString(predLevels.indexOf(pLev));
        double fp = 0.0;
        double tp = 0.0;
        double recall = 0.0;
        double precision = 0.0;
        double fWeightSquared = 0.0;
        double fMeasure = 0.0;
        double sp = Double.parseDouble(md.getLevelCount(path[1], pLev));
        for (int i = 0; i < depLevels.size(); ++i) {
            String oLev = (String)depLevels.get(i);
            path[2] = Integer.toString(depLevels.indexOf(oLev));
            if (oLev.equals(pLev)) {
                tp += props.getDouble(path, 0.0);
                continue;
            }
            fp += props.getDouble(path, 0.0);
        }
        recall = sp == 0.0 ? 1.0 : tp / sp;
        precision = tp / (tp + fp);
        fWeightSquared = 1.0;
        fMeasure = (fWeightSquared + 1.0) * (recall * precision) / (fWeightSquared * recall + precision);
        if (Double.isNaN(precision)) {
            precision = 0.0;
        }
        if (Double.isNaN(fMeasure)) {
            fMeasure = 0.0;
        }
        statsPath[2] = "Recall";
        outputProps.set(statsPath, Double.toString(recall));
        statsPath[2] = "Precision";
        outputProps.set(statsPath, Double.toString(precision));
        statsPath[2] = "F-Measure";
        outputProps.set(statsPath, Double.toString(fMeasure));
    }
}

