/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ColumnStats {
    protected Document document = null;
    protected Element dataStatsNode = null;
    protected Element lastStatsEntry = null;
    protected String lastStatsName = "";
    protected int lastStatsSearch = -1;
    protected Element firstPostUnivariateNode = null;
    public static String DATA_STATS_NODE_TAG = "ColumnStats";
    public static String TABLE_STATS_NODE_TAG = "TableStats";
    public static String UNIVARIATE_STATS_NODE_TAG = "UnivariateStats";
    public static String COUNTS_NODE_TAG = "Counts";
    public static String CONTINUOUS_STATS_NODE_TAG = "ContStats";
    public static String CATEGORY_NODE_TAG = "Category";
    public static String NUMERIC_INFO_NODE_TAG = "NumericInfo";
    public static String QUANTILE_NODE_TAG = "Quantile";
    public static String BIVARIATE_STATS_NODE_TAG = "BivariateStats";
    public static String CORRELATION_NODE_TAG = "Correlation";
    public static String ROW_COUNT_ATTRIBUTE_TAG = "rowCount";
    public static String FIELD_ATTRIBUTE_TAG = "field";
    public static String TOTAL_FREQUENCY_ATTRIBUTE_TAG = "totalFreq";
    public static String MISSING_FREQUENCY_ATTRIBUTE_TAG = "missingFreq";
    public static String VALUE_ATTRIBUTE_TAG = "value";
    public static String FREQUENCY_ATTRIBUTE_TAG = "freq";
    public static String MINIMUM_ATTRIBUTE_TAG = "minimum";
    public static String MAXIMUM_ATTRIBUTE_TAG = "maximum";
    public static String MEAN_ATTRIBUTE_TAG = "mean";
    public static String STANDARD_DEVIATION_ATTRIBUTE_TAG = "standardDeviation";
    public static String MEDIAN_ATTRIBUTE_TAG = "median";
    public static String IQR_ATTRIBUTE_TAG = "interQuartileRange";
    public static String QUANTILE_LIMIT_ATTRIBUTE_TAG = "quantileLimit";
    public static String QUANTILE_VALUE_ATTRIBUTE_TAG = "quantileValue";
    public static String NAME_1_ATTRIBUTE_TAG = "name1";
    public static String NAME_2_ATTRIBUTE_TAG = "name2";

    public ColumnStats(Document doc) throws Exception {
        try {
            this.document = doc;
            this.dataStatsNode = this.document.createElement(DATA_STATS_NODE_TAG);
        }
        catch (Exception e) {
            throw new Exception("Couldn't create MetaData object.");
        }
    }

    public ColumnStats(Element xml) throws Exception {
        try {
            this.document = xml.getOwnerDocument();
            this.dataStatsNode = xml;
            if (!xml.getNodeName().equals(DATA_STATS_NODE_TAG)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception("Couldn't create MetaData object.");
        }
    }

    public Element getElement() {
        return this.dataStatsNode;
    }

    public double getColumnRowCount(String name) {
        if (this.findUnivariateStats(name)) {
            return this.getLastFoundColumnRowCount();
        }
        return -1.0;
    }

    public double getColumnRowCount(int num) {
        if (this.findUnivariateStats(num)) {
            return this.getLastFoundColumnRowCount();
        }
        return -1.0;
    }

    public double getColumnMissingCount(String name) {
        if (this.findUnivariateStats(name)) {
            return this.getLastFoundColumnMissingCount();
        }
        return -1.0;
    }

    public double getColumnMissingCount(int num) {
        if (this.findUnivariateStats(num)) {
            return this.getLastFoundColumnMissingCount();
        }
        return -1.0;
    }

    public double getColumnMean(String name) {
        if (this.findUnivariateStats(name)) {
            return this.getLastFoundColumnMean();
        }
        return -1.0;
    }

    public double getColumnMean(int num) {
        if (this.findUnivariateStats(num)) {
            return this.getLastFoundColumnMean();
        }
        return -1.0;
    }

    public double getColumnMin(String name) {
        if (this.findUnivariateStats(name)) {
            return this.getLastFoundColumnMin();
        }
        return -1.0;
    }

    public double getColumnMin(int num) {
        if (this.findUnivariateStats(num)) {
            return this.getLastFoundColumnMin();
        }
        return -1.0;
    }

    public double getColumnMax(String name) {
        if (this.findUnivariateStats(name)) {
            return this.getLastFoundColumnMax();
        }
        return -1.0;
    }

    public double getColumnMax(int num) {
        if (this.findUnivariateStats(num)) {
            return this.getLastFoundColumnMax();
        }
        return -1.0;
    }

    public double getColumnStandardDeviation(String name) {
        if (this.findUnivariateStats(name)) {
            return this.getLastFoundColumnStandardDeviation();
        }
        return -1.0;
    }

    public double getColumnStandardDeviation(int num) {
        if (this.findUnivariateStats(num)) {
            return this.getLastFoundColumnStandardDeviation();
        }
        return -1.0;
    }

    public long getNumRows() {
        try {
            Element tableStats = (Element)this.dataStatsNode.getFirstChild();
            return Long.parseLong(tableStats.getAttribute(ROW_COUNT_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public String getLevelCount(String col, String level) {
        try {
            if (this.findUnivariateStats(col)) {
                Element counts = null;
                counts = (Element)this.lastStatsEntry.getFirstChild();
                while (!COUNTS_NODE_TAG.equals(counts.getNodeName())) {
                    counts = (Element)counts.getNextSibling();
                }
                Element category = (Element)counts.getFirstChild();
                while (!level.equals(category.getAttribute(VALUE_ATTRIBUTE_TAG))) {
                    category = (Element)category.getNextSibling();
                }
                return category.getAttribute(FREQUENCY_ATTRIBUTE_TAG);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "0";
    }

    public Vector getQuantileLimts(String name) {
        Vector<String> ret = new Vector<String>();
        try {
            if (this.findUnivariateStats(name)) {
                Element numericInfo = null;
                for (numericInfo = (Element)this.lastStatsEntry.getFirstChild(); numericInfo != null && !numericInfo.hasAttribute(MINIMUM_ATTRIBUTE_TAG); numericInfo = (Element)numericInfo.getNextSibling()) {
                }
                Element quantile = (Element)numericInfo.getFirstChild();
                NodeList limits = quantile.getChildNodes();
                int numLimits = limits.getLength();
                for (int i = 0; i < numLimits; ++i) {
                    Element limit = (Element)limits.item(i);
                    ret.add(limit.getAttribute(QUANTILE_LIMIT_ATTRIBUTE_TAG));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Vector getQuantileValues(String name) {
        Vector<String> ret = new Vector<String>();
        try {
            if (this.findUnivariateStats(name)) {
                Element numericInfo = null;
                for (numericInfo = (Element)this.lastStatsEntry.getFirstChild(); numericInfo != null && !numericInfo.hasAttribute(MINIMUM_ATTRIBUTE_TAG); numericInfo = (Element)numericInfo.getNextSibling()) {
                }
                Element quantile = (Element)numericInfo.getFirstChild();
                NodeList limits = quantile.getChildNodes();
                int numLimits = limits.getLength();
                for (int i = 0; i < numLimits; ++i) {
                    Element limit = (Element)limits.item(i);
                    ret.add(limit.getAttribute(QUANTILE_VALUE_ATTRIBUTE_TAG));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean setTableStats(long numRows) {
        try {
            Element first = (Element)this.dataStatsNode.getFirstChild();
            if (first == null) {
                Element tableStats = this.document.createElement(TABLE_STATS_NODE_TAG);
                tableStats.setAttribute(ROW_COUNT_ATTRIBUTE_TAG, Long.toString(numRows));
                this.dataStatsNode.appendChild(tableStats);
            } else if (!first.getNodeName().equals(TABLE_STATS_NODE_TAG)) {
                Element tableStats = this.document.createElement(TABLE_STATS_NODE_TAG);
                tableStats.setAttribute(ROW_COUNT_ATTRIBUTE_TAG, Long.toString(numRows));
                this.dataStatsNode.insertBefore(tableStats, first);
            } else {
                Element tableStats = first;
                tableStats.setAttribute(ROW_COUNT_ATTRIBUTE_TAG, Long.toString(numRows));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean modifyColumnName(String oldName, String newName) {
        try {
            if (this.findUnivariateStats(oldName)) {
                this.lastStatsEntry.setAttribute(FIELD_ATTRIBUTE_TAG, newName);
                this.lastStatsName = newName;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendUnivariateStats(String name) {
        try {
            if (!this.findUnivariateStats(name)) {
                Element us = this.document.createElement(UNIVARIATE_STATS_NODE_TAG);
                us.setAttribute(FIELD_ATTRIBUTE_TAG, name);
                if (this.firstPostUnivariateNode != null) {
                    this.dataStatsNode.insertBefore(us, this.firstPostUnivariateNode);
                } else {
                    this.dataStatsNode.appendChild(us);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean removeUnivariateStats(String name) {
        try {
            if (this.findUnivariateStats(name)) {
                this.dataStatsNode.removeChild(this.lastStatsEntry);
                this.lastStatsName = "";
                this.lastStatsSearch = -1;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendCounts(String name, long totalFreq, long missingFreq) {
        try {
            if (this.findUnivariateStats(name)) {
                Element counts = this.findChildNodeOfType(COUNTS_NODE_TAG, this.lastStatsEntry);
                if (counts == null) {
                    counts = this.document.createElement(COUNTS_NODE_TAG);
                    counts.setAttribute(TOTAL_FREQUENCY_ATTRIBUTE_TAG, Long.toString(totalFreq));
                    counts.setAttribute(MISSING_FREQUENCY_ATTRIBUTE_TAG, Long.toString(missingFreq));
                    this.lastStatsEntry.appendChild(counts);
                } else {
                    counts.setAttribute(TOTAL_FREQUENCY_ATTRIBUTE_TAG, Long.toString(totalFreq));
                    counts.setAttribute(MISSING_FREQUENCY_ATTRIBUTE_TAG, Long.toString(missingFreq));
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendCountsCategories(String name, String[] values, long[] frequencies) {
        try {
            if (frequencies.length != values.length) {
                return false;
            }
            if (this.findUnivariateStats(name)) {
                Element counts = null;
                for (counts = (Element)this.lastStatsEntry.getFirstChild(); counts != null && !counts.hasAttribute(TOTAL_FREQUENCY_ATTRIBUTE_TAG); counts = (Element)counts.getNextSibling()) {
                }
                for (int i = 0; i < values.length; ++i) {
                    Element category = this.document.createElement(CATEGORY_NODE_TAG);
                    category.setAttribute(VALUE_ATTRIBUTE_TAG, values[i]);
                    category.setAttribute(FREQUENCY_ATTRIBUTE_TAG, Long.toString(frequencies[i]));
                    counts.appendChild(category);
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendCountsCategory(String name, String value, long frequency) {
        try {
            if (this.findUnivariateStats(name)) {
                Element counts = null;
                for (counts = (Element)this.lastStatsEntry.getFirstChild(); counts != null && !counts.hasAttribute(TOTAL_FREQUENCY_ATTRIBUTE_TAG); counts = (Element)counts.getNextSibling()) {
                }
                Element category = this.document.createElement(CATEGORY_NODE_TAG);
                category.setAttribute(VALUE_ATTRIBUTE_TAG, value);
                category.setAttribute(FREQUENCY_ATTRIBUTE_TAG, Long.toString(frequency));
                counts.appendChild(category);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendNumericInfo(String name, double mean, double min, double max, double stdDev, double median, double iqr) {
        try {
            if (this.findUnivariateStats(name)) {
                Element ni = this.findChildNodeOfType(NUMERIC_INFO_NODE_TAG, this.lastStatsEntry);
                if (ni == null) {
                    ni = this.document.createElement(NUMERIC_INFO_NODE_TAG);
                    ni.setAttribute(MEAN_ATTRIBUTE_TAG, Double.toString(mean));
                    ni.setAttribute(MINIMUM_ATTRIBUTE_TAG, Double.toString(min));
                    ni.setAttribute(MAXIMUM_ATTRIBUTE_TAG, Double.toString(max));
                    ni.setAttribute(STANDARD_DEVIATION_ATTRIBUTE_TAG, Double.toString(stdDev));
                    ni.setAttribute(MEDIAN_ATTRIBUTE_TAG, Double.toString(median));
                    ni.setAttribute(IQR_ATTRIBUTE_TAG, Double.toString(iqr));
                    this.lastStatsEntry.appendChild(ni);
                } else {
                    ni.setAttribute(MEAN_ATTRIBUTE_TAG, Double.toString(mean));
                    ni.setAttribute(MINIMUM_ATTRIBUTE_TAG, Double.toString(min));
                    ni.setAttribute(MAXIMUM_ATTRIBUTE_TAG, Double.toString(max));
                    ni.setAttribute(STANDARD_DEVIATION_ATTRIBUTE_TAG, Double.toString(stdDev));
                    ni.setAttribute(MEDIAN_ATTRIBUTE_TAG, Double.toString(median));
                    ni.setAttribute(IQR_ATTRIBUTE_TAG, Double.toString(iqr));
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendQuantiles(String name, double[] limits, double[] values) {
        try {
            if (limits.length != values.length) {
                return false;
            }
            if (this.findUnivariateStats(name)) {
                Element numericInfo = null;
                for (numericInfo = (Element)this.lastStatsEntry.getFirstChild(); numericInfo != null && !numericInfo.hasAttribute(MINIMUM_ATTRIBUTE_TAG); numericInfo = (Element)numericInfo.getNextSibling()) {
                }
                for (int i = 0; i < values.length; ++i) {
                    Element quantile = this.document.createElement(QUANTILE_NODE_TAG);
                    quantile.setAttribute(QUANTILE_LIMIT_ATTRIBUTE_TAG, Double.toString(limits[i]));
                    quantile.setAttribute(QUANTILE_VALUE_ATTRIBUTE_TAG, Double.toString(values[i]));
                    numericInfo.appendChild(quantile);
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendQuantile(String name, double limit, double value) {
        try {
            if (this.findUnivariateStats(name)) {
                Element numericInfo = null;
                for (numericInfo = (Element)this.lastStatsEntry.getFirstChild(); numericInfo != null && !numericInfo.hasAttribute(MINIMUM_ATTRIBUTE_TAG); numericInfo = (Element)numericInfo.getNextSibling()) {
                }
                Element quantile = this.document.createElement(QUANTILE_NODE_TAG);
                quantile.setAttribute(QUANTILE_LIMIT_ATTRIBUTE_TAG, Double.toString(limit));
                quantile.setAttribute(QUANTILE_VALUE_ATTRIBUTE_TAG, Double.toString(value));
                numericInfo.appendChild(quantile);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected double getLastFoundColumnRowCount() {
        Element numericInfo = null;
        try {
            numericInfo = (Element)this.lastStatsEntry.getFirstChild();
            while (!numericInfo.hasAttribute(TOTAL_FREQUENCY_ATTRIBUTE_TAG)) {
                numericInfo = (Element)numericInfo.getNextSibling();
            }
            return Double.parseDouble(numericInfo.getAttribute(TOTAL_FREQUENCY_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    protected double getLastFoundColumnMissingCount() {
        Element numericInfo = null;
        try {
            numericInfo = (Element)this.lastStatsEntry.getFirstChild();
            while (!numericInfo.hasAttribute(MISSING_FREQUENCY_ATTRIBUTE_TAG)) {
                numericInfo = (Element)numericInfo.getNextSibling();
            }
            return Double.parseDouble(numericInfo.getAttribute(MISSING_FREQUENCY_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    protected double getLastFoundColumnMean() {
        Element numericInfo = null;
        try {
            numericInfo = (Element)this.lastStatsEntry.getFirstChild();
            while (!numericInfo.hasAttribute(MEAN_ATTRIBUTE_TAG)) {
                numericInfo = (Element)numericInfo.getNextSibling();
            }
            return Double.parseDouble(numericInfo.getAttribute(MEAN_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    protected double getLastFoundColumnMin() {
        Element numericInfo = null;
        try {
            numericInfo = (Element)this.lastStatsEntry.getFirstChild();
            while (!numericInfo.hasAttribute(MINIMUM_ATTRIBUTE_TAG)) {
                numericInfo = (Element)numericInfo.getNextSibling();
            }
            return Double.parseDouble(numericInfo.getAttribute(MINIMUM_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    protected double getLastFoundColumnMax() {
        try {
            Element numericInfo = null;
            numericInfo = (Element)this.lastStatsEntry.getFirstChild();
            while (!numericInfo.hasAttribute(MAXIMUM_ATTRIBUTE_TAG)) {
                numericInfo = (Element)numericInfo.getNextSibling();
            }
            return Double.parseDouble(numericInfo.getAttribute(MAXIMUM_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    protected double getLastFoundColumnStandardDeviation() {
        try {
            Element numericInfo = null;
            numericInfo = (Element)this.lastStatsEntry.getFirstChild();
            while (!numericInfo.hasAttribute(STANDARD_DEVIATION_ATTRIBUTE_TAG)) {
                numericInfo = (Element)numericInfo.getNextSibling();
            }
            return Double.parseDouble(numericInfo.getAttribute(STANDARD_DEVIATION_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    protected Element findChildNodeOfType(String type, Element searchFrom) throws Exception {
        NodeList searchList = searchFrom.getChildNodes();
        int listLength = searchList.getLength();
        for (int i = 0; i < listLength; ++i) {
            Element ret = (Element)searchList.item(i);
            if (!ret.getNodeName().equals(type)) continue;
            return ret;
        }
        return null;
    }

    protected boolean findUnivariateStats(int num) {
        if (num != this.lastStatsSearch) {
            int i = 0;
            for (Element child = (Element)this.dataStatsNode.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
                if (!child.getNodeName().equals(UNIVARIATE_STATS_NODE_TAG)) continue;
                if (i == num) {
                    this.lastStatsEntry = child;
                    this.lastStatsName = "";
                    this.lastStatsSearch = num;
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    protected boolean findUnivariateStats(String columnName) {
        boolean found = true;
        if (!columnName.equals(this.lastStatsName)) {
            found = false;
            for (Element child = (Element)this.dataStatsNode.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
                String str = child.getAttribute(FIELD_ATTRIBUTE_TAG);
                if (str == null || !columnName.equals(str)) continue;
                this.lastStatsEntry = child;
                this.lastStatsName = columnName;
                this.lastStatsSearch = -1;
                found = true;
                break;
            }
        }
        return found;
    }
}

