/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;

public class CompareEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String UNION_ATTRIBUTE_TAG = "union";
    public static String LOGICAL_ATTRIBUTE_TAG = "logical";
    public static String ABSOLUTE_ATTRIBUTE_TAG = "absolute";
    public static String TOLERANCE_ATTRIBUTE_TAG = "tolerance";
    public static String FILTER_PASSING_ROWS_ATTRIBUTE_TAG = "filterPassing";
    public static String SUMMARY_INPUTS_ATTRIBUTE_TAG = "summaryInputs";
    public static String SUMMARY_INPUT_AND_ROW_ATTRIBUTE_TAG = "inputAndRows";
    public static String SUMMARY_INPUT_AND_COLUMN_ATTRIBUTE_TAG = "inputAndColumns";
    public static String SUMMARY_INPUT_AND_ROW_NUM_ATTRIBUTE_TAG = "inputAndRowNum";
    public static String ROW_NUM_COLUMN_ATTRIBUTE_TAG = "rowNumColumn";
    public static String SUMMARY_ROW_ATTRIBUTE_TAG = "summaryRows";
    public static String SUMMARY_COLUMN_ATTRIBUTE_TAG = "summaryColumns";
    public static String MESSAGE_PANE_ATTRIBUTE_TAG = "messagePane";
    public static String SUMMARY_COLUMN_NAME = "Row Equality";
    public static String ROW_NUM_COLUMN_NAME = "Row Number";
    private final int TARGET_INPUT = 1;
    private final int CURRENT_INPUT = 0;
    private final int NUM_SUMMARY_ROWS = 2;
    public final double DEFAULT_TOLERANCE = 1.5E-8;
    private boolean m_logical;
    private boolean m_absolute;
    private double m_tolerance;
    private boolean m_union;
    private boolean m_filterPassingRows;
    private boolean m_rowNumColumn;
    private boolean m_summaryInputs;
    private boolean m_summaryRows;
    private boolean m_summaryColumn;
    private boolean m_outputMessagePane;
    private int[] m_outputToInput1;
    private int[] m_outputToInput2;
    private XTMetaData m_testColumnsMD;
    private boolean[] m_compareAsString;
    private double[] m_summaryRowData;
    private double[] m_summaryRowMaxVals;
    private long[] m_summaryRowDataCount;
    private boolean m_allEqual;
    private boolean m_outputPhase;
    private static String[] logicalLevels = new String[]{"false", "true"};

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) throws Exception {
        XTProps props = this.getNodeProperties();
        this.m_logical = props.getBoolean(LOGICAL_ATTRIBUTE_TAG, true);
        this.m_absolute = props.getBoolean(ABSOLUTE_ATTRIBUTE_TAG, true);
        this.m_tolerance = props.getDouble(TOLERANCE_ATTRIBUTE_TAG, 1.5E-8);
        this.m_union = props.getBoolean(UNION_ATTRIBUTE_TAG, true);
        this.m_summaryInputs = props.getBoolean(SUMMARY_INPUTS_ATTRIBUTE_TAG, true);
        this.m_outputMessagePane = props.getBoolean(MESSAGE_PANE_ATTRIBUTE_TAG, true);
        this.m_filterPassingRows = props.getBoolean(FILTER_PASSING_ROWS_ATTRIBUTE_TAG, true);
        if (this.m_summaryInputs) {
            this.m_summaryRows = props.getBoolean(SUMMARY_INPUT_AND_ROW_ATTRIBUTE_TAG, true);
            this.m_summaryColumn = props.getBoolean(SUMMARY_INPUT_AND_COLUMN_ATTRIBUTE_TAG, false);
            this.m_rowNumColumn = props.getBoolean(SUMMARY_INPUT_AND_ROW_NUM_ATTRIBUTE_TAG, true);
        } else {
            this.m_summaryRows = props.getBoolean(SUMMARY_ROW_ATTRIBUTE_TAG, true);
            this.m_summaryColumn = props.getBoolean(SUMMARY_COLUMN_ATTRIBUTE_TAG, false);
            this.m_rowNumColumn = props.getBoolean(ROW_NUM_COLUMN_ATTRIBUTE_TAG, true);
            if (!this.m_summaryColumn) {
                this.m_rowNumColumn = false;
            }
        }
        XTMetaData in1MD = this.getInputMetaData(1);
        XTMetaData in2MD = this.getInputMetaData(0);
        this.m_testColumnsMD = this.createCombinedMD(in1MD, in2MD, this.m_union, this.m_logical, false);
        this.m_outputToInput1 = new int[this.m_testColumnsMD.getNumColumns()];
        this.m_outputToInput2 = new int[this.m_outputToInput1.length];
        this.m_compareAsString = new boolean[this.m_outputToInput1.length];
        this.m_summaryRowData = new double[this.m_outputToInput1.length];
        this.m_summaryRowMaxVals = new double[this.m_outputToInput1.length];
        this.m_summaryRowDataCount = new long[this.m_outputToInput1.length];
        for (int i = 0; i < this.m_outputToInput1.length; ++i) {
            String colName = this.m_testColumnsMD.ordinalToName(i);
            this.m_outputToInput1[i] = in1MD.nameToOrdinal(colName);
            this.m_outputToInput2[i] = in2MD.nameToOrdinal(colName);
            boolean nf1 = this.m_outputToInput1[i] < 0;
            boolean nf2 = this.m_outputToInput2[i] < 0;
            boolean str1 = in1MD.isCategoricalColumn(colName) || in1MD.isStringColumn(colName);
            boolean str2 = in2MD.isCategoricalColumn(colName) || in2MD.isStringColumn(colName);
            boolean bl = this.m_compareAsString[i] = str1 && str2 || !str1 && nf1 && str2 || str1 && !str2 && nf2;
            if (this.m_compareAsString[i] || this.m_logical) {
                this.m_summaryRowData[i] = 1.0;
                this.m_summaryRowMaxVals[i] = 1.0;
            } else {
                this.m_summaryRowData[i] = 0.0;
                this.m_summaryRowMaxVals[i] = 0.0;
            }
            this.m_summaryRowDataCount[i] = 0L;
        }
        this.m_allEqual = true;
        this.m_outputPhase = true;
    }

    public void execute(CNKProcJavaTransform proc) {
        int numrows1 = proc.getChunkInputRows(1);
        int numrows2 = proc.getChunkInputRows(0);
        int minrows = Math.min(numrows1, numrows2);
        int maxrows = Math.max(numrows1, numrows2);
        int biggerIndex = numrows1 < numrows2 ? 0 : 1;
        long pos = proc.getChunkInputPosition(1);
        int numcols = this.m_testColumnsMD.getNumColumns();
        boolean lastRow = proc.getChunkInputLast(0) && proc.getChunkInputLast(1);
        boolean[] failureRow = new boolean[maxrows];
        for (int cnk = 0; cnk < maxrows; ++cnk) {
            failureRow[cnk] = false;
        }
        int acutualRowNum = 0;
        if (proc.getChunkInputPosition(0) == proc.getChunkInputTotalRows(0) && proc.getChunkInputPosition(1) == proc.getChunkInputTotalRows(1)) {
            if (this.m_summaryRows) {
                double[] outRows = null;
                double[] rowNumColumn = null;
                if (this.m_rowNumColumn) {
                    rowNumColumn = proc.getChunkOutputColumnData(0, 0);
                }
                double[] summaryColumn = null;
                if (this.m_summaryColumn) {
                    int cNum;
                    int n = cNum = this.m_summaryInputs ? numcols : 0;
                    if (this.m_rowNumColumn) {
                        ++cNum;
                    }
                    summaryColumn = proc.getChunkOutputColumnData(0, cNum);
                }
                for (int c = 0; c < numcols; ++c) {
                    int outCol = this.m_rowNumColumn ? c + 1 : c;
                    outRows = proc.getChunkOutputColumnData(0, outCol);
                    int rowNum = this.m_summaryInputs ? acutualRowNum : 0;
                    outRows[rowNum++] = this.m_summaryRowMaxVals[c];
                    if (this.m_compareAsString[c] || this.m_logical) {
                        outRows[rowNum++] = this.m_summaryRowData[c];
                    } else {
                        double denominator = this.m_summaryRowDataCount[c];
                        if (denominator == 0.0) {
                            outRows[rowNum++] = 0.0;
                        } else {
                            double difference = Math.abs(this.m_summaryRowData[c]);
                            outRows[rowNum++] = difference / denominator;
                        }
                    }
                    if (c != numcols - 1) continue;
                    int n = rowNum = this.m_summaryInputs ? acutualRowNum : 0;
                    if (rowNumColumn != null) {
                        rowNumColumn[rowNum] = Double.NaN;
                    }
                    if (summaryColumn != null) {
                        summaryColumn[rowNum] = Double.NaN;
                    }
                    ++rowNum;
                    if (rowNumColumn != null) {
                        rowNumColumn[rowNum] = Double.NaN;
                    }
                    if (summaryColumn == null) continue;
                    summaryColumn[rowNum] = this.m_allEqual ? 1.0 : 0.0;
                }
                proc.setChunkOutputReleaseRows(0, 2);
            }
            proc.setChunkDone(true);
            return;
        }
        for (int phase = 0; phase < 2; ++phase) {
            int c;
            boolean outputSummaryRows = phase == 1 && this.m_summaryRows && lastRow;
            this.m_outputPhase = phase == 1;
            int columnNum = 0;
            double[] rowNumColumn = null;
            if (this.m_rowNumColumn && this.m_outputPhase) {
                rowNumColumn = proc.getChunkOutputColumnData(0, columnNum++);
                long abs = pos + 1L;
                int cnk = 0;
                int outputRow = 0;
                while (cnk < maxrows) {
                    if (!this.m_filterPassingRows || failureRow[cnk]) {
                        rowNumColumn[outputRow++] = abs;
                    }
                    ++cnk;
                    ++abs;
                }
            }
            double[] summaryColumn = null;
            if (this.m_summaryColumn && this.m_outputPhase) {
                int cNum;
                int n = cNum = this.m_summaryInputs ? numcols : 0;
                if (this.m_rowNumColumn) {
                    ++cNum;
                }
                summaryColumn = proc.getChunkOutputColumnData(0, cNum);
                for (int r = 0; r < maxrows; ++r) {
                    summaryColumn[r] = 1.0;
                }
            }
            String[][] inStrData = new String[2][];
            double[][] inDblData = new double[2][];
            double[] outRows = null;
            for (c = 0; c < numcols; ++c) {
                int in1Col = this.m_outputToInput1[c];
                int in2Col = this.m_outputToInput2[c];
                int outCol = this.m_rowNumColumn ? c + 1 : c;
                outRows = !this.m_outputPhase ? null : proc.getChunkOutputColumnData(0, outCol);
                double allGood = 1.0;
                if (in1Col < 0 || in2Col < 0) {
                    int validInput = 1;
                    int validColumn = in1Col;
                    if (in1Col < 0) {
                        validInput = 0;
                        validColumn = in2Col;
                    }
                    double[] colData = proc.getChunkInputColumnData(validInput, validColumn);
                    acutualRowNum = 0;
                    for (int r = 0; r < maxrows; ++r) {
                        if (summaryColumn != null) {
                            summaryColumn[acutualRowNum] = 0.0;
                        }
                        if (!this.m_outputPhase) {
                            int n = r;
                            failureRow[n] = failureRow[n] | true;
                        }
                        if (this.m_compareAsString[c] || this.m_logical) {
                            if (outRows != null) {
                                outRows[acutualRowNum] = 0.0;
                            }
                            allGood = 0.0;
                        } else {
                            if (outRows != null) {
                                outRows[acutualRowNum] = colData[r];
                            }
                            if (this.m_summaryRowMaxVals[c] < colData[r]) {
                                this.m_summaryRowMaxVals[c] = colData[r];
                            }
                            int n = c;
                            this.m_summaryRowData[n] = this.m_summaryRowData[n] + colData[r];
                            int n2 = c;
                            this.m_summaryRowDataCount[n2] = this.m_summaryRowDataCount[n2] + 1L;
                        }
                        ++acutualRowNum;
                    }
                    this.m_allEqual = false;
                } else if (this.m_compareAsString[c]) {
                    if (this.m_outputPhase) {
                        inStrData[1] = proc.getChunkInputColumnStrings(1, in1Col);
                        inStrData[0] = proc.getChunkInputColumnStrings(0, in2Col);
                        double val = 0.0;
                        acutualRowNum = 0;
                        for (int r = 0; r < maxrows; ++r) {
                            double d = val = r >= minrows || !inStrData[1][r].equals(inStrData[0][r]) ? 0.0 : 1.0;
                            if (allGood == 1.0 && val == 0.0) {
                                if (summaryColumn != null) {
                                    summaryColumn[acutualRowNum] = val;
                                }
                                this.m_allEqual = false;
                                allGood = 0.0;
                            }
                            if (this.m_filterPassingRows && !failureRow[r]) continue;
                            if (outRows != null) {
                                outRows[acutualRowNum] = val;
                            }
                            ++acutualRowNum;
                        }
                        inStrData[1] = null;
                        inStrData[0] = null;
                    }
                } else {
                    inDblData[1] = proc.getChunkInputColumnData(1, in1Col);
                    inDblData[0] = proc.getChunkInputColumnData(0, in2Col);
                    double val = 0.0;
                    double denom = 1.0;
                    boolean unequal = false;
                    acutualRowNum = 0;
                    for (int r = 0; r < maxrows; ++r) {
                        if (r < minrows) {
                            val = Math.abs(inDblData[1][r] - inDblData[0][r]);
                            if (val < this.m_tolerance) {
                                val = 0.0;
                            }
                            denom = Math.abs(inDblData[1][r]);
                            if (!this.m_logical && !this.m_absolute && denom > this.m_tolerance) {
                                val /= denom;
                            }
                        } else {
                            val = inDblData[biggerIndex][r];
                        }
                        boolean bl = unequal = val > this.m_tolerance || r >= minrows;
                        if (unequal) {
                            if (summaryColumn != null) {
                                summaryColumn[acutualRowNum] = 0.0;
                            }
                            if (!this.m_outputPhase && !failureRow[r]) {
                                failureRow[r] = true;
                            }
                            this.m_allEqual = false;
                        }
                        if (this.m_logical) {
                            double d = val = unequal ? 0.0 : 1.0;
                            if (val == 0.0) {
                                this.m_summaryRowMaxVals[c] = val;
                                this.m_summaryRowData[c] = val;
                                int n = c;
                                this.m_summaryRowDataCount[n] = this.m_summaryRowDataCount[n] + 1L;
                            }
                        } else if (r >= minrows) {
                            if (this.m_summaryRowMaxVals[c] < inDblData[biggerIndex][r]) {
                                this.m_summaryRowMaxVals[c] = inDblData[biggerIndex][r];
                            }
                            int n = c;
                            this.m_summaryRowData[n] = this.m_summaryRowData[n] + inDblData[biggerIndex][r];
                            int n3 = c;
                            this.m_summaryRowDataCount[n3] = this.m_summaryRowDataCount[n3] + 1L;
                        } else if (val > 0.0) {
                            if (this.m_summaryRowMaxVals[c] < val) {
                                this.m_summaryRowMaxVals[c] = val;
                            }
                            int n = c;
                            this.m_summaryRowData[n] = this.m_summaryRowData[n] + val;
                            int n4 = c;
                            this.m_summaryRowDataCount[n4] = this.m_summaryRowDataCount[n4] + 1L;
                        }
                        if ((!this.m_outputPhase || this.m_filterPassingRows) && !failureRow[r]) continue;
                        if (outRows != null) {
                            outRows[acutualRowNum] = val;
                        }
                        ++acutualRowNum;
                    }
                    inDblData[1] = null;
                    inDblData[0] = null;
                }
                if (allGood != 0.0) continue;
                this.m_summaryRowData[c] = 0.0;
                int n = c;
                this.m_summaryRowDataCount[n] = this.m_summaryRowDataCount[n] + 1L;
                this.m_summaryRowMaxVals[c] = 0.0;
            }
            for (c = 0; lastRow && this.m_outputMessagePane && this.m_outputPhase && c < numcols; ++c) {
                if (c == 0) {
                    this.printlnInformation("Inputs 1 & 2 were " + (this.m_allEqual ? "EQUAL" : "UNEQUAL"));
                }
                String colName = this.m_testColumnsMD.ordinalToName(c);
                if (this.m_compareAsString[c] || this.m_logical) {
                    if (!this.m_filterPassingRows || this.m_summaryRowData[c] == 0.0) {
                        this.printlnInformation("Column " + c + " (" + colName + ") is " + (this.m_summaryRowData[c] == 0.0 ? "unequal" : "equal") + " in inputs 1 & 2.");
                    }
                } else {
                    double denominator = this.m_summaryRowDataCount[c];
                    double difference = Math.abs(this.m_summaryRowData[c]);
                    if (!this.m_filterPassingRows || difference != 0.0 && denominator != 0.0) {
                        String output = "Column " + c + " (" + colName + ") has ";
                        output = this.m_absolute ? output + "an absolute mean difference of " : output + "a relative mean difference of ";
                        double val = denominator != 0.0 && !Double.isNaN(this.m_summaryRowData[c]) ? difference / denominator : 0.0;
                        output = output + this.getNetworkManager().getWorksheetPropertiesManager().formatDouble(val);
                        this.printlnInformation(output);
                    }
                }
                outRows = null;
            }
            summaryColumn = null;
            if (!this.m_outputPhase) continue;
            if (lastRow) {
                proc.setChunkOutputReleaseRows(0, acutualRowNum);
                proc.setChunkDone(!this.m_summaryInputs);
                continue;
            }
            if (this.m_summaryRows && !this.m_summaryInputs) {
                proc.setChunkOutputReleaseRows(0, 0);
                continue;
            }
            proc.setChunkOutputReleaseRows(0, acutualRowNum);
        }
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData md = null;
        try {
            XTProps props = this.getNodeProperties();
            boolean logical = props.getBoolean(LOGICAL_ATTRIBUTE_TAG, true);
            boolean union = props.getBoolean(UNION_ATTRIBUTE_TAG, true);
            boolean summaryInputs = props.getBoolean(SUMMARY_INPUTS_ATTRIBUTE_TAG, true);
            boolean summaryRows = props.getBoolean(SUMMARY_ROW_ATTRIBUTE_TAG, true);
            boolean summaryColumn = props.getBoolean(SUMMARY_COLUMN_ATTRIBUTE_TAG, false);
            boolean rowNumColumn = props.getBoolean(ROW_NUM_COLUMN_ATTRIBUTE_TAG, true);
            XTMetaData in1 = this.getInputMetaData(1);
            XTMetaData in2 = this.getInputMetaData(0);
            if (summaryInputs) {
                summaryRows = props.getBoolean(SUMMARY_INPUT_AND_ROW_ATTRIBUTE_TAG, true);
                summaryColumn = props.getBoolean(SUMMARY_INPUT_AND_COLUMN_ATTRIBUTE_TAG, false);
                rowNumColumn = props.getBoolean(SUMMARY_INPUT_AND_ROW_NUM_ATTRIBUTE_TAG, true);
                md = this.createCombinedMD(in1, in2, union, logical, rowNumColumn);
                if (summaryColumn) {
                    md.appendCategoricalDataField(SUMMARY_COLUMN_NAME, logicalLevels);
                }
            } else if (summaryRows) {
                md = this.createCombinedMD(in1, in2, union, logical, false);
            } else {
                md = new XTMetaData();
                if (rowNumColumn) {
                    md.appendContinousDataField(ROW_NUM_COLUMN_NAME);
                }
                md.appendCategoricalDataField(SUMMARY_COLUMN_NAME, logicalLevels);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return md;
    }

    private XTMetaData createCombinedMD(XTMetaData in1, XTMetaData in2, boolean union, boolean logical, boolean rowNumColumn) throws Exception {
        String colType;
        String colName;
        int numColumns1 = in1.getNumColumns();
        int numColumns2 = in2.getNumColumns();
        XTMetaData retMD = null;
        int col1 = 0;
        int col2 = 0;
        retMD = new XTMetaData();
        if (rowNumColumn) {
            retMD.appendContinousDataField(ROW_NUM_COLUMN_NAME);
        }
        while (col1 < numColumns1) {
            colName = in1.ordinalToName(col1);
            colType = in1.getColumnType(col1);
            int in2ColumnNum = in2.nameToOrdinal(colName);
            if ((in2ColumnNum >= 0 || union) && colType.equals(in2.getColumnType(colName))) {
                this.copyColumnInfo(colName, colType, in1, retMD, logical);
            }
            ++col1;
        }
        while (union && col2 < numColumns2) {
            colName = in2.ordinalToName(col2);
            colType = in2.getColumnType(col2);
            int retMDColNum = retMD.nameToOrdinal(colName);
            if (retMDColNum < 0) {
                this.copyColumnInfo(colName, colType, in2, retMD, logical);
            }
            ++col2;
        }
        return retMD;
    }

    private void copyColumnInfo(String colName, String colType, XTMetaData from, XTMetaData to, boolean logical) {
        if (!logical && (colType.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG) || colType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG))) {
            to.appendContinousDataField(colName);
        } else {
            to.appendCategoricalDataField(colName, logicalLevels);
        }
    }
}

