/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.cnkjava.CNKObj;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.XTMetaData;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class DataCacheFileReader {
    private String m_filename;
    private RandomAccessFile m_file;
    private XTMetaData m_metaData;
    private long m_numRowsInFile;
    private int m_numColumns;
    private DataCacheRowBuf m_rowBuf;
    private int m_bytesPerRow;
    private int m_cacheNumRows;
    private int m_cacheNumBytes;
    private byte[] m_cache;
    private long m_cacheFirstRowNum;
    private int m_cacheRowsSaved;
    private long m_rowBufRowNum;
    private String m_blobFileName;
    private RandomAccessFile m_blobFile;
    private boolean m_printedBlobFileNotFoundError = false;
    private WorksheetPropertiesManager m_worksheetPropertiesManager;

    public DataCacheFileReader(String filename, String blobFileName, XTMetaData md, WorksheetPropertiesManager wpm) throws Exception {
        this.m_filename = filename;
        this.m_file = new RandomAccessFile(filename, "r");
        this.m_metaData = (XTMetaData)md.clone();
        this.m_numRowsInFile = this.m_metaData.getNumRows();
        this.m_numColumns = this.m_metaData.getNumColumns();
        this.m_rowBuf = new DataCacheRowBuf(this.m_metaData, false);
        this.m_bytesPerRow = this.m_rowBuf.getBytesPerRow();
        this.m_cacheNumRows = Math.max(1, (int)(8192.0 / (double)Math.max(1, this.m_bytesPerRow)));
        this.m_cacheNumBytes = this.m_cacheNumRows * this.m_bytesPerRow;
        this.m_cache = new byte[this.m_cacheNumBytes];
        this.m_cacheFirstRowNum = 0L;
        this.m_cacheRowsSaved = 0;
        this.m_rowBufRowNum = -1L;
        this.m_blobFileName = blobFileName;
        this.m_blobFile = null;
        this.m_worksheetPropertiesManager = wpm;
    }

    public void close() throws Exception {
        this.m_file.close();
        if (this.m_blobFile != null) {
            this.m_blobFile.close();
        }
    }

    public long getNumRows() {
        return this.m_numRowsInFile;
    }

    public int getNumColumns() {
        return this.m_numColumns;
    }

    public String[] getColumnNames() {
        Vector columnNames = this.m_metaData.getColumnNames();
        int len = columnNames.size();
        String[] val = new String[len];
        for (int i = 0; i < len; ++i) {
            val[i] = (String)columnNames.get(i);
        }
        return val;
    }

    public DataCacheRowBuf getRowBuf() {
        return this.m_rowBuf;
    }

    private void seekToRowNum(long rowNum) throws Exception {
        if (rowNum != this.m_rowBufRowNum) {
            if (rowNum < this.m_cacheFirstRowNum || rowNum >= this.m_cacheFirstRowNum + (long)this.m_cacheRowsSaved) {
                int numRowsToRead = this.m_cacheNumRows;
                if (rowNum + (long)numRowsToRead > this.m_numRowsInFile) {
                    numRowsToRead = (int)(this.m_numRowsInFile - rowNum);
                }
                int bytesToRead = numRowsToRead * this.m_bytesPerRow;
                long newSeekPosition = rowNum * (long)this.m_bytesPerRow;
                this.m_file.seek(newSeekPosition);
                this.m_file.readFully(this.m_cache, 0, bytesToRead);
                this.m_cacheFirstRowNum = rowNum;
                this.m_cacheRowsSaved = numRowsToRead;
            }
            int rowInCache = (int)(rowNum - this.m_cacheFirstRowNum);
            this.m_rowBuf.setData(this.m_cache, rowInCache * this.m_bytesPerRow);
            this.m_rowBufRowNum = rowNum;
        }
    }

    public double getDouble(long rowNum, int colNum) throws Exception {
        this.seekToRowNum(rowNum);
        return this.m_rowBuf.getDouble(colNum);
    }

    public String getString(long rowNum, int colNum) throws Exception {
        this.seekToRowNum(rowNum);
        return this.m_rowBuf.getString(colNum);
    }

    public String getCategoricalString(long rowNum, int colNum) throws Exception {
        this.seekToRowNum(rowNum);
        int level = this.m_rowBuf.getLevelNum(colNum);
        if (CNKObj.isLevelNumNA(level)) {
            return null;
        }
        return this.m_metaData.getCategoricalDataFieldLevel(colNum, level);
    }

    public long getDateTime(long rowNum, int colNum) throws Exception {
        this.seekToRowNum(rowNum);
        return this.m_rowBuf.getTimeDate(colNum);
    }

    public long getBlobOffset(long rowNum, int colNum) throws Exception {
        this.seekToRowNum(rowNum);
        return this.m_rowBuf.getBlobOffset(colNum);
    }

    public long getBlobLength(long rowNum, int colNum) throws Exception {
        this.seekToRowNum(rowNum);
        return this.m_rowBuf.getBlobLength(colNum);
    }

    public Object[] getBlobColumn(int colNum, long[] blobOffsets, long[] blobLengths) throws Exception {
        Object[] val = new Object[blobOffsets.length];
        int cacheReadSize = 1024;
        boolean cacheEnabled = false;
        byte[] cache = new byte[cacheReadSize];
        long cacheOffset = 0L;
        int cacheLength = 0;
        int cacheMisses = 0;
        try {
            if (this.m_blobFile == null) {
                if (this.m_blobFileName == null) {
                    return null;
                }
                this.m_blobFile = new RandomAccessFile(this.m_blobFileName, "r");
            }
            String blobClassName = this.m_metaData.getBlobDataFieldClassName(colNum);
            CNKBlobClassHandler classHandler = CNKBlobClassHandler.getClassHandler(blobClassName);
            for (int row = 0; row < blobOffsets.length; ++row) {
                Object obj;
                int blobOffsetInCache;
                long blobOffset = blobOffsets[row];
                long blobLength = blobLengths[row];
                if (blobOffset < 0L || blobLength < 0L) {
                    val[row] = null;
                    continue;
                }
                int totalLength = DataCacheRowBuf.getTotalBlobLength(blobLength);
                if (cacheEnabled && blobOffset >= cacheOffset && blobOffset + (long)totalLength <= cacheOffset + (long)cacheLength) {
                    blobOffsetInCache = (int)(blobOffset - cacheOffset);
                } else {
                    int len;
                    ++cacheMisses;
                    if (totalLength > cache.length) {
                        cache = new byte[totalLength];
                    }
                    int numToRead = totalLength;
                    if (cacheEnabled && cacheReadSize > numToRead) {
                        numToRead = cacheReadSize;
                    }
                    this.m_blobFile.seek(blobOffset);
                    cacheOffset = blobOffset;
                    for (cacheLength = 0; cacheLength < numToRead && (len = this.m_blobFile.read(cache, cacheLength, numToRead - cacheLength)) >= 1; cacheLength += len) {
                    }
                    blobOffsetInCache = 0;
                    if (cacheLength < totalLength) {
                        val[row] = null;
                        continue;
                    }
                }
                if (!DataCacheRowBuf.blobHeaderTrailerOK(cache, blobOffsetInCache, blobOffset, blobLength)) {
                    val[row] = null;
                    continue;
                }
                ByteArrayInputStream bin = new ByteArrayInputStream(cache, blobOffsetInCache + 12, (int)blobLength);
                val[row] = obj = classHandler.readBlobObject(bin);
            }
            return val;
        }
        catch (FileNotFoundException ex) {
            if (!this.m_printedBlobFileNotFoundError) {
                System.out.println("DataCacheFileReader.getBlobColumn: " + ex);
                this.m_printedBlobFileNotFoundError = true;
            }
            return null;
        }
        catch (Exception ex) {
            System.out.println("DataCacheFileReader.getBlobColumn: " + ex);
            return null;
        }
    }

    private boolean byteMatch(byte[] b1, int offset, byte[] b2) {
        if (b1 == null || b2 == null || offset < 0 || offset + b2.length > b1.length) {
            return false;
        }
        for (int i = 0; i < b2.length; ++i) {
            if (b1[offset + i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static class RandomInputStream
    extends InputStream {
        private RandomAccessFile m_rin;
        private long m_blobLength;
        private long m_ptr;

        public RandomInputStream(RandomAccessFile rin, long blobLength) {
            this.m_rin = rin;
            this.m_blobLength = blobLength;
            this.m_ptr = 0L;
        }

        public int read() throws IOException {
            byte[] bytes = new byte[1];
            int val = this.read(bytes, 0, 1);
            if (val < 1) {
                return -1;
            }
            int c = bytes[0];
            if (c < 0) {
                c += 256;
            }
            return c;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b == null ? 0 : b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int bytesToRead = len;
            if (this.m_ptr + (long)len > this.m_blobLength) {
                bytesToRead = (int)(this.m_blobLength - this.m_ptr);
            }
            if (bytesToRead < 1) {
                return -1;
            }
            try {
                this.m_rin.readFully(b, off, bytesToRead);
            }
            catch (EOFException ex) {
                throw new IOException("end of file");
            }
            this.m_ptr += (long)bytesToRead;
            return bytesToRead;
        }
    }
}

