/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.UniqueEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.DataInput;
import java.io.DataOutput;

public class DuplicatedEngineNode
extends UniqueEngineNode {
    public static final int TRUE_INT = 1;
    public static final int FALSE_INT = 0;
    public static final String DUP_COL_NAME = "DUPLICATED";
    public static final String KEEP_ORIG_ATTRIBUTE_TAG = "keepOrigColumns";
    public static final String DUPLICATE_ATTRIBUTE_TAG = "duplicateColumn";
    public static final String FACTOR_ATTRIBUTE_TAG = "returnFactor";
    public static final String TRUE_FACTOR_ATTRIBUTE_TAG = "trueFactor";
    public static final String FALSE_FACTOR_ATTRIBUTE_TAG = "falseFactor";
    public static final String INCLUDE_FIRST = "includeFirst";
    public static final boolean INCLUDE_FIRST_DEFAULT = true;
    public static final String ADD_STATE_COLUMN = "addStateColumn";
    public static final String RUN_TYPE = "run";
    public static final int RUN_ALL_TYPE = 0;
    public static final int RUN_UNIQUE_TYPE = 1;
    public static final int RUN_DUPLICATED_TYPE = 2;
    protected int m_runType = 0;
    protected String m_trueFactor = "true";
    protected String m_falseFactor = "false";
    protected boolean m_returnFactor = false;
    protected boolean m_keepOrigColumns = true;
    protected String m_duplicateName = "DUPLICATED";
    protected boolean m_outputStateCol = true;
    protected boolean m_includeFirstOccurrence = false;

    public boolean executeDataCacheProc() throws Exception {
        this.refreshPropsForCalculateOutputMetaData(this.getNodeProperties());
        return super.executeDataCacheProc();
    }

    protected void refreshPropsForCalculateOutputMetaData(XTProps props) {
        this.m_runType = props.getInt(RUN_TYPE, 0);
        this.m_outputStateCol = props.getBoolean(ADD_STATE_COLUMN, true);
        this.m_includeFirstOccurrence = props.getBoolean(INCLUDE_FIRST, true);
        this.m_keepOrigColumns = props.getBoolean(KEEP_ORIG_ATTRIBUTE_TAG, true);
        this.m_duplicateName = props.getValue(DUPLICATE_ATTRIBUTE_TAG, DUP_COL_NAME);
        this.m_returnFactor = props.getBoolean(FACTOR_ATTRIBUTE_TAG, true);
        this.m_trueFactor = props.getValue(TRUE_FACTOR_ATTRIBUTE_TAG, "true");
        this.m_falseFactor = props.getValue(FALSE_FACTOR_ATTRIBUTE_TAG, "false");
        super.refreshPropsForCalculateOutputMetaData(props);
    }

    protected boolean sort() throws Exception {
        int num = this.m_equalityColNames.length;
        String[] sortCols = new String[num + 1];
        boolean[] ascend = new boolean[num + 1];
        boolean[] naTop = new boolean[num + 1];
        for (int i = 0; i < num; ++i) {
            sortCols[i] = this.m_equalityColNames[i];
            naTop[i] = true;
            ascend[i] = true;
        }
        sortCols[num] = ".im_index_im.";
        naTop[num] = true;
        ascend[num] = true;
        return SortAndShuffle.sort(this.m_indexedFile, this.m_sortedFile, this.m_indexedMD, (EngineNode)this, this.getMaxRowsPerBlock(), sortCols, ascend, naTop, true, true);
    }

    protected boolean manip(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        DataCacheRowBuf lastRow = new DataCacheRowBuf(preMD);
        boolean lastIsDup = false;
        long numRows = preMD.getNumRows();
        long rowsOutput = 0L;
        int numColumns = preMD.getNumColumns();
        int dupColNum = newMD.nameToOrdinal(this.m_duplicateName);
        int oldIndexColNum = preMD.nameToOrdinal(".im_index_im.");
        int newIndexColNum = newMD.nameToOrdinal(".im_index_im.");
        for (long rowNum = 0L; rowNum < numRows; ++rowNum) {
            try {
                preBuf.readRow(preStream);
                if (rowNum != 0L) {
                    boolean same = preBuf.isSame(lastRow, this.m_equalityColNums);
                    if (this.m_keepOrigColumns) {
                        for (int i = 0; i < numColumns; ++i) {
                            newBuf.copyColumn(i, i, lastRow);
                        }
                    } else {
                        newBuf.copyColumn(newIndexColNum, oldIndexColNum, lastRow);
                    }
                    boolean markAsDup = lastIsDup || this.m_includeFirstOccurrence && same;
                    newBuf.setDouble(dupColNum, markAsDup ? 1.0 : 0.0);
                    newBuf.writeRow(newStream);
                    ++rowsOutput;
                    if (rowNum == numRows - 1L) {
                        if (this.m_keepOrigColumns) {
                            for (int i = 0; i < numColumns; ++i) {
                                newBuf.copyColumn(i, i, preBuf);
                            }
                        } else {
                            newBuf.copyColumn(newIndexColNum, oldIndexColNum, preBuf);
                        }
                        newBuf.setDouble(dupColNum, same ? 1.0 : 0.0);
                        newBuf.writeRow(newStream);
                        ++rowsOutput;
                    }
                    lastIsDup = same;
                }
                lastRow.copyAllColumns(preBuf);
                continue;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        newMD.setNumRows(rowsOutput);
        return true;
    }

    protected boolean drop(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        long numRows = preMD.getNumRows();
        int indexColNum = preMD.nameToOrdinal(".im_index_im.");
        int dupColNum = preMD.nameToOrdinal(this.m_duplicateName);
        int numColumns = preMD.getNumColumns();
        if (this.m_runType == 0) {
            this.copyAll(preBuf, preStream, newBuf, newStream, numRows, numColumns, indexColNum, dupColNum);
        } else {
            long outputRows = this.duplicateOrUnique(preBuf, preStream, newBuf, newStream, numRows, numColumns, indexColNum, dupColNum, this.m_runType == 1);
            newMD.setNumRows(outputRows);
        }
        return true;
    }

    private long duplicateOrUnique(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, long numRows, int numColumns, int indexColNum, int dupColNum, boolean unique) {
        long outputRows = 0L;
        for (long rowNum = 0L; rowNum < numRows; ++rowNum) {
            try {
                boolean dup;
                preBuf.readRow(preStream);
                boolean bl = dup = (int)preBuf.getDouble(dupColNum) == 1;
                if ((!unique || dup) && (unique || !dup)) continue;
                this.copyRow(preBuf, newBuf, newStream, numColumns, indexColNum, dupColNum);
                ++outputRows;
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return outputRows;
    }

    private void copyAll(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, long numRows, int numColumns, int indexColNum, int dupColNum) {
        for (long rowNum = 0L; rowNum < numRows; ++rowNum) {
            try {
                preBuf.readRow(preStream);
                this.copyRow(preBuf, newBuf, newStream, numColumns, indexColNum, dupColNum);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
    }

    private void copyRow(DataCacheRowBuf preBuf, DataCacheRowBuf newBuf, DataOutput newStream, int numColumns, int indexColNum, int dupColNum) {
        int c = 0;
        for (int i = 0; i < numColumns; ++i) {
            if (i == indexColNum || !this.m_outputStateCol && i == dupColNum) continue;
            newBuf.copyColumn(c++, i, preBuf);
        }
        newBuf.writeRow(newStream);
    }

    protected XTMetaData getModifiedMD() {
        if (this.m_modifiedMD == null) {
            try {
                if (this.m_keepOrigColumns) {
                    this.m_modifiedMD = (XTMetaData)this.getSortedMD().clone();
                } else {
                    this.m_modifiedMD = new XTMetaData();
                    this.m_modifiedMD.appendContinousDataField(".im_index_im.");
                }
                if (this.m_returnFactor) {
                    String[] tfLevels = new String[2];
                    tfLevels[1] = this.m_trueFactor;
                    tfLevels[0] = this.m_falseFactor;
                    this.m_modifiedMD.appendCategoricalDataField(this.m_duplicateName, tfLevels);
                } else {
                    this.m_modifiedMD.appendContinousDataField(this.m_duplicateName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_modifiedMD;
    }

    protected XTMetaData getOutputMD() {
        try {
            XTMetaData md = (XTMetaData)this.getModifiedMD().clone();
            md.removeDataField(".im_index_im.");
            if (!this.m_outputStateCol) {
                md.removeDataField(this.m_duplicateName);
            }
            return md;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

