/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;

public class ExecViewer {
    String m_worksheetID = null;
    String m_nodeID = null;
    String m_nodeName = null;
    XTProps m_nodeProps = null;
    XTMetaData m_metadata = null;
    boolean m_isRegression = true;
    private boolean m_userStopRequested = false;
    private boolean m_userPauseRequested = false;
    private boolean m_userFailRequested = false;

    public void setWorksheetID(String worksheetID) {
        this.m_worksheetID = worksheetID;
    }

    public void show() {
    }

    public void initialize() {
        this.m_isRegression = true;
        this.m_userStopRequested = false;
        this.m_userPauseRequested = false;
        this.m_userFailRequested = false;
    }

    public void setIsRegression(Boolean b) {
        if (b != null) {
            this.m_isRegression = b;
        }
    }

    public void setNodeID(String nodeID) {
        this.m_nodeID = nodeID;
    }

    public void setConfigData(XTProps nodeProps, XTMetaData metadata) {
        this.m_metadata = metadata;
        this.m_nodeProps = nodeProps;
    }

    public void setNodeName(String nodeName) {
        this.m_nodeName = nodeName;
    }

    public void closeExecViewer() {
    }

    public Object sendMessageToEngineNode(String msg, Object[] args) {
        return this.sendMessageToEngineNode(this.m_nodeID, msg, args);
    }

    public Object sendMessageToEngineNode(String nodeID, String msg, Object[] args) {
        Object val = GuiMessageHandler.sendMessageToEngine(this.m_worksheetID, nodeID, msg, args);
        return val;
    }

    public void unlinkExecViewer() {
        MinerApp.unlinkExecViewer(this.m_worksheetID, this.m_nodeID);
    }

    public boolean isUserStopRequested() {
        return this.m_userStopRequested;
    }

    public boolean isUserFailRequested() {
        return this.m_userFailRequested;
    }

    public boolean isUserPauseRequested() {
        return this.m_userPauseRequested;
    }

    public void pause() {
        this.m_userPauseRequested = true;
    }

    public void finishNode() {
        this.m_userStopRequested = true;
    }

    public void finishNodeFail() {
        this.m_userStopRequested = true;
        this.m_userFailRequested = true;
    }

    public void continueRun() {
        this.m_userPauseRequested = false;
        this.sendMessageToEngineNode(null, "nodeExecContinue", new Object[]{this.m_nodeID});
    }
}

