/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ChartBuilder;
import com.insightful.miner.ChartPropertiesDialog;
import com.insightful.miner.ClusterFrame;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.PrintPreview;
import com.insightful.miner.graph.ExportGraphCommand;
import com.insightful.miner.tree.gui.ColorBroker;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartPanel;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.event.ChartChangeListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public abstract class InsBasicChartPanel
extends JFreeChartPanel
implements ActionListener,
Printable,
ClipboardOwner,
ChartChangeListener {
    public static final String PROPERTIES_ACTION_COMMAND = "PROPERTIES";
    public static final String SAVE_ACTION_COMMAND = "SAVE";
    public static final String PRINT_ACTION_COMMAND = "PRINT";
    private ColorBroker colorBroker = null;

    public InsBasicChartPanel(JFreeChart chart, int width, int height, double minimumDrawWidth, double minimumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
        this.popup = this.createPopupMenu();
        this.setOpaque(true);
    }

    public InsBasicChartPanel(JFreeChart chart) {
        this(chart, 250, 250, 250.0, 250.0, true, true, true, true, true, true);
    }

    public InsBasicChartPanel getChartPanel() {
        return this;
    }

    public abstract NumberAxis getRangeAxis();

    public abstract double getMaxVal();

    public abstract double getMinVal();

    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if ((e.getModifiers() & 4) == 4 && this.popup != null) {
            this.popup.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        MinerPopupMenu result = new MinerPopupMenu();
        JMenuItem saveMenuItem = new JMenuItem(ChartBuilder.getText("clusterFrame_filesave"));
        saveMenuItem.setActionCommand(SAVE_ACTION_COMMAND);
        saveMenuItem.addActionListener(this);
        result.add(saveMenuItem);
        result.addSeparator();
        JMenuItem copyMenuItem = new JMenuItem(new AbstractAction(ChartBuilder.getText("clusterFrame_filecopy")){

            public void actionPerformed(ActionEvent e) {
                Toolkit toolkit = InsBasicChartPanel.this.getToolkit();
                Clipboard clipboard = toolkit.getSystemClipboard();
                ClusterFrame.copyToClipboard(clipboard, InsBasicChartPanel.this, (Component)((Object)InsBasicChartPanel.this));
            }
        });
        result.add(copyMenuItem);
        JMenuItem printMenuItem = new JMenuItem(ChartBuilder.getText("clusterFrame_fileprint"));
        printMenuItem.setActionCommand(PRINT_ACTION_COMMAND);
        printMenuItem.addActionListener(this);
        result.add(printMenuItem);
        return result;
    }

    public void lostOwnership(Clipboard c, Transferable t) {
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(PROPERTIES_ACTION_COMMAND)) {
            this.createChartPropsDialog();
        } else if (command.equals(SAVE_ACTION_COMMAND)) {
            this.saveAs();
        } else if (command.equals(PRINT_ACTION_COMMAND)) {
            this.print();
        }
    }

    protected void createChartPropsDialog() {
        Frame parent = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        ChartPropertiesDialog chartProps = new ChartPropertiesDialog(parent, this);
        chartProps.setVisible(true);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void saveAs() {
        ExportGraphCommand egc = new ExportGraphCommand(this.getParentFrame(), (JComponent)((Object)this));
        egc.doExecute();
    }

    public abstract Frame getParentFrame();

    public void printPreview() {
        Thread runner = new Thread(){

            public void run() {
                Component comp = MinerApp.getMainFrame().getGlassPane();
                Cursor oldCursor = comp.getCursor();
                comp.setCursor(Cursor.getPredefinedCursor(3));
                comp.setVisible(true);
                new PrintPreview(InsBasicChartPanel.this.getChartPanel(), (JComponent)((Object)InsBasicChartPanel.this.getChartPanel()));
                comp.setCursor(oldCursor);
                comp.setVisible(false);
            }
        };
        runner.start();
    }

    public void print() {
        PrintThread thrd = new PrintThread(this);
        thrd.start();
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h1 = pf.getImageableHeight() * 0.6;
        this.getChart().draw(g2, (Rectangle2D)new Rectangle2D.Double(x, y, w, h1), new DrawInfo());
        return 0;
    }

    protected class PrintThread
    extends Thread {
        private InsBasicChartPanel m_ui;

        public PrintThread(InsBasicChartPanel ui) {
            this.m_ui = ui;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                Paper paper = pf.getPaper();
                double margin = 36.0;
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                pf.setPaper(paper);
                pj.setPrintable(this.m_ui, pf);
                new MinerApp.GenericPrintThread(pj).start();
            }
            MinerApp.getMainFrame().requestFocus();
            this.m_ui.requestFocus();
        }
    }
}

