/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerLicenseInfo;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class MinerAboutBox {
    private String m_text = null;
    private static final String DATE_CHECK_OBJECT_RELATIVE_PATH = "bin\\WinLink.dll";

    public String getVersionInfoText() {
        String retStr = "";
        ResourceBundle bundle = null;
        try {
            MinerLicenseInfo info = MinerApp.getLicenseInfo();
            bundle = ResourceBundle.getBundle("minerBuild");
            retStr = retStr + bundle.getString("minerProduct");
            retStr = retStr + " ";
            retStr = retStr + bundle.getString("minerVersion");
            retStr = retStr + "\nBuild Date:  ";
            retStr = retStr + bundle.getString("minerBuildDate");
            retStr = retStr + "\nBuild Number:  ";
            try {
                SplusDataResult result = SplusSystem.getEngineQueryHandler().processDataQuery("build.number()");
                String[] buildNumber = result.getStringData();
                retStr = retStr + buildNumber[0];
            }
            catch (Exception e) {
                retStr = retStr + "[Build Number information not available]";
            }
            retStr = retStr + "\n\n";
        }
        catch (Exception e) {
            retStr = "[Version information not available]\n\n";
        }
        return retStr;
    }

    public String getCopywriteInfoText() {
        String retStr = "";
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("minerBuild");
            retStr = retStr + bundle.getString("minerCopyright");
        }
        catch (Exception e) {
            retStr = retStr + "[Copyright information not available]\n";
        }
        return retStr;
    }

    private String getAboutText() {
        if (this.m_text == null) {
            this.m_text = this.getVersionInfoText();
            this.m_text = this.m_text + "OS Name:  ";
            this.m_text = this.m_text + System.getProperty("os.name");
            this.m_text = this.m_text + "\nOS Version:  ";
            this.m_text = this.m_text + System.getProperty("os.version");
            this.m_text = this.m_text + "\n\n";
            try {
                MinerLicenseInfo info = MinerApp.getLicenseInfo();
                String serialNumber = info.getSerialNumber();
                String sExpiration = "[licensed]";
                long lDaysLeft = info.getDaysLeft();
                if (lDaysLeft > 0L) {
                    sExpiration = "[expires in " + lDaysLeft + " day(s)]";
                }
                this.m_text = this.m_text + "Serial Number:  " + serialNumber + "\n" + sExpiration + "\n\n";
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.m_text = this.m_text + this.getCopywriteInfoText();
        }
        return this.m_text;
    }

    public void show() {
        new TextAndImageDialog(this.getAboutText()).setVisible(true);
    }

    public void show(JFrame frame) {
        new TextAndImageDialog(frame, this.getAboutText()).setVisible(true);
    }

    private class TextAndImageDialog
    extends JDialog {
        public TextAndImageDialog(String text) {
            this(MinerApp.getMainFrame(), text);
        }

        public TextAndImageDialog(Frame frame, String text) {
            super(frame, "About Insightful Miner");
            JTextArea aboutText = new JTextArea(text);
            JPanel aboutTextPanel = new JPanel(new BorderLayout());
            aboutTextPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            aboutTextPanel.add((Component)aboutText, "Center");
            aboutText.setEditable(false);
            aboutText.setBackground(this.getBackground());
            AbstractAction okAction = new AbstractAction("OK"){

                public void actionPerformed(ActionEvent e) {
                    TextAndImageDialog.this.setVisible(false);
                    TextAndImageDialog.this.dispose();
                }
            };
            JButton ok = new JButton(okAction);
            ok.setMnemonic('O');
            ok.registerKeyboardAction(okAction, KeyStroke.getKeyStroke("ESCAPE"), 2);
            this.getRootPane().setDefaultButton(ok);
            JPanel okPanel = new JPanel();
            okPanel.setLayout(new BoxLayout(okPanel, 0));
            okPanel.add(Box.createHorizontalGlue());
            okPanel.add(ok);
            JPanel cont = new JPanel();
            cont.setLayout(new GridBagLayout());
            cont.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridy = 0;
            cont.add((Component)aboutTextPanel, gbc);
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.weighty = 0.0;
            gbc.gridy = 1;
            cont.add((Component)okPanel, gbc);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)cont, "Center");
            this.pack();
            this.setLocationRelativeTo(MinerApp.getMainFrame());
        }
    }
}

