/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.jrefinery.ui.FontChooserPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class MinerTextNodeDialog
extends JDialog
implements ActionListener {
    protected FontChooserPanel m_fontChooser;
    protected boolean m_colorChooserOK;
    protected boolean m_okClicked;
    protected Font m_font;
    protected JTextField m_colorTF;

    public MinerTextNodeDialog(Font initFont, Color txt, Color bkg) {
        super(MinerApp.getMainFrame(), MinerApp.getText("MinerTextNodeDialog_textNodeDialog"), true);
        this.init(initFont, txt, bkg);
        this.pack();
        this.setLocationRelativeTo(MinerApp.getMainFrame());
    }

    private void init(Font initFont, Color txt, Color bkg) {
        this.m_fontChooser = new FontChooserPanel(initFont);
        MinerTextNodeDialog.setJListSelection((Container)this.m_fontChooser, initFont.getName());
        MinerTextNodeDialog.setJListSelection((Container)this.m_fontChooser, Integer.toString(initFont.getSize()));
        MinerTextNodeDialog.setJCheckBoxSelection((Container)this.m_fontChooser, "Bold", initFont.isBold());
        MinerTextNodeDialog.setJCheckBoxSelection((Container)this.m_fontChooser, "Italic", initFont.isItalic());
        this.m_colorTF = new JTextField(MinerApp.getText("MinerTextNodeDialog_alphabet"));
        this.m_colorTF.setEditable(false);
        this.m_colorTF.setForeground(txt);
        JButton setFontColor = new JButton(new AbstractAction(MinerApp.getText("MinerTextNodeDialog_text")){

            public void actionPerformed(ActionEvent e) {
                Color newColor = MinerTextNodeDialog.this.setColor(MinerTextNodeDialog.this, MinerTextNodeDialog.this.m_colorTF.getForeground());
                MinerTextNodeDialog.this.m_colorTF.setForeground(newColor);
                MinerTextNodeDialog.this.m_colorTF.updateUI();
            }
        });
        this.m_colorTF.setBackground(bkg);
        JButton setBackgroundColor = new JButton(new AbstractAction(MinerApp.getText("MinerTextNodeDialog_background")){

            public void actionPerformed(ActionEvent e) {
                Color newColor = MinerTextNodeDialog.this.setColor(MinerTextNodeDialog.this, MinerTextNodeDialog.this.m_colorTF.getBackground());
                MinerTextNodeDialog.this.m_colorTF.setBackground(newColor);
                MinerTextNodeDialog.this.m_colorTF.updateUI();
            }
        });
        JButton ok = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_ok")){

            public void actionPerformed(ActionEvent e) {
                MinerTextNodeDialog.this.m_font = MinerTextNodeDialog.this.m_fontChooser.getSelectedFont();
                MinerTextNodeDialog.this.m_okClicked = true;
                MinerTextNodeDialog.this.dispose();
            }
        });
        ok.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
        JButton cancel = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_cancel")){

            public void actionPerformed(ActionEvent e) {
                MinerTextNodeDialog.this.m_okClicked = false;
                MinerTextNodeDialog.this.dispose();
            }
        });
        cancel.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
        JButton help = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_help")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getHelpManager().showTopic("Annotation");
            }
        });
        help.setMnemonic(MinerApp.getText("NodeDialog_helpHotkey").charAt(0));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(ok);
        buttonsPanel.add(Box.createHorizontalStrut(5));
        buttonsPanel.add(cancel);
        buttonsPanel.add(Box.createHorizontalStrut(5));
        buttonsPanel.add(help);
        JPanel colorSelectionPanel = new JPanel(new GridBagLayout());
        colorSelectionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("MinerTextNodeDialog_colorSelection")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        colorSelectionPanel.add((Component)this.m_colorTF, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        colorSelectionPanel.add((Component)setFontColor, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        colorSelectionPanel.add((Component)setBackgroundColor, gbc);
        Container cont = this.getContentPane();
        cont.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        cont.add((Component)this.m_fontChooser, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        cont.add((Component)colorSelectionPanel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(10, 0, 10, 0);
        cont.add((Component)buttonsPanel, gbc);
    }

    public static boolean setJListSelection(Container parentComp, Object objToSelect) {
        int numComp = parentComp.getComponentCount();
        for (int c = 0; c < numComp; ++c) {
            Component comp = parentComp.getComponent(c);
            if (comp instanceof JList) {
                ListModel model = ((JList)comp).getModel();
                int numItems = model.getSize();
                for (int i = 0; i < numItems; ++i) {
                    Object obj = model.getElementAt(i);
                    if (!obj.equals(objToSelect)) continue;
                    ((JList)comp).setSelectedIndex(i);
                    ((JList)comp).ensureIndexIsVisible(i);
                    ((JList)comp).repaint();
                    return true;
                }
                continue;
            }
            if (!(comp instanceof Container) || !MinerTextNodeDialog.setJListSelection((Container)comp, objToSelect)) continue;
            return true;
        }
        return false;
    }

    public static boolean setJCheckBoxSelection(Container parentComp, String label, boolean selected) {
        int numComp = parentComp.getComponentCount();
        for (int c = 0; c < numComp; ++c) {
            Component comp = parentComp.getComponent(c);
            if (comp instanceof JCheckBox) {
                if (!((JCheckBox)comp).getText().equals(label)) continue;
                ((JCheckBox)comp).setSelected(selected);
                return true;
            }
            if (!(comp instanceof Container) || !MinerTextNodeDialog.setJCheckBoxSelection((Container)comp, label, selected)) continue;
            return true;
        }
        return false;
    }

    private Color setColor(Component comp, Color initColor) {
        JColorChooser cc = new JColorChooser(initColor);
        JDialog dlg = JColorChooser.createDialog(comp, MinerApp.getText("MinerTextNodeDialog_setColor"), true, cc, this, this);
        dlg.show();
        if (this.m_colorChooserOK) {
            return cc.getColor();
        }
        return initColor;
    }

    public void actionPerformed(ActionEvent e) {
        this.m_colorChooserOK = e.getActionCommand().equals(MinerApp.getText("NodeDialog_ok"));
    }

    public boolean isItalics() {
        return this.m_font.isItalic();
    }

    public boolean isBold() {
        return this.m_font.isBold();
    }

    public Font getFont() {
        return this.m_font;
    }

    public Color getBackground() {
        return this.m_colorTF.getBackground();
    }

    public Color getForeground() {
        return this.m_colorTF.getForeground();
    }

    public boolean ok() {
        return this.m_okClicked;
    }
}

