/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NeuralNetViewer;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.SetRolesPanel;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NeuralNetworkDialog
extends NodeDialog {
    private SetRolesPanel setRolesPanel;
    private PredictionPanel predictionPanel;
    private JPanel nnetOptionsPanel;
    private boolean noError = true;
    private JComboBox trainingMethodComboBox;
    private JTextField accuracyTextField;
    private JTextField epochsTextField;
    private JTextField numNodesTextField;
    private JTextField learningRateTextField;
    private JTextField momentumTextField;
    private JTextField weightDecayTextField;
    private JComboBox numHiddenLayersComboBox;
    private JCheckBox m_execViewerCheckbox;
    private JTextField validationPercentTextField;
    private JCheckBox m_usePreviousWeights;
    private JTextField m_initFile;
    private JButton m_browseButton;
    private FocusManager m_focusMananger = null;
    private JRadioButton[] initialWeightsButtons;
    private JRadioButton loadFinalWeightFileButton;
    private JRadioButton useBestButton;
    private JRadioButton useLastButton;
    private ItemListener selectTrainMethodListener;
    public static final String accuracyDefault = "0.00001";
    public static final String epochsDefault = "50";
    public static final String numNodesHiddenLayerDefault = "10";
    public static final String learningRateDefault = "0.001";
    public static final String momentumDefault = "0.0";
    public static final String weightDecayDefault = "1.0";
    public static final String numHiddenLayersDefault = "1";
    public static final String validationPercentDefault = "10";
    private static final String[] nHiddenLayerStrings = new String[]{"0", "1", "2", "3"};
    public static final String[] trainingMethods = new String[]{"rprop", "quickProp", "deltaBarDelta", "online", "conjugateGradient"};
    public static final String[] trainingMethodStrings = new String[]{MinerApp.getText("NeuralNetworkDialog_rprop"), MinerApp.getText("NeuralNetworkDialog_quickProp"), MinerApp.getText("NeuralNetworkDialog_deltaBarDelta"), MinerApp.getText("NeuralNetworkDialog_online"), MinerApp.getText("NeuralNetworkDialog_conjugateGradient")};
    public static final int CONJUGATE_GRADIENT_INDEX = 4;
    private int neuralNetwork = 0;
    public static final int CLASSIFICATION_NEURAL_NETWORK = 1;
    public static final int REGRESSION_NEURAL_NETWORK = 0;
    private AbstractAction enterSeedAction;
    private AbstractAction generateSeedAction;
    private AbstractAction newSeedEveryTimeAction;
    private AbstractAction randomWeightsAction;
    private AbstractAction previousWeightsAction;
    private AbstractAction useBestWeightsRadioButtonAction;
    private AbstractAction useLastWeightsRadioButtonAction;
    private AbstractAction loadInitialWeightFileButtonAction;
    private static NeuralNetworkDialog instance = null;

    public static NeuralNetworkDialog getInstance() {
        if (instance == null) {
            instance = new NeuralNetworkDialog();
        }
        return instance;
    }

    private NeuralNetworkDialog() {
        Dimension dim = new Dimension(510, 530);
        this.setSize(dim);
        this.setMinimumSize(dim);
        this.setResizable(true);
    }

    public void show(ActivityNodeModel newModel, int neuralNetwork) {
        if (newModel != null) {
            this.neuralNetwork = neuralNetwork;
            if (neuralNetwork == 1) {
                this.setRolesPanel.changeDependentType(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            } else {
                this.setRolesPanel.changeDependentType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
            }
            this.show(newModel);
            this.m_focusMananger = FocusManager.getCurrentManager();
        }
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        int iMethod;
        super.restoreProperties();
        this.setRolesPanel.restoreProperties(this.getNodeModel());
        this.predictionPanel.restoreProperties(this.getNodeModel(), this.neuralNetwork);
        XTProps props = this.getNodeModel().getXTProps();
        String method = props.getValue("trainingMethod", "rprop");
        for (iMethod = 0; iMethod < trainingMethods.length; ++iMethod) {
            if (!method.equals(trainingMethods[iMethod])) continue;
            this.trainingMethodComboBox.setSelectedIndex(iMethod);
            break;
        }
        this.accuracyTextField.setText(props.getValue("attribute", accuracyDefault));
        this.epochsTextField.setText(props.getValue("epochs", epochsDefault));
        this.numNodesTextField.setText(props.getValue("numNodesHiddenLayer", "10"));
        this.learningRateTextField.setText(props.getValue("learningRate", learningRateDefault));
        this.momentumTextField.setText(props.getValue("momentum", momentumDefault));
        this.weightDecayTextField.setText(props.getValue("weightDecay", weightDecayDefault));
        if (iMethod == 4) {
            this.momentumTextField.disable();
            this.weightDecayTextField.disable();
        }
        this.validationPercentTextField.setText(props.getValue("validationPercent", "10"));
        String val = props.getValue("hiddenLayers", numHiddenLayersDefault);
        int j = Integer.parseInt(val);
        this.numHiddenLayersComboBox.setSelectedIndex(j);
        if (props.getBoolean("initWithPrevWeights", false)) {
            this.initialWeightsButtons[1].setSelected(false);
            this.seedPanel.setEnabled(false);
            val = props.getValue("initWithWeightsFromFile", "");
            if (val.length() > 0) {
                this.m_initFile.setText(val);
                this.initialWeightsButtons[0].setSelected(false);
                this.initialWeightsButtons[2].setSelected(true);
                this.m_initFile.setEnabled(true);
                this.m_browseButton.setEnabled(true);
            } else {
                this.initialWeightsButtons[0].setSelected(true);
                this.initialWeightsButtons[2].setSelected(false);
                this.m_initFile.setEnabled(false);
                this.m_browseButton.setEnabled(false);
            }
        } else {
            this.initialWeightsButtons[0].setSelected(false);
            this.initialWeightsButtons[1].setSelected(true);
            this.initialWeightsButtons[2].setSelected(false);
            this.seedPanel.setEnabled(true);
            this.m_initFile.setEnabled(false);
            this.m_browseButton.setEnabled(false);
        }
        this.m_execViewerCheckbox.setSelected(props.getBoolean("showExecViewer", true));
        if (props.getInt("finalModelOption", 1) == 1) {
            this.useBestButton.setSelected(true);
            this.useLastButton.setSelected(false);
        } else {
            this.useBestButton.setSelected(false);
            this.useLastButton.setSelected(true);
        }
    }

    protected boolean initWithPrevWeights(XTProps oldProps, XTProps newProps) {
        boolean bInitWithPrevWeights;
        boolean bl = bInitWithPrevWeights = oldProps != null;
        if (bInitWithPrevWeights) {
            Vector rolesOld = oldProps.getSubProperties("columnRoles");
            Vector rolesNew = newProps.getSubProperties("columnRoles");
            Iterator iter1 = rolesOld.iterator();
            Iterator iter2 = rolesNew.iterator();
            while (iter1.hasNext() && iter2.hasNext() && bInitWithPrevWeights) {
                String varName1 = (String)iter1.next();
                String varName2 = (String)iter2.next();
                bInitWithPrevWeights = varName1.equals(varName2);
                bInitWithPrevWeights &= oldProps.getValue(new String[]{"columnRoles", varName1}).equals(newProps.getValue(new String[]{"columnRoles", varName2}));
            }
            bInitWithPrevWeights &= iter1.hasNext() == iter2.hasNext();
            bInitWithPrevWeights &= oldProps.getInt("hiddenLayers", 0) == newProps.getInt("hiddenLayers", 1);
            bInitWithPrevWeights &= oldProps.getInt("numNodesHiddenLayer", 1) == newProps.getInt("numNodesHiddenLayer", 2);
        }
        return bInitWithPrevWeights;
    }

    public void saveProperties() throws NodeDialog.DialogException {
        XTProps oldProps = null;
        try {
            oldProps = new XTProps(this.getNodeModel().getXTProps());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.saveProperties();
        this.setRolesPanel.saveProperties(this.getNodeModel());
        this.predictionPanel.saveProperties(this.getNodeModel(), this.neuralNetwork);
        XTProps props = this.getNodeModel().getXTProps();
        String s = this.accuracyTextField.getText();
        try {
            double d = Double.valueOf(s);
            if (d < 0.0 || d >= 1.0) {
                s = accuracyDefault;
            }
        }
        catch (Exception e) {
            s = accuracyDefault;
        }
        props.set("attribute", s);
        s = this.epochsTextField.getText();
        try {
            int i = Integer.parseInt(s);
            if ((double)i < 0.0) {
                s = epochsDefault;
            }
        }
        catch (Exception e) {
            s = epochsDefault;
        }
        props.set("epochs", s);
        s = this.numNodesTextField.getText();
        try {
            int i = Integer.parseInt(s);
            if ((double)i < 0.0) {
                s = "10";
            }
        }
        catch (Exception e) {
            s = "10";
        }
        props.set("numNodesHiddenLayer", s);
        props.set("trainingMethod", trainingMethods[this.trainingMethodComboBox.getSelectedIndex()]);
        props.set("hiddenLayers", nHiddenLayerStrings[this.numHiddenLayersComboBox.getSelectedIndex()]);
        s = this.learningRateTextField.getText();
        try {
            double d = Double.valueOf(s);
            if (d <= 0.0 || d > 1.0) {
                s = learningRateDefault;
            }
        }
        catch (Exception e) {
            s = learningRateDefault;
        }
        props.set("learningRate", s);
        s = this.momentumTextField.getText();
        try {
            double d = Double.valueOf(s);
            if (d < 0.0 || d > 1.0) {
                s = momentumDefault;
            }
        }
        catch (Exception e) {
            s = momentumDefault;
        }
        props.set("momentum", s);
        s = this.weightDecayTextField.getText();
        try {
            double d = Double.valueOf(s);
            if (d < 0.0 || d > 1.0) {
                s = weightDecayDefault;
            }
        }
        catch (Exception e) {
            s = weightDecayDefault;
        }
        props.set("weightDecay", s);
        if ((this.initialWeightsButtons[0].isSelected() || this.initialWeightsButtons[2].isSelected()) && this.initWithPrevWeights(oldProps, props)) {
            props.set("initWithPrevWeights", true);
            if (this.m_initFile.getText().length() > 0) {
                props.set("initWithWeightsFromFile", this.m_initFile.getText());
            }
        } else {
            props.set("initWithPrevWeights", false);
        }
        props.set("showExecViewer", this.m_execViewerCheckbox.isSelected());
        s = this.validationPercentTextField.getText();
        try {
            int i = Integer.valueOf(s);
            if (i < 0 || i > 50) {
                s = "10";
            }
        }
        catch (Exception e) {
            s = "10";
        }
        props.set("validationPercent", s);
        if (this.useLastButton.isSelected()) {
            props.set("finalModelOption", 2);
        } else {
            props.set("finalModelOption", 1);
        }
    }

    public void createActions() {
        super.createActions();
        this.previousWeightsAction = new AbstractAction(MinerApp.getText("NeuralNetworkDialog_previousWeights")){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkDialog.this.seedPanel.setEnabled(false);
                NeuralNetworkDialog.this.numHiddenLayersComboBox.setEnabled(false);
                NeuralNetworkDialog.this.numNodesTextField.setEnabled(false);
                NeuralNetworkDialog.this.m_initFile.setEnabled(false);
                NeuralNetworkDialog.this.m_browseButton.setEnabled(false);
            }
        };
        this.randomWeightsAction = new AbstractAction(MinerApp.getText("NeuralNetworkDialog_randomWeights")){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkDialog.this.seedPanel.setEnabled(true);
                NeuralNetworkDialog.this.numHiddenLayersComboBox.setEnabled(true);
                NeuralNetworkDialog.this.numNodesTextField.setEnabled(true);
                NeuralNetworkDialog.this.m_initFile.setEnabled(false);
                NeuralNetworkDialog.this.m_browseButton.setEnabled(false);
            }
        };
        this.loadInitialWeightFileButtonAction = new AbstractAction(MinerApp.getText("NeuralNetworkDialog_loadWeights")){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkDialog.this.seedPanel.setEnabled(false);
                NeuralNetworkDialog.this.numHiddenLayersComboBox.setEnabled(false);
                NeuralNetworkDialog.this.numNodesTextField.setEnabled(false);
                NeuralNetworkDialog.this.m_initFile.setEnabled(true);
                NeuralNetworkDialog.this.m_browseButton.setEnabled(true);
                NeuralNetworkDialog.this.m_initFile.setFocusable(true);
                if (NeuralNetworkDialog.this.m_focusMananger != null) {
                    NeuralNetworkDialog.this.m_focusMananger.focusNextComponent(NeuralNetworkDialog.this.m_browseButton);
                }
            }
        };
        this.useBestWeightsRadioButtonAction = new AbstractAction(MinerApp.getText("NeuralNetworkDialog_useBestWeights")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetworkDialog.this.useBestButton.isSelected()) {
                    // empty if block
                }
            }
        };
        this.useLastWeightsRadioButtonAction = new AbstractAction(MinerApp.getText("NeuralNetworkDialog_useLastWeights")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetworkDialog.this.useLastButton.isSelected()) {
                    // empty if block
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        this.setRolesPanel = new SetRolesPanel(this.okAction, false);
        this.setRolesPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        this.setRolesPanel.addPropertyChangeListener("dependentChange", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                NeuralNetworkDialog.this.predictionPanel.dependentChanged((String)e.getNewValue());
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.setRolesPanel, "Center");
        panel.add((Component)this.createExecViewerPanel(), "South");
        return panel;
    }

    public JPanel createNNetOptionsPanel() {
        this.selectTrainMethodListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String s = (String)e.getItem();
                if (s.equalsIgnoreCase(trainingMethodStrings[4])) {
                    NeuralNetworkDialog.this.momentumTextField.setEnabled(false);
                    NeuralNetworkDialog.this.weightDecayTextField.setEnabled(false);
                } else {
                    NeuralNetworkDialog.this.momentumTextField.setEnabled(true);
                    NeuralNetworkDialog.this.weightDecayTextField.setEnabled(true);
                }
            }
        };
        JLabel trainingMethodLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_trainingMethod"));
        this.trainingMethodComboBox = new JComboBox<String>(trainingMethodStrings);
        trainingMethodLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_trainingMethodHotkey").charAt(0));
        trainingMethodLabel.setLabelFor(this.trainingMethodComboBox);
        this.trainingMethodComboBox.addItemListener(this.selectTrainMethodListener);
        this.trainingMethodComboBox.setEditable(false);
        JLabel accuracyLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_accuracy"));
        this.accuracyTextField = new JTextField();
        this.accuracyTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        accuracyLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_accuracyHotkey").charAt(0));
        accuracyLabel.setLabelFor(this.accuracyTextField);
        this.accuracyTextField.setDocument(new NodeDialog.InputDoubleDoc());
        JLabel epochsLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_epochs"));
        this.epochsTextField = new JTextField();
        this.epochsTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        epochsLabel.setDisplayedMnemonic('p');
        epochsLabel.setLabelFor(this.epochsTextField);
        this.epochsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        JLabel numHiddenLayersLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_numHiddenLayers"));
        this.numHiddenLayersComboBox = new JComboBox<String>(nHiddenLayerStrings);
        this.numHiddenLayersComboBox.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        numHiddenLayersLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_numHiddenLayersHotkey").charAt(0));
        numHiddenLayersLabel.setLabelFor(this.numHiddenLayersComboBox);
        this.numHiddenLayersComboBox.setEditable(false);
        JLabel numNodesLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_numNodesHiddenLayer"));
        this.numNodesTextField = new JTextField();
        this.numNodesTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        numNodesLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_numNodesHiddenLayerHotkey").charAt(0));
        numNodesLabel.setLabelFor(this.numNodesTextField);
        this.numNodesTextField.setDocument(new NodeDialog.InputIntegerDoc());
        JLabel learningRateLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_learningRate"));
        this.learningRateTextField = new JTextField();
        this.learningRateTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        learningRateLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_learningRateHotkey").charAt(0));
        learningRateLabel.setLabelFor(this.learningRateTextField);
        this.learningRateTextField.setDocument(new NodeDialog.InputDoubleDoc());
        JLabel momentumLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_momentum"));
        this.momentumTextField = new JTextField();
        this.momentumTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        momentumLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_momentumHotkey").charAt(0));
        momentumLabel.setLabelFor(this.momentumTextField);
        this.momentumTextField.setDocument(new NodeDialog.InputDoubleDoc());
        JLabel weightDecayLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_weightDecay"));
        this.weightDecayTextField = new JTextField();
        this.weightDecayTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        weightDecayLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_weightDecayHotkey").charAt(0));
        weightDecayLabel.setLabelFor(this.weightDecayTextField);
        this.weightDecayTextField.setDocument(new NodeDialog.InputDoubleDoc());
        JLabel validationPercentLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_validationPercent"));
        this.validationPercentTextField = new JTextField();
        this.validationPercentTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        validationPercentLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_validationPercentHotkey").charAt(0));
        validationPercentLabel.setLabelFor(this.validationPercentTextField);
        this.validationPercentTextField.setDocument(new NodeDialog.InputIntegerDoc());
        JPanel optionsPanel1 = new JPanel(new GridBagLayout());
        optionsPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NeuralNetworkDialog_network")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints1 = new GridBagConstraints();
        constraints1.anchor = 18;
        optionsPanel1.add((Component)numHiddenLayersLabel, constraints1);
        constraints1.gridx = 1;
        constraints1.insets = new Insets(0, 20, 0, 0);
        constraints1.weightx = 1.0;
        optionsPanel1.add((Component)this.numHiddenLayersComboBox, constraints1);
        constraints1.gridy = 1;
        constraints1.gridx = 0;
        constraints1.insets = new Insets(0, 0, 0, 0);
        constraints1.weightx = 0.0;
        optionsPanel1.add((Component)numNodesLabel, constraints1);
        constraints1.gridx = 1;
        constraints1.insets = new Insets(0, 20, 0, 0);
        constraints1.weightx = 1.0;
        constraints1.weighty = 1.0;
        optionsPanel1.add((Component)this.numNodesTextField, constraints1);
        JPanel optionsPanel2 = new JPanel(new GridBagLayout());
        optionsPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NeuralNetworkDialog_training")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.anchor = 18;
        constraints2.fill = 2;
        constraints1.insets = new Insets(0, 0, 0, 0);
        optionsPanel2.add((Component)trainingMethodLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.insets = new Insets(0, 75, 0, 0);
        constraints2.weightx = 1.0;
        optionsPanel2.add((Component)this.trainingMethodComboBox, constraints2);
        constraints2.gridy = 1;
        constraints2.gridx = 0;
        constraints2.insets = new Insets(0, 0, 0, 0);
        constraints2.weightx = 0.0;
        optionsPanel2.add((Component)accuracyLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.insets = new Insets(0, 75, 0, 0);
        constraints2.weightx = 1.0;
        optionsPanel2.add((Component)this.accuracyTextField, constraints2);
        constraints2.gridy = 2;
        constraints2.gridx = 0;
        constraints2.insets = new Insets(0, 0, 0, 0);
        constraints2.weightx = 0.0;
        optionsPanel2.add((Component)epochsLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.insets = new Insets(0, 75, 0, 0);
        constraints2.weightx = 1.0;
        optionsPanel2.add((Component)this.epochsTextField, constraints2);
        constraints2.gridy = 3;
        constraints2.gridx = 0;
        constraints2.insets = new Insets(0, 0, 0, 0);
        constraints2.weightx = 0.0;
        optionsPanel2.add((Component)learningRateLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.insets = new Insets(0, 75, 0, 0);
        constraints2.weightx = 1.0;
        optionsPanel2.add((Component)this.learningRateTextField, constraints2);
        constraints2.gridy = 4;
        constraints2.gridx = 0;
        constraints2.insets = new Insets(0, 0, 0, 0);
        constraints2.weightx = 0.0;
        optionsPanel2.add((Component)momentumLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.insets = new Insets(0, 75, 0, 0);
        constraints2.weightx = 1.0;
        optionsPanel2.add((Component)this.momentumTextField, constraints2);
        constraints2.gridy = 5;
        constraints2.gridx = 0;
        constraints2.insets = new Insets(0, 0, 0, 0);
        constraints2.weightx = 0.0;
        optionsPanel2.add((Component)weightDecayLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.insets = new Insets(0, 75, 0, 0);
        constraints2.weightx = 1.0;
        optionsPanel2.add((Component)this.weightDecayTextField, constraints2);
        constraints2.gridy = 6;
        constraints2.gridx = 0;
        constraints2.insets = new Insets(0, 0, 0, 0);
        constraints2.weightx = 0.0;
        constraints2.weighty = 1.0;
        optionsPanel2.add((Component)validationPercentLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.insets = new Insets(0, 75, 0, 0);
        constraints2.weightx = 1.0;
        optionsPanel2.add((Component)this.validationPercentTextField, constraints2);
        JPanel topPanel = new JPanel(new GridLayout(1, 2));
        topPanel.add(this.getInitialWeightsPanel());
        topPanel.add(this.getFinalWeightsPanel());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)topPanel, "North");
        panel.add((Component)optionsPanel2, "Center");
        panel.add((Component)optionsPanel1, "South");
        panel.setName(MinerApp.getText("NeuralNetworkDialog_options"));
        return panel;
    }

    private JPanel getInitialWeightsPanel() {
        JPanel initialWeightsPanel = new JPanel(new GridBagLayout());
        initialWeightsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NeuralNetworkDialog_initialWeights")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup initialWeightsGroup = new ButtonGroup();
        this.initialWeightsButtons = new JRadioButton[3];
        JRadioButton previousWeightsButton = new JRadioButton(this.previousWeightsAction);
        previousWeightsButton.setMnemonic(MinerApp.getText("NeuralNetworkDialog_previousWeightsHotkey").charAt(0));
        this.initialWeightsButtons[0] = previousWeightsButton;
        initialWeightsGroup.add(previousWeightsButton);
        JRadioButton randomWeightsButton = new JRadioButton(this.randomWeightsAction);
        randomWeightsButton.setMnemonic(MinerApp.getText("NeuralNetworkDialog_randomWeightsHotkey").charAt(0));
        this.initialWeightsButtons[1] = randomWeightsButton;
        initialWeightsGroup.add(randomWeightsButton);
        JRadioButton loadInitialWeightFileButton = new JRadioButton(this.loadInitialWeightFileButtonAction);
        initialWeightsGroup.add(loadInitialWeightFileButton);
        loadInitialWeightFileButton.setMnemonic(MinerApp.getText("NeuralNetworkDialog_initialWeightsHotkey").charAt(0));
        this.initialWeightsButtons[2] = loadInitialWeightFileButton;
        initialWeightsGroup.add(loadInitialWeightFileButton);
        this.m_initFile = new JTextField(50);
        this.m_browseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                Frame f = new Frame();
                f.setTitle(MinerApp.getText("NeuralNetworkDialog_useFileWeights"));
                WideFileChooser fc = new WideFileChooser(MinerApp.getSettingsDir());
                fc.setFileFilter(new NeuralNetViewer.XMLFileFilter());
                if (fc.showOpenDialog(f) == 0) {
                    NeuralNetworkDialog.this.m_initFile.setText(fc.getSelectedFile().getPath());
                }
                NeuralNetworkDialog.this.m_initFile.setFocusable(true);
            }
        });
        this.m_browseButton.setMnemonic(66);
        JPanel prevPanel = new JPanel();
        prevPanel.setLayout(new BoxLayout(prevPanel, 0));
        prevPanel.add(previousWeightsButton);
        prevPanel.add(Box.createGlue());
        JPanel randPanel = new JPanel();
        randPanel.setLayout(new BoxLayout(randPanel, 0));
        randPanel.add(randomWeightsButton);
        randPanel.add(Box.createGlue());
        JPanel loadPanel = new JPanel();
        loadPanel.setLayout(new BoxLayout(loadPanel, 0));
        loadPanel.add(loadInitialWeightFileButton);
        loadPanel.add(Box.createGlue());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        initialWeightsPanel.add((Component)prevPanel, constraints);
        constraints.gridy = 1;
        initialWeightsPanel.add((Component)randPanel, constraints);
        constraints.gridy = 2;
        initialWeightsPanel.add((Component)loadPanel, constraints);
        constraints.gridy = 2;
        constraints.gridx = 1;
        initialWeightsPanel.add((Component)this.m_browseButton, constraints);
        constraints.gridy = 3;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(10, 0, 0, 0);
        initialWeightsPanel.add((Component)this.m_initFile, constraints);
        return initialWeightsPanel;
    }

    private JPanel getFinalWeightsPanel() {
        JPanel finalWeightsPanel = new JPanel(new GridBagLayout());
        finalWeightsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NeuralNetworkDialog_final_weights")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup bg = new ButtonGroup();
        this.useBestButton = new JRadioButton(this.useBestWeightsRadioButtonAction);
        bg.add(this.useBestButton);
        this.useBestButton.setMnemonic('e');
        this.useBestButton.setSelected(true);
        this.useLastButton = new JRadioButton(this.useLastWeightsRadioButtonAction);
        bg.add(this.useLastButton);
        this.useLastButton.setMnemonic('s');
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        finalWeightsPanel.add((Component)this.useBestButton, constraints);
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        finalWeightsPanel.add((Component)this.useLastButton, constraints);
        return finalWeightsPanel;
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        this.nnetOptionsPanel = this.createNNetOptionsPanel();
        panels.add(this.nnetOptionsPanel);
        this.predictionPanel = new PredictionPanel();
        panels.add(this.predictionPanel);
        return panels;
    }

    protected JPanel createExecViewerPanel() {
        JPanel globalPanel = new JPanel(new BorderLayout());
        globalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NeuralNetworkDialog_execViewer")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_execViewerCheckbox = new JCheckBox(MinerApp.getText("NeuralNetworkDialog_showExecViewer"));
        globalPanel.add((Component)this.m_execViewerCheckbox, "West");
        this.m_execViewerCheckbox.setEnabled(!MinerApp.isSolarisOS());
        return globalPanel;
    }
}

