/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PartitionEngineNode;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PartitionDialog
extends NodeDialog {
    private JTextField trainTextField;
    private JTextField testTextField;
    private JTextField validateTextField;
    private static PartitionDialog instance = null;

    public static PartitionDialog getInstance() {
        if (instance == null) {
            instance = new PartitionDialog();
        }
        return instance;
    }

    private PartitionDialog() {
        this.pack();
        this.setMinimumSize(new Dimension(400, 400));
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        String train = Integer.toString((int)(props.getDouble(PartitionEngineNode.TRAIN_SIZE_ATTRIBUTE_TAG, 0.7) * 100.0));
        String test = Integer.toString((int)(props.getDouble(PartitionEngineNode.TEST_SIZE_ATTRIBUTE_TAG, 0.3) * 100.0));
        String valid = Integer.toString((int)(props.getDouble(PartitionEngineNode.VALID_SIZE_ATTRIBUTE_TAG, 0.0) * 100.0));
        this.trainTextField.setText(train);
        this.testTextField.setText(test);
        this.validateTextField.setText(valid);
    }

    public void saveProperties() throws NodeDialog.DialogException {
        double test;
        double train;
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        try {
            train = Double.parseDouble(this.trainTextField.getText());
            props.set(PartitionEngineNode.TRAIN_SIZE_ATTRIBUTE_TAG, Double.toString(train / 100.0));
        }
        catch (Exception e) {
            throw new NodeDialog.DialogException("Training percent must be between 0 and 100.");
        }
        try {
            test = Double.parseDouble(this.testTextField.getText());
            props.set(PartitionEngineNode.TEST_SIZE_ATTRIBUTE_TAG, Double.toString(test / 100.0));
        }
        catch (Exception e) {
            throw new NodeDialog.DialogException("Testing percent must be between 0 and 100.");
        }
        if (test + train > 100.0) {
            throw new NodeDialog.DialogException("The total percentage must be equal to 100%.");
        }
        double valid = 100.0 - (test + train);
        props.set(PartitionEngineNode.VALID_SIZE_ATTRIBUTE_TAG, Double.toString(valid / 100.0));
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)this.getPercentagePanel(), "North");
        return optionsPanel;
    }

    private JPanel getPercentagePanel() {
        JPanel percentagesPanel = new JPanel(new GridBagLayout());
        percentagesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("PartitionDialog_percentages")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel trainLabel = new JLabel(MinerApp.getText("PartitionDialog_train"));
        this.trainTextField = new JTextField(11);
        trainLabel.setDisplayedMnemonic(MinerApp.getText("PartitionDialog_trainHotkey").charAt(0));
        trainLabel.setLabelFor(this.trainTextField);
        this.trainTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.trainTextField.getDocument().addDocumentListener(new MyDocumentListener());
        JLabel testLabel = new JLabel(MinerApp.getText("PartitionDialog_test"));
        this.testTextField = new JTextField(11);
        testLabel.setDisplayedMnemonic(MinerApp.getText("PartitionDialog_testHotkey").charAt(0));
        testLabel.setLabelFor(this.testTextField);
        this.testTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.testTextField.getDocument().addDocumentListener(new MyDocumentListener());
        JLabel validateLabel = new JLabel(MinerApp.getText("PartitionDialog_validate"));
        this.validateTextField = new JTextField(11);
        validateLabel.setDisplayedMnemonic(MinerApp.getText("PartitionDialog_validateHotkey").charAt(0));
        validateLabel.setLabelFor(this.validateTextField);
        this.validateTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.validateTextField.setOpaque(false);
        this.validateTextField.setEditable(false);
        this.validateTextField.setBorder(null);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        percentagesPanel.add((Component)trainLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 115, 0, 0);
        percentagesPanel.add((Component)this.trainTextField, constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        percentagesPanel.add((Component)testLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 115, 0, 0);
        percentagesPanel.add((Component)this.testTextField, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        percentagesPanel.add((Component)validateLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 115, 0, 0);
        percentagesPanel.add((Component)this.validateTextField, constraints);
        return percentagesPanel;
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private void update(DocumentEvent e) {
            try {
                int train;
                int test;
                Document doc = e.getDocument();
                if (doc == PartitionDialog.this.testTextField.getDocument()) {
                    test = Integer.parseInt(doc.getText(0, doc.getLength()));
                    String str = PartitionDialog.this.trainTextField.getText();
                    train = str.length() != 0 ? Integer.parseInt(str) : 0;
                } else {
                    train = Integer.parseInt(doc.getText(0, doc.getLength()));
                    String str = PartitionDialog.this.testTextField.getText();
                    test = str.length() != 0 ? Integer.parseInt(str) : 0;
                }
                int valid = 100 - (test + train);
                if (valid > 0) {
                    PartitionDialog.this.validateTextField.setText(Integer.toString(valid));
                } else {
                    PartitionDialog.this.validateTextField.setText("");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

