/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.CorrelationsEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.SelectColumnsPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PrincipalComponentDialog
extends NodeDialog {
    private SelectColumnsPanel selectColumnsPanel;
    private PredictionPanel predictionPanel;
    private JTextField percentVarExplainedTextField;
    private JComboBox weightsComboBox;
    private JCheckBox correlationsCheckBox;
    private static PrincipalComponentDialog instance = null;
    public static final String percentVarExplainedDefault = "90";

    private PrincipalComponentDialog() {
        this.setSize(475, 425);
        this.setMinimumSize(new Dimension(475, 425));
        this.setResizable(true);
    }

    public static PrincipalComponentDialog getInstance() {
        if (instance == null) {
            instance = new PrincipalComponentDialog();
        }
        return instance;
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.selectColumnsPanel.restoreProperties(this.getNodeModel());
        this.predictionPanel.restoreProperties(this.getNodeModel(), 3);
        XTProps props = this.getNodeModel().getXTProps();
        XTMetaData metaData = null;
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        this.weightsComboBox.removeAllItems();
        this.weightsComboBox.addItem("");
        Vector columnNames = metaData.getColumnNames();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            String cName = (String)columnNames.get(i);
            if (!metaData.isContinuousColumn(cName)) continue;
            this.weightsComboBox.addItem(cName);
        }
        String s = props.getValue("weightedColumn", "");
        this.weightsComboBox.setSelectedItem(s);
        s = props.getValue("percentVariationExplained", percentVarExplainedDefault);
        this.percentVarExplainedTextField.setText(s);
        this.correlationsCheckBox.setSelected(props.getBoolean(CorrelationsEngineNode.CORRELATIONS_ATTRIBUTE_TAG, true));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        String s = percentVarExplainedDefault;
        try {
            String test = this.percentVarExplainedTextField.getText();
            int i = Integer.parseInt(test);
            if (i <= 0 || i > 100) {
                String msg = MinerApp.getText("PrincipalComponentsDialog_percentVariationExplained") + " value must be between 0 and 100.";
                throw new NodeDialog.DialogException(msg);
            }
            s = test;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.selectColumnsPanel.saveProperties(this.getNodeModel());
        this.predictionPanel.saveProperties(this.getNodeModel(), 3);
        XTProps props = this.getNodeModel().getXTProps();
        props.set("weightedColumn", (String)this.weightsComboBox.getSelectedItem());
        props.set("percentVariationExplained", s);
        this.percentVarExplainedTextField.setText(s);
        props.set(CorrelationsEngineNode.CORRELATIONS_ATTRIBUTE_TAG, this.correlationsCheckBox.isSelected());
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.selectColumnsPanel = new SelectColumnsPanel(this.okAction, "featureVariables");
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG);
        panel.add((Component)this.selectColumnsPanel, "Center");
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("RegressionDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.percentVarExplainedTextField = new JTextField(10);
        this.percentVarExplainedTextField.setDocument(new NodeDialog.InputIntegerDoc());
        JLabel varExplainedLabel = new JLabel(MinerApp.getText("PrincipalComponentsDialog_percentVariationExplained"));
        varExplainedLabel.setDisplayedMnemonic(MinerApp.getText("PrincipalComponentsDialog_percentVariationExplainedHotkey").charAt(0));
        varExplainedLabel.setLabelFor(this.percentVarExplainedTextField);
        JLabel weightsLabel = new JLabel(MinerApp.getText("RegressionDialog_weights"));
        this.weightsComboBox = new JComboBox();
        weightsLabel.setDisplayedMnemonic('w');
        weightsLabel.setLabelFor(this.weightsComboBox);
        this.weightsComboBox.setPreferredSize(this.percentVarExplainedTextField.getPreferredSize());
        this.correlationsCheckBox = new JCheckBox(MinerApp.getText("PrincipalComponentsDialog_useCorrelations"));
        this.correlationsCheckBox.setMnemonic(MinerApp.getText("PrincipalComponentsDialog_useCorrelationsHotkey").charAt(0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridy = 0;
        constraints.gridx = 0;
        optionsPanel.add((Component)weightsLabel, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 20, 0, 0);
        constraints.weightx = 1.0;
        optionsPanel.add((Component)this.weightsComboBox, constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        optionsPanel.add((Component)varExplainedLabel, constraints);
        constraints.gridy = 1;
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 20, 0, 0);
        constraints.weightx = 1.0;
        optionsPanel.add((Component)this.percentVarExplainedTextField, constraints);
        constraints.gridy = 1;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        optionsPanel.add((Component)this.correlationsCheckBox, constraints);
        panel.add((Component)optionsPanel, "South");
        return panel;
    }

    public Vector createOtherTabs() {
        Vector<PredictionPanel> panels = new Vector<PredictionPanel>();
        this.predictionPanel = new PredictionPanel();
        panels.add(this.predictionPanel);
        return panels;
    }
}

