/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.SetRolesPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RegressionDialog
extends NodeDialog {
    private SetRolesPanel setRolesPanel;
    private PredictionPanel predictionPanel;
    private int optionsTab = 1;
    private JPanel optimizationPanel;
    private JCheckBox includeInterceptCheckBox;
    private JComboBox weightsComboBox;
    private JTextField maxIterationsTextField;
    private JTextField convergenceToleranceTextField;
    private String maxIterationsDefault = "10";
    private String convergenceToleranceDefault = "0.0001";
    private JRadioButton[] positiveResponseButtons;
    private JRadioButton lastCategoryRadioButton;
    private JRadioButton specifiedCategoryRadioButton;
    private JComboBox specifiedCategoryComboBox;
    private String[] positiveResponseStrings = new String[]{"lastCategory", "specifiedCategory"};
    private int regressionType;
    public static final int REGRESSION = 0;
    public static final int LOGISTIC_REGRESSION = 0;
    public static final int LINEAR_REGRESSION = 1;
    private AbstractAction lastCategoryAction;
    private AbstractAction specifiedCategoryAction;
    private static RegressionDialog instance = null;

    public static RegressionDialog getInstance() {
        if (instance == null) {
            instance = new RegressionDialog();
        }
        return instance;
    }

    private RegressionDialog() {
        this.setSize(510, 500);
        this.setMinimumSize(new Dimension(475, 500));
        this.setResizable(true);
    }

    public void show(ActivityNodeModel newModel, int regressionType) {
        if (newModel != null) {
            this.regressionType = regressionType;
            if (regressionType == 1) {
                this.setRolesPanel.changeDependentType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
            } else {
                this.setRolesPanel.changeDependentType(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            }
            this.show(newModel);
            if (regressionType == 1) {
                if (this.tabbedPane.getTabCount() > 3) {
                    this.tabbedPane.removeTabAt(this.optionsTab);
                }
            } else {
                this.tabbedPane.add((Component)this.optimizationPanel, this.optionsTab);
            }
        }
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.setRolesPanel.restoreProperties(this.getNodeModel());
        this.predictionPanel.restoreProperties(this.getNodeModel(), this.regressionType == 0 ? 1 : 0);
        XTProps props = this.getNodeModel().getXTProps();
        XTMetaData metaData = null;
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        this.includeInterceptCheckBox.setSelected(props.getBoolean("includeIntercept", true));
        this.weightsComboBox.removeAllItems();
        this.weightsComboBox.addItem("");
        Vector columnNames = metaData.getColumnNames();
        int cnSize = columnNames.size();
        for (int i = 0; i < cnSize; ++i) {
            String cName = (String)columnNames.get(i);
            if (!metaData.isContinuousColumn(cName)) continue;
            this.weightsComboBox.addItem(cName);
        }
        String weight = props.getValue("weightedColumn", "");
        this.weightsComboBox.setSelectedItem(weight);
        if (this.regressionType == 0) {
            this.maxIterationsTextField.setText(props.getValue("maxIterations", this.maxIterationsDefault));
            this.convergenceToleranceTextField.setText(props.getValue("convergenceTolerance", this.convergenceToleranceDefault));
            String positiveResponseString = props.getValue("probabilityFor", "forLastCategory");
            for (int i = 0; i < this.positiveResponseStrings.length; ++i) {
                if (!this.positiveResponseStrings[i].equals(positiveResponseString)) continue;
                this.positiveResponseButtons[i].setSelected(true);
                this.positiveResponseButtons[i].doClick();
                break;
            }
            String dependentString = null;
            Vector propNames = props.getSubProperties("columnRoles");
            Vector propRoles = props.getSubPropertyValues("columnRoles");
            for (int i = 0; i < propRoles.size(); ++i) {
                if (!((String)propRoles.get(i)).equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
                dependentString = (String)propNames.get(i);
            }
            this.dependentChanged(dependentString, metaData);
            int length = this.specifiedCategoryComboBox.getItemCount();
            if (this.positiveResponseButtons[0].isSelected()) {
                if (length > 0) {
                    this.specifiedCategoryComboBox.setSelectedIndex(length - 1);
                }
                this.specifiedCategoryComboBox.disable();
            } else {
                int i;
                String specifiedCategoryString = props.getValue("specifiedCategory", "");
                boolean addNewEntry = true;
                for (i = 0; i < length; ++i) {
                    if (!specifiedCategoryString.equals(this.specifiedCategoryComboBox.getItemAt(i))) continue;
                    this.specifiedCategoryComboBox.setSelectedIndex(i);
                    addNewEntry = false;
                    break;
                }
                if (addNewEntry) {
                    this.specifiedCategoryComboBox.addItem(specifiedCategoryString);
                    for (i = 0; i < length + 1; ++i) {
                        if (!specifiedCategoryString.equals(this.specifiedCategoryComboBox.getItemAt(i))) continue;
                        this.specifiedCategoryComboBox.setSelectedIndex(i);
                        break;
                    }
                }
            }
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        this.setRolesPanel.saveProperties(this.getNodeModel());
        this.predictionPanel.saveProperties(this.getNodeModel(), this.regressionType == 0 ? 1 : 0);
        XTProps props = this.getNodeModel().getXTProps();
        props.set("includeIntercept", this.includeInterceptCheckBox.isSelected());
        props.set("weightedColumn", (String)this.weightsComboBox.getSelectedItem());
        if (this.regressionType == 0) {
            props.set("maxIterations", this.maxIterationsTextField.getText());
            props.set("convergenceTolerance", this.convergenceToleranceTextField.getText());
            String positiveResponseString = "";
            for (int i = 0; i < this.positiveResponseButtons.length; ++i) {
                if (!this.positiveResponseButtons[i].isSelected()) continue;
                positiveResponseString = this.positiveResponseStrings[i];
                break;
            }
            props.set("probabilityFor", positiveResponseString);
            props.set("specifiedCategory", (String)this.specifiedCategoryComboBox.getSelectedItem());
        }
    }

    private void dependentChanged(String newDependent) {
        this.dependentChanged(newDependent, null);
    }

    private void dependentChanged(String newDependent, XTMetaData md) {
        XTMetaData metaData = md;
        if (metaData == null) {
            try {
                metaData = this.getNodeModel().getInputMetaData(0);
            }
            catch (Exception e) {
                AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
                e.printStackTrace();
                e.printStackTrace();
                return;
            }
        }
        Vector levels = new Vector();
        this.specifiedCategoryComboBox.removeAllItems();
        if (newDependent != null) {
            levels = metaData.getCategoricalDataFieldLevels(newDependent);
        } else {
            Vector dependents = metaData.getDataFieldsWithRole(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
            if (!dependents.isEmpty()) {
                levels = metaData.getCategoricalDataFieldLevels((String)dependents.get(0));
            }
        }
        if (levels.isEmpty()) {
            this.specifiedCategoryComboBox.addItem("");
        } else {
            for (int i = 0; i < levels.size(); ++i) {
                this.specifiedCategoryComboBox.addItem((String)levels.get(i));
            }
        }
    }

    public void createActions() {
        super.createActions();
        this.lastCategoryAction = new AbstractAction(MinerApp.getText("RegressionDialog_forLastCategory")){

            public void actionPerformed(ActionEvent e) {
                RegressionDialog.this.specifiedCategoryComboBox.setEnabled(false);
            }
        };
        this.specifiedCategoryAction = new AbstractAction(MinerApp.getText("RegressionDialog_forSpecifiedCategory")){

            public void actionPerformed(ActionEvent e) {
                RegressionDialog.this.specifiedCategoryComboBox.setEnabled(true);
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.setRolesPanel = new SetRolesPanel(this.okAction);
        this.setRolesPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        this.setRolesPanel.addPropertyChangeListener("dependentChange", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (RegressionDialog.this.regressionType == 0) {
                    RegressionDialog.this.predictionPanel.dependentChanged((String)e.getNewValue());
                    RegressionDialog.this.dependentChanged((String)e.getNewValue());
                }
            }
        });
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("RegressionDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.includeInterceptCheckBox = new JCheckBox(MinerApp.getText("RegressionDialog_includeIntercept"));
        this.includeInterceptCheckBox.setMnemonic('n');
        JLabel contrastTypeLabel = new JLabel(MinerApp.getText("RegressionDialog_weights"));
        this.weightsComboBox = new JComboBox();
        contrastTypeLabel.setDisplayedMnemonic('w');
        contrastTypeLabel.setLabelFor(this.weightsComboBox);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        optionsPanel.add((Component)this.includeInterceptCheckBox, constraints);
        constraints.gridx = 2;
        optionsPanel.add((Component)contrastTypeLabel, constraints);
        constraints.fill = 1;
        constraints.insets = new Insets(0, 72, 0, 0);
        constraints.anchor = 12;
        constraints.gridwidth = 2;
        optionsPanel.add((Component)this.weightsComboBox, constraints);
        this.optimizationPanel = this.createOptimizationPanel();
        panel.add((Component)this.setRolesPanel, "Center");
        panel.add((Component)optionsPanel, "South");
        return panel;
    }

    protected JPanel createOptimizationPanel() {
        this.optimizationPanel = new JPanel(new GridBagLayout());
        this.optimizationPanel.setName(MinerApp.getText("RegressionDialog_options"));
        this.optimizationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("RegressionDialog_fittingOptions")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel maxIterationsLabel = new JLabel(MinerApp.getText("RegressionDialog_maximumIterations"));
        this.maxIterationsTextField = new JTextField(10);
        this.maxIterationsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        maxIterationsLabel.setDisplayedMnemonic('m');
        maxIterationsLabel.setLabelFor(this.maxIterationsTextField);
        JLabel convergenceToleranceLabel = new JLabel(MinerApp.getText("RegressionDialog_convergenceTolerance"));
        this.convergenceToleranceTextField = new JTextField(10);
        this.convergenceToleranceTextField.setDocument(new NodeDialog.InputDoubleDoc());
        convergenceToleranceLabel.setDisplayedMnemonic('t');
        convergenceToleranceLabel.setLabelFor(this.convergenceToleranceTextField);
        JLabel positiveResponseLabel = new JLabel(MinerApp.getText("RegressionDialog_positiveResponseIs"));
        ButtonGroup positiveResponseGroup = new ButtonGroup();
        this.positiveResponseButtons = new JRadioButton[2];
        this.lastCategoryRadioButton = new JRadioButton(this.lastCategoryAction);
        this.lastCategoryRadioButton.setMnemonic('f');
        this.lastCategoryRadioButton.setSelected(true);
        positiveResponseGroup.add(this.lastCategoryRadioButton);
        this.positiveResponseButtons[0] = this.lastCategoryRadioButton;
        this.specifiedCategoryRadioButton = new JRadioButton(this.specifiedCategoryAction);
        this.specifiedCategoryRadioButton.setMnemonic('p');
        positiveResponseGroup.add(this.specifiedCategoryRadioButton);
        this.positiveResponseButtons[1] = this.specifiedCategoryRadioButton;
        this.specifiedCategoryComboBox = new JComboBox();
        this.specifiedCategoryComboBox.setPreferredSize(this.convergenceToleranceTextField.getPreferredSize());
        this.specifiedCategoryComboBox.setEditable(true);
        this.specifiedCategoryComboBox.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        this.optimizationPanel.add((Component)maxIterationsLabel, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.weightx = 1.0;
        this.optimizationPanel.add((Component)this.maxIterationsTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 0.0;
        this.optimizationPanel.add((Component)convergenceToleranceLabel, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.weightx = 1.0;
        this.optimizationPanel.add((Component)this.convergenceToleranceTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 0.0;
        this.optimizationPanel.add((Component)positiveResponseLabel, constraints);
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 15, 0, 0);
        this.optimizationPanel.add((Component)this.lastCategoryRadioButton, constraints);
        constraints.gridy = 4;
        this.optimizationPanel.add((Component)this.specifiedCategoryRadioButton, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.optimizationPanel.add((Component)this.specifiedCategoryComboBox, constraints);
        return this.optimizationPanel;
    }

    public Vector createOtherTabs() {
        Vector<PredictionPanel> panels = new Vector<PredictionPanel>();
        this.predictionPanel = new PredictionPanel();
        panels.add(this.predictionPanel);
        return panels;
    }
}

