/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;

public class RepEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    private XTMetaData m_md = null;
    private long m_lengthOut = -1L;
    private long m_inputRowCount = -1L;
    private long m_outputRowCount = -1L;
    private long m_numEach = 0L;
    private long m_innerChunkPosition = 0L;
    public static String LENGTH_OUT_ATTRIBUTE_TAG = "length.out";
    public static String EACH_ATTRIBUTE_TAG = "each";
    private boolean m_useDoubleVec;
    private boolean m_useDateTimeVec;
    private double[] m_inDoubleVec;
    private double[] m_outDoubleVec;
    private long[] m_inDateTimeVec;
    private long[] m_outDateTimeVec;
    private String[] m_inStringVec;
    private String[] m_outStringVec;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        this.m_md = this.getInputMetaData(0);
        this.m_inputRowCount = this.m_md.getNumRows();
        XTProps props = this.getNodeProperties();
        this.m_outputRowCount = this.m_lengthOut = Long.parseLong(props.getValue(LENGTH_OUT_ATTRIBUTE_TAG, "-1"));
        this.m_innerChunkPosition = 0L;
        this.m_numEach = this.getInputMetaData(1).getNumRows();
    }

    public void execute(CNKProcJavaTransform proc) {
        if (this.m_lengthOut == -1L) {
            this.executeEach(proc);
        } else {
            this.executeLength(proc);
        }
    }

    public void executeLength(CNKProcJavaTransform proc) {
        boolean useCopyData;
        if (this.m_outputRowCount <= 0L) {
            proc.setChunkDone(true);
            return;
        }
        int iRowBlock = proc.getChunkInputRows(0);
        int oRowBlock = proc.getChunkOutputRows(0);
        long iPos = proc.getChunkInputPosition(0);
        long oPos = proc.getChunkOutputPosition(0);
        int actualRowsToCopy = (int)Math.min((long)iRowBlock, this.m_outputRowCount - oPos);
        int maxOutput = (int)Math.min((long)oRowBlock, this.m_outputRowCount);
        if ((long)iRowBlock < this.m_inputRowCount) {
            maxOutput = Math.min(maxOutput, iRowBlock);
        }
        boolean bl = useCopyData = (double)actualRowsToCopy > (double)maxOutput * 0.2;
        if (!useCopyData) {
            this.initIOVectors(proc);
        }
        int oChunkPos = 0;
        while (oChunkPos + actualRowsToCopy <= maxOutput) {
            if (useCopyData) {
                proc.copyData(0, 0, oChunkPos, 0, 0, 0, actualRowsToCopy, 1);
            } else {
                this.copyIOVectorData(oChunkPos, 0, actualRowsToCopy);
            }
            if ((long)(oChunkPos += actualRowsToCopy) + oPos < this.m_outputRowCount) continue;
        }
        this.clearIOVectors();
        long inPosition = iPos + (long)actualRowsToCopy;
        long outPosition = oPos + (long)oChunkPos;
        if (outPosition == this.m_outputRowCount) {
            proc.setChunkOutputReleaseRows(0, oChunkPos);
            proc.setChunkDone(true);
            return;
        }
        if (inPosition == this.m_inputRowCount) {
            proc.setChunkNextInputPosition(0, 0L);
        }
        proc.setChunkOutputReleaseRows(0, oChunkPos);
    }

    public void executeEach(CNKProcJavaTransform proc) {
        boolean incrementEach = this.m_numEach > 1L;
        int iRowBlock = proc.getChunkInputRows(0);
        int oRowBlock = proc.getChunkOutputRows(0);
        int outputRow = 0;
        int inputRow = 0;
        outputRow = 0;
        inputRow = 0;
        this.initIOVectors(proc);
        double[] chunkEachNums = proc.getChunkInputColumnDoubles(1, 0);
        for (int row = 0; outputRow < oRowBlock && row < iRowBlock; ++row) {
            long each;
            long numToOutput;
            long l = numToOutput = incrementEach ? (long)chunkEachNums[row] : (long)chunkEachNums[0];
            for (each = this.m_innerChunkPosition; outputRow < oRowBlock && each < numToOutput; ++each) {
                this.copyIOVectorData(outputRow++, row, 1);
            }
            if (each == numToOutput) {
                this.m_innerChunkPosition = 0L;
                ++inputRow;
                continue;
            }
            this.m_innerChunkPosition = each;
        }
        this.clearIOVectors();
        long inputPos = proc.getChunkInputPosition(0);
        if (inputPos + (long)inputRow == this.m_inputRowCount) {
            proc.setChunkDone(true);
        } else {
            proc.setChunkInputReleaseRows(0, inputRow);
            if (incrementEach) {
                proc.setChunkInputReleaseRows(1, inputRow);
            } else {
                proc.setChunkNextInputPosition(1, 0L);
            }
        }
        proc.setChunkOutputReleaseRows(0, outputRow);
    }

    private void initIOVectors(CNKProcJavaTransform proc) {
        this.m_useDoubleVec = this.m_md.isContinuousColumn(0);
        this.m_useDateTimeVec = this.m_md.isDateTimeColumn(0);
        if (this.m_useDoubleVec) {
            this.m_inDoubleVec = proc.getChunkInputColumnDoubles(0, 0);
            this.m_outDoubleVec = proc.getChunkOutputColumnDoubles(0, 0);
        } else if (this.m_useDateTimeVec) {
            this.m_inDateTimeVec = proc.getChunkInputColumnDateTimes(0, 0);
            this.m_outDateTimeVec = proc.getChunkOutputColumnDateTimes(0, 0);
        } else {
            this.m_inStringVec = proc.getChunkInputColumnStrings(0, 0);
            this.m_outStringVec = proc.getChunkOutputColumnStrings(0, 0);
        }
    }

    private void copyIOVectorData(int outputFirstRow, int inputFirstRow, int numRows) {
        if (numRows < 10) {
            if (this.m_useDoubleVec) {
                for (int i = 0; i < numRows; ++i) {
                    this.m_outDoubleVec[outputFirstRow + i] = this.m_inDoubleVec[inputFirstRow + i];
                }
            } else if (this.m_useDateTimeVec) {
                for (int i = 0; i < numRows; ++i) {
                    this.m_outDateTimeVec[outputFirstRow + i] = this.m_inDateTimeVec[inputFirstRow + i];
                }
            } else {
                for (int i = 0; i < numRows; ++i) {
                    this.m_outStringVec[outputFirstRow + i] = this.m_inStringVec[inputFirstRow + i];
                }
            }
        } else if (this.m_useDoubleVec) {
            System.arraycopy(this.m_inDoubleVec, inputFirstRow, this.m_outDoubleVec, outputFirstRow, numRows);
        } else if (this.m_useDateTimeVec) {
            System.arraycopy(this.m_inDateTimeVec, inputFirstRow, this.m_outDateTimeVec, outputFirstRow, numRows);
        } else {
            System.arraycopy(this.m_inStringVec, inputFirstRow, this.m_outStringVec, outputFirstRow, numRows);
        }
    }

    private void clearIOVectors() {
        this.m_inDoubleVec = null;
        this.m_outDoubleVec = null;
        this.m_inDateTimeVec = null;
        this.m_outDateTimeVec = null;
        this.m_inStringVec = null;
        this.m_outStringVec = null;
    }
}

