/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerRandom;
import com.insightful.miner.XTMetaData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Vector;

public class SortAndShuffle {
    private int m_tempFileCount;
    private DataCacheRowBuf m_topRowFilteredBuf;
    private DataCacheRowBuf m_bottomFilteredRowBuf;
    private DataCacheRowBuf m_tempFilteredRowBuf;
    private int m_numOverallComparisons = 1;
    private XTMetaData m_outputMD = null;
    private int[] m_in2out = null;
    private int m_percentForSort = 20;
    private byte[] m_chunkData = null;
    private int[] m_sortOrder = null;
    private int[] m_tempOrder = null;
    private static boolean m_useOldAlgorithm = false;
    private static int m_mergeNway = 4;
    EngineNode m_engineNode;
    private DataCacheRowBuf m_topRowBuf;
    private DataCacheRowBuf m_bottomRowBuf;
    private long m_totalRowCount;
    private int m_totalColCount;
    private int m_rowChunkSize;
    private int m_bytesPerRow;
    private long m_inputFileChunks;
    private boolean m_sort;
    private boolean m_absVal = false;
    private boolean m_keepRowsIntact = false;
    private XTMetaData m_inputMD = null;
    private boolean m_alphabetical = false;
    private int[] m_sortColumns = null;
    private String[][] m_sortColumnsLevels = null;
    private boolean[] m_sortAscending = null;
    private boolean[] m_sortNAatTop = null;
    private long m_randomSeed = 1L;
    private MinerRandom m_random = null;
    private DataInputStream m_dataInputStream = null;
    private LinkedList m_tempFiles = null;
    private SortFile m_inputFile = null;
    private SortFile m_outputFile = null;
    private SortFile m_tempDir = null;
    private double m_percentDone = 0.0;
    private double m_percentPerRow = 0.0;
    private int m_quickInterruptCounter = 0;
    private int m_quickInterruptCounterInit = 1000;
    private static long m_reportBegin;
    private static long m_reportEndInMemory;
    private static long m_reportEnd;
    private static long m_numComparisonsInMemory;
    private static long m_numComparisons;
    private static long m_numFilesWritten;
    private static long m_numFilesRead;
    private static long m_numBytesRead;

    public static void setUseOldAlgorithm(boolean val) {
        m_useOldAlgorithm = val;
    }

    public static boolean getUseOldAlgorithm() {
        return m_useOldAlgorithm;
    }

    public static void setMergeNway(int val) {
        m_mergeNway = val;
    }

    public static int getMergeNway() {
        return m_mergeNway;
    }

    private SortAndShuffle() {
    }

    public static boolean sort(File unsortedFile, File sortedFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean keepRowsIntact) throws Exception {
        return SortAndShuffle.sort(new SortFile(unsortedFile), new SortFile(sortedFile), metaData, engineNode, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, keepRowsIntact);
    }

    public static boolean sortBase(File unsortedFile, File sortedFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean keepRowsIntact, boolean absoluteVals) throws Exception {
        return SortAndShuffle.sortBase(new SortFile(unsortedFile), new SortFile(sortedFile), metaData, engineNode, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, keepRowsIntact, absoluteVals);
    }

    public static boolean columnSort(File unsortedFile, File sortedFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean useAbsoluteValue) throws Exception {
        return SortAndShuffle.columnSort(new SortFile(unsortedFile), new SortFile(sortedFile), metaData, engineNode, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, useAbsoluteValue);
    }

    public static boolean shuffle(File unshuffledFile, File shuffledFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize) throws Exception {
        return SortAndShuffle.shuffle(unshuffledFile, shuffledFile, metaData, engineNode, rowChunkSize, System.currentTimeMillis());
    }

    public static boolean shuffle(File unshuffledFile, File shuffledFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, long randomSeed) throws Exception {
        return SortAndShuffle.shuffle(new SortFile(unshuffledFile), new SortFile(shuffledFile), metaData, engineNode, rowChunkSize, randomSeed);
    }

    private static boolean shuffle(SortFile unshuffledFile, SortFile shuffledFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, long randomSeed) throws Exception {
        String origText = SortAndShuffle.addStatusText(engineNode, ": Shuffling Rows...");
        boolean ok = SortAndShuffle.sortBase(unshuffledFile, shuffledFile, metaData, engineNode, rowChunkSize, new String[0], false, randomSeed, null, null, false, true, false);
        SortAndShuffle.setStatusText(engineNode, origText);
        return ok;
    }

    private static boolean sort(SortFile unsortedFile, SortFile sortedFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean keepRowsIntact) throws Exception {
        String origText = SortAndShuffle.addStatusText(engineNode, ": Sorting Rows...");
        boolean success = SortAndShuffle.sortBase(unsortedFile, sortedFile, metaData, engineNode, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, keepRowsIntact, false);
        SortAndShuffle.setStatusText(engineNode, origText);
        return success;
    }

    private static boolean columnSort(SortFile unsortedFile, SortFile sortedFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean useAbsoluteValue) throws Exception {
        String origText = SortAndShuffle.addStatusText(engineNode, ": Sorting Rows...");
        boolean success = SortAndShuffle.sortBase(unsortedFile, sortedFile, metaData, engineNode, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, false, useAbsoluteValue);
        SortAndShuffle.setStatusText(engineNode, origText);
        return success;
    }

    private static boolean sortBase(SortFile unsortedFile, SortFile sortedFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean keepRowsIntact, boolean absoluteVals) throws Exception {
        return SortAndShuffle.sortBase(unsortedFile, sortedFile, metaData, engineNode, rowChunkSize, sortColumnOrder, true, 0L, sortAscending, sortNAatTop, alphabetical, keepRowsIntact, absoluteVals);
    }

    private static boolean sortBase(SortFile unsortedFile, SortFile sortedFile, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, String[] sortColumnOrder, boolean doSort, long randomSeed, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean keepRowsIntact, boolean absoluteVals) throws Exception {
        SortAndShuffle.initReport();
        ++EngineNetworkManager.m_statSorts;
        if (doSort) {
            if (sortColumnOrder == null) {
                throw new Exception("sortBase: null sortColumnOrder argument");
            }
            if (sortAscending == null || sortAscending.length != sortColumnOrder.length) {
                throw new Exception("sortBase: bad sortAscending argument");
            }
            if (sortNAatTop == null || sortNAatTop.length != sortColumnOrder.length) {
                throw new Exception("sortBase: bad sortNAatTop argument");
            }
        }
        if (metaData.getNumRows() == 0L) {
            sortedFile.getDataOutputStream();
            sortedFile.close();
            SortAndShuffle.endReport();
            return true;
        }
        SortAndShuffle sAs = new SortAndShuffle();
        sAs.m_inputMD = metaData;
        sAs.m_topRowBuf = new DataCacheRowBuf(metaData, false);
        sAs.m_bottomRowBuf = sAs.m_topRowBuf.copy(false);
        sAs.m_bytesPerRow = sAs.m_topRowBuf.getBytesPerRow();
        sAs.m_totalRowCount = metaData.getNumRows();
        sAs.m_totalColCount = metaData.getNumColumns();
        sAs.m_sort = doSort;
        sAs.m_randomSeed = randomSeed;
        MinerRandom minerRandom = sAs.m_random = doSort ? null : new MinerRandom(randomSeed);
        if (engineNode != null) {
            rowChunkSize = engineNode.getNetworkManager().limitRowsPerChunk(engineNode.getNodeID(), sAs.m_bytesPerRow);
        }
        sAs.m_rowChunkSize = rowChunkSize;
        sAs.m_engineNode = engineNode;
        sAs.m_keepRowsIntact = keepRowsIntact;
        sAs.m_absVal = absoluteVals;
        sAs.m_sortAscending = sortAscending;
        sAs.m_sortNAatTop = sortNAatTop;
        sAs.m_alphabetical = alphabetical;
        sAs.m_inputFile = unsortedFile;
        sAs.m_outputFile = sortedFile;
        sAs.m_tempDir = sortedFile;
        if (sAs.m_alphabetical) {
            sAs.m_sortColumnsLevels = new String[sortColumnOrder.length][];
        }
        sAs.m_sortColumns = new int[sortColumnOrder.length];
        Vector levels = null;
        for (int i = 0; i < sAs.m_sortColumns.length; ++i) {
            sAs.m_sortColumns[i] = metaData.nameToOrdinal(sortColumnOrder[i]);
            if (!sAs.m_alphabetical || !metaData.getColumnType(sAs.m_sortColumns[i]).equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
            levels = metaData.getCategoricalDataFieldLevels(sortColumnOrder[i]);
            sAs.m_sortColumnsLevels[i] = new String[levels.size()];
            for (int j = 0; j < sAs.m_sortColumnsLevels[i].length; ++j) {
                sAs.m_sortColumnsLevels[i][j] = (String)levels.get(j);
            }
        }
        sAs.m_inputFileChunks = (int)(sAs.m_totalRowCount / (long)rowChunkSize);
        if ((long)sAs.m_rowChunkSize * sAs.m_inputFileChunks != sAs.m_totalRowCount) {
            ++sAs.m_inputFileChunks;
        }
        boolean ok = false;
        if (m_useOldAlgorithm || !keepRowsIntact) {
            sAs.m_dataInputStream = unsortedFile.getDataInputStream();
            int n = sAs.m_numOverallComparisons = keepRowsIntact ? 1 : sortColumnOrder.length;
            if (keepRowsIntact) {
                sAs.m_outputMD = (XTMetaData)metaData.clone();
            } else {
                int i;
                Vector<String> selCols = new Vector<String>(sortColumnOrder.length);
                for (i = 0; i < sortColumnOrder.length; ++i) {
                    selCols.add(sortColumnOrder[i]);
                }
                sAs.m_outputMD = metaData.selectiveClone(selCols);
                sAs.m_topRowFilteredBuf = new DataCacheRowBuf(sAs.m_outputMD);
                sAs.m_bottomFilteredRowBuf = new DataCacheRowBuf(sAs.m_outputMD);
                sAs.m_tempFilteredRowBuf = new DataCacheRowBuf(sAs.m_outputMD);
                sAs.m_in2out = new int[metaData.getNumColumns()];
                for (i = 0; i < sAs.m_in2out.length; ++i) {
                    sAs.m_in2out[i] = sAs.m_outputMD.nameToOrdinal(metaData.ordinalToName(i));
                }
            }
            sAs.m_tempFileCount = (int)(sAs.m_totalRowCount / (long)rowChunkSize);
            if ((long)(sAs.m_rowChunkSize * sAs.m_tempFileCount) != sAs.m_totalRowCount) {
                ++sAs.m_tempFileCount;
            }
            sAs.m_tempFiles = new LinkedList();
            ok = sAs.mergeSortOld();
            SortAndShuffle.endReport();
            return ok;
        }
        if (!sAs.m_keepRowsIntact) {
            throw new Exception("sAs.columnMergeSort() -- not implemented yet");
        }
        ok = sAs.mergeSort();
        SortAndShuffle.endReport();
        return ok;
    }

    private boolean mergeSort() throws Exception {
        long inputFileChunks = this.m_totalRowCount / (long)this.m_rowChunkSize;
        long extraChunkSize = this.m_totalRowCount % (long)this.m_rowChunkSize;
        MultiFile in = new MultiFile(this.m_inputFile, inputFileChunks, this.m_rowChunkSize, extraChunkSize);
        MergeFileSet out = this.getTempOutputFiles(new MergeFileSet(in));
        double numIterations = 1.0 + Math.log(inputFileChunks + 1L) / Math.log(m_mergeNway);
        double totalRowIO = 2.0 * (double)this.m_totalRowCount * (1.0 + numIterations);
        this.m_percentPerRow = 100.0 / totalRowIO;
        this.m_percentDone = 0.0;
        boolean ok = true;
        try {
            ok = this.inMemorySortSplit(out, in);
        }
        catch (Exception ex) {
            out.delete();
            throw ex;
        }
        if (!ok) {
            out.delete();
            return false;
        }
        m_reportEndInMemory = System.currentTimeMillis();
        m_numComparisonsInMemory = m_numComparisons;
        while (out.getMaxSubfiles() > 1L) {
            MergeFileSet nextOut = this.getTempOutputFiles(out);
            try {
                ok = this.mergeSort(nextOut, out);
            }
            catch (Exception ex) {
                nextOut.delete();
                out.delete();
                throw ex;
            }
            if (!ok) {
                nextOut.delete();
                out.delete();
                return false;
            }
            out.delete();
            out = nextOut;
        }
        MergeFileSet finalOut = new MergeFileSet(new MultiFile(this.m_outputFile, 1L, this.m_totalRowCount, 0L));
        try {
            ok = this.mergeSort(finalOut, out);
        }
        catch (Exception ex) {
            finalOut.delete();
            out.delete();
            throw ex;
        }
        out.delete();
        if (!ok) {
            finalOut.delete();
        }
        return ok;
    }

    private boolean inMemorySortSplit(MergeFileSet out, MultiFile in) throws Exception {
        boolean ok = true;
        int chunkSize = this.m_rowChunkSize;
        if ((long)chunkSize > this.m_totalRowCount) {
            chunkSize = (int)this.m_totalRowCount;
        }
        int[] sortOrder = new int[chunkSize];
        int[] tempOrder = new int[chunkSize];
        byte[] chunkData = new byte[chunkSize * this.m_bytesPerRow];
        in.openForRead();
        out.openForWrite();
        while (!in.readEOF()) {
            int numRows = in.readNextChunk(chunkData, chunkSize);
            in.closeSubfileRead();
            ok = this.sortInMemory(chunkData, sortOrder, tempOrder, numRows);
            if (!ok) break;
            for (int i = 0; i < numRows; ++i) {
                int index = sortOrder[i];
                this.m_topRowBuf.setData(chunkData, index);
                out.writeBuf(this.m_topRowBuf);
                if (!this.quickInterruptCheck()) continue;
                ok = false;
                break;
            }
            if (!ok) break;
            out.closeSubfileWrite();
            this.m_percentDone += (double)(2 * numRows) * this.m_percentPerRow;
            if (!this.isNodeProgressInterrupted(this.m_engineNode, (int)this.m_percentDone)) continue;
            ok = false;
            break;
        }
        in.close();
        out.close();
        if (!ok) {
            out.delete();
        }
        return ok;
    }

    private boolean sortInMemory(byte[] chunkData, int[] sortOrder, int[] tempOrder, int numRows) {
        int byteOffset = 0;
        for (int i = 0; i < numRows; ++i) {
            sortOrder[i] = byteOffset;
            byteOffset += this.m_bytesPerRow;
        }
        if (this.m_sort) {
            this.inMemoryNonRecursiveMergeSort(chunkData, sortOrder, tempOrder, 0, numRows - 1);
        } else {
            this.inMemoryShuffle(chunkData, sortOrder, 0, numRows - 1);
        }
        return !this.isNodeInterruptRequested(this.m_engineNode);
    }

    private boolean mergeSort(MergeFileSet out, MergeFileSet in) throws Exception {
        in.openForRead();
        out.openForWrite();
        while (!in.readEOF()) {
            in.openForReadMerge();
            if (!this.mergeSortOneLayer(out, in)) {
                in.close();
                out.close();
                return false;
            }
            in.closeSubfileReadMerge();
            out.closeSubfileWrite();
        }
        in.close();
        out.close();
        return true;
    }

    private boolean mergeSortOneLayer(MergeFileSet out, MergeFileSet in) throws Exception {
        DataCacheRowBuf buf;
        int rowCnt = 0;
        rowCnt = 0;
        while ((buf = in.getTopReadMergeBuf()) != null) {
            out.writeBuf(buf);
            in.flushTopReadMergeBuf();
            if (this.quickInterruptCheck()) {
                return false;
            }
            if (rowCnt > this.m_rowChunkSize) {
                this.m_percentDone += (double)(2 * rowCnt) * this.m_percentPerRow;
                rowCnt = 0;
                if (this.isNodeProgressInterrupted(this.m_engineNode, (int)this.m_percentDone)) {
                    return false;
                }
            }
            ++rowCnt;
        }
        this.m_percentDone += (double)(2 * rowCnt) * this.m_percentPerRow;
        return !this.isNodeProgressInterrupted(this.m_engineNode, (int)this.m_percentDone);
    }

    MergeFileSet getTempOutputFiles(MergeFileSet in) throws IOException {
        long inputLayers = in.getMaxSubfiles();
        long outputLayers = inputLayers / (long)m_mergeNway;
        int numWithExtraLayer = (int)(inputLayers % (long)m_mergeNway);
        int numOutputFiles = outputLayers == 0L ? numWithExtraLayer : m_mergeNway;
        MultiFile[] outMultiFiles = new MultiFile[numOutputFiles];
        for (int i = 0; i < numOutputFiles; ++i) {
            boolean hasExtraLayer = outputLayers < 1L ? true : numOutputFiles - (i + 1) < numWithExtraLayer;
            outMultiFiles[i] = new MultiFile(this.m_tempDir.createTempFile("sort", "tmp"), hasExtraLayer ? outputLayers + 1L : outputLayers);
        }
        return new MergeFileSet(outMultiFiles);
    }

    private boolean mergeSortOld() throws Exception {
        for (int i = 0; i < this.m_tempFileCount; ++i) {
            this.chunkMergeSort(i);
            int tempPercentDone = (int)((double)this.m_percentForSort * ((double)i / (double)this.m_tempFileCount));
            if (this.m_engineNode.updateProgressIndicator(tempPercentDone)) continue;
            return false;
        }
        this.m_sortOrder = null;
        this.m_tempOrder = null;
        this.m_chunkData = null;
        m_reportEndInMemory = System.currentTimeMillis();
        m_numComparisonsInMemory = m_numComparisons;
        return this.mergeChunks();
    }

    private void chunkMergeSort(int chunkNum) throws IOException {
        int chunksize = chunkNum == this.m_tempFileCount - 1 ? (int)((this.m_totalRowCount - (long)(this.m_rowChunkSize * chunkNum)) * (long)this.m_bytesPerRow) : this.m_rowChunkSize * this.m_bytesPerRow;
        int totalLength = chunksize / this.m_bytesPerRow;
        if (this.m_chunkData == null || this.m_chunkData.length != chunksize) {
            this.m_chunkData = new byte[chunksize];
            this.m_sortOrder = new int[totalLength];
            this.m_tempOrder = new int[totalLength];
        }
        int i = 0;
        int val = 0;
        while (i < totalLength) {
            this.m_sortOrder[i] = val;
            ++i;
            val += this.m_bytesPerRow;
        }
        this.m_dataInputStream.readFully(this.m_chunkData, 0, chunksize);
        if (chunkNum == this.m_tempFileCount - 1) {
            this.m_dataInputStream.close();
        }
        if (this.m_sort) {
            this.inMemoryNonRecursiveMergeSort(this.m_chunkData, this.m_sortOrder, this.m_tempOrder, 0, totalLength - 1);
        } else {
            this.inMemoryShuffle(this.m_chunkData, this.m_sortOrder, 0, totalLength - 1);
        }
        SortFile tempFile = this.m_tempDir.createTempFile("sort", "tmp");
        if (this.m_tempFileCount > 1) {
            tempFile.deleteOnExit();
        }
        this.m_tempFiles.add(tempFile);
        DataOutputStream out = tempFile.getDataOutputStream();
        this.writeSortedChunk(this.m_chunkData, this.m_sortOrder, out);
        out.flush();
        out.close();
    }

    private void inMemoryShuffle(byte[] data, int[] sortOrder, int startRowIndex, int endRowIndex) {
        int i;
        int numRowsToSort = endRowIndex - startRowIndex + 1;
        long[] magicNums = new long[numRowsToSort];
        for (i = 0; i < numRowsToSort; ++i) {
            long randomLong;
            long randomInt = this.m_random.nextInt();
            magicNums[i] = randomLong = randomInt << 32 | (long)i;
        }
        if (this.isNodeInterruptRequested(this.m_engineNode)) {
            return;
        }
        Arrays.sort(magicNums);
        for (i = 0; i < numRowsToSort; ++i) {
            int permIndex = (int)(magicNums[i] & 0xFFFFFFFFL);
            if (permIndex < 0 || permIndex >= numRowsToSort) {
                return;
            }
            sortOrder[i] = permIndex * this.m_bytesPerRow;
        }
    }

    private void inMemoryNonRecursiveMergeSort(byte[] data, int[] sortOrder, int[] tempOrder, int startRowIndex, int endRowIndex) {
        int numRowsToSort = endRowIndex - startRowIndex + 1;
        int sortedSubGroupSize = 1;
        int groupSize = sortedSubGroupSize * 2;
        while (true) {
            for (int i = startRowIndex; i < numRowsToSort; i += groupSize) {
                boolean ok;
                int midpoint = i + sortedSubGroupSize - 1;
                if (i + groupSize > numRowsToSort) {
                    if (midpoint > numRowsToSort - 1) {
                        midpoint = numRowsToSort - 1;
                    }
                    ok = this.inMemoryMerge(data, sortOrder, tempOrder, i, midpoint, numRowsToSort - 1);
                } else {
                    ok = this.inMemoryMerge(data, sortOrder, tempOrder, i, midpoint, i + groupSize - 1);
                }
                if (ok) continue;
                return;
            }
            if (groupSize > numRowsToSort) break;
            sortedSubGroupSize *= 2;
            groupSize *= 2;
        }
    }

    private void inMemoryRecursiveMergeSort(byte[] data, int[] sortOrder, int[] tempOrder, int startRowIndex, int endRowIndex) {
        if (startRowIndex < endRowIndex) {
            int midpointRowIndex = (startRowIndex + endRowIndex) / 2;
            this.inMemoryRecursiveMergeSort(data, sortOrder, tempOrder, startRowIndex, midpointRowIndex);
            this.inMemoryRecursiveMergeSort(data, sortOrder, tempOrder, midpointRowIndex + 1, endRowIndex);
            this.inMemoryMerge(data, sortOrder, tempOrder, startRowIndex, midpointRowIndex, endRowIndex);
        }
    }

    private void writeSortedChunk(byte[] chunkData, int[] sortOrder, DataOutputStream out) throws IOException {
        if (!this.m_keepRowsIntact) {
            int numRows = chunkData.length / this.m_bytesPerRow;
            int actBPR = this.m_topRowFilteredBuf.getBytesPerRow();
            out.write(chunkData, 0, numRows * actBPR);
            return;
        }
        for (int i = 0; i < sortOrder.length; ++i) {
            int index = sortOrder[i];
            out.write(chunkData, index, this.m_bytesPerRow);
        }
    }

    private boolean inMemoryMerge(byte[] data, int[] sortOrder, int[] tempOrder, int startRowIndex, int midpointRowIndex, int endRowIndex) {
        int tempBaseIndex;
        if (!this.m_keepRowsIntact) {
            this.inMemoryMergeByColumn(data, sortOrder, tempOrder, startRowIndex, midpointRowIndex, endRowIndex);
            return true;
        }
        boolean pickTop = false;
        int bottomRowIndex = midpointRowIndex + 1;
        int topRowIndex = startRowIndex;
        int length = endRowIndex - startRowIndex + 1;
        int origLoc = tempBaseIndex = startRowIndex;
        while (topRowIndex <= midpointRowIndex && bottomRowIndex <= endRowIndex) {
            int top = sortOrder[topRowIndex];
            int bottom = sortOrder[bottomRowIndex];
            pickTop = this.m_sort ? this.shouldSelectTop(data, top, bottom) : this.shouldRandomlySelectTop();
            tempOrder[tempBaseIndex++] = pickTop ? sortOrder[topRowIndex++] : sortOrder[bottomRowIndex++];
            if (!this.quickInterruptCheck()) continue;
            return false;
        }
        if (topRowIndex <= midpointRowIndex) {
            System.arraycopy(sortOrder, topRowIndex, tempOrder, tempBaseIndex, midpointRowIndex - topRowIndex + 1);
        } else {
            System.arraycopy(sortOrder, bottomRowIndex, tempOrder, tempBaseIndex, bottomRowIndex - bottomRowIndex + 1);
        }
        System.arraycopy(tempOrder, origLoc, sortOrder, origLoc, length);
        return true;
    }

    private boolean keepMerging(int[] topRowIndex, int[] bottomRowIndex, int midpointRowIndex, int endRowIndex) {
        int i;
        for (i = 0; i < topRowIndex.length; ++i) {
            if (topRowIndex[i] > midpointRowIndex) continue;
            return true;
        }
        for (i = 0; i < bottomRowIndex.length; ++i) {
            if (bottomRowIndex[i] > endRowIndex) continue;
            return true;
        }
        return false;
    }

    private void setRowBufData(DataCacheRowBuf src, int srcIndex, DataCacheRowBuf dest, int destIndex) {
        if (src.isBlob(srcIndex)) {
            dest.setBlobOffsetLength(destIndex, src.getBlobOffset(srcIndex), src.getBlobLength(srcIndex));
        } else if (src.isString(srcIndex)) {
            dest.setString(destIndex, src.getString(srcIndex));
        } else if (src.isFactor(srcIndex)) {
            int srcLevelNum = src.getLevelNum(srcIndex);
            dest.setLevelNum(destIndex, srcLevelNum);
        } else if (src.isTimeDate(srcIndex)) {
            dest.setTimeDate(destIndex, src.getTimeDate(srcIndex));
        } else if (src.isDouble(srcIndex)) {
            double srcDbl = src.getDouble(srcIndex);
            dest.setDouble(destIndex, srcDbl);
        }
    }

    private void inMemoryMergeByColumn(byte[] data, int[] sortOrder, int[] tempOrder, int startRowIndex, int midpointRowIndex, int endRowIndex) {
        int[] bottomRowIndex = new int[this.m_numOverallComparisons];
        int[] topRowIndex = new int[this.m_numOverallComparisons];
        DataCacheRowBuf topRB = null;
        DataCacheRowBuf botRB = null;
        int tempBaseIndex = 0;
        boolean pickTop = false;
        boolean firstLevelSort = false;
        int length = endRowIndex - startRowIndex + 1;
        int origLoc = startRowIndex;
        firstLevelSort = length <= 2;
        for (int i = 0; i < this.m_numOverallComparisons; ++i) {
            bottomRowIndex[i] = midpointRowIndex + 1;
            topRowIndex[i] = startRowIndex;
        }
        int filteredRowLength = this.m_tempFilteredRowBuf.getBytesPerRow();
        byte[] tempData = new byte[filteredRowLength * length];
        while (this.keepMerging(topRowIndex, bottomRowIndex, midpointRowIndex, endRowIndex)) {
            for (int i = 0; i < this.m_numOverallComparisons; ++i) {
                int bottom;
                int outColIndex = this.m_in2out[this.m_sortColumns[i]];
                int inColIndex = this.m_sortColumns[i];
                int rowLength = this.m_bytesPerRow;
                if (firstLevelSort) {
                    topRB = this.m_topRowBuf;
                    botRB = this.m_bottomRowBuf;
                } else {
                    inColIndex = this.m_in2out[inColIndex];
                    topRB = this.m_topRowFilteredBuf;
                    botRB = this.m_bottomFilteredRowBuf;
                    rowLength = filteredRowLength;
                }
                int top = topRowIndex[i] <= midpointRowIndex ? topRowIndex[i] * rowLength : -1;
                int n = bottom = bottomRowIndex[i] <= endRowIndex ? bottomRowIndex[i] * rowLength : -1;
                if (top == -1 && bottom == -1) break;
                pickTop = this.shouldSelectTopByColumn(data, top, bottom, i, topRB, botRB, !firstLevelSort);
                this.m_tempFilteredRowBuf.setData(tempData, tempBaseIndex * filteredRowLength);
                if (pickTop) {
                    this.setRowBufData(topRB, inColIndex, this.m_tempFilteredRowBuf, outColIndex);
                    int n2 = i;
                    topRowIndex[n2] = topRowIndex[n2] + 1;
                    continue;
                }
                this.setRowBufData(botRB, inColIndex, this.m_tempFilteredRowBuf, outColIndex);
                int n3 = i;
                bottomRowIndex[n3] = bottomRowIndex[n3] + 1;
            }
            ++tempBaseIndex;
        }
        System.arraycopy(tempData, 0, data, startRowIndex * filteredRowLength, length * filteredRowLength);
    }

    private boolean shouldSelectTop(byte[] data, int topRowIndex, int bottomRowIndex) {
        return this.shouldSelectTopByColumn(data, topRowIndex, bottomRowIndex, -1, this.m_topRowBuf, this.m_bottomRowBuf, false);
    }

    private boolean shouldSelectTopByColumn(byte[] data, int topRowIndex, int bottomRowIndex, int sortOrderNum, DataCacheRowBuf topRowBuf, DataCacheRowBuf bottomRowBuf, boolean watchFilteredColumns) {
        if (topRowIndex == -1) {
            bottomRowBuf.setData(data, bottomRowIndex);
            return false;
        }
        if (bottomRowIndex == -1) {
            topRowBuf.setData(data, topRowIndex);
            return true;
        }
        topRowBuf.setData(data, topRowIndex);
        bottomRowBuf.setData(data, bottomRowIndex);
        return this.shouldSelectTopByColumn(sortOrderNum, topRowBuf, bottomRowBuf, watchFilteredColumns);
    }

    private boolean shouldSelectTopByColumn(byte[] topData, byte[] bottomData, int column, DataCacheRowBuf topRowBuf, DataCacheRowBuf bottomRowBuf, boolean watchFilteredColumns) {
        if (topData == null) {
            return false;
        }
        if (bottomData == null) {
            return true;
        }
        topRowBuf.setData(topData, 0);
        bottomRowBuf.setData(bottomData, 0);
        return this.shouldSelectTopByColumn(column, topRowBuf, bottomRowBuf, watchFilteredColumns);
    }

    private boolean shouldSelectTopByColumn(int sortOrderNum, DataCacheRowBuf topRowBuf, DataCacheRowBuf bottomRowBuf, boolean watchFilteredColumns) {
        ++m_numComparisons;
        if (!watchFilteredColumns && sortOrderNum < 0) {
            int comp = topRowBuf.compareToRow(bottomRowBuf, this.m_sortColumns, this.m_sortAscending, this.m_sortNAatTop, this.m_sortColumnsLevels, this.m_absVal);
            return comp <= 0;
        }
        for (int i = 0; i < this.m_sortColumns.length; ++i) {
            int bottomLevelNum;
            int topLevelNum;
            int orderNum = sortOrderNum != -1 ? sortOrderNum : i;
            int sortColumn = this.m_sortColumns[orderNum];
            if (watchFilteredColumns) {
                sortColumn = this.m_in2out[sortColumn];
            }
            if (topRowBuf.isNA(sortColumn)) {
                if (bottomRowBuf.isNA(sortColumn)) continue;
                return this.m_sortNAatTop[orderNum];
            }
            if (bottomRowBuf.isNA(sortColumn)) {
                return !this.m_sortNAatTop[orderNum];
            }
            int comparison = topRowBuf.compareTo(bottomRowBuf, sortColumn);
            if (this.m_absVal && topRowBuf.isDouble(sortColumn)) {
                double bot;
                double top = Math.abs(topRowBuf.getDouble(sortColumn));
                if (top == (bot = Math.abs(bottomRowBuf.getDouble(sortColumn)))) {
                    comparison = 0;
                } else if (top > bot) {
                    comparison = 1;
                } else if (top < bot) {
                    comparison = -1;
                }
            }
            if (comparison == 0) {
                if (sortOrderNum == -1) continue;
                return true;
            }
            boolean topBigger = this.m_alphabetical && this.m_sortColumnsLevels[orderNum] != null ? this.m_sortColumnsLevels[orderNum][topLevelNum = topRowBuf.getLevelNum(sortColumn)].compareTo(this.m_sortColumnsLevels[orderNum][bottomLevelNum = bottomRowBuf.getLevelNum(sortColumn)]) > 0 : comparison > 0;
            return topBigger != this.m_sortAscending[orderNum];
        }
        return true;
    }

    private boolean shouldRandomlySelectTop() {
        return this.m_random.nextBoolean();
    }

    private boolean mergeChunks() throws Exception {
        int numFiles = this.m_tempFiles.size();
        if (numFiles == 1) {
            SortFile onlyFile = (SortFile)this.m_tempFiles.get(0);
            this.m_outputFile.delete();
            onlyFile.renameTo(this.m_outputFile);
            return true;
        }
        int origNumFiles = numFiles;
        int numIterations = (int)(1.0 + Math.log(origNumFiles) / Math.log(2.0));
        double percent = this.m_percentForSort;
        double totalRowsUsed = this.m_totalRowCount * (long)numIterations;
        double percentPerRow = (100.0 - percent) / totalRowsUsed;
        while (numFiles > 1) {
            SortFile topFile = (SortFile)this.m_tempFiles.get(0);
            SortFile bottomFile = (SortFile)this.m_tempFiles.get(1);
            SortFile combinedFile = null;
            if (numFiles == 2) {
                combinedFile = this.m_outputFile;
            } else {
                combinedFile = this.m_tempDir.createTempFile("sort", "tmp");
                combinedFile.deleteOnExit();
            }
            percent = this.mergeFiles(topFile, bottomFile, combinedFile, percent, percentPerRow);
            if (this.isNodeInterruptRequested(this.m_engineNode)) {
                return false;
            }
            this.m_tempFiles.add(combinedFile);
            this.m_tempFiles.remove(1);
            this.m_tempFiles.remove(0);
            topFile.delete();
            bottomFile.delete();
            numFiles = this.m_tempFiles.size();
        }
        return true;
    }

    private double mergeFiles(SortFile topFile, SortFile bottomFile, SortFile combinedFile, double percent, double percentIncrement) throws Exception {
        if (!this.m_keepRowsIntact) {
            return this.mergeFilesByColumn(topFile, bottomFile, combinedFile, percent, percentIncrement);
        }
        DataInputStream topInputStream = topFile.getDataInputStream();
        DataInputStream bottomInputStream = bottomFile.getDataInputStream();
        DataOutputStream combinedOutputStream = combinedFile.getDataOutputStream();
        byte[] compareRows = new byte[this.m_bytesPerRow * 2];
        boolean bottomRead = true;
        boolean topRead = true;
        try {
            topInputStream.readFully(compareRows, 0, this.m_bytesPerRow);
        }
        catch (EOFException e) {
            topRead = false;
        }
        try {
            bottomInputStream.readFully(compareRows, this.m_bytesPerRow, this.m_bytesPerRow);
        }
        catch (EOFException e) {
            bottomRead = false;
        }
        while (topRead && bottomRead) {
            boolean pickTop = this.m_sort ? this.shouldSelectTop(compareRows, 0, this.m_bytesPerRow) : this.shouldRandomlySelectTop();
            if (pickTop) {
                combinedOutputStream.write(compareRows, 0, this.m_bytesPerRow);
                if (this.isNodeProgressInterrupted(this.m_engineNode, percent += percentIncrement)) {
                    return percent;
                }
                try {
                    topInputStream.readFully(compareRows, 0, this.m_bytesPerRow);
                }
                catch (EOFException e) {
                    topRead = false;
                }
                continue;
            }
            combinedOutputStream.write(compareRows, this.m_bytesPerRow, this.m_bytesPerRow);
            if (this.isNodeProgressInterrupted(this.m_engineNode, percent += percentIncrement)) {
                return percent;
            }
            try {
                bottomInputStream.readFully(compareRows, this.m_bytesPerRow, this.m_bytesPerRow);
            }
            catch (EOFException e) {
                bottomRead = false;
            }
        }
        while (topRead) {
            combinedOutputStream.write(compareRows, 0, this.m_bytesPerRow);
            if (this.isNodeProgressInterrupted(this.m_engineNode, percent += percentIncrement)) {
                return percent;
            }
            try {
                topInputStream.readFully(compareRows, 0, this.m_bytesPerRow);
            }
            catch (EOFException e) {
                topRead = false;
            }
        }
        while (bottomRead) {
            combinedOutputStream.write(compareRows, this.m_bytesPerRow, this.m_bytesPerRow);
            if (this.isNodeProgressInterrupted(this.m_engineNode, percent += percentIncrement)) {
                return percent;
            }
            try {
                bottomInputStream.readFully(compareRows, this.m_bytesPerRow, this.m_bytesPerRow);
            }
            catch (EOFException e) {
                bottomRead = false;
            }
        }
        combinedOutputStream.flush();
        topInputStream.close();
        bottomInputStream.close();
        combinedOutputStream.close();
        return percent;
    }

    private double mergeFilesByColumn(SortFile topFile, SortFile bottomFile, SortFile combinedFile, double percent, double percentIncrement) throws Exception {
        int i;
        DataCacheRowBuf[] topRowBuf = new DataCacheRowBuf[this.m_numOverallComparisons];
        DataInputStream[] topInputStream = new DataInputStream[this.m_numOverallComparisons];
        DataCacheRowBuf[] bottomRowBuf = new DataCacheRowBuf[this.m_numOverallComparisons];
        DataInputStream[] bottomInputStream = new DataInputStream[this.m_numOverallComparisons];
        DataOutputStream combinedOutputStream = combinedFile.getDataOutputStream();
        DataCacheRowBuf outputRowBuf = new DataCacheRowBuf(this.m_outputMD);
        byte[] compareRows = new byte[this.m_bytesPerRow * 2];
        boolean[] bottomRead = new boolean[this.m_numOverallComparisons];
        boolean[] topRead = new boolean[this.m_numOverallComparisons];
        ColumnInputSortFile topColumnInputFile = new ColumnInputSortFile(topFile);
        ColumnInputSortFile bottomColumnInputFile = new ColumnInputSortFile(bottomFile);
        for (int i2 = 0; i2 < this.m_numOverallComparisons; ++i2) {
            bottomInputStream[i2] = bottomColumnInputFile.getDataInputStream();
            topInputStream[i2] = topColumnInputFile.getDataInputStream();
            topRowBuf[i2] = this.m_topRowFilteredBuf.copy();
            bottomRowBuf[i2] = this.m_topRowFilteredBuf.copy();
            try {
                bottomRead[i2] = true;
                bottomRowBuf[i2].readRowUnsafe(bottomInputStream[i2]);
            }
            catch (Exception e) {
                bottomRead[i2] = false;
            }
            try {
                topRead[i2] = true;
                topRowBuf[i2].readRowUnsafe(topInputStream[i2]);
                continue;
            }
            catch (Exception e) {
                topRead[i2] = false;
            }
        }
        byte[] outputRow = new byte[outputRowBuf.getBytesPerRow()];
        outputRowBuf.setData(outputRow, 0);
        boolean done = false;
        while (!done) {
            for (i = 0; i < this.m_numOverallComparisons; ++i) {
                boolean pickTop;
                int sortCol = this.m_in2out[this.m_sortColumns[i]];
                if (topRead[i] && bottomRead[i]) {
                    byte[] topData = topRowBuf[i].getDataBytes();
                    byte[] bottomData = bottomRowBuf[i].getDataBytes();
                    pickTop = this.shouldSelectTopByColumn(topData, bottomData, i, this.m_topRowFilteredBuf, this.m_bottomFilteredRowBuf, true);
                } else if (topRead[i]) {
                    pickTop = true;
                } else if (bottomRead[i]) {
                    pickTop = false;
                } else {
                    done = true;
                    break;
                }
                int outputCol = sortCol;
                if (pickTop) {
                    this.setRowBufData(topRowBuf[i], sortCol, outputRowBuf, outputCol);
                    try {
                        topRowBuf[i].readRowUnsafe(topInputStream[i]);
                    }
                    catch (EOFException e) {
                        topRead[i] = false;
                    }
                    continue;
                }
                this.setRowBufData(bottomRowBuf[i], sortCol, outputRowBuf, outputCol);
                try {
                    bottomRowBuf[i].readRowUnsafe(bottomInputStream[i]);
                    continue;
                }
                catch (EOFException e) {
                    bottomRead[i] = false;
                }
            }
            if (done) continue;
            outputRowBuf.writeRow(combinedOutputStream);
        }
        combinedOutputStream.flush();
        for (i = 0; i < this.m_numOverallComparisons; ++i) {
            topInputStream[i].close();
            bottomInputStream[i].close();
        }
        combinedOutputStream.close();
        return percent;
    }

    private boolean quickInterruptCheck() {
        if (this.m_quickInterruptCounter-- < 0) {
            this.m_quickInterruptCounter = this.m_quickInterruptCounterInit;
            return this.m_engineNode != null && this.m_engineNode.getNetworkManager().isInterruptRequested();
        }
        return false;
    }

    private boolean isNodeProgressInterrupted(EngineNode node, double percent) {
        return node != null && !node.updateProgressIndicator((int)percent);
    }

    private boolean isNodeInterruptRequested(EngineNode node) {
        return node != null && node.getNetworkManager().isInterruptRequested();
    }

    private static String getStatusText(EngineNode node) {
        return node == null ? "" : (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
    }

    private static void setStatusText(EngineNode node, String str) {
        if (node != null) {
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        }
    }

    private static String addStatusText(EngineNode node, String str) {
        String origText = SortAndShuffle.getStatusText(node);
        String newStr = origText + str;
        SortAndShuffle.setStatusText(node, newStr);
        return origText;
    }

    private static void initReport() {
        m_reportBegin = System.currentTimeMillis();
        m_numComparisons = 0L;
        m_numFilesWritten = 0L;
        m_numFilesRead = 0L;
        m_numBytesRead = 0L;
    }

    private static void endReport() {
        m_reportEnd = System.currentTimeMillis();
    }

    public static Object[] getReport() {
        String[] labels = new String[]{"in-mem sort: secs", "in-mem sort: comparisons", "mergesort: secs", "mergesort: comparisons", "files read", "file written", "bytes read"};
        double[] stats = new double[]{(double)((m_reportEndInMemory - m_reportBegin) / 100L) / 10.0, m_numComparisonsInMemory, (double)((m_reportEnd - m_reportEndInMemory) / 100L) / 10.0, m_numComparisons - m_numComparisonsInMemory, m_numFilesRead, m_numFilesWritten, m_numBytesRead};
        return new Object[]{labels, stats};
    }

    private static double[][] testSort(byte[] inputBytes, XTMetaData metaData, EngineNode engineNode, int rowChunkSize, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean keepRowsIntact) throws Exception {
        SortFile inputFile = new SortFile(inputBytes);
        SortFile outputFile = new SortFile();
        boolean ok = SortAndShuffle.sort(inputFile, outputFile, metaData, null, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, keepRowsIntact);
        if (!ok) {
            throw new Exception("sort not ok");
        }
        byte[] sortedFileBytes = outputFile.getBytes();
        if (sortedFileBytes == null || sortedFileBytes.length != inputBytes.length) {
            throw new Exception("bad sort output bytes");
        }
        DataCacheRowBuf rowBuf = new DataCacheRowBuf(metaData, false);
        int bytesPerRow = rowBuf.getBytesPerRow();
        int numInts = inputBytes.length / bytesPerRow;
        double[][] outVals = new double[metaData.getNumColumns()][numInts];
        for (int i = 0; i < numInts; ++i) {
            rowBuf.setData(sortedFileBytes, i * bytesPerRow);
            for (int j = 0; j < 3; ++j) {
                outVals[j][i] = rowBuf.getDouble(j);
            }
        }
        return outVals;
    }

    public static boolean testSort(int numInts, int rowChunkSize, boolean keepRowsIntact) throws Exception {
        XTMetaData md = new XTMetaData();
        md.appendContinousDataField("x");
        md.appendContinousDataField("y");
        md.appendContinousDataField("z");
        md.setNumRows(numInts);
        double[][] inVals = new double[numInts][3];
        for (int i = 0; i < numInts; ++i) {
            inVals[i][0] = i;
            inVals[i][1] = numInts - 1 - i;
            inVals[i][2] = i % 5;
        }
        if (keepRowsIntact) {
            if (!SortAndShuffle.testSort("testing: reverse sort x", inVals, md, rowChunkSize, new String[]{"x"}, new boolean[]{false}, new boolean[]{true}, true, true)) {
                return false;
            }
            if (!SortAndShuffle.testSort("testing: sort x (already sorted)", inVals, md, rowChunkSize, new String[]{"x"}, new boolean[]{true}, new boolean[]{true}, true, true)) {
                return false;
            }
            if (!SortAndShuffle.testSort("testing: reverse sort x,z (already sorted)", inVals, md, rowChunkSize, new String[]{"x", "z"}, new boolean[]{true, true}, new boolean[]{true, true}, true, true)) {
                return false;
            }
            if (!SortAndShuffle.testSort("testing: sort z,y", inVals, md, rowChunkSize, new String[]{"z", "y"}, new boolean[]{false, true}, new boolean[]{true, true}, true, true)) {
                return false;
            }
        } else {
            if (!SortAndShuffle.testSort("column x,y,z", inVals, md, rowChunkSize, new String[]{"x", "y", "z"}, new boolean[]{false, false, false}, new boolean[]{true, true, true}, true, false)) {
                return false;
            }
            if (!SortAndShuffle.testSort("column z,x,y", inVals, md, rowChunkSize, new String[]{"z", "x", "y"}, new boolean[]{false, false, false}, new boolean[]{true, true, true}, true, false)) {
                return false;
            }
            if (!SortAndShuffle.testSort("column x,y,z alt order", inVals, md, rowChunkSize, new String[]{"x", "y", "z"}, new boolean[]{false, true, false}, new boolean[]{false, true, false}, true, false)) {
                return false;
            }
        }
        return true;
    }

    public static boolean testSort(String msg, double[][] inVals, XTMetaData metaData, int rowChunkSize, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop, boolean alphabetical, boolean keepRowsIntact) throws Exception {
        double fileVal;
        int col;
        int row;
        int numRows = (int)metaData.getNumRows();
        int numCols = metaData.getNumColumns();
        DataCacheRowBuf rowBuf = new DataCacheRowBuf(metaData, false);
        int bytesPerRow = rowBuf.getBytesPerRow();
        int numInputBytes = bytesPerRow * numRows;
        byte[] inputBytes = new byte[numInputBytes];
        double[][] sortData = new double[numRows][numCols];
        for (int row2 = 0; row2 < numRows; ++row2) {
            rowBuf.setData(inputBytes, row2 * bytesPerRow);
            for (int col2 = 0; col2 < numCols; ++col2) {
                rowBuf.setDouble(col2, inVals[row2][col2]);
                sortData[row2][col2] = inVals[row2][col2];
            }
        }
        System.out.println("testing: " + msg);
        SortFile inputFile = new SortFile(inputBytes);
        SortFile outputFile = new SortFile();
        boolean ok = SortAndShuffle.sort(inputFile, outputFile, metaData, null, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, keepRowsIntact);
        if (!ok) {
            return false;
        }
        byte[] sortedFileBytes = outputFile.getBytes();
        if (sortedFileBytes == null || sortedFileBytes.length != inputBytes.length) {
            return false;
        }
        DoubleArrayComparator rowComp = new DoubleArrayComparator(metaData, sortColumnOrder, sortAscending, sortNAatTop);
        Arrays.sort(sortData, rowComp);
        double[][] fileVals = new double[numRows][numCols];
        for (row = 0; row < numRows; ++row) {
            rowBuf.setData(sortedFileBytes, row * bytesPerRow);
            for (col = 0; col < numCols; ++col) {
                fileVals[row][col] = fileVal = rowBuf.getDouble(col);
            }
        }
        for (row = 0; row < numRows; ++row) {
            for (col = 0; col < numCols; ++col) {
                fileVal = fileVals[row][col];
                double javaVal = sortData[row][col];
                if (Double.isNaN(fileVal) && Double.isNaN(javaVal) || fileVal == javaVal) continue;
                return false;
            }
        }
        return true;
    }

    private static void testShuffle(int numInts, int rowChunkSize, int reps, String fileName) throws Exception {
        System.out.println("shuffle test with numInts=" + numInts + ", rowChunkSize=" + rowChunkSize + ", reps=" + reps + ", file=" + fileName);
        int[][] counts = SortAndShuffle.testShuffleGetCounts(numInts, rowChunkSize, reps);
        System.out.println("\nwriting: " + fileName);
        FileOutputStream fileStream = new FileOutputStream(fileName);
        BufferedOutputStream buffer = new BufferedOutputStream(fileStream);
        OutputStreamWriter out = new OutputStreamWriter(buffer);
        for (int i = 0; i < numInts; ++i) {
            out.write("" + i);
            for (int j = 0; j < numInts; ++j) {
                out.write("," + counts[i][j]);
            }
            out.write("\n");
        }
        out.close();
        System.out.println("done");
    }

    private static void testShuffle(int numInts, int rowChunkSize, int reps) throws Exception {
        System.out.println("shuffle test with numInts=" + numInts + ", rowChunkSize=" + rowChunkSize + ", reps=" + reps);
        int[][] counts = SortAndShuffle.testShuffleGetCounts(numInts, rowChunkSize, reps);
        for (int i = 0; i < 5 && i < numInts; ++i) {
            System.out.print("counts for " + i + ": ");
            for (int j = 0; j < numInts; ++j) {
                System.out.print(" " + j + ":" + counts[i][j]);
            }
            System.out.println("");
        }
        System.out.println("done");
    }

    private static int[][] testShuffleGetCounts(int numInts, int rowChunkSize, int reps) throws Exception {
        int[][] counts = new int[numInts][numInts];
        XTMetaData md = new XTMetaData();
        md.appendContinousDataField("x");
        md.setNumRows(numInts);
        DataCacheRowBuf rowBuf = new DataCacheRowBuf(md, false);
        int bytesPerRow = rowBuf.getBytesPerRow();
        int numInputBytes = bytesPerRow * numInts;
        byte[] inputBytes = new byte[numInputBytes];
        for (int i = 0; i < numInts; ++i) {
            rowBuf.setData(inputBytes, i * bytesPerRow);
            rowBuf.setDouble(0, i);
        }
        for (int rep = 0; rep < reps; ++rep) {
            if (rep > 0 && rep % 10000 == 0) {
                System.out.print("<" + rep + ">");
            }
            byte[] inputFileBytes = new byte[inputBytes.length];
            System.arraycopy(inputBytes, 0, inputFileBytes, 0, inputBytes.length);
            SortFile inputFile = new SortFile(inputFileBytes);
            SortFile outputFile = new SortFile();
            boolean ok = SortAndShuffle.shuffle(inputFile, outputFile, md, null, rowChunkSize, (long)(1 + rep * 123));
            if (!ok) {
                throw new Exception("shuffle not ok at rep==" + rep);
            }
            byte[] shuffledFileBytes = outputFile.getBytes();
            if (shuffledFileBytes == null || shuffledFileBytes.length != inputBytes.length) {
                throw new Exception("bad shuffle output bytes");
            }
            int[] countEachFound = new int[numInts];
            int i = 0;
            while (i < numInts) {
                rowBuf.setData(shuffledFileBytes, i * bytesPerRow);
                double dVal = rowBuf.getDouble(0);
                if (dVal != Math.rint(dVal) || dVal < 0.0 || dVal >= (double)numInts) {
                    throw new Exception("bad shuffle output val:" + dVal);
                }
                int shuffledInt = (int)dVal;
                int[] nArray = counts[shuffledInt];
                int n = i++;
                nArray[n] = nArray[n] + 1;
                int n2 = shuffledInt;
                countEachFound[n2] = countEachFound[n2] + 1;
            }
            for (i = 0; i < numInts; ++i) {
                if (countEachFound[i] == 1) continue;
                throw new Exception("bad shuffle output: " + i + " found " + countEachFound[i] + " times");
            }
        }
        System.out.println("shuffle done");
        return counts;
    }

    public static void main(String[] args) {
        try {
            if (args.length >= 1 && args[0].equals("sorttest")) {
                int arg = 1;
                while (arg + 1 < args.length) {
                    int numInts = Integer.parseInt(args[arg]);
                    int rowChunkSize = Integer.parseInt(args[arg + 1]);
                    System.out.println("sort test with numInts=" + numInts + ", rowChunkSize=" + rowChunkSize);
                    boolean ok = SortAndShuffle.testSort(numInts, rowChunkSize, true);
                    if (ok) {
                        System.out.println("sort test successful");
                    } else {
                        System.out.println("sort test failed");
                    }
                    arg += 2;
                }
            } else if (args.length >= 1 && args[0].equals("sortcolumntest")) {
                int arg = 1;
                while (arg + 1 < args.length) {
                    int numInts = Integer.parseInt(args[arg]);
                    int rowChunkSize = Integer.parseInt(args[arg + 1]);
                    System.out.println("column sort test with numInts=" + numInts + ", rowChunkSize=" + rowChunkSize);
                    boolean ok = SortAndShuffle.testSort(numInts, rowChunkSize, false);
                    if (ok) {
                        System.out.println("sort test successful");
                    } else {
                        System.out.println("sort test failed");
                    }
                    arg += 2;
                }
            } else if (args.length >= 5 && args[0].equals("shuffletest")) {
                int arg = 1;
                int numInts = Integer.parseInt(args[arg++]);
                int rowChunkSize = Integer.parseInt(args[arg++]);
                int reps = Integer.parseInt(args[arg++]);
                String fileName = args[arg++];
                SortAndShuffle.testShuffle(numInts, rowChunkSize, reps, fileName);
            } else {
                System.out.println("unknown args to main");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class DoubleArrayComparator
    implements Comparator {
        int[] m_colsToSort = null;
        boolean[] m_sortAscending = null;
        boolean[] m_sortNAatTop = null;

        DoubleArrayComparator(XTMetaData metaData, String[] sortColumnOrder, boolean[] sortAscending, boolean[] sortNAatTop) {
            this.m_colsToSort = new int[sortColumnOrder.length];
            for (int i = 0; i < sortColumnOrder.length; ++i) {
                this.m_colsToSort[i] = metaData.nameToOrdinal(sortColumnOrder[i]);
            }
            this.m_sortAscending = sortAscending;
            this.m_sortNAatTop = sortNAatTop;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || !(o1 instanceof double[])) {
                return -1;
            }
            if (o2 == null || !(o2 instanceof double[])) {
                return 1;
            }
            double[] dv1 = (double[])o1;
            double[] dv2 = (double[])o2;
            for (int i = 0; i < this.m_colsToSort.length; ++i) {
                double d1 = dv1[this.m_colsToSort[i]];
                double d2 = dv2[this.m_colsToSort[i]];
                if (Double.isNaN(d1)) {
                    if (Double.isNaN(d2)) continue;
                    return this.m_sortNAatTop[i] ? -1 : 1;
                }
                if (Double.isNaN(d2)) {
                    return this.m_sortNAatTop[i] ? 1 : -1;
                }
                if (d1 == d2) continue;
                if (this.m_sortAscending[i]) {
                    return d1 < d2 ? -1 : 1;
                }
                return d1 < d2 ? 1 : -1;
            }
            return 0;
        }
    }

    private static class ColumnInputSortFile
    extends SortFile {
        Vector streams = new Vector();

        public ColumnInputSortFile(SortFile file) throws IOException {
            super(file.m_file);
        }

        void close() throws IOException {
            super.close();
            for (int i = 0; i < this.streams.size(); ++i) {
                Object streamObj = this.streams.get(i);
                if (streamObj == null || !(streamObj instanceof DataInputStream)) continue;
                ((DataInputStream)streamObj).close();
            }
        }

        DataInputStream getDataInputStream() throws Exception {
            m_numFilesRead++;
            DataInputStream newStream = null;
            if (this.m_file != null) {
                long len = this.m_file.length();
                m_numBytesRead += len;
                FileInputStream fileStream = new FileInputStream(this.m_file);
                BufferedInputStream buffer = new BufferedInputStream(fileStream);
                newStream = new DataInputStream(buffer);
            } else {
                byte[] data = this.getBytes();
                if (data == null) {
                    throw new Exception("bad mem SortFile");
                }
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                newStream = new DataInputStream(in);
            }
            if (newStream != null) {
                this.streams.add(newStream);
            }
            return newStream;
        }

        DataOutputStream getDataOutputStream() throws IOException {
            return null;
        }
    }

    private class MergeFileSet {
        MultiFile[] m_files = null;
        int m_numFiles = 0;
        int m_currentFile = -1;
        DataCacheRowBuf[] m_readSortBufs = null;
        int m_readSortNum = 0;
        int[] m_readSortInputs = null;
        DataCacheRowBuf m_readShuffleBuf = null;
        long m_readShuffleTotalRemainingRows = 0L;
        long[] m_readShuffleInputRemainingRows = null;

        MergeFileSet(MultiFile in) {
            this(new MultiFile[]{in});
        }

        MergeFileSet(MultiFile[] in) {
            this.m_files = in;
            this.m_numFiles = in.length;
        }

        int getNumFiles() {
            return this.m_numFiles;
        }

        MultiFile getFile(int i) {
            return this.m_files[i];
        }

        void close() {
            try {
                this.m_readSortBufs = null;
                this.m_readShuffleBuf = null;
                for (int i = 0; i < this.m_numFiles; ++i) {
                    this.m_files[i].close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void delete() {
            try {
                this.close();
                for (int i = 0; i < this.m_numFiles; ++i) {
                    this.m_files[i].delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        long getMaxSubfiles() {
            long val = 0L;
            for (int i = 0; i < this.m_numFiles; ++i) {
                val = Math.max(val, this.m_files[i].getTotalSubfiles());
            }
            return val;
        }

        void openForWrite() throws Exception {
            this.m_currentFile = 0;
            if (this.m_currentFile < this.m_numFiles) {
                this.m_files[this.m_currentFile].openForWrite();
            }
        }

        void closeSubfileWrite() throws Exception {
            if (this.m_currentFile < this.m_numFiles) {
                this.m_files[this.m_currentFile].closeSubfileWrite();
                if (this.m_files[this.m_currentFile].writeIsFull()) {
                    this.m_files[this.m_currentFile].close();
                    ++this.m_currentFile;
                    if (this.m_currentFile < this.m_numFiles) {
                        this.m_files[this.m_currentFile].openForWrite();
                    }
                }
            }
        }

        void writeChunk(byte[] data, int numRows) throws Exception {
            this.m_files[this.m_currentFile].writeNextChunk(data, numRows);
        }

        void writeBuf(DataCacheRowBuf buf) throws Exception {
            this.m_files[this.m_currentFile].writeBuf(buf);
        }

        void readSortFirstInsert(int in) {
            ++this.m_readSortNum;
            for (int i = this.m_readSortNum - 1; i > 0; --i) {
                this.m_readSortInputs[i] = this.m_readSortInputs[i - 1];
            }
            this.m_readSortInputs[0] = in;
        }

        void readSortFirstDelete() {
            --this.m_readSortNum;
            for (int i = 0; i < this.m_readSortNum; ++i) {
                this.m_readSortInputs[i] = this.m_readSortInputs[i + 1];
            }
        }

        boolean sortFirstInputComesBefore(int sortInputNum) {
            return SortAndShuffle.this.shouldSelectTopByColumn(-1, this.m_readSortBufs[this.m_readSortInputs[0]], this.m_readSortBufs[this.m_readSortInputs[sortInputNum]], false);
        }

        void readSortReorderFirstInput() {
            int newPos = 0;
            switch (this.m_readSortNum) {
                case 0: 
                case 1: {
                    return;
                }
                case 2: {
                    if (this.sortFirstInputComesBefore(1)) {
                        newPos = 0;
                        break;
                    }
                    newPos = 1;
                    break;
                }
                case 3: {
                    if (this.sortFirstInputComesBefore(1)) {
                        newPos = 0;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(2)) {
                        newPos = 1;
                        break;
                    }
                    newPos = 2;
                    break;
                }
                case 4: {
                    if (this.sortFirstInputComesBefore(2)) {
                        if (this.sortFirstInputComesBefore(1)) {
                            newPos = 0;
                            break;
                        }
                        newPos = 1;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(3)) {
                        newPos = 2;
                        break;
                    }
                    newPos = 3;
                    break;
                }
                case 5: {
                    if (this.sortFirstInputComesBefore(2)) {
                        if (this.sortFirstInputComesBefore(1)) {
                            newPos = 0;
                            break;
                        }
                        newPos = 1;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(3)) {
                        newPos = 2;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(4)) {
                        newPos = 3;
                        break;
                    }
                    newPos = 4;
                    break;
                }
                case 6: {
                    if (this.sortFirstInputComesBefore(3)) {
                        if (this.sortFirstInputComesBefore(1)) {
                            newPos = 0;
                            break;
                        }
                        if (this.sortFirstInputComesBefore(2)) {
                            newPos = 1;
                            break;
                        }
                        newPos = 2;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(4)) {
                        newPos = 3;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(5)) {
                        newPos = 4;
                        break;
                    }
                    newPos = 5;
                    break;
                }
                case 7: {
                    if (this.sortFirstInputComesBefore(3)) {
                        if (this.sortFirstInputComesBefore(1)) {
                            newPos = 0;
                            break;
                        }
                        if (this.sortFirstInputComesBefore(2)) {
                            newPos = 1;
                            break;
                        }
                        newPos = 2;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(5)) {
                        if (this.sortFirstInputComesBefore(4)) {
                            newPos = 3;
                            break;
                        }
                        newPos = 4;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(6)) {
                        newPos = 5;
                        break;
                    }
                    newPos = 6;
                    break;
                }
                case 8: {
                    if (this.sortFirstInputComesBefore(4)) {
                        if (this.sortFirstInputComesBefore(2)) {
                            if (this.sortFirstInputComesBefore(1)) {
                                newPos = 0;
                                break;
                            }
                            newPos = 1;
                            break;
                        }
                        if (this.sortFirstInputComesBefore(3)) {
                            newPos = 2;
                            break;
                        }
                        newPos = 3;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(6)) {
                        if (this.sortFirstInputComesBefore(5)) {
                            newPos = 4;
                            break;
                        }
                        newPos = 5;
                        break;
                    }
                    if (this.sortFirstInputComesBefore(7)) {
                        newPos = 6;
                        break;
                    }
                    newPos = 7;
                    break;
                }
            }
            if (newPos < 1) {
                return;
            }
            int firstFile = this.m_readSortInputs[0];
            for (int i = 0; i < newPos; ++i) {
                this.m_readSortInputs[i] = this.m_readSortInputs[i + 1];
            }
            this.m_readSortInputs[newPos] = firstFile;
        }

        void openForRead() throws Exception {
            this.close();
            for (int i = 0; i < this.m_numFiles; ++i) {
                this.m_files[i].openForRead();
            }
        }

        void openForReadMerge() throws Exception {
            if (SortAndShuffle.this.m_sort) {
                int i;
                this.m_readSortBufs = new DataCacheRowBuf[this.m_numFiles];
                for (i = 0; i < this.m_numFiles; ++i) {
                    if (this.m_files[i].readEOF()) continue;
                    this.m_readSortBufs[i] = new DataCacheRowBuf(SortAndShuffle.this.m_inputMD);
                }
                this.m_readSortNum = 0;
                this.m_readSortInputs = new int[this.m_numFiles];
                for (i = 0; i < this.m_numFiles; ++i) {
                    this.m_readSortInputs[i] = -1;
                }
                for (i = 0; i < this.m_numFiles; ++i) {
                    if (this.m_files[i].readEOF()) continue;
                    this.readSortFirstInsert(i);
                    this.flushTopReadMergeBuf();
                }
            } else {
                this.m_readShuffleTotalRemainingRows = 0L;
                this.m_readShuffleInputRemainingRows = new long[this.m_numFiles];
                for (int i = 0; i < this.m_numFiles; ++i) {
                    this.m_readShuffleInputRemainingRows[i] = this.m_files[i].readEOF() || this.m_files[i].readSubfileEOF() ? 0L : this.m_files[i].currentSubfileNumRows();
                    this.m_readShuffleTotalRemainingRows += this.m_readShuffleInputRemainingRows[i];
                }
                this.m_readShuffleBuf = new DataCacheRowBuf(SortAndShuffle.this.m_inputMD);
            }
        }

        void flushTopReadMergeBuf() throws Exception {
            if (SortAndShuffle.this.m_sort) {
                if (this.m_readSortNum < 1) {
                    return;
                }
                int in = this.m_readSortInputs[0];
                MultiFile firstFile = this.m_files[in];
                if (firstFile.readSubfileEOF()) {
                    this.readSortFirstDelete();
                    return;
                }
                firstFile.readBuf(this.m_readSortBufs[in]);
                this.readSortReorderFirstInput();
            }
        }

        DataCacheRowBuf getTopReadMergeBuf() throws Exception {
            if (SortAndShuffle.this.m_sort) {
                if (this.m_readSortNum < 1) {
                    return null;
                }
                return this.m_readSortBufs[this.m_readSortInputs[0]];
            }
            if (this.m_readShuffleTotalRemainingRows < 1L) {
                return null;
            }
            double randVal = SortAndShuffle.this.m_random.nextDouble();
            int selectedInput = this.m_numFiles - 1;
            long cnt = (long)Math.floor(randVal * (double)this.m_readShuffleTotalRemainingRows);
            for (int i = 0; i < this.m_numFiles; ++i) {
                if (cnt < this.m_readShuffleInputRemainingRows[i]) {
                    selectedInput = i;
                    break;
                }
                cnt -= this.m_readShuffleInputRemainingRows[i];
            }
            this.m_files[selectedInput].readBuf(this.m_readShuffleBuf);
            int n = selectedInput;
            this.m_readShuffleInputRemainingRows[n] = this.m_readShuffleInputRemainingRows[n] - 1L;
            --this.m_readShuffleTotalRemainingRows;
            return this.m_readShuffleBuf;
        }

        boolean readEOF() {
            for (int i = 0; i < this.m_numFiles; ++i) {
                if (this.m_files[i].readEOF()) continue;
                return false;
            }
            return true;
        }

        void closeSubfileReadMerge() throws Exception {
            for (int i = 0; i < this.m_numFiles; ++i) {
                if (this.m_files[i].readEOF()) continue;
                this.m_files[i].closeSubfileRead();
            }
        }
    }

    private class MultiFile {
        SortFile m_file;
        long m_lastSubfileNumRows = 0L;
        long m_butlastSubfileNumRows = 0L;
        long m_butlastSubfileCount = 0L;
        long m_currentSubfile = 0L;
        long m_currentSubfileRow = 0L;
        long m_writeSubfileMaxCount = 0L;

        MultiFile(SortFile file, long butlastSubfileCount, long butlastSubfileNumRows, long lastSubfileNumRows) {
            this.m_file = file;
            this.m_lastSubfileNumRows = lastSubfileNumRows;
            this.m_butlastSubfileNumRows = butlastSubfileNumRows;
            this.m_butlastSubfileCount = butlastSubfileCount;
            if (this.m_lastSubfileNumRows < 1L && this.m_butlastSubfileCount > 0L) {
                this.m_lastSubfileNumRows = this.m_butlastSubfileNumRows;
                --this.m_butlastSubfileCount;
            }
        }

        MultiFile(SortFile file, long writeSubfileMaxCount) {
            this.m_file = file;
            this.m_writeSubfileMaxCount = writeSubfileMaxCount;
        }

        String getFileName() throws Exception {
            return this.m_file.getFileName();
        }

        boolean readEOF() {
            return this.m_currentSubfile >= this.m_butlastSubfileCount + 1L;
        }

        boolean readSubfileEOF() {
            return this.m_currentSubfileRow >= this.currentSubfileNumRows();
        }

        long getTotalSubfiles() {
            return this.m_butlastSubfileCount + 1L;
        }

        long getTotalRows() {
            return this.m_butlastSubfileCount * this.m_butlastSubfileNumRows + this.m_lastSubfileNumRows;
        }

        long getLastSubfileRows() {
            return this.m_lastSubfileNumRows;
        }

        long getButlastSubfileRows() {
            return this.m_butlastSubfileNumRows;
        }

        long getButlastSubfileCount() {
            return this.m_butlastSubfileCount;
        }

        void setLastSubfileRows(long val) {
            this.m_lastSubfileNumRows = val;
        }

        void setButlastSubfileRows(long val) {
            this.m_butlastSubfileNumRows = val;
        }

        void setButlastSubfileCount(long val) {
            this.m_butlastSubfileCount = val;
        }

        long getWriteSubfileMaxCount() {
            return this.m_writeSubfileMaxCount;
        }

        boolean writeIsFull() {
            return this.getWriteSubfileMaxCount() <= this.getTotalSubfiles();
        }

        long currentSubfileNumRows() {
            return this.m_currentSubfile < this.m_butlastSubfileCount ? this.m_butlastSubfileNumRows : this.m_lastSubfileNumRows;
        }

        void openForRead() throws Exception {
            this.m_currentSubfile = 0L;
            this.m_currentSubfileRow = 0L;
        }

        void openForWrite() throws Exception {
            this.m_currentSubfile = 0L;
            this.m_currentSubfileRow = 0L;
            this.m_lastSubfileNumRows = 0L;
            this.m_butlastSubfileNumRows = 0L;
            this.m_butlastSubfileCount = 0L;
        }

        void closeSubfileRead() throws Exception {
            if (this.m_currentSubfileRow < this.currentSubfileNumRows()) {
                throw new Exception("MultiFile subfile not consumed before next open for read");
            }
            ++this.m_currentSubfile;
            this.m_currentSubfileRow = 0L;
        }

        void closeSubfileWrite() throws Exception {
            if (this.m_currentSubfile < 1L) {
                this.m_lastSubfileNumRows = this.m_currentSubfileRow;
                this.m_butlastSubfileNumRows = 0L;
                this.m_butlastSubfileCount = 0L;
            } else if (this.m_butlastSubfileCount < 1L) {
                this.m_butlastSubfileCount = 1L;
                this.m_butlastSubfileNumRows = this.m_lastSubfileNumRows;
                this.m_lastSubfileNumRows = this.m_currentSubfileRow;
            } else {
                if (this.m_butlastSubfileNumRows != this.m_lastSubfileNumRows) {
                    throw new Exception("MultiFile: more than two subfile lengths");
                }
                ++this.m_butlastSubfileCount;
                this.m_lastSubfileNumRows = this.m_currentSubfileRow;
            }
            ++this.m_currentSubfile;
            this.m_currentSubfileRow = 0L;
        }

        int readNextChunk(byte[] chunkData, int maxRows) throws Exception {
            long readRows = this.currentSubfileNumRows();
            long readBytes = readRows * (long)SortAndShuffle.this.m_bytesPerRow;
            if (readRows > (long)maxRows || readBytes > (long)chunkData.length) {
                throw new Exception("MultiFile subfile length " + readRows + " too large");
            }
            this.m_file.readFully(chunkData, 0, (int)readBytes);
            this.m_currentSubfileRow += readRows;
            return (int)readRows;
        }

        void writeNextChunk(byte[] chunkData, int numRows) throws Exception {
            long writeBytes = numRows * SortAndShuffle.this.m_bytesPerRow;
            this.m_file.write(chunkData, 0, (int)writeBytes);
            this.m_currentSubfileRow += (long)numRows;
        }

        void writeBuf(DataCacheRowBuf buf) throws Exception {
            byte[] bytes = buf.getDataBytes();
            int offset = buf.getDataOffset();
            this.m_file.write(bytes, offset, SortAndShuffle.this.m_bytesPerRow);
            ++this.m_currentSubfileRow;
        }

        void readBuf(DataCacheRowBuf buf) throws Exception {
            byte[] bytes = buf.getDataBytes();
            int offset = buf.getDataOffset();
            this.m_file.readFully(bytes, offset, SortAndShuffle.this.m_bytesPerRow);
            ++this.m_currentSubfileRow;
        }

        void close() throws Exception {
            this.m_file.close();
        }

        void delete() throws Exception {
            this.m_file.delete();
        }
    }

    private static class SortFile {
        File m_file = null;
        byte[] m_data = null;
        boolean m_checkedTempDir = false;
        File m_tempDir = null;
        ByteArrayOutputStream m_byteArrayOutputStream = null;
        DataInputStream m_dataInputStream = null;
        DataOutputStream m_dataOutputStream = null;

        SortFile(File f) throws IOException {
            if (f == null) {
                throw new IOException("SortFile given null file");
            }
            this.m_file = f;
        }

        SortFile(byte[] data) {
            this.m_data = data;
        }

        SortFile() {
        }

        byte[] getBytes() {
            if (this.m_file != null) {
                return null;
            }
            if (this.m_data != null) {
                return this.m_data;
            }
            if (this.m_byteArrayOutputStream != null) {
                return this.m_byteArrayOutputStream.toByteArray();
            }
            return null;
        }

        DataInputStream getDataInputStream() throws Exception {
            this.close();
            m_numFilesRead++;
            if (this.m_file != null) {
                long len = this.m_file.length();
                m_numBytesRead += len;
                FileInputStream fileStream = new FileInputStream(this.m_file);
                BufferedInputStream buffer = new BufferedInputStream(fileStream);
                this.m_dataInputStream = new DataInputStream(buffer);
            } else {
                byte[] data = this.getBytes();
                if (data == null) {
                    throw new Exception("bad mem SortFile");
                }
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                this.m_dataInputStream = new DataInputStream(in);
            }
            return this.m_dataInputStream;
        }

        DataOutputStream getDataOutputStream() throws IOException {
            this.close();
            m_numFilesWritten++;
            if (this.m_file != null) {
                FileOutputStream fileStream = new FileOutputStream(this.m_file);
                BufferedOutputStream buffer = new BufferedOutputStream(fileStream);
                this.m_dataOutputStream = new DataOutputStream(buffer);
            } else {
                this.m_data = null;
                this.m_byteArrayOutputStream = new ByteArrayOutputStream();
                this.m_dataOutputStream = new DataOutputStream(this.m_byteArrayOutputStream);
            }
            return this.m_dataOutputStream;
        }

        SortFile createTempFile(String prefix, String suffix) throws IOException {
            if (this.m_file != null) {
                if (!this.m_checkedTempDir) {
                    String path = this.m_file.getCanonicalPath();
                    this.m_tempDir = new File(path.substring(0, path.indexOf(this.m_file.getName())));
                    if (!(this.m_tempDir.exists() && this.m_tempDir.isDirectory())) {
                        this.m_tempDir = null;
                    }
                    this.m_checkedTempDir = true;
                }
                File tempFile = File.createTempFile(prefix, suffix, this.m_tempDir);
                return new SortFile(tempFile);
            }
            return new SortFile();
        }

        String getFileName() throws Exception {
            if (this.m_file != null) {
                return this.m_file.getCanonicalPath();
            }
            throw new Exception("can't get file name for in-mem file");
        }

        boolean delete() throws Exception {
            this.close();
            if (this.m_file != null && this.m_file.exists()) {
                return this.m_file.delete();
            }
            return true;
        }

        void close() throws IOException {
            if (this.m_dataInputStream != null) {
                this.m_dataInputStream.close();
                this.m_dataInputStream = null;
            }
            if (this.m_dataOutputStream != null) {
                this.m_dataOutputStream.close();
                if (this.m_file == null) {
                    this.m_data = this.getBytes();
                }
                this.m_dataOutputStream = null;
            }
        }

        void deleteOnExit() throws IOException {
            if (this.m_file != null) {
                this.m_file.deleteOnExit();
            }
        }

        boolean renameTo(SortFile dest) throws Exception {
            this.close();
            dest.close();
            if (this.m_file != null) {
                if (dest.m_file == null) {
                    throw new Exception("renameTo from File to Mem");
                }
                return this.m_file.renameTo(dest.m_file);
            }
            if (dest.m_file != null) {
                throw new Exception("renameTo from Mem to File");
            }
            dest.m_data = this.getBytes();
            dest.m_byteArrayOutputStream = null;
            return true;
        }

        void readFully(byte[] b, int off, int len) throws Exception {
            if (this.m_dataInputStream == null) {
                this.getDataInputStream();
            }
            this.m_dataInputStream.readFully(b, off, len);
        }

        void write(byte[] b, int off, int len) throws IOException {
            if (this.m_dataOutputStream == null) {
                this.getDataOutputStream();
            }
            this.m_dataOutputStream.write(b, off, len);
            EngineNetworkManager.m_statSortWriteBytes += (long)len;
        }
    }
}

