/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.UnstackEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class UnstackDialog
extends NodeDialog {
    private NodeDialog.SortingScrollPane availableScrollPane;
    private NodeDialog.DNDList availableList;
    private NodeDialog.DNDListModel availableListModel;
    private NodeDialog.SortingScrollPane stackScrollPane;
    private NodeDialog.DNDList stackList;
    private NodeDialog.DNDListModel stackListModel;
    private NodeDialog.DNDList replicateList;
    private NodeDialog.SortingScrollPane replicateScrollPane;
    private NodeDialog.DNDListModel replicateListModel;
    private NodeDialog.DNDList valueList;
    private JScrollPane valueScrollPane;
    private NodeDialog.DNDListModel valueListModel;
    private JCheckBox pruneColumnsCheckBox;
    private AbstractAction addValueAction;
    private AbstractAction removeValueAction;
    private AbstractAction addStackAction;
    private AbstractAction removeStackAction;
    private AbstractAction addReplicateAction;
    private AbstractAction removeReplicateAction;
    private static UnstackDialog instance = null;

    public static UnstackDialog getInstance() {
        if (instance == null) {
            instance = new UnstackDialog();
        }
        return instance;
    }

    private UnstackDialog() {
        this.setResizable(true);
        this.setMinimumSize(new Dimension(525, 500));
    }

    public void restoreProperties() {
        int colNum;
        int i;
        XTMetaData metaData;
        super.restoreProperties();
        this.availableListModel.removeAllElements();
        this.stackListModel.removeAllElements();
        this.replicateListModel.removeAllElements();
        this.valueListModel.removeAllElements();
        XTProps props = this.getNodeModel().getXTProps();
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propGroup = props.getSubProperties(UnstackEngineNode.GROUP_COLUMNS_ATTRIBUTE_TAG);
        Vector propKey = props.getSubProperties(UnstackEngineNode.KEY_COLUMNS_ATTRIBUTE_TAG);
        String valueColumn = props.getValue(UnstackEngineNode.VALUE_COLUMN_ATTRIBUTE_TAG, "");
        boolean[] isGroupCol = new boolean[names.size()];
        boolean[] isKeyCol = new boolean[isGroupCol.length];
        for (i = 0; i < propGroup.size(); ++i) {
            colNum = metaData.nameToOrdinal((String)propGroup.get(i));
            if (colNum <= -1) continue;
            isGroupCol[colNum] = true;
        }
        for (i = 0; i < propKey.size(); ++i) {
            colNum = metaData.nameToOrdinal((String)propKey.get(i));
            if (colNum <= -1) continue;
            isKeyCol[colNum] = true;
        }
        for (i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String role = (String)roles.get(i);
            String type = (String)types.get(i);
            NodeDialog.ColumnInformationObject info = new NodeDialog.ColumnInformationObject(name, type, role, false, i);
            if (isGroupCol[i]) {
                this.stackListModel.addElement(info);
                continue;
            }
            if (isKeyCol[i]) {
                this.replicateListModel.addElement(info);
                continue;
            }
            if (!name.equals(valueColumn)) {
                this.availableListModel.addElement(info);
                continue;
            }
            this.valueListModel.addElement(info);
        }
        this.pruneColumnsCheckBox.setSelected(props.getBoolean(UnstackEngineNode.PRUNE_EMPTY_COLUMNS_ATTRIBUTE_TAG, true));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{UnstackEngineNode.GROUP_COLUMNS_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{UnstackEngineNode.KEY_COLUMNS_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{UnstackEngineNode.VALUE_COLUMN_ATTRIBUTE_TAG});
        NodeDialog.ColumnInformationObject object = null;
        Enumeration stackColumns = this.stackListModel.elements();
        while (stackColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)stackColumns.nextElement();
            props.set(UnstackEngineNode.GROUP_COLUMNS_ATTRIBUTE_TAG, object.getText(), "");
        }
        stackColumns = null;
        Enumeration replicateColumns = this.replicateListModel.elements();
        while (replicateColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)replicateColumns.nextElement();
            String colName = object.getText();
            props.set(UnstackEngineNode.KEY_COLUMNS_ATTRIBUTE_TAG, colName, "");
        }
        replicateColumns = null;
        if (!this.valueListModel.isEmpty()) {
            object = (NodeDialog.ColumnInformationObject)this.valueListModel.get(0);
            props.set(UnstackEngineNode.VALUE_COLUMN_ATTRIBUTE_TAG, object.getText());
        }
        props.set(UnstackEngineNode.PRUNE_EMPTY_COLUMNS_ATTRIBUTE_TAG, this.pruneColumnsCheckBox.isSelected());
    }

    public void createActions() {
        super.createActions();
        this.addStackAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!UnstackDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = UnstackDialog.this.availableList.getSelectedValues();
                    int[] indices = UnstackDialog.this.availableList.getSelectedIndices();
                    UnstackDialog.this.availableList.getSelectionModel().clearSelection();
                    UnstackDialog.this.stackListModel.removeListDataListeners();
                    UnstackDialog.this.availableListModel.removeListDataListeners();
                    int dif = 0;
                    for (int i = 0; i < values.length; ++i) {
                        String type = ((NodeDialog.ColumnInformationObject)values[i]).getType();
                        if (!type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
                        if (UnstackDialog.this.stackListModel.isEmpty()) {
                            UnstackDialog.this.stackListModel.addElement(values[i]);
                            UnstackDialog.this.availableListModel.removeElementAt(indices[i - dif++]);
                            continue;
                        }
                        UnstackDialog.this.stackListModel.addElement(values[i]);
                        UnstackDialog.this.availableListModel.removeElementAt(indices[i] - dif++);
                    }
                    UnstackDialog.this.stackListModel.undoRemoveListDataListeners();
                    UnstackDialog.this.availableListModel.undoRemoveListDataListeners();
                    UnstackDialog.this.stackScrollPane.sort();
                    UnstackDialog.this.availableListModel.listContentsChanged();
                    UnstackDialog.this.stackListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.removeStackAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!UnstackDialog.this.stackList.isSelectionEmpty()) {
                    Object[] values = UnstackDialog.this.stackList.getSelectedValues();
                    int[] indices = UnstackDialog.this.stackList.getSelectedIndices();
                    UnstackDialog.this.stackList.getSelectionModel().clearSelection();
                    UnstackDialog.this.stackListModel.removeListDataListeners();
                    UnstackDialog.this.availableListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        UnstackDialog.this.stackListModel.removeElementAt(indices[i] - i);
                        UnstackDialog.this.availableListModel.addElement(values[i]);
                    }
                    UnstackDialog.this.stackListModel.undoRemoveListDataListeners();
                    UnstackDialog.this.availableListModel.undoRemoveListDataListeners();
                    UnstackDialog.this.stackListModel.listContentsChanged();
                    UnstackDialog.this.availableListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.addReplicateAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!UnstackDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = UnstackDialog.this.availableList.getSelectedValues();
                    int[] indices = UnstackDialog.this.availableList.getSelectedIndices();
                    UnstackDialog.this.availableList.getSelectionModel().clearSelection();
                    UnstackDialog.this.availableListModel.removeListDataListeners();
                    UnstackDialog.this.replicateListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        UnstackDialog.this.replicateListModel.addElement(values[i]);
                        UnstackDialog.this.availableListModel.removeElementAt(indices[i] - i);
                    }
                    UnstackDialog.this.availableListModel.undoRemoveListDataListeners();
                    UnstackDialog.this.replicateListModel.undoRemoveListDataListeners();
                    UnstackDialog.this.replicateScrollPane.sort();
                    UnstackDialog.this.availableListModel.listContentsChanged();
                    UnstackDialog.this.replicateListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.removeReplicateAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!UnstackDialog.this.replicateList.isSelectionEmpty()) {
                    Object[] values = UnstackDialog.this.replicateList.getSelectedValues();
                    int[] indices = UnstackDialog.this.replicateList.getSelectedIndices();
                    UnstackDialog.this.replicateList.getSelectionModel().clearSelection();
                    UnstackDialog.this.availableListModel.removeListDataListeners();
                    UnstackDialog.this.replicateListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        UnstackDialog.this.replicateListModel.removeElementAt(indices[i] - i);
                        UnstackDialog.this.availableListModel.addElement(values[i]);
                    }
                    UnstackDialog.this.availableListModel.undoRemoveListDataListeners();
                    UnstackDialog.this.replicateListModel.undoRemoveListDataListeners();
                    UnstackDialog.this.availableListModel.listContentsChanged();
                    UnstackDialog.this.replicateListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.addValueAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!UnstackDialog.this.availableList.isSelectionEmpty() && UnstackDialog.this.valueListModel.isEmpty()) {
                    Object obj = UnstackDialog.this.availableList.getSelectedValue();
                    int index = UnstackDialog.this.availableList.getSelectedIndex();
                    UnstackDialog.this.availableList.getSelectionModel().clearSelection();
                    UnstackDialog.this.valueListModel.addElement(obj);
                    UnstackDialog.this.availableListModel.removeElementAt(index);
                }
            }
        };
        this.removeValueAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!UnstackDialog.this.valueList.isSelectionEmpty()) {
                    Object obj = UnstackDialog.this.valueList.getSelectedValue();
                    int index = UnstackDialog.this.valueList.getSelectedIndex();
                    UnstackDialog.this.valueList.getSelectionModel().clearSelection();
                    UnstackDialog.this.availableListModel.addElement(obj);
                    UnstackDialog.this.valueListModel.removeElementAt(index);
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getSelectColumnsPanel(), "Center");
        return panel;
    }

    private JPanel getSelectColumnsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("StackDialog_selectColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel availableLabel = new JLabel(MinerApp.getText("StackDialog_availableColumns"));
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 15;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.availableScrollPane, constraints);
        JButton addValueButton = new JButton(this.addValueAction);
        JButton removeValueButton = new JButton(this.removeValueAction);
        JButton addStackButton = new JButton(this.addStackAction);
        JButton removeStackButton = new JButton(this.removeStackAction);
        JButton addReplicateButton = new JButton(this.addReplicateAction);
        JButton removeReplicateButton = new JButton(this.removeReplicateAction);
        constraints.gridx = 5;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(3, 10, 3, 10);
        constraints.fill = 0;
        selectColumnsPanel.add((Component)addValueButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeValueButton, constraints);
        constraints.gridy = 5;
        selectColumnsPanel.add((Component)addStackButton, constraints);
        constraints.gridy = 6;
        selectColumnsPanel.add((Component)removeStackButton, constraints);
        constraints.gridy = 11;
        selectColumnsPanel.add((Component)addReplicateButton, constraints);
        constraints.gridy = 12;
        selectColumnsPanel.add((Component)removeReplicateButton, constraints);
        JLabel stackLabel = new JLabel(MinerApp.getText("UnstackDialog_groupColumns"));
        stackLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.stackListModel = new NodeDialog.DNDListModel();
        this.stackList = new NodeDialog.DNDList(this.stackListModel);
        this.stackList.setCellRenderer(renderer);
        this.stackScrollPane = new NodeDialog.SortingScrollPane(this.stackList);
        this.stackScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel replicateLabel = new JLabel(MinerApp.getText("UnstackDialog_keyColumns"));
        replicateLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.replicateListModel = new NodeDialog.DNDListModel();
        this.replicateList = new NodeDialog.DNDList(this.replicateListModel);
        this.replicateList.setCellRenderer(renderer);
        this.replicateScrollPane = new NodeDialog.SortingScrollPane(this.replicateList);
        this.replicateScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel valueLabel = new JLabel(MinerApp.getText("UnstackDialog_valueColumn"));
        valueLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.valueListModel = new NodeDialog.DNDListModel();
        this.valueList = new NodeDialog.DNDList(this.valueListModel);
        this.valueList.setCellRenderer(renderer);
        this.valueScrollPane = new JScrollPane(this.valueList);
        this.valueScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.valueScrollPane.setPreferredSize(new Dimension(125, 25));
        this.pruneColumnsCheckBox = new JCheckBox(MinerApp.getText("UnstackDialog_pruneColumns"));
        constraints.gridx = 6;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 2;
        selectColumnsPanel.add((Component)valueLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        selectColumnsPanel.add((Component)this.valueScrollPane, constraints);
        constraints.gridy = 2;
        constraints.gridheight = 2;
        selectColumnsPanel.add((Component)new JLabel(" "), constraints);
        constraints.gridy = 4;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        selectColumnsPanel.add((Component)stackLabel, constraints);
        constraints.gridy = 5;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)this.stackScrollPane, constraints);
        constraints.gridy = 10;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        selectColumnsPanel.add((Component)replicateLabel, constraints);
        constraints.gridy = 11;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.replicateScrollPane, constraints);
        constraints.gridy = 15;
        constraints.gridx = 0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(8, 0, 0, 0);
        selectColumnsPanel.add((Component)this.pruneColumnsCheckBox, constraints);
        return selectColumnsPanel;
    }
}

