/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.WriteOtherFileDialog;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WriteSASFileDialog
extends NodeDialog {
    private JComboBox typeComboBox;
    private JTextField fileNameTextField;
    private static String[] typeCodeList = new String[]{"SAS-WIN", "SASV6", "SAS1", "SAS4", "SAS_TPT"};
    private static String[] m_typeDescriptionList = new String[]{"SAS Version 7/8/9 (*.sas7bdat)", "SAS - Windows/OS2 (*.sd2)", "SAS - HP IBM & SUN Unix (*.ssd01)", "SAS - Dec Unix (*.ssd04)", "SAS Transport File (*.tpt;*.xpt)"};
    private static String[][] m_extensionList = new String[][]{{".sas7bdat"}, {".sd2"}, {".ssd01"}, {".ssd04"}, {".tpt", ".xpt"}};
    private AbstractAction fileNameTextFieldAction;
    private AbstractAction typeComboBoxAction;
    private AbstractAction saveAsAction;
    private static WriteSASFileDialog instance = null;

    public static WriteSASFileDialog getInstance() {
        if (instance == null) {
            instance = new WriteSASFileDialog();
        }
        return instance;
    }

    private WriteSASFileDialog() {
        this.setResizable(true);
        this.setSize(450, 400);
        this.setMinimumSize(new Dimension(450, 400));
    }

    public void onOk() {
        if (WriteOtherFileDialog.hasFilenameChanged(this.fileNameTextField, this.getNodeModel().getXTProps()) && !ReadOtherFileDialog.checkOverWriteFile(this, this.fileNameTextField.getText())) {
            return;
        }
        super.onOk();
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        String type = props.getValue("fileType", typeCodeList[0]);
        ReadOtherFileDialog.setComboBoxFromTypeString(type, typeCodeList, this.typeComboBox);
        this.fileNameTextField.setText(props.getValue("filePath", ""));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        String path = this.fileNameTextField.getText();
        WriteOtherFileDialog.directoryCreationCheck(this.tabbedPane, path);
        props.set("filePath", path);
        int sel = this.typeComboBox.getSelectedIndex();
        if (sel == -1) {
            throw new NodeDialog.DialogException("Unrecognized file type.  Please select file type.");
        }
        props.set("fileType", typeCodeList[sel]);
    }

    public void createActions() {
        super.createActions();
        this.fileNameTextFieldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkWriteFileName(WriteSASFileDialog.this.fileNameTextField, m_extensionList, WriteSASFileDialog.this.typeComboBox);
            }
        };
        this.typeComboBoxAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkFileNameOnComboBoxAction(WriteSASFileDialog.this.fileNameTextField, m_extensionList, WriteSASFileDialog.this.typeComboBox);
            }
        };
        this.saveAsAction = new AbstractAction(MinerApp.getText("WriteTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseWriteFileName(instance, WriteSASFileDialog.this.fileNameTextField, m_extensionList, m_typeDescriptionList, WriteSASFileDialog.this.typeComboBox);
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.fileNameTextField = new JTextField(25);
        this.fileNameTextField.setAction(this.fileNameTextFieldAction);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && WriteOtherFileDialog.hasFilenameChanged(WriteSASFileDialog.this.fileNameTextField, WriteSASFileDialog.this.getNodeModel().getXTProps())) {
                    ReadOtherFileDialog.checkWriteFileName(WriteSASFileDialog.this.fileNameTextField, m_extensionList, WriteSASFileDialog.this.typeComboBox);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("WriteTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(this.saveAsAction);
        browseButton.setMnemonic('b');
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel typeLabel = new JLabel(MinerApp.getText("WriteOtherFileDialog_type"));
        typeLabel.setDisplayedMnemonic(84);
        this.typeComboBox = new JComboBox<String>(m_typeDescriptionList);
        this.typeComboBox.setAction(this.typeComboBoxAction);
        typeLabel.setLabelFor(this.typeComboBox);
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        moreOptionsPanel.add((Component)typeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = new Insets(0, 65, 0, 0);
        moreOptionsPanel.add((Component)this.typeComboBox, optionsConstraints);
        optionsPanel.add((Component)saveFilePanel, "North");
        optionsPanel.add((Component)moreOptionsPanel, "Center");
        return optionsPanel;
    }
}

