/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XMLTree;
import com.insightful.miner.XMLTreeNetwork;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XTNetwork
extends XMLTreeNetwork
implements Serializable {
    private Vector m_nodeList = null;
    private Vector m_textNodeList = null;
    private Vector m_linkList = null;
    private HashMap m_nodes = null;
    private XMLInfo m_comments = null;
    private FileInfo m_fileInfo = null;
    private String m_linkType = null;
    private String m_lastUsedID = null;
    private boolean m_visibleANA = false;
    private boolean m_visibleCNA = false;
    private boolean m_visibleTN = false;
    private boolean m_visibleLinks = false;
    private XTProps m_worksheetProperties = null;
    private XTProps m_worksheetParameters = null;
    private boolean m_pre_version_7_0 = false;
    private String m_lastNodeID = null;
    private NodeInfo m_lastNode = null;

    public XTNetwork() throws Exception {
        this.m_nodeList = new Vector();
        this.m_linkList = new Vector();
        this.m_textNodeList = new Vector();
        this.m_nodes = new HashMap();
        try {
            this.setWorksheetProperties(new XTProps());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XTNetwork(XMLTree tree) throws Exception {
        this.init(tree);
    }

    public XTNetwork(Element elt) throws Exception {
        this();
        this.init(new XMLTree(elt));
    }

    public XTNetwork(XTNetwork net) throws Exception {
        if (net.m_nodeList != null) {
            this.m_nodeList = (Vector)net.m_nodeList.clone();
        }
        if (net.m_linkList != null) {
            this.m_linkList = (Vector)net.m_linkList.clone();
        }
        if (net.m_textNodeList != null) {
            this.m_textNodeList = (Vector)net.m_textNodeList.clone();
        }
        if (net.m_nodes != null) {
            this.m_nodes = this.copyHashMap(net.m_nodes, true);
        }
        if (net.m_comments != null) {
            this.m_comments = net.m_comments.copy();
        }
        if (net.m_fileInfo != null) {
            this.m_fileInfo = net.m_fileInfo.copy();
        }
        if (net.m_worksheetProperties != null) {
            this.m_worksheetProperties = (XTProps)net.m_worksheetProperties.copy();
        }
        if (net.m_worksheetParameters != null) {
            this.m_worksheetParameters = (XTProps)net.m_worksheetParameters.copy();
        }
        this.m_linkType = net.m_linkType;
        this.m_lastUsedID = net.m_lastUsedID;
        this.m_visibleANA = net.m_visibleANA;
        this.m_visibleCNA = net.m_visibleCNA;
        this.m_visibleLinks = net.m_visibleLinks;
    }

    private void init(XMLTree tree) throws Exception {
        StringReader reader = new StringReader(tree.writeToString());
        InputSource ins = new InputSource(reader);
        NetworkSaxHandler customHandler = new NetworkSaxHandler(this);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(ins, (DefaultHandler)customHandler);
    }

    public void addFlatLink(LinkInfo info) {
        if (!this.m_visibleLinks) {
            this.m_visibleLinks = info.container == null;
        }
        this.m_linkList.add(info);
    }

    public void addExternalLink(ExternalLinkInfo info) {
        if (!this.m_visibleLinks) {
            this.m_visibleLinks = info.container == null;
        }
        this.m_linkList.add(info);
    }

    public void addModelLink(ModelLinkInfo info) {
        if (!this.m_visibleLinks) {
            this.m_visibleLinks = info.container == null;
        }
        this.m_linkList.add(info);
    }

    public void addFlatNode(NodeInfo info) {
        String nodeID = info.nodeID;
        if (!this.m_visibleANA) {
            boolean bl = this.m_visibleANA = info.container == null;
        }
        if (this.m_nodes.get(nodeID) != null) {
            this.m_nodes.remove(nodeID);
            this.m_nodeList.remove(nodeID);
        }
        this.m_nodes.put(nodeID, info);
        this.m_nodeList.add(nodeID);
        this.m_lastNodeID = nodeID;
        this.m_lastNode = info;
    }

    public void addCollapsedNode(CollapsedNodeInfo info) {
        String nodeID = info.nodeID;
        if (!this.m_visibleCNA) {
            boolean bl = this.m_visibleCNA = info.container == null;
        }
        if (this.m_nodes.get(nodeID) != null) {
            this.m_nodes.remove(nodeID);
            this.m_nodeList.remove(nodeID);
        }
        this.m_nodes.put(nodeID, info);
        this.m_nodeList.add(nodeID);
        this.m_lastNodeID = null;
        this.m_lastNode = null;
    }

    public void addTextNode(TextNodeInfo info) {
        if (!this.m_visibleTN) {
            this.m_visibleTN = info.container == null;
        }
        this.m_textNodeList.add(info);
    }

    public void setLastUsedID(String id) {
        this.m_lastUsedID = id;
    }

    public void setLinkType(String type) {
        this.m_linkType = type;
    }

    public void setFileInfo(String author, String version, String filename, String created) {
        this.m_fileInfo = new FileInfo(author, version, filename, created);
    }

    public void setComments(XMLTree tree) {
        if (this.m_comments == null) {
            this.m_comments = new XMLInfo(tree);
        } else {
            this.m_comments.tree = tree;
        }
    }

    public void setComments(Element element) {
        try {
            XMLTree tree = new XMLTree(element);
            if (this.m_comments == null) {
                this.m_comments = new XMLInfo(tree);
            } else {
                this.m_comments.tree = tree;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setWorksheetProperties(XTProps props) {
        this.m_worksheetProperties = props;
    }

    public void setWorksheetParameters(XTProps props) {
        this.m_worksheetParameters = props;
    }

    public boolean isPreVersion70() {
        return this.m_pre_version_7_0;
    }

    public int getNumParams() {
        if (this.m_worksheetParameters != null) {
            return this.m_worksheetParameters.getSubProperties(new String[0]).size();
        }
        return 0;
    }

    public Vector getParamNames() {
        if (this.m_worksheetParameters != null) {
            return this.m_worksheetParameters.getSubProperties(new String[0]);
        }
        return new Vector();
    }

    public Vector getParamValues() {
        if (this.m_worksheetParameters != null) {
            return this.m_worksheetParameters.getSubPropertyValues(new String[0]);
        }
        return new Vector();
    }

    public String getLastUsedID() {
        return this.m_lastUsedID;
    }

    public String getLinkType() {
        return this.m_linkType;
    }

    public String getFileInfoAuthor() {
        if (this.m_fileInfo == null) {
            return "";
        }
        return this.m_fileInfo.author;
    }

    public String getFileInfoVersion() {
        if (this.m_fileInfo == null) {
            return "";
        }
        return this.m_fileInfo.version;
    }

    public String getFileInfoFilename() {
        if (this.m_fileInfo == null) {
            return "";
        }
        return this.m_fileInfo.filename;
    }

    public String getFileInfoCreated() {
        if (this.m_fileInfo == null) {
            return "";
        }
        return this.m_fileInfo.created;
    }

    public XMLTree getComments() {
        if (this.m_comments == null) {
            return null;
        }
        return this.m_comments.tree;
    }

    public XTProps getWorksheetProperties() {
        return this.m_worksheetProperties;
    }

    public XTProps getWorksheetParameters() {
        return this.m_worksheetParameters;
    }

    public Vector getVisibleNodesInfo() {
        Vector<Serializable> ret = new Vector<Serializable>();
        for (int i = 0; i < this.m_nodeList.size(); ++i) {
            Object obj = this.m_nodes.get(this.m_nodeList.get(i));
            if (obj instanceof NodeInfo) {
                if (((NodeInfo)obj).container != null) continue;
                ret.add((NodeInfo)obj);
                continue;
            }
            if (!(obj instanceof CollapsedNodeInfo) || ((CollapsedNodeInfo)obj).container != null) continue;
            ret.add((CollapsedNodeInfo)obj);
        }
        return ret;
    }

    public Vector getVisibleLinksInfo() {
        Vector<Serializable> ret = new Vector<Serializable>();
        for (int i = 0; i < this.m_linkList.size(); ++i) {
            Object obj = this.m_linkList.get(i);
            if (obj instanceof LinkInfo) {
                if (((LinkInfo)obj).container != null || ((LinkInfo)obj).inExternal) continue;
                ret.add((LinkInfo)obj);
                continue;
            }
            if (!(obj instanceof ExternalLinkInfo) || ((ExternalLinkInfo)obj).container != null) continue;
            ret.add((ExternalLinkInfo)obj);
        }
        return ret;
    }

    public CollapsedNodeInfo getCollapsedNodeInfo(String nodeID) {
        Object obj = this.m_nodes.get(nodeID);
        if (obj instanceof CollapsedNodeInfo) {
            return (CollapsedNodeInfo)obj;
        }
        return null;
    }

    public NodeInfo getNodeInfo(String nodeID) {
        Object obj = this.m_nodes.get(nodeID);
        if (obj instanceof NodeInfo) {
            return (NodeInfo)obj;
        }
        return null;
    }

    public Vector getFlatNodes() {
        Vector<String> ret = new Vector<String>();
        for (int i = 0; i < this.m_nodeList.size(); ++i) {
            Object obj = this.m_nodes.get(this.m_nodeList.get(i));
            if (!(obj instanceof NodeInfo)) continue;
            ret.add(((NodeInfo)obj).nodeID);
        }
        return ret;
    }

    public Vector getFlatLinks() {
        Vector ret = new Vector();
        for (int i = 0; i < this.m_linkList.size(); ++i) {
            Object obj = this.m_linkList.get(i);
            if (obj instanceof ModelLinkInfo) continue;
            if (obj instanceof LinkInfo) {
                ret.add(obj);
                continue;
            }
            if (!(obj instanceof ExternalLinkInfo)) continue;
        }
        int portNum = 0;
        Object[] array = ret.toArray();
        LinkComparator comparator = new LinkComparator();
        Arrays.sort(array, comparator);
        if (comparator.multiPortFound) {
            ret.removeAllElements();
            LinkInfo last = null;
            LinkInfo current = null;
            boolean count = false;
            boolean endCount = false;
            for (int i = 0; i < array.length; ++i) {
                current = (LinkInfo)array[i];
                if (i == 0) {
                    last = current;
                } else {
                    boolean sameToPort;
                    boolean sameToNode = current.getToNodeID().equals(last.getToNodeID());
                    boolean bl = sameToPort = current.getToInputPort() == last.getToInputPort();
                    if (!count) {
                        if (sameToNode) {
                            count = sameToPort;
                            portNum = 0;
                        }
                    } else if (!sameToNode) {
                        endCount = true;
                    }
                    if (count) {
                        if (portNum == 0) {
                            last.setToPort(portNum++);
                        }
                        if (endCount) {
                            endCount = false;
                            count = false;
                        } else {
                            current.setToPort(portNum++);
                        }
                    }
                }
                ret.add(current);
                last = current;
            }
        }
        return ret;
    }

    public String getEngineNodeClassName(String nodeID) {
        if (this.findFlatNode(nodeID)) {
            return this.m_lastNode.engineClass;
        }
        return "";
    }

    public XMLTree getModelProperties(String nodeID) {
        try {
            if (this.findFlatNode(nodeID)) {
                if (this.m_lastNode.model == null) {
                    return null;
                }
                return this.m_lastNode.model.getXMLTree();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getModelString(String nodeID) {
        try {
            if (this.findFlatNode(nodeID)) {
                if (this.m_lastNode.model == null) {
                    return null;
                }
                return this.m_lastNode.model.modelString;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getModelParent(String nodeID) {
        try {
            if (this.findFlatNode(nodeID)) {
                return this.m_lastNode.modelParent;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getExecuteAfter(String nodeID) {
        try {
            if (this.findFlatNode(nodeID)) {
                return this.m_lastNode.executeAfter;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Element getComponenetComments(String nodeID) {
        if (this.findFlatNode(nodeID)) {
            if (this.m_lastNode.comments == null) {
                return null;
            }
            return this.m_lastNode.comments.tree.getXML();
        }
        return null;
    }

    public Element getWorksheetComments() {
        if (this.m_comments == null) {
            return null;
        }
        return this.m_comments.tree.getXML();
    }

    public String getNodeName(String nodeID) {
        if (this.findFlatNode(nodeID)) {
            return this.m_lastNode.labelText;
        }
        return "";
    }

    public int getNodeNumInputs(String nodeID) {
        if (this.findFlatNode(nodeID)) {
            if (this.m_lastNode.numInputs != -1) {
                return this.m_lastNode.numInputs;
            }
            return this.countNumInputs(nodeID);
        }
        return 0;
    }

    public int getNodeNumOutputs(String nodeID) {
        if (this.findFlatNode(nodeID)) {
            return this.m_lastNode.numOutputs;
        }
        return 0;
    }

    public XTProps getNodeProperties(String nodeID) {
        if (this.findFlatNode(nodeID)) {
            return this.m_lastNode.properties;
        }
        return null;
    }

    public boolean setModelProperties(String nodeID, XMLTree modelProperties) {
        if (this.findFlatNode(nodeID)) {
            this.m_lastNode.model = new ModelInfo(modelProperties);
            return true;
        }
        return false;
    }

    public Vector getTextNodes() {
        return this.m_textNodeList;
    }

    public static void test() {
    }

    public static void paramaterize(XTNetwork origNetwork) {
        Vector paramNames = origNetwork.getParamNames();
        if (paramNames.size() == 0) {
            return;
        }
        Vector paramValues = origNetwork.getParamValues();
        for (int i = 0; i < origNetwork.m_nodeList.size(); ++i) {
            Object obj = origNetwork.m_nodes.get(origNetwork.m_nodeList.get(i));
            if (!(obj instanceof NodeInfo)) continue;
            ((NodeInfo)obj).properties.paramaterize(paramNames, paramValues);
        }
    }

    public static String convertToXML(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public XMLTree copy() {
        try {
            return new XTNetwork(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object clone() {
        return this.copy();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XTNetwork) {
            return this.equals((XTNetwork)obj);
        }
        return false;
    }

    public boolean equals(XMLTree obj) {
        if (obj instanceof XTNetwork) {
            return this.equals((XTNetwork)obj);
        }
        return false;
    }

    public boolean equals(XTNetwork obj) {
        return XTMetaData.nullCognizantCompare(this.m_nodeList, obj.m_nodeList) && XTMetaData.nullCognizantCompare(this.m_textNodeList, obj.m_textNodeList) && XTMetaData.nullCognizantCompare(this.m_linkList, obj.m_linkList) && XTMetaData.nullCognizantCompare(this.m_nodes, obj.m_nodes) && XTMetaData.nullCognizantCompare(this.m_comments, obj.m_comments) && XTMetaData.nullCognizantCompare(this.m_worksheetProperties, obj.m_worksheetProperties) && XTMetaData.nullCognizantCompare(this.m_worksheetParameters, obj.m_worksheetParameters) && XTMetaData.nullCognizantCompare(this.m_fileInfo, obj.m_fileInfo) && XTMetaData.nullCognizantCompare(this.m_linkType, obj.m_linkType) && XTMetaData.nullCognizantCompare(this.m_lastUsedID, obj.m_lastUsedID);
    }

    private boolean findFlatNode(String nodeID) {
        if (this.m_lastNodeID != null && nodeID.equals(this.m_lastNodeID)) {
            return true;
        }
        Object obj = this.m_nodes.get(nodeID);
        if (obj instanceof NodeInfo) {
            this.m_lastNodeID = nodeID;
            this.m_lastNode = (NodeInfo)obj;
            return true;
        }
        return false;
    }

    private HashMap copyHashMap(HashMap orig, boolean deep) {
        if (!deep) {
            return new HashMap(orig);
        }
        HashMap<String, Serializable> copy = new HashMap<String, Serializable>();
        Set keys = orig.keySet();
        for (String key : keys) {
            Object obj = orig.get(key);
            if (obj instanceof NodeInfo) {
                copy.put(key, ((NodeInfo)obj).copy());
                continue;
            }
            if (obj instanceof CollapsedNodeInfo) {
                copy.put(key, ((CollapsedNodeInfo)obj).copy());
                continue;
            }
            if (obj instanceof ExternalLinkInfo) {
                copy.put(key, ((ExternalLinkInfo)obj).copy());
                continue;
            }
            if (obj instanceof ModelLinkInfo) {
                copy.put(key, ((ModelLinkInfo)obj).copy());
                continue;
            }
            if (!(obj instanceof XMLTreeNetwork.Link)) continue;
            XMLTreeNetwork.Link ol = (XMLTreeNetwork.Link)obj;
            XMLTreeNetwork.Link nl = new XMLTreeNetwork.Link(ol.getFromNodeID(), ol.getFromOutputPort(), ol.getToNodeID(), ol.getToInputPort());
            copy.put(key, nl);
        }
        return copy;
    }

    protected int countNumInputs(String nodeID) {
        int ret = 0;
        for (int i = 0; i < this.m_linkList.size(); ++i) {
            Object obj = this.m_linkList.get(i);
            if (!(obj instanceof LinkInfo) || !nodeID.equals(((LinkInfo)obj).getToNodeID())) continue;
            ++ret;
        }
        return ret;
    }

    protected void addLinkToVector(Vector linkList, XMLTreeNetwork.Link link) {
        int toPort = link.getToInputPort();
        String toNode = link.getToNodeID();
        int linkListLength = linkList.size();
        int portNum = 0;
        for (int i = 0; i < linkListLength; ++i) {
            XMLTreeNetwork.Link item = (XMLTreeNetwork.Link)linkList.get(i);
            if (!item.getToNodeID().equals(toNode) || item.getToInputPort() != toPort && portNum == 0) continue;
            item.setToPort(portNum++);
        }
        if (portNum != 0) {
            link.setToPort(portNum);
        }
        linkList.add(link);
    }

    protected void getLinksFromExternalLink(ExternalLinkInfo eli, Vector linkList) {
        for (int i = 0; i < eli.links.size(); ++i) {
            Object obj = eli.links.get(i);
            if (obj instanceof LinkInfo) {
                this.addLinkToVector(linkList, (XMLTreeNetwork.Link)obj);
                continue;
            }
            if (!(obj instanceof ExternalLinkInfo)) continue;
            this.getLinksFromExternalLink((ExternalLinkInfo)obj, linkList);
        }
    }

    public String writeToString() {
        try {
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outs, "UTF-8");
            this.outputXML(writer);
            return outs.toString("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void outputXML(Writer writer) throws IOException {
        Object obj;
        String nodeID;
        int i;
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        writer.write("<" + XMLTree.IMML_NODE_TAG + " " + XMLTree.IMML_VERSION_ATTRIBUTE_TAG + "=\"" + XMLTree.CURRENT_VERSION_ATTRIBUTE_TAG + "\">\n");
        writer.write("\t<" + NETWORK_NODE_TAG + " " + LAST_NODE_ID_ATTRIBUTE_TAG + "=\"" + this.m_lastUsedID + "\" " + LINK_TYPE_ATTRIBUTE_TAG + "=\"" + this.m_linkType + "\">\n");
        if (this.m_fileInfo != null) {
            this.m_fileInfo.write(writer, "\t\t");
        }
        if (this.m_worksheetProperties != null) {
            writer.write("\t\t<" + WORKSHEET_PROPERTIES_NODE_TAG + ">\n");
            this.m_worksheetProperties.outputXML(writer, false, "\t\t\t");
            writer.write("\t\t</" + WORKSHEET_PROPERTIES_NODE_TAG + ">\n");
        }
        if (this.m_worksheetParameters != null) {
            writer.write("\t\t<" + WORKSHEET_PARAMETERS_NODE_TAG + ">\n");
            this.m_worksheetParameters.outputXML(writer, false, "\t\t\t");
            writer.write("\t\t</" + WORKSHEET_PARAMETERS_NODE_TAG + ">\n");
        }
        if (this.m_comments != null && this.m_comments.tree != null) {
            this.m_comments.write(writer, "\t\t");
        }
        if (!this.m_visibleANA) {
            writer.write("\t\t<" + ACTIVITY_NODE_LIST_NODE_TAG + " />\n");
        } else {
            writer.write("\t\t<" + ACTIVITY_NODE_LIST_NODE_TAG + ">\n");
            for (i = 0; i < this.m_nodeList.size(); ++i) {
                nodeID = (String)this.m_nodeList.get(i);
                obj = this.m_nodes.get(nodeID);
                if (!(obj instanceof NodeInfo) || ((NodeInfo)obj).container != null) continue;
                ((NodeInfo)obj).write(writer, "\t\t\t");
            }
            writer.write("\t\t</" + ACTIVITY_NODE_LIST_NODE_TAG + ">\n");
        }
        if (!this.m_visibleTN) {
            writer.write("\t\t<" + TEXT_NODE_LIST_NODE_TAG + " />\n");
        } else {
            writer.write("\t\t<" + TEXT_NODE_LIST_NODE_TAG + ">\n");
            for (i = 0; i < this.m_textNodeList.size(); ++i) {
                TextNodeInfo ni = (TextNodeInfo)this.m_textNodeList.get(i);
                if (ni.container != null) continue;
                ni.write(writer, "\t\t\t");
            }
            writer.write("\t\t</" + TEXT_NODE_LIST_NODE_TAG + ">\n");
        }
        if (!this.m_visibleCNA) {
            writer.write("\t\t<" + COLLAPSED_NODE_LIST_NODE_TAG + " />\n");
        } else {
            writer.write("\t\t<" + COLLAPSED_NODE_LIST_NODE_TAG + ">\n");
            for (i = 0; i < this.m_nodeList.size(); ++i) {
                nodeID = (String)this.m_nodeList.get(i);
                obj = this.m_nodes.get(nodeID);
                if (!(obj instanceof CollapsedNodeInfo) || ((CollapsedNodeInfo)obj).container != null) continue;
                this.writeCNA((CollapsedNodeInfo)obj, writer, "\t\t\t");
            }
            writer.write("\t\t</" + COLLAPSED_NODE_LIST_NODE_TAG + ">\n");
        }
        if (!this.m_visibleLinks) {
            writer.write("\t\t<" + LINK_LIST_NODE_TAG + " />\n");
        } else {
            writer.write("\t\t<" + LINK_LIST_NODE_TAG + ">\n");
            for (i = 0; i < this.m_linkList.size(); ++i) {
                Object obj2 = this.m_linkList.get(i);
                if (obj2 instanceof LinkInfo) {
                    if (((LinkInfo)obj2).inExternal || ((LinkInfo)obj2).container != null) continue;
                    ((LinkInfo)obj2).write(writer, "\t\t\t");
                    continue;
                }
                if (!(obj2 instanceof ExternalLinkInfo) || ((ExternalLinkInfo)obj2).container != null) continue;
                ((ExternalLinkInfo)obj2).write(writer, "\t\t\t");
            }
            writer.write("\t\t</" + LINK_LIST_NODE_TAG + ">\n");
        }
        writer.write("\t</" + NETWORK_NODE_TAG + ">\n");
        writer.write("</" + XMLTree.IMML_NODE_TAG + ">\n");
        writer.flush();
    }

    public void writeCNA(CollapsedNodeInfo info, Writer writer, String indent) throws IOException {
        Object obj;
        Object obj2;
        writer.write(indent + "<" + COLLAPSED_NODE_NODE_TAG + " " + ID_ATTRIBUTE_TAG + "=\"" + info.nodeID + "\">\n");
        writer.write(indent + "\t<" + DISPLAY_INFO_NODE_TAG + " " + LABEL_TEXT_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(info.labelText) + "\" " + X_ATTRIBUTE_TAG + "=\"" + info.x + "\" " + Y_ATTRIBUTE_TAG + "=\"" + info.y + "\" ");
        if (info.helpFile != null) {
            writer.write(HELP_FILE_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(info.helpFile) + "\" ");
        }
        if (info.largeIcon != null) {
            writer.write(LARGE_ICON_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(info.largeIcon) + "\" ");
        }
        if (info.smallIcon != null) {
            writer.write(SMALL_ICON_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(info.smallIcon) + "\" ");
        }
        writer.write("/>\n");
        if (info.comments != null) {
            info.comments.write(writer, indent + "\t");
        }
        for (int output = 0; output < 2; ++output) {
            Vector ports;
            Vector vector = ports = output == 0 ? info.inputPorts : info.outputPorts;
            if (output == 0) {
                writer.write(indent + "\t<" + INPUT_PORT_LIST_NODE_TAG);
            } else {
                writer.write(indent + "\t<" + OUTPUT_PORT_LIST_NODE_TAG);
            }
            for (int i = 0; i < ports.size(); ++i) {
                if (i == 0) {
                    writer.write(">\n");
                }
                if (!((obj2 = ports.get(i)) instanceof PortInfo)) continue;
                ((PortInfo)obj2).write(writer, indent + "\t\t");
            }
            if (ports.size() == 0) {
                writer.write(" />\n");
                continue;
            }
            if (output == 0) {
                writer.write(indent + "\t</" + INPUT_PORT_LIST_NODE_TAG + ">\n");
                continue;
            }
            writer.write(indent + "\t</" + OUTPUT_PORT_LIST_NODE_TAG + ">\n");
        }
        boolean visibleANAs = false;
        writer.write(indent + "\t<" + ACTIVITY_NODE_LIST_NODE_TAG);
        for (int i = 0; i < info.nodes.size(); ++i) {
            String nodeID = (String)info.nodes.get(i);
            obj2 = this.m_nodes.get(nodeID);
            if (!(obj2 instanceof NodeInfo)) continue;
            if (!visibleANAs) {
                writer.write(">\n");
                visibleANAs = true;
            }
            ((NodeInfo)obj2).write(writer, indent + "\t\t");
        }
        if (visibleANAs) {
            writer.write(indent + "\t</" + ACTIVITY_NODE_LIST_NODE_TAG + ">\n");
        } else {
            writer.write(" />\n");
        }
        boolean visibleTNs = false;
        writer.write(indent + "\t<" + TEXT_NODE_LIST_NODE_TAG);
        for (int i = 0; i < info.textNodes.size(); ++i) {
            obj2 = (TextNodeInfo)info.textNodes.get(i);
            if (!visibleTNs) {
                writer.write(">\n");
                visibleTNs = true;
            }
            ((TextNodeInfo)obj2).write(writer, indent + "\t\t");
        }
        if (visibleTNs) {
            writer.write(indent + "\t</" + TEXT_NODE_LIST_NODE_TAG + ">\n");
        } else {
            writer.write(" />\n");
        }
        boolean visibleCNAs = false;
        writer.write(indent + "\t<" + COLLAPSED_NODE_LIST_NODE_TAG);
        for (int i = 0; i < info.nodes.size(); ++i) {
            String nodeID = (String)info.nodes.get(i);
            obj = this.m_nodes.get(nodeID);
            if (!(obj instanceof CollapsedNodeInfo)) continue;
            if (!visibleCNAs) {
                writer.write(">\n");
                visibleCNAs = true;
            }
            this.writeCNA((CollapsedNodeInfo)obj, writer, indent + "\t\t");
        }
        if (visibleCNAs) {
            writer.write(indent + "\t</" + COLLAPSED_NODE_LIST_NODE_TAG + ">\n");
        } else {
            writer.write(" />\n");
        }
        boolean visibleLINKs = false;
        writer.write(indent + "\t<" + LINK_LIST_NODE_TAG);
        for (int i = 0; i < info.links.size(); ++i) {
            obj = info.links.get(i);
            if (!visibleLINKs) {
                writer.write(">\n");
                visibleLINKs = true;
            }
            if (obj instanceof LinkInfo) {
                ((LinkInfo)obj).write(writer, indent + "\t\t");
                continue;
            }
            ((ExternalLinkInfo)obj).write(writer, indent + "\t\t");
        }
        if (visibleLINKs) {
            writer.write(indent + "\t</" + LINK_LIST_NODE_TAG + ">\n");
        } else {
            writer.write(" />\n");
        }
        writer.write(indent + "</" + COLLAPSED_NODE_NODE_TAG + ">\n");
        writer.flush();
    }

    public OutputStream getHtmlOutputStream(String xslFilename, String title) {
        ByteArrayOutputStream htmlByteStream = new ByteArrayOutputStream();
        try {
            StringReader reader = new StringReader(this.writeToString());
            InputSource is = new InputSource(reader);
            SAXSource xmlSource = new SAXSource(is);
            StreamResult htmlResult = new StreamResult(htmlByteStream);
            Transformer xslTransformer = null;
            if (xslTransformerMap == null) {
                xslTransformerMap = new HashMap();
                transformerFactory = TransformerFactory.newInstance();
            } else {
                xslTransformer = (Transformer)xslTransformerMap.get(xslFilename);
            }
            if (xslTransformer == null) {
                StreamSource xslStream = new StreamSource(xslFilename);
                xslTransformer = transformerFactory.newTransformer(xslStream);
                xslTransformerMap.put(xslFilename, xslTransformer);
            }
            xslTransformer.transform(xmlSource, htmlResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            htmlByteStream = null;
        }
        return htmlByteStream;
    }

    public static XTNetwork readXTNetworkFromFile(String filename) {
        try {
            FileInputStream ins = new FileInputStream(filename);
            return XTNetwork.readXTNetworkFromFile(ins);
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static XTNetwork readXTNetworkFromFile(InputStream ins) {
        try {
            XTNetwork net = new XTNetwork();
            NetworkSaxHandler customHandler = new NetworkSaxHandler(net);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(ins, (DefaultHandler)customHandler);
            ins.close();
            return net;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveToFile(String filename) {
        try {
            FileOutputStream outs = new FileOutputStream(filename);
            this.saveToFile(outs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToFile(FileOutputStream outs) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outs, "UTF-8");
            this.outputXML(writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLTreeNetwork getXMLTreeNetwork() {
        XMLTreeNetwork ret = null;
        try {
            ret = this.convertToXMLTreeNetwork();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Element getXML() {
        return this.getXMLTreeNetwork().networkRootNode;
    }

    public Document getDocument() {
        return this.getXMLTreeNetwork().getDocument();
    }

    private XMLTreeNetwork convertToXMLTreeNetwork() {
        try {
            XMLTreeNetwork converted = new XMLTreeNetwork();
            return converted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class NetworkSaxHandler
    extends DefaultHandler {
        private static String m_splusIcon = "splus_";
        private static String m_splus = "Splus";
        private XTNetwork m_network = null;
        private Stack m_stack = new Stack();
        private CollapsedNodeInfo m_cNI = null;
        private Vector m_collapsedPortList = null;
        private NodeInfo m_NI = null;
        private TextNodeInfo m_TNI = null;
        private LinkInfo m_L = null;
        private ModelLinkInfo m_MLI = null;
        private ExternalLinkInfo m_ELI = null;
        private boolean m_getProperties = false;
        private XTProps m_XTP = null;
        private XMLTree m_XT = null;
        private StringBuffer m_XML = null;
        private boolean m_empty = false;
        private XTProps.PropsSaxHandler m_propsHandler = null;
        private DocumentBuilder m_builder = null;
        private FileInfo m_fileInfo = null;
        private boolean m_author = false;
        private boolean m_filename = false;
        private boolean m_created = false;
        private boolean m_version = false;
        private boolean m_version_1_0 = false;
        private boolean m_changeToSplusNode = false;
        private boolean m_worksheetProperties = false;
        private boolean m_worksheetParameters = false;

        public NetworkSaxHandler(XTNetwork en) throws Exception {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.m_builder = factory.newDocumentBuilder();
            this.m_network = en;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.m_propsHandler != null) {
                this.m_propsHandler.startElement(uri, localName, qName, attributes);
            }
            if (this.m_XML != null) {
                this.m_XML.append("<" + qName);
                if (attributes.getLength() == 0) {
                    this.m_XML.append(">");
                } else {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String qname = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        this.m_XML.append(" " + qname + "=\"" + value + "\"");
                    }
                    this.m_XML.append(">");
                }
                this.m_empty = true;
            } else if (qName.equals(XMLTree.IMML_NODE_TAG)) {
                this.m_version_1_0 = attributes.getValue(XMLTree.IMML_VERSION_ATTRIBUTE_TAG).equals("1.00");
                try {
                    double val = Double.parseDouble(attributes.getValue(XMLTree.IMML_VERSION_ATTRIBUTE_TAG));
                    this.m_network.m_pre_version_7_0 = val < 7.0;
                }
                catch (Exception e) {
                    this.m_network.m_pre_version_7_0 = false;
                }
            } else if (qName.equals(NETWORK_NODE_TAG)) {
                this.m_network.m_lastUsedID = attributes.getValue(LAST_NODE_ID_ATTRIBUTE_TAG);
                this.m_network.m_linkType = attributes.getValue(LINK_TYPE_ATTRIBUTE_TAG);
            } else if (qName.equals(FILE_INFO_NODE_TAG)) {
                this.m_fileInfo = new FileInfo();
            } else if (qName.equals(FILE_AUTHOR_NODE_TAG)) {
                this.m_author = true;
            } else if (qName.equals(FILE_VERSION_NODE_TAG)) {
                this.m_version = true;
            } else if (qName.equals(FILE_NAME_NODE_TAG)) {
                this.m_filename = true;
            } else if (qName.equals(FILE_DATE_CREATED_NODE_TAG)) {
                this.m_created = true;
            } else if (qName.equals(COMPONENT_COMMENTS_NODE_TAG)) {
                this.m_XML = new StringBuffer("<" + COMPONENT_COMMENTS_NODE_TAG + ">");
            } else if (qName.equals(MODEL_PROPERTIES_NODE_TAG)) {
                this.m_XML = new StringBuffer();
            } else if (qName.equals(TEXT_NODE_NODE_TAG)) {
                this.m_TNI = new TextNodeInfo();
                this.m_TNI.labelText = attributes.getValue(LABEL_TEXT_ATTRIBUTE_TAG);
                this.m_TNI.fontName = attributes.getValue(FONT_NAME_ATTRIBUTE_TAG);
                this.m_TNI.fontSize = Integer.parseInt(attributes.getValue(FONT_SIZE_ATTRIBUTE_TAG));
                this.m_TNI.fontColor = Integer.parseInt(attributes.getValue(FONT_COLOR_ATTRIBUTE_TAG));
                this.m_TNI.backgroundColor = Integer.parseInt(attributes.getValue(BACKGROUND_COLOR_ATTRIBUTE_TAG));
                this.m_TNI.italic = attributes.getValue(ITALIC_ATTRIBUTE_TAG).equals("true");
                this.m_TNI.bold = attributes.getValue(BOLD_ATTRIBUTE_TAG).equals("true");
                this.m_TNI.x = Integer.parseInt(attributes.getValue(X_ATTRIBUTE_TAG));
                this.m_TNI.y = Integer.parseInt(attributes.getValue(Y_ATTRIBUTE_TAG));
            } else if (qName.equals(ACTIVITY_NODE_NODE_TAG)) {
                this.m_NI = new NodeInfo();
                String engineClass = attributes.getValue(ENGINE_CLASS_ATTRIBUTE_TAG);
                boolean bl = this.m_changeToSplusNode = this.m_version_1_0 && (engineClass.equals("com.insightful.miner.CreateColumnsEngineNode") || engineClass.equals("com.insightful.miner.FilterRowsEngineNode") || engineClass.equals("com.insightful.miner.SplitEngineNode"));
                if (this.m_changeToSplusNode) {
                    int pos = engineClass.lastIndexOf(".");
                    String packageName = engineClass.substring(0, pos + 1);
                    String className = engineClass.substring(pos + 1, engineClass.length());
                    this.m_NI.engineClass = packageName + m_splus + className;
                    className = attributes.getValue(GUI_CLASS_ATTRIBUTE_TAG);
                    pos = className.lastIndexOf(".");
                    packageName = className.substring(0, pos + 1);
                    className = className.substring(pos + 1, className.length());
                    this.m_NI.guiClass = packageName + m_splus + className;
                } else {
                    this.m_NI.guiClass = attributes.getValue(GUI_CLASS_ATTRIBUTE_TAG);
                    this.m_NI.engineClass = engineClass;
                }
                this.m_NI.nodeID = attributes.getValue(ID_ATTRIBUTE_TAG);
                this.m_NI.numInputs = Integer.parseInt(attributes.getValue(NUM_INPUTS_ATTRIBUTE_TAG));
                this.m_NI.numOutputs = Integer.parseInt(attributes.getValue(NUM_OUTPUTS_ATTRIBUTE_TAG));
            } else if (qName.equals(DISPLAY_INFO_NODE_TAG)) {
                if (this.m_cNI != null && this.m_cNI.labelText == null) {
                    this.m_cNI.labelText = attributes.getValue(LABEL_TEXT_ATTRIBUTE_TAG);
                    this.m_cNI.helpFile = attributes.getValue(HELP_FILE_ATTRIBUTE_TAG);
                    this.m_cNI.largeIcon = attributes.getValue(LARGE_ICON_ATTRIBUTE_TAG);
                    this.m_cNI.smallIcon = attributes.getValue(SMALL_ICON_ATTRIBUTE_TAG);
                    this.m_cNI.x = Integer.parseInt(attributes.getValue(X_ATTRIBUTE_TAG));
                    this.m_cNI.y = Integer.parseInt(attributes.getValue(Y_ATTRIBUTE_TAG));
                } else {
                    if (this.m_changeToSplusNode) {
                        String dLabel;
                        String label = attributes.getValue(LABEL_TEXT_ATTRIBUTE_TAG);
                        this.m_NI.labelText = label.startsWith(dLabel = attributes.getValue(DEFAULT_LABEL_TEXT_ATTRIBUTE_TAG)) ? m_splus + " " + label : label;
                        this.m_NI.defaultLabelText = m_splus + " " + dLabel;
                        this.m_NI.smallIcon = m_splusIcon + attributes.getValue(SMALL_ICON_ATTRIBUTE_TAG);
                        this.m_NI.largeIcon = m_splusIcon + attributes.getValue(LARGE_ICON_ATTRIBUTE_TAG);
                    } else {
                        this.m_NI.labelText = attributes.getValue(LABEL_TEXT_ATTRIBUTE_TAG);
                        this.m_NI.defaultLabelText = attributes.getValue(DEFAULT_LABEL_TEXT_ATTRIBUTE_TAG);
                        this.m_NI.smallIcon = attributes.getValue(SMALL_ICON_ATTRIBUTE_TAG);
                        this.m_NI.largeIcon = attributes.getValue(LARGE_ICON_ATTRIBUTE_TAG);
                    }
                    this.m_NI.x = Integer.parseInt(attributes.getValue(X_ATTRIBUTE_TAG));
                    this.m_NI.y = Integer.parseInt(attributes.getValue(Y_ATTRIBUTE_TAG));
                }
            } else if (qName.equals(INPUT_PORT_TOOL_TIPS_NODE_TAG)) {
                int numToolTips = this.m_NI.numInputs > -1 ? this.m_NI.numInputs : 1;
                this.m_NI.inputPortToolTips = new String[numToolTips];
                for (int i = 0; i < numToolTips; ++i) {
                    String tTip = attributes.getValue("port" + Integer.toString(i + 1));
                    if (tTip == null || tTip.length() <= 0) continue;
                    this.m_NI.inputPortToolTips[i] = tTip;
                }
            } else if (qName.equals(OUTPUT_PORT_TOOL_TIPS_NODE_TAG)) {
                int numToolTips = this.m_NI.numOutputs > -1 ? this.m_NI.numOutputs : 1;
                this.m_NI.outputPortToolTips = new String[numToolTips];
                for (int i = 0; i < numToolTips; ++i) {
                    String tTip = attributes.getValue("port" + Integer.toString(i + 1));
                    if (tTip == null || tTip.length() <= 0) continue;
                    this.m_NI.outputPortToolTips[i] = tTip;
                }
            } else if (qName.equals(ARGUMENT_LIST_NODE_TAG)) {
                this.m_getProperties = true;
            } else if (qName.equals(WORKSHEET_PROPERTIES_NODE_TAG)) {
                this.m_getProperties = true;
                this.m_worksheetProperties = true;
            } else if (qName.equals(WORKSHEET_PARAMETERS_NODE_TAG)) {
                this.m_getProperties = true;
                this.m_worksheetParameters = true;
            } else if (qName.equals(EXECUTE_AFTER_NODE_TAG)) {
                this.m_NI.executeAfter = attributes.getValue(ID_ATTRIBUTE_TAG);
            } else if (qName.equals(MODEL_PARENT_NODE_TAG)) {
                this.m_NI.modelParent = attributes.getValue(ID_ATTRIBUTE_TAG);
            } else if (qName.equals(XTProps.XT_PROPERTY_NODE_TAG)) {
                if (this.m_getProperties) {
                    try {
                        this.m_XTP = new XTProps();
                        this.m_propsHandler = new XTProps.PropsSaxHandler(this.m_XTP);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.m_propsHandler = null;
                        this.m_XTP = null;
                    }
                }
            } else if (qName.equals(COLLAPSED_NODE_NODE_TAG)) {
                String container = null;
                if (this.m_cNI != null) {
                    this.m_stack.push(this.m_cNI);
                    container = this.m_cNI.nodeID;
                }
                this.m_cNI = new CollapsedNodeInfo();
                this.m_cNI.container = container;
                this.m_cNI.nodeID = attributes.getValue(ID_ATTRIBUTE_TAG);
            } else if (qName.equals(INPUT_PORT_LIST_NODE_TAG)) {
                this.m_collapsedPortList = new Vector();
            } else if (qName.equals(OUTPUT_PORT_LIST_NODE_TAG)) {
                this.m_collapsedPortList = new Vector();
            } else if (qName.equals(PORT_INFO_NODE_TAG)) {
                PortInfo pi = new PortInfo();
                pi.nodeID = attributes.getValue(TO_NODE_ATTRIBUTE_TAG);
                pi.toolTip = attributes.getValue(TOOLTIP_ATTRIBUTE_TAG);
                String booleanTrueString = Boolean.toString(true);
                pi.visible = attributes.getValue(VISIBLE_ATTRIBUTE_TAG).equals(booleanTrueString);
                pi.input = attributes.getValue(INPUT_TYPE_ATTRIBUTE_TAG).equals(booleanTrueString);
                pi.portNum = Integer.parseInt(attributes.getValue(TO_PORT_ATTRIBUTE_TAG));
                this.m_collapsedPortList.add(pi);
            } else if (qName.equals(LINK_NODE_TAG)) {
                this.m_L = new LinkInfo();
                if (this.m_cNI != null) {
                    this.m_L.container = this.m_cNI.nodeID;
                }
                String fromID = attributes.getValue(FROM_NODE_ATTRIBUTE_TAG);
                int fromPort = Integer.parseInt(attributes.getValue(FROM_PORT_ATTRIBUTE_TAG));
                this.m_L.setFromInfo(fromID, fromPort);
                String toID = attributes.getValue(TO_NODE_ATTRIBUTE_TAG);
                int toPort = Integer.parseInt(attributes.getValue(TO_PORT_ATTRIBUTE_TAG));
                this.m_L.setToInfo(toID, toPort);
                String orth = attributes.getValue(ORTHOGONAL_LINK_ATTRIBUTE_TAG);
                this.m_L.isOrthog = orth != null ? orth.equals("true") : this.m_network.m_linkType.equals(ORTHOGONAL_LINK_ATTRIBUTE_TAG);
            } else if (qName.equals(MODEL_LINK_NODE_TAG)) {
                this.m_MLI = new ModelLinkInfo();
                if (this.m_cNI != null) {
                    this.m_MLI.container = this.m_cNI.nodeID;
                }
                String fromID = attributes.getValue(FROM_NODE_ATTRIBUTE_TAG);
                int fromPort = Integer.parseInt(attributes.getValue(FROM_PORT_ATTRIBUTE_TAG));
                this.m_MLI.setFromInfo(fromID, fromPort);
                String toID = attributes.getValue(TO_NODE_ATTRIBUTE_TAG);
                int toPort = Integer.parseInt(attributes.getValue(TO_PORT_ATTRIBUTE_TAG));
                this.m_MLI.setToInfo(toID, toPort);
                String orth = attributes.getValue(ORTHOGONAL_LINK_ATTRIBUTE_TAG);
                this.m_MLI.isOrthog = orth != null ? orth.equals("true") : this.m_network.m_linkType.equals(ORTHOGONAL_LINK_ATTRIBUTE_TAG);
            } else if (qName.equals(LINK_HISTORY_NODE_TAG)) {
                String container;
                String string = container = this.m_cNI == null ? null : this.m_cNI.nodeID;
                if (this.m_ELI == null) {
                    this.m_ELI = new ExternalLinkInfo(this.m_L.getToNodeID(), this.m_L.getToInputPort(), this.m_L.getFromNodeID(), this.m_L.getFromOutputPort(), container, null, this.m_L.isOrthog);
                }
                this.m_L = new LinkInfo();
                this.m_L.inExternal = true;
                String fromID = attributes.getValue(FROM_NODE_ATTRIBUTE_TAG);
                int fromPort = Integer.parseInt(attributes.getValue(FROM_PORT_ATTRIBUTE_TAG));
                this.m_L.setFromInfo(fromID, fromPort);
                String toID = attributes.getValue(TO_NODE_ATTRIBUTE_TAG);
                int toPort = Integer.parseInt(attributes.getValue(TO_PORT_ATTRIBUTE_TAG));
                this.m_L.setToInfo(toID, toPort);
                String orth = attributes.getValue(ORTHOGONAL_LINK_ATTRIBUTE_TAG);
                this.m_L.isOrthog = orth != null ? orth.equals("true") : this.m_network.m_linkType.equals(ORTHOGONAL_LINK_ATTRIBUTE_TAG);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.m_propsHandler != null) {
                this.m_propsHandler.characters(ch, start, length);
            } else {
                String test = new String(ch, start, length);
                if (test.trim().length() > 0) {
                    if (this.m_XML != null) {
                        String xmlFriendly = XTNetwork.convertToXML(test);
                        this.m_XML.append(xmlFriendly);
                        this.m_empty = false;
                    } else if (this.m_fileInfo != null) {
                        if (this.m_filename) {
                            this.m_fileInfo.filename = new String(ch, start, length);
                        } else if (this.m_author) {
                            this.m_fileInfo.author = new String(ch, start, length);
                        } else if (this.m_version) {
                            this.m_fileInfo.version = new String(ch, start, length);
                        } else if (this.m_created) {
                            this.m_fileInfo.created = new String(ch, start, length);
                        }
                    }
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.m_propsHandler != null) {
                this.m_propsHandler.endElement(uri, localName, qName);
                if (qName.equals(XTProps.XT_PROPERTY_NODE_TAG)) {
                    if (this.m_NI != null) {
                        this.m_NI.properties = this.m_XTP;
                    } else if (this.m_worksheetProperties) {
                        this.m_network.setWorksheetProperties(this.m_XTP);
                    } else if (this.m_worksheetParameters) {
                        this.m_network.setWorksheetParameters(this.m_XTP);
                    }
                    this.m_propsHandler = null;
                    this.m_XTP = null;
                }
            }
            if (this.m_XML != null && !qName.equals(COMPONENT_COMMENTS_NODE_TAG) && !qName.equals(MODEL_PROPERTIES_NODE_TAG)) {
                int length = this.m_XML.length();
                if (this.m_empty && this.m_XML.charAt(length - 1) == '>') {
                    this.m_XML.insert(length - 1, '/');
                } else {
                    this.m_XML.append("</" + qName + ">");
                }
                this.m_empty = false;
            } else if (qName.equals(FILE_INFO_NODE_TAG)) {
                this.m_network.m_fileInfo = this.m_fileInfo;
                this.m_fileInfo = null;
            } else if (qName.equals(FILE_AUTHOR_NODE_TAG)) {
                this.m_author = false;
            } else if (qName.equals(FILE_NAME_NODE_TAG)) {
                this.m_filename = false;
            } else if (qName.equals(FILE_DATE_CREATED_NODE_TAG)) {
                this.m_created = false;
            } else if (qName.equals(FILE_VERSION_NODE_TAG)) {
                this.m_version = false;
            } else if (qName.equals(COMPONENT_COMMENTS_NODE_TAG)) {
                this.m_XML.append("</" + COMPONENT_COMMENTS_NODE_TAG + ">");
                XMLInfo info = new XMLInfo();
                if (this.m_NI == null && this.m_cNI == null) {
                    this.m_network.m_comments = info;
                } else if (this.m_NI == null) {
                    this.m_cNI.comments = info;
                } else {
                    this.m_NI.comments = info;
                }
                try {
                    StringReader reader = new StringReader(this.m_XML.toString());
                    InputSource is = new InputSource(reader);
                    Document document = this.m_builder.parse(is);
                    info.tree = new XMLTree((Element)document.getFirstChild());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    try {
                        info.tree = new XMLTree();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        info.tree = null;
                    }
                }
                this.m_XML = null;
            } else if (qName.equals(MODEL_PROPERTIES_NODE_TAG)) {
                this.m_NI.model = new ModelInfo(this.m_XML.toString());
                this.m_XML = null;
            } else if (qName.equals(TEXT_NODE_NODE_TAG)) {
                if (this.m_cNI != null) {
                    this.m_cNI.textNodes.add(this.m_TNI);
                    this.m_TNI.container = this.m_cNI.nodeID;
                } else {
                    this.m_network.addTextNode(this.m_TNI);
                }
                this.m_TNI = null;
            } else if (qName.equals(ACTIVITY_NODE_NODE_TAG)) {
                String type;
                String ver;
                this.m_network.addFlatNode(this.m_NI);
                if (this.m_cNI != null) {
                    this.m_cNI.nodes.add(this.m_NI.nodeID);
                    this.m_NI.container = this.m_cNI.nodeID;
                }
                if (((ver = ((XTNetwork)this.m_network).m_fileInfo.version) == null || Double.parseDouble(ver) < 3.0) && this.m_NI.guiClass.equals("com.insightful.miner.ReadOtherFileNodeModel") && (type = this.m_NI.properties.getValue("fileType")).equals("EXCEL")) {
                    this.m_NI.guiClass = "com.insightful.miner.ReadExcelFileNodeModel";
                    this.m_NI.engineClass = "com.insightful.miner.ReadExcelFileEngineNode";
                    this.m_NI.defaultLabelText = "Read Excel File";
                    this.m_NI.labelText = this.m_NI.labelText.replaceFirst("Read Other File", "Read Excel File");
                    this.m_NI.smallIcon = "read_excel_small.gif";
                    this.m_NI.largeIcon = "read_excel_large.gif";
                }
                this.m_NI = null;
            } else if (qName.equals(COLLAPSED_NODE_NODE_TAG)) {
                this.m_network.addCollapsedNode(this.m_cNI);
                CollapsedNodeInfo tInfo = this.m_cNI;
                if (this.m_stack.isEmpty()) {
                    this.m_cNI = null;
                } else {
                    this.m_cNI = (CollapsedNodeInfo)this.m_stack.pop();
                    this.m_cNI.nodes.add(tInfo.nodeID);
                }
            } else if (qName.equals(INPUT_PORT_LIST_NODE_TAG)) {
                this.m_cNI.inputPorts = this.m_collapsedPortList;
                this.m_collapsedPortList = null;
            } else if (qName.equals(OUTPUT_PORT_LIST_NODE_TAG)) {
                this.m_cNI.outputPorts = this.m_collapsedPortList;
                this.m_collapsedPortList = null;
            } else if (qName.equals(LINK_HISTORY_NODE_TAG)) {
                this.m_network.addFlatLink(this.m_L);
                this.m_ELI.links.add(this.m_L);
            } else if (qName.equals(MODEL_LINK_NODE_TAG)) {
                this.m_network.addModelLink(this.m_MLI);
                if (this.m_cNI != null) {
                    this.m_cNI.links.add(this.m_MLI);
                }
            } else if (qName.equals(LINK_NODE_TAG)) {
                if (this.m_collapsedPortList != null) {
                    this.m_collapsedPortList.add(this.m_L);
                    this.m_L = null;
                } else if (this.m_ELI != null) {
                    this.m_network.addExternalLink(this.m_ELI);
                    if (this.m_cNI != null) {
                        this.m_cNI.links.add(this.m_ELI);
                    }
                    this.m_ELI = null;
                } else {
                    this.m_network.addFlatLink(this.m_L);
                    if (this.m_cNI != null) {
                        this.m_cNI.links.add(this.m_L);
                    }
                    this.m_L = null;
                }
            } else if (qName.equals(ARGUMENT_LIST_NODE_TAG)) {
                this.m_getProperties = false;
            } else if (qName.equals(WORKSHEET_PROPERTIES_NODE_TAG)) {
                this.m_getProperties = false;
                this.m_worksheetProperties = false;
            } else if (qName.equals(WORKSHEET_PARAMETERS_NODE_TAG)) {
                this.m_getProperties = false;
                this.m_worksheetParameters = false;
            } else if (qName.equals(NETWORK_NODE_TAG) && this.m_network.getWorksheetParameters() == null) {
                try {
                    this.m_network.setWorksheetParameters(new XTProps());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ExternalLinkInfo
    implements Serializable {
        public String toNodeID = null;
        public String fromNodeID = null;
        public int fromPort = 0;
        public int toPort = 0;
        public Vector links = new Vector();
        public boolean isOrthog = false;
        public String container = null;

        public ExternalLinkInfo() {
        }

        public ExternalLinkInfo(String toNodeID, int toPort, String fromNodeID, int fromPort, String container, Vector links, boolean isOrthog) {
            this.toNodeID = toNodeID;
            this.toPort = toPort;
            this.fromNodeID = fromNodeID;
            this.fromPort = fromPort;
            this.container = container;
            this.links = links == null ? new Vector() : links;
            this.isOrthog = isOrthog;
        }

        public ExternalLinkInfo copy() {
            ExternalLinkInfo nlink = new ExternalLinkInfo();
            nlink.toNodeID = this.toNodeID;
            nlink.toPort = this.toPort;
            nlink.fromNodeID = this.fromNodeID;
            nlink.fromPort = this.fromPort;
            nlink.container = this.container;
            nlink.isOrthog = this.isOrthog;
            if (this.links != null) {
                nlink.links = (Vector)this.links.clone();
            }
            return nlink;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExternalLinkInfo) {
                return this.fromPort == ((ExternalLinkInfo)obj).fromPort && this.toPort == ((ExternalLinkInfo)obj).toPort && XTMetaData.nullCognizantCompare(this.toNodeID, ((ExternalLinkInfo)obj).toNodeID) && XTMetaData.nullCognizantCompare(this.fromNodeID, ((ExternalLinkInfo)obj).fromNodeID) && XTMetaData.nullCognizantCompare(this.links, ((ExternalLinkInfo)obj).links);
            }
            return false;
        }

        public void write(Writer writer, String indent) throws IOException {
            writer.write(indent + "<" + LINK_NODE_TAG + " " + FROM_NODE_ATTRIBUTE_TAG + "=\"" + this.fromNodeID + "\" " + FROM_PORT_ATTRIBUTE_TAG + "=\"" + this.fromPort + "\" " + TO_NODE_ATTRIBUTE_TAG + "=\"" + this.toNodeID + "\" " + TO_PORT_ATTRIBUTE_TAG + "=\"" + this.toPort + "\" " + ORTHOGONAL_LINK_ATTRIBUTE_TAG + "=\"" + this.isOrthog + "\"");
            if (this.links.size() < 1) {
                writer.write(" />\n");
            } else {
                writer.write(">\n");
                for (int i = 0; i < this.links.size(); ++i) {
                    LinkInfo info = (LinkInfo)this.links.get(i);
                    writer.write(indent + "\t<" + LINK_HISTORY_NODE_TAG + " " + FROM_NODE_ATTRIBUTE_TAG + "=\"" + info.getFromNodeID() + "\" " + FROM_PORT_ATTRIBUTE_TAG + "=\"" + info.getFromOutputPort() + "\" " + TO_NODE_ATTRIBUTE_TAG + "=\"" + info.getToNodeID() + "\" " + TO_PORT_ATTRIBUTE_TAG + "=\"" + info.getToInputPort() + "\" " + ORTHOGONAL_LINK_ATTRIBUTE_TAG + "=\"" + info.isOrthog + "\" " + "/>\n");
                }
                writer.write(indent + "</" + LINK_NODE_TAG + ">\n");
            }
        }
    }

    public static class ModelLinkInfo
    extends LinkInfo
    implements Serializable {
        public LinkInfo copy() {
            ModelLinkInfo nlink = new ModelLinkInfo();
            nlink.setFromInfo(this.m_fromNode, this.m_fromPort);
            nlink.setToInfo(this.m_toNode, this.m_toPort);
            nlink.container = this.container;
            nlink.inExternal = this.inExternal;
            nlink.isOrthog = this.isOrthog;
            return nlink;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModelLinkInfo) {
                return super.equals(obj);
            }
            return false;
        }

        public void write(Writer writer, String indent) throws IOException {
            writer.write(indent + "<" + MODEL_LINK_NODE_TAG + " " + FROM_NODE_ATTRIBUTE_TAG + "=\"" + this.getFromNodeID() + "\" " + FROM_PORT_ATTRIBUTE_TAG + "=\"" + this.getFromOutputPort() + "\" " + TO_NODE_ATTRIBUTE_TAG + "=\"" + this.getToNodeID() + "\" " + TO_PORT_ATTRIBUTE_TAG + "=\"" + this.getToInputPort() + "\" " + ORTHOGONAL_LINK_ATTRIBUTE_TAG + "=\"" + this.isOrthog + "\" " + "/>\n");
        }
    }

    public static class LinkInfo
    extends XMLTreeNetwork.Link
    implements Serializable {
        public boolean inExternal = false;
        public String container = null;
        public boolean isOrthog = false;

        public LinkInfo() {
            super(null, -1, null, -1);
        }

        public void setFromInfo(String fromID, int fromPort) {
            this.m_fromNode = fromID;
            this.m_fromPort = fromPort;
        }

        public void setToInfo(String toID, int toPort) {
            this.m_toNode = toID;
            this.m_toPort = toPort;
        }

        public LinkInfo copy() {
            LinkInfo nlink = new LinkInfo();
            nlink.setFromInfo(this.m_fromNode, this.m_fromPort);
            nlink.setToInfo(this.m_toNode, this.m_toPort);
            nlink.container = this.container;
            nlink.inExternal = this.inExternal;
            nlink.isOrthog = this.isOrthog;
            return nlink;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LinkInfo) {
                return super.equals(obj);
            }
            return false;
        }

        public void write(Writer writer, String indent) throws IOException {
            writer.write(indent + "<" + LINK_NODE_TAG + " " + FROM_NODE_ATTRIBUTE_TAG + "=\"" + this.getFromNodeID() + "\" " + FROM_PORT_ATTRIBUTE_TAG + "=\"" + this.getFromOutputPort() + "\" " + TO_NODE_ATTRIBUTE_TAG + "=\"" + this.getToNodeID() + "\" " + TO_PORT_ATTRIBUTE_TAG + "=\"" + this.getToInputPort() + "\" " + ORTHOGONAL_LINK_ATTRIBUTE_TAG + "=\"" + this.isOrthog + "\" " + "/>\n");
        }
    }

    public static class PortInfo
    implements Serializable {
        public boolean visible = true;
        public boolean input = true;
        public String toolTip = null;
        public String nodeID = null;
        public int portNum = 0;

        public PortInfo copy() {
            PortInfo copy = new PortInfo();
            copy.visible = this.visible;
            copy.input = this.input;
            copy.toolTip = this.toolTip;
            copy.nodeID = this.nodeID;
            copy.portNum = this.portNum;
            return copy;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PortInfo) {
                return this.visible == ((PortInfo)obj).visible && this.input == ((PortInfo)obj).input && this.portNum == ((PortInfo)obj).portNum && XTMetaData.nullCognizantCompare(this.nodeID, ((PortInfo)obj).nodeID) && XTMetaData.nullCognizantCompare(this.toolTip, ((PortInfo)obj).toolTip);
            }
            return false;
        }

        public void write(Writer writer, String indent) throws IOException {
            writer.write(indent + "<" + PORT_INFO_NODE_TAG + " " + TO_NODE_ATTRIBUTE_TAG + "=\"" + this.nodeID + "\" " + TO_PORT_ATTRIBUTE_TAG + "=\"" + this.portNum + "\" " + VISIBLE_ATTRIBUTE_TAG + "=\"" + this.visible + "\" " + INPUT_TYPE_ATTRIBUTE_TAG + "=\"" + this.input + "\" ");
            if (this.toolTip != null) {
                writer.write(TOOLTIP_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.toolTip) + "\" ");
            }
            writer.write("/>\n");
        }
    }

    public static class CollapsedNodeInfo
    implements Serializable {
        public String nodeID = null;
        public String labelText = null;
        public String helpFile = null;
        public String largeIcon = null;
        public String smallIcon = null;
        public int x = 0;
        public int y = 0;
        public Vector nodes = new Vector();
        public Vector textNodes = new Vector();
        public Vector links = new Vector();
        public Vector inputPorts = new Vector();
        public Vector outputPorts = new Vector();
        public XMLInfo comments = null;
        public String container = null;

        public CollapsedNodeInfo() {
        }

        public CollapsedNodeInfo(String nodeID, XMLInfo comments, String container, String labelText, String helpFile, String largeIcon, String smallIcon, int x, int y, Vector nodes, Vector textNodes, Vector links, Vector inputs, Vector outputs) {
            this.x = x;
            this.y = y;
            this.nodeID = nodeID;
            this.labelText = labelText;
            this.helpFile = helpFile;
            this.largeIcon = largeIcon;
            this.smallIcon = smallIcon;
            this.comments = comments;
            this.container = container;
            this.nodes = nodes == null ? new Vector() : nodes;
            this.textNodes = textNodes == null ? new Vector() : textNodes;
            this.links = links == null ? new Vector() : links;
            this.inputPorts = inputs == null ? new Vector() : inputs;
            this.outputPorts = outputs == null ? new Vector() : outputs;
        }

        public CollapsedNodeInfo copy() {
            try {
                CollapsedNodeInfo nNode = new CollapsedNodeInfo();
                nNode.nodeID = this.nodeID;
                nNode.container = this.container;
                nNode.labelText = this.labelText;
                nNode.helpFile = this.helpFile;
                nNode.largeIcon = this.largeIcon;
                nNode.smallIcon = this.smallIcon;
                nNode.x = this.x;
                nNode.y = this.y;
                if (this.nodes != null) {
                    nNode.nodes = (Vector)this.nodes.clone();
                }
                if (this.textNodes != null) {
                    nNode.textNodes = (Vector)this.textNodes.clone();
                }
                if (this.links != null) {
                    nNode.links = (Vector)this.links.clone();
                }
                if (this.inputPorts != null) {
                    nNode.inputPorts = (Vector)this.inputPorts.clone();
                }
                if (this.outputPorts != null) {
                    nNode.outputPorts = (Vector)this.outputPorts.clone();
                }
                if (this.comments != null) {
                    nNode.comments = this.comments.copy();
                }
                return nNode;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof CollapsedNodeInfo) {
                return XTMetaData.nullCognizantCompare(this.nodeID, ((CollapsedNodeInfo)obj).nodeID) && XTMetaData.nullCognizantCompare(this.inputPorts, ((CollapsedNodeInfo)obj).inputPorts) && XTMetaData.nullCognizantCompare(this.outputPorts, ((CollapsedNodeInfo)obj).outputPorts) && XTMetaData.nullCognizantCompare(this.nodes, ((CollapsedNodeInfo)obj).nodes) && XTMetaData.nullCognizantCompare(this.links, ((CollapsedNodeInfo)obj).links);
            }
            return false;
        }
    }

    public static class TextNodeInfo
    implements Serializable {
        public String labelText = null;
        public int x = 0;
        public int y = 0;
        public String fontName = null;
        public int fontSize = 0;
        public int fontColor = 0;
        public boolean italic = false;
        public boolean bold = false;
        public int backgroundColor = 0;
        public String container = null;

        public TextNodeInfo() {
        }

        public TextNodeInfo(String labelText, int x, int y, String fontName, int fontSize, int fontColor, boolean italic, boolean bold, int backgroundColor, String container) {
            this.labelText = labelText;
            this.x = x;
            this.y = y;
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.italic = italic;
            this.bold = bold;
            this.fontColor = fontColor;
            this.backgroundColor = backgroundColor;
            this.container = container;
        }

        public TextNodeInfo copy() {
            try {
                TextNodeInfo nNode = new TextNodeInfo(this.labelText, this.x, this.y, this.fontName, this.fontSize, this.fontColor, this.italic, this.bold, this.backgroundColor, this.container);
                return nNode;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof TextNodeInfo) {
                return this.x == ((TextNodeInfo)obj).x && this.y == ((TextNodeInfo)obj).y && this.fontSize == ((TextNodeInfo)obj).fontSize && this.italic == ((TextNodeInfo)obj).italic && this.bold == ((TextNodeInfo)obj).bold && this.fontColor == ((TextNodeInfo)obj).fontColor && this.backgroundColor == ((TextNodeInfo)obj).backgroundColor && XTMetaData.nullCognizantCompare(this.fontName, ((TextNodeInfo)obj).fontName) && XTMetaData.nullCognizantCompare(this.container, ((TextNodeInfo)obj).container) && XTMetaData.nullCognizantCompare(this.labelText, ((TextNodeInfo)obj).labelText);
            }
            return false;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(new Integer(this.x));
            out.writeObject(new Integer(this.y));
            out.writeObject(this.labelText);
            out.writeObject(this.fontName);
            out.writeObject(new Integer(this.fontSize));
            out.writeObject(new Integer(this.fontColor));
            out.writeObject(new Boolean(this.italic));
            out.writeObject(new Boolean(this.bold));
            out.writeObject(new Integer(this.backgroundColor));
            out.writeObject(this.container);
        }

        private void readObject(ObjectInputStream in) throws Exception {
            this.x = (Integer)in.readObject();
            this.y = (Integer)in.readObject();
            Object obj = in.readObject();
            if (obj != null) {
                this.labelText = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.fontName = (String)obj;
            }
            this.fontSize = (Integer)in.readObject();
            this.fontColor = (Integer)in.readObject();
            this.italic = (Boolean)in.readObject();
            this.bold = (Boolean)in.readObject();
            this.backgroundColor = (Integer)in.readObject();
            obj = in.readObject();
            if (obj != null) {
                this.container = (String)obj;
            }
        }

        public void write(Writer writer, String indent) throws IOException {
            writer.write(indent + "<" + TEXT_NODE_NODE_TAG + " " + LABEL_TEXT_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.labelText.replaceAll("\n", "")) + "\" ");
            writer.write(FONT_NAME_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.fontName) + "\" " + FONT_SIZE_ATTRIBUTE_TAG + "=\"" + this.fontSize + "\" ");
            writer.write(ITALIC_ATTRIBUTE_TAG + "=\"" + this.italic + "\" " + BOLD_ATTRIBUTE_TAG + "=\"" + this.bold + "\" ");
            writer.write(FONT_COLOR_ATTRIBUTE_TAG + "=\"" + this.fontColor + "\" " + BACKGROUND_COLOR_ATTRIBUTE_TAG + "=\"" + this.backgroundColor + "\" ");
            writer.write(X_ATTRIBUTE_TAG + "=\"" + this.x + "\" " + Y_ATTRIBUTE_TAG + "=\"" + this.y + "\" />\n");
        }

        public void convertFromXML(Element elt) {
            this.labelText = elt.getAttribute(LABEL_TEXT_ATTRIBUTE_TAG);
            this.fontName = elt.getAttribute(FONT_NAME_ATTRIBUTE_TAG);
            try {
                this.italic = Boolean.getBoolean(elt.getAttribute(ITALIC_ATTRIBUTE_TAG));
            }
            catch (NumberFormatException e) {
                this.italic = false;
            }
            try {
                this.bold = Boolean.getBoolean(elt.getAttribute(BOLD_ATTRIBUTE_TAG));
            }
            catch (NumberFormatException e) {
                this.bold = false;
            }
            try {
                this.fontSize = Integer.parseInt(elt.getAttribute(FONT_SIZE_ATTRIBUTE_TAG));
            }
            catch (NumberFormatException e) {
                this.fontSize = 10;
            }
            try {
                this.fontColor = Integer.parseInt(elt.getAttribute(FONT_COLOR_ATTRIBUTE_TAG));
            }
            catch (NumberFormatException e) {
                this.fontColor = 10;
            }
            try {
                this.x = Integer.parseInt(elt.getAttribute(X_ATTRIBUTE_TAG));
            }
            catch (NumberFormatException e) {
                this.x = 0;
            }
            try {
                this.y = Integer.parseInt(elt.getAttribute(Y_ATTRIBUTE_TAG));
            }
            catch (NumberFormatException e) {
                this.y = 0;
            }
            try {
                this.backgroundColor = Integer.parseInt(elt.getAttribute(BACKGROUND_COLOR_ATTRIBUTE_TAG));
            }
            catch (NumberFormatException e) {
                this.backgroundColor = 10;
            }
        }
    }

    public static class NodeInfo
    implements Serializable {
        public String engineClass = null;
        public String guiClass = null;
        public XTProps properties = null;
        public String defaultLabelText = null;
        public String smallIcon = null;
        public String largeIcon = null;
        public String modelParent = null;
        public String executeAfter = null;
        public ModelInfo model = null;
        public XMLInfo comments = null;
        public int numOutputs = 0;
        public int numInputs = 0;
        public int x = 0;
        public int y = 0;
        public String labelText = null;
        public String nodeID = null;
        public String container = null;
        public String[] inputPortToolTips = null;
        public String[] outputPortToolTips = null;

        public NodeInfo() {
        }

        public NodeInfo(String eClass, String gClass, String labelText, String defaultLabelText, String smallIcon, String largeIcon, XTProps properties, String mParent, ModelInfo model, XMLInfo comments, int numOutputs, int numInputs, int x, int y, String nodeID, String container, String eAfter, String[] iPortTT, String[] oPortTT) {
            this.engineClass = eClass;
            this.guiClass = gClass;
            this.labelText = labelText;
            this.defaultLabelText = defaultLabelText;
            this.properties = properties;
            this.executeAfter = eAfter;
            this.modelParent = mParent;
            this.model = model;
            this.x = x;
            this.y = y;
            this.smallIcon = smallIcon;
            this.largeIcon = largeIcon;
            this.comments = comments;
            this.numOutputs = numOutputs;
            this.numInputs = numInputs;
            this.nodeID = nodeID;
            this.container = container;
            this.inputPortToolTips = iPortTT;
            this.outputPortToolTips = oPortTT;
        }

        public NodeInfo copy() {
            try {
                NodeInfo nNode = new NodeInfo(this.engineClass, this.guiClass, this.labelText, this.defaultLabelText, this.smallIcon, this.largeIcon, null, this.modelParent, null, null, this.numOutputs, this.numInputs, this.x, this.y, this.nodeID, this.container, this.executeAfter, this.inputPortToolTips, this.outputPortToolTips);
                if (this.properties != null) {
                    nNode.properties = (XTProps)this.properties.copy();
                }
                if (this.model != null) {
                    nNode.model = this.model.copy();
                }
                if (this.comments != null) {
                    nNode.comments = this.comments.copy();
                }
                return nNode;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeInfo) {
                return this.numOutputs == ((NodeInfo)obj).numOutputs && this.numInputs == ((NodeInfo)obj).numInputs && XTMetaData.nullCognizantCompare(this.engineClass, ((NodeInfo)obj).engineClass) && XTMetaData.nullCognizantCompare(this.guiClass, ((NodeInfo)obj).guiClass) && XTMetaData.nullCognizantCompare(this.executeAfter, ((NodeInfo)obj).executeAfter) && XTMetaData.nullCognizantCompare(this.inputPortToolTips, ((NodeInfo)obj).inputPortToolTips) && XTMetaData.nullCognizantCompare(this.outputPortToolTips, ((NodeInfo)obj).outputPortToolTips) && XTMetaData.nullCognizantCompare(this.nodeID, ((NodeInfo)obj).nodeID) && XTMetaData.nullCognizantCompare(this.properties, ((NodeInfo)obj).properties) && XTMetaData.nullCognizantCompare(this.modelParent, ((NodeInfo)obj).modelParent) && XTMetaData.nullCognizantCompare(this.model, ((NodeInfo)obj).model);
            }
            return false;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(new Integer(this.numInputs));
            out.writeObject(new Integer(this.numOutputs));
            out.writeObject(new Integer(this.x));
            out.writeObject(new Integer(this.y));
            out.writeObject(this.engineClass);
            out.writeObject(this.guiClass);
            out.writeObject(this.defaultLabelText);
            out.writeObject(this.smallIcon);
            out.writeObject(this.largeIcon);
            out.writeObject(this.nodeID);
            out.writeObject(this.labelText);
            out.writeObject(this.container);
            out.writeObject(this.executeAfter);
            out.writeObject(this.modelParent);
            out.writeObject(this.model);
            out.writeObject(this.comments);
            out.writeObject(this.inputPortToolTips);
            out.writeObject(this.outputPortToolTips);
            try {
                if (this.properties != null) {
                    this.properties.forcedWriteObject(out);
                } else {
                    new XTProps().forcedWriteObject(out);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void readObject(ObjectInputStream in) throws Exception {
            this.numInputs = (Integer)in.readObject();
            this.numOutputs = (Integer)in.readObject();
            this.x = (Integer)in.readObject();
            this.y = (Integer)in.readObject();
            Object obj = in.readObject();
            if (obj != null) {
                this.engineClass = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.guiClass = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.defaultLabelText = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.smallIcon = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.largeIcon = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.nodeID = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.labelText = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.container = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.executeAfter = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.modelParent = (String)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.model = (ModelInfo)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.comments = (XMLInfo)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.inputPortToolTips = (String[])obj;
            }
            if ((obj = in.readObject()) != null) {
                this.outputPortToolTips = (String[])obj;
            }
            this.properties = new XTProps();
            try {
                XTProps.forcedReadObject(in, this.properties);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void write(Writer writer, String indent) throws IOException {
            String tTip;
            int i;
            writer.write(indent + "<" + ACTIVITY_NODE_NODE_TAG + " " + ENGINE_CLASS_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.engineClass) + "\" " + GUI_CLASS_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.guiClass) + "\" " + NUM_INPUTS_ATTRIBUTE_TAG + "=\"" + this.numInputs + "\" " + NUM_OUTPUTS_ATTRIBUTE_TAG + "=\"" + this.numOutputs + "\" id=\"" + this.nodeID + "\">\n");
            writer.write(indent + "\t<" + DISPLAY_INFO_NODE_TAG + " " + LABEL_TEXT_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.labelText.replaceAll("\n", "")) + "\" ");
            if (this.defaultLabelText != null) {
                writer.write(DEFAULT_LABEL_TEXT_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.defaultLabelText) + "\" ");
            }
            writer.write(SMALL_ICON_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.smallIcon) + "\" " + LARGE_ICON_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.largeIcon) + "\" " + X_ATTRIBUTE_TAG + "=\"" + this.x + "\" " + Y_ATTRIBUTE_TAG + "=\"" + this.y + "\" />\n");
            if (this.inputPortToolTips != null) {
                writer.write(indent + "\t<" + INPUT_PORT_TOOL_TIPS_NODE_TAG + " ");
                for (i = 0; i < this.inputPortToolTips.length; ++i) {
                    tTip = this.inputPortToolTips[i] != null ? this.inputPortToolTips[i] : "";
                    writer.write("port" + Integer.toString(i + 1) + "=\"" + XTNetwork.convertToXML(tTip) + "\" ");
                }
                writer.write("/>\n");
            }
            if (this.outputPortToolTips != null) {
                writer.write(indent + "\t<" + OUTPUT_PORT_TOOL_TIPS_NODE_TAG + " ");
                for (i = 0; i < this.outputPortToolTips.length; ++i) {
                    tTip = this.outputPortToolTips[i] != null ? this.outputPortToolTips[i] : "";
                    writer.write("port" + Integer.toString(i + 1) + "=\"" + XTNetwork.convertToXML(tTip) + "\" ");
                }
                writer.write("/>\n");
            }
            if (this.properties == null) {
                writer.write(indent + "\t<ArgumentList />\n");
            } else {
                writer.write(indent + "\t<ArgumentList>\n");
                this.properties.outputXML(writer, false, indent + "\t\t");
                writer.write(indent + "\t</ArgumentList>\n");
            }
            if (this.executeAfter != null) {
                writer.write(indent + "\t<" + EXECUTE_AFTER_NODE_TAG + " " + ID_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.executeAfter) + "\" />\n");
            }
            if (this.modelParent != null) {
                writer.write(indent + "\t<" + MODEL_PARENT_NODE_TAG + " " + ID_ATTRIBUTE_TAG + "=\"" + XTNetwork.convertToXML(this.modelParent) + "\" />\n");
            }
            if (this.model != null && this.model.modelString != null) {
                writer.write(indent + "\t<ModelProperties>\n");
                this.model.write(writer, indent + "\t\t");
                writer.write(indent + "\t</ModelProperties>\n");
            }
            if (this.comments != null && this.comments.tree != null) {
                this.comments.write(writer, indent + "\t");
            }
            writer.write(indent + "</" + ACTIVITY_NODE_NODE_TAG + ">\n");
        }

        public void convertFromXML(Element elt) {
            Element mod;
            Element oPortTTs;
            Element iPortTTs;
            Element dispInf;
            this.engineClass = elt.getAttribute(ENGINE_CLASS_ATTRIBUTE_TAG);
            this.guiClass = elt.getAttribute(GUI_CLASS_ATTRIBUTE_TAG);
            this.numOutputs = Integer.parseInt(elt.getAttribute(NUM_OUTPUTS_ATTRIBUTE_TAG));
            this.numInputs = Integer.parseInt(elt.getAttribute(NUM_INPUTS_ATTRIBUTE_TAG));
            this.nodeID = elt.getAttribute(ID_ATTRIBUTE_TAG);
            NodeList list = elt.getElementsByTagName(DISPLAY_INFO_NODE_TAG);
            Element element = dispInf = list != null && list.getLength() > 0 ? (Element)list.item(0) : null;
            if (dispInf != null) {
                this.labelText = dispInf.getAttribute(LABEL_TEXT_ATTRIBUTE_TAG);
                this.defaultLabelText = dispInf.getAttribute(DEFAULT_LABEL_TEXT_ATTRIBUTE_TAG);
                this.smallIcon = dispInf.getAttribute(SMALL_ICON_ATTRIBUTE_TAG);
                this.largeIcon = dispInf.getAttribute(LARGE_ICON_ATTRIBUTE_TAG);
                try {
                    this.x = Integer.parseInt(dispInf.getAttribute(X_ATTRIBUTE_TAG));
                }
                catch (NumberFormatException e) {
                    this.x = 0;
                }
                try {
                    this.y = Integer.parseInt(dispInf.getAttribute(Y_ATTRIBUTE_TAG));
                }
                catch (NumberFormatException e) {
                    this.y = 0;
                }
            }
            Element element2 = iPortTTs = (list = elt.getElementsByTagName(INPUT_PORT_TOOL_TIPS_NODE_TAG)) != null && list.getLength() > 0 ? (Element)list.item(0) : null;
            if (iPortTTs != null) {
                int numToolTips = this.numInputs > -1 ? this.numInputs : 1;
                this.inputPortToolTips = new String[numToolTips];
                for (int i = 0; i < numToolTips; ++i) {
                    String str = iPortTTs.getAttribute("port" + Integer.toString(i + 1));
                    if (str == null || str.length() <= 0) continue;
                    this.inputPortToolTips[i] = str;
                }
            }
            Element element3 = oPortTTs = (list = elt.getElementsByTagName(OUTPUT_PORT_TOOL_TIPS_NODE_TAG)) != null && list.getLength() > 0 ? (Element)list.item(0) : null;
            if (oPortTTs != null) {
                int numToolTips = this.numOutputs > -1 ? this.numOutputs : 1;
                this.outputPortToolTips = new String[numToolTips];
                for (int i = 0; i < numToolTips; ++i) {
                    String str = oPortTTs.getAttribute("port" + Integer.toString(i + 1));
                    if (str == null || str.length() <= 0) continue;
                    this.outputPortToolTips[i] = str;
                }
            }
            try {
                list = elt.getElementsByTagName(EXECUTE_AFTER_NODE_TAG);
                Element element4 = mod = list != null && list.getLength() > 0 ? (Element)list.item(0) : null;
                if (mod != null) {
                    this.executeAfter = mod.getAttribute(ID_ATTRIBUTE_TAG);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                list = elt.getElementsByTagName(MODEL_PARENT_NODE_TAG);
                Element element5 = mod = list != null && list.getLength() > 0 ? (Element)list.item(0) : null;
                if (mod != null) {
                    this.modelParent = mod.getAttribute(ID_ATTRIBUTE_TAG);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.model = new ModelInfo();
            try {
                Element model;
                list = elt.getElementsByTagName(MODEL_PROPERTIES_NODE_TAG);
                Node modParent = list != null && list.getLength() > 0 ? (Element)list.item(0) : null;
                Element element6 = model = modParent == null ? null : (Element)modParent.getFirstChild();
                if (model != null) {
                    this.model = new ModelInfo(new XMLTree(model));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.properties = null;
            try {
                Element propsElt;
                list = elt.getElementsByTagName(ARGUMENT_LIST_NODE_TAG);
                Node propsParent = list != null && list.getLength() > 0 ? (Element)list.item(0) : null;
                Element element7 = propsElt = propsParent == null ? null : (Element)propsParent.getFirstChild();
                if (propsElt != null) {
                    this.properties = new XTProps(propsElt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.comments = new XMLInfo();
            try {
                Element comments;
                list = elt.getElementsByTagName(COMPONENT_COMMENTS_NODE_TAG);
                Element element8 = comments = list != null && list.getLength() > 0 ? (Element)list.item(0) : null;
                if (comments != null) {
                    this.comments.tree = new XMLTree(comments);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class FileInfo
    implements Serializable {
        public String author = null;
        public String version = null;
        public String filename = null;
        public String created = null;

        public FileInfo() {
        }

        public FileInfo(String author, String version, String filename, String created) {
            this.author = author;
            this.version = version;
            this.filename = filename;
            this.created = created;
        }

        public FileInfo copy() {
            return new FileInfo(this.author, this.version, this.filename, this.created);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileInfo) {
                return XTMetaData.nullCognizantCompare(this.author, ((FileInfo)obj).author) && XTMetaData.nullCognizantCompare(this.version, ((FileInfo)obj).version) && XTMetaData.nullCognizantCompare(this.filename, ((FileInfo)obj).filename) && XTMetaData.nullCognizantCompare(this.created, ((FileInfo)obj).created);
            }
            return false;
        }

        public void write(Writer writer, String indent) throws IOException {
            writer.write(indent + "<" + FILE_INFO_NODE_TAG + ">\n");
            if (this.author != null && !this.author.equals("")) {
                writer.write(indent + "\t<" + FILE_AUTHOR_NODE_TAG + ">" + XTNetwork.convertToXML(this.author) + "</" + FILE_AUTHOR_NODE_TAG + ">\n");
            }
            if (this.version != null && !this.version.equals("")) {
                writer.write(indent + "\t<" + FILE_VERSION_NODE_TAG + ">" + XTNetwork.convertToXML(this.version) + "</" + FILE_VERSION_NODE_TAG + ">\n");
            }
            if (this.filename != null && !this.filename.equals("")) {
                writer.write(indent + "\t<" + FILE_NAME_NODE_TAG + ">" + XTNetwork.convertToXML(this.filename) + "</" + FILE_NAME_NODE_TAG + ">\n");
            }
            if (this.created != null && !this.created.equals("")) {
                writer.write(indent + "\t<" + FILE_DATE_CREATED_NODE_TAG + ">" + XTNetwork.convertToXML(this.created) + "</" + FILE_DATE_CREATED_NODE_TAG + ">\n");
            }
            writer.write(indent + "</" + FILE_INFO_NODE_TAG + ">\n");
        }
    }

    public static class XMLInfo
    implements Serializable {
        public XMLTree tree = null;

        public XMLInfo() {
        }

        public XMLInfo(XMLTree tree) {
            this.tree = tree;
        }

        public XMLInfo copy() {
            XMLInfo copy = new XMLInfo();
            if (this.tree != null) {
                try {
                    Element node = (Element)this.tree.copy().getXML().getChildNodes().item(0);
                    copy.tree = new XMLTree(node);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return copy;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XMLInfo) {
                return XTMetaData.nullCognizantCompare(this.tree, ((XMLInfo)obj).tree);
            }
            return false;
        }

        protected Element getFirstChild() {
            Element element = this.tree.getXML();
            if (!element.getNodeName().equals(XMLTree.IMML_NODE_TAG)) {
                return element;
            }
            return (Element)element.getFirstChild();
        }

        public void write(Writer writer, String indent) throws IOException {
            String workingString;
            Element actualStart = this.getFirstChild();
            String remainingString = actualStart.toString();
            int totalLength = remainingString.length();
            int currentLocation = 0;
            int endLocation = remainingString.indexOf(">", 0) + 1;
            String extraIndent = "";
            int extraLength = 0;
            boolean closeTag = false;
            boolean inline = false;
            if (endLocation == 0) {
                return;
            }
            while (true) {
                if (endLocation == totalLength) break;
                workingString = remainingString.substring(currentLocation, endLocation);
                if (workingString.charAt(endLocation - currentLocation - 2) == '/') {
                    writer.write(indent + extraIndent + workingString + "\n");
                    currentLocation = endLocation;
                    endLocation = remainingString.indexOf(">", endLocation) + 1;
                    continue;
                }
                if (remainingString.charAt(endLocation) == '<') {
                    boolean bl = closeTag = workingString.charAt(1) == '/';
                    if (closeTag && extraLength > 0) {
                        extraIndent = extraIndent.substring(0, --extraLength);
                    }
                    writer.write(indent + extraIndent + workingString + "\n");
                    if (inline || closeTag) {
                        inline = false;
                        closeTag = false;
                    } else {
                        extraIndent = extraIndent + "\t";
                        ++extraLength;
                    }
                    currentLocation = endLocation;
                    endLocation = remainingString.indexOf(">", endLocation) + 1;
                    continue;
                }
                endLocation = remainingString.indexOf(">", endLocation) + 1;
                inline = true;
            }
            workingString = remainingString.substring(currentLocation, endLocation);
            writer.write(indent + workingString + "\n");
            writer.flush();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.tree);
        }

        private void readObject(ObjectInputStream in) throws Exception {
            Object obj = in.readObject();
            this.tree = obj == null ? null : new XMLTree((XMLTree)obj);
        }
    }

    public static class ModelInfo
    implements Serializable {
        public String modelString = null;

        public ModelInfo() {
        }

        public ModelInfo(String xmlString) {
            this.modelString = xmlString;
        }

        public ModelInfo(XMLTree tree) {
            this.modelString = tree.getXML().toString();
        }

        public ModelInfo copy() {
            return new ModelInfo(this.modelString);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModelInfo) {
                return XTMetaData.nullCognizantCompare(this.modelString, ((ModelInfo)obj).modelString);
            }
            if (obj instanceof String) {
                return XTMetaData.nullCognizantCompare(this.modelString, (String)obj);
            }
            if (obj instanceof XMLTree) {
                String compare = ((XMLTree)obj).getXML().toString();
                return XTMetaData.nullCognizantCompare(this.modelString, compare);
            }
            return false;
        }

        public XMLTree getXMLTree() {
            if (this.modelString == null) {
                return null;
            }
            try {
                return XMLTree.readFromString(this.modelString);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String translateStringToXML(String workingString) {
            boolean openNode = false;
            boolean openQuote = false;
            StringBuffer translatedString = new StringBuffer();
            int length = workingString.length();
            for (int i = 0; i < length; ++i) {
                char currentChar = workingString.charAt(i);
                if (currentChar == '<') {
                    if (!openNode && !openQuote) {
                        openNode = true;
                        translatedString.append(currentChar);
                        continue;
                    }
                    translatedString.append("&lt;");
                    continue;
                }
                if (currentChar == '>') {
                    if (openNode && !openQuote) {
                        openNode = false;
                        translatedString.append(currentChar);
                        continue;
                    }
                    translatedString.append("&gt;");
                    continue;
                }
                if (currentChar == '\"') {
                    if (!openQuote) {
                        openQuote = true;
                        translatedString.append(currentChar);
                        continue;
                    }
                    if (i < length - 1) {
                        char nextChar = workingString.charAt(i + 1);
                        if (nextChar == ' ' || nextChar == '\n' || nextChar == '\t' || nextChar == '/' || nextChar == '>' || nextChar == '<') {
                            translatedString.append(currentChar);
                            openQuote = false;
                            continue;
                        }
                        translatedString.append("&quot;");
                        continue;
                    }
                    translatedString.append(currentChar);
                    continue;
                }
                if (currentChar == '\'') {
                    translatedString.append("&apos;");
                    continue;
                }
                if (currentChar == '&') {
                    translatedString.append("&amp;");
                    continue;
                }
                translatedString.append(currentChar);
            }
            return translatedString.toString();
        }

        public void write(Writer writer, String indent) throws IOException {
            String workingString;
            String remainingString = this.translateStringToXML(this.modelString);
            int totalLength = remainingString.length();
            int currentLocation = 0;
            int endLocation = remainingString.indexOf(">", 0) + 1;
            String extraIndent = "";
            int extraLength = 0;
            boolean closeTag = false;
            boolean inline = false;
            while (true) {
                if (endLocation == totalLength) break;
                workingString = remainingString.substring(currentLocation, endLocation);
                if (workingString.charAt(endLocation - currentLocation - 2) == '/') {
                    writer.write(indent + extraIndent + workingString + "\n");
                    currentLocation = endLocation;
                    endLocation = remainingString.indexOf(">", endLocation) + 1;
                    continue;
                }
                if (remainingString.charAt(endLocation) == '<') {
                    boolean bl = closeTag = workingString.charAt(1) == '/';
                    if (closeTag && extraLength > 0) {
                        extraIndent = extraIndent.substring(0, --extraLength);
                    }
                    writer.write(indent + extraIndent + workingString + "\n");
                    if (inline || closeTag) {
                        inline = false;
                        closeTag = false;
                    } else {
                        extraIndent = extraIndent + "\t";
                        ++extraLength;
                    }
                    currentLocation = endLocation;
                    endLocation = remainingString.indexOf(">", endLocation) + 1;
                    continue;
                }
                endLocation = remainingString.indexOf(">", endLocation) + 1;
                inline = true;
            }
            workingString = remainingString.substring(currentLocation, endLocation);
            writer.write(indent + workingString + "\n");
            writer.flush();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.modelString);
        }

        private void readObject(ObjectInputStream in) throws Exception {
            Object obj = in.readObject();
            this.modelString = obj == null ? null : (String)obj;
        }
    }

    private class LinkComparator
    implements Comparator {
        public boolean multiPortFound = false;

        private LinkComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof LinkInfo && o2 instanceof LinkInfo) {
                int compareTo;
                String to1 = ((LinkInfo)o1).getToNodeID();
                String to2 = ((LinkInfo)o2).getToNodeID();
                if (!this.multiPortFound) {
                    int port2;
                    int port1 = ((LinkInfo)o1).getToInputPort();
                    boolean bl = this.multiPortFound = port1 == (port2 = ((LinkInfo)o2).getToInputPort()) && to1.equals(to2);
                }
                if ((compareTo = to1.compareTo(to2)) != 0) {
                    return compareTo;
                }
                return ((LinkInfo)o1).getFromNodeID().compareTo(((LinkInfo)o2).getFromNodeID());
            }
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof LinkComparator;
        }
    }
}

