/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graph;

import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCanvasListener;
import com.insightful.gdevice.SCanvasPaneController;
import com.insightful.gdevice.SCanvasPaneView;
import com.insightful.gdevice.SCanvasPoint;
import com.insightful.gdevice.STreeNode;
import com.insightful.gdevice.XMLElement;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.graph.GraphOptionsDialog;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.graph.GraphColorsDialog;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class CanvasTabbedPane
extends JPanel
implements SCanvasPaneView {
    JScrollBar m_hscroll = new JScrollBar(0);
    JScrollBar m_vscroll = new JScrollBar(1);
    JPanel m_pagePanel = new JPanel(new BorderLayout());
    JComponent m_pageCanvas = new JComponent(){

        public void paint(Graphics g) {
            CanvasTabbedPane.this.m_controller.paintCanvas(g);
        }

        public void update(Graphics g) {
            this.paint(g);
        }
    };
    JComponent m_tabCanvas = new JComponent(){
        int m_desiredHeight = 15;
        boolean m_gotDesiredHeight = false;

        public Dimension getPreferredSize() {
            if (!this.m_gotDesiredHeight) {
                Graphics g = this.getGraphics();
                if (g != null) {
                    FontMetrics fm = g.getFontMetrics();
                    this.m_desiredHeight = fm.getHeight() + 3;
                }
                this.m_gotDesiredHeight = true;
            }
            return new Dimension(100, this.m_desiredHeight);
        }

        public void paint(Graphics g) {
            CanvasTabbedPane.this.m_controller.paintTabs(g);
        }

        public void update(Graphics g) {
            this.paint(g);
        }
    };
    SCanvasPaneController m_controller = null;
    SCanvas m_activeCanvas = null;
    private GWSCListener m_canvasListener = null;
    private JPopupMenu m_popupMenu = null;
    private ActionListener m_popupMenuListener = null;
    public static final int TAB_IN_EXPRESSION_ON_NEW_GRAPH = 0;
    public static final int TAB_ON_NEW_GRAPH = 1;
    public static final int CLEAR_ON_NEW_GRAPH = 2;
    private static int m_clearReaction = 0;
    boolean m_closeOnWrap = true;
    int m_lastCanvasTab = -1;
    static ReadPenDialog m_readPenDialog = null;
    int m_screenPopupX = 0;
    int m_screenPopupY = 0;
    JPopupMenu m_screenPopupMenu = null;

    public CanvasTabbedPane() {
        this(true);
    }

    public CanvasTabbedPane(boolean closeOnWrap) {
        super(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.m_closeOnWrap = closeOnWrap;
        this.m_pagePanel.add("Center", this.m_pageCanvas);
        this.m_pagePanel.add("East", this.m_vscroll);
        this.m_pagePanel.add("South", this.m_hscroll);
        this.add("Center", this.m_pagePanel);
        this.add("South", this.m_tabCanvas);
        this.m_canvasListener = new GWSCListener();
        TabPaneContextMenu theMenu = new TabPaneContextMenu();
        this.m_tabCanvas.addMouseListener(theMenu);
        this.m_controller = new SCanvasPaneController((SCanvasPaneView)this);
    }

    public Component getCanvasComponent() {
        return this.m_pageCanvas;
    }

    public Component getTabComponent() {
        return this.m_tabCanvas;
    }

    public Adjustable getScrollAdjustable(int orientation) {
        return this.getScrollbar(orientation);
    }

    JScrollBar getScrollbar(int orientation) {
        return orientation == 0 ? this.m_hscroll : this.m_vscroll;
    }

    public boolean getScrollVisible(int orientation) {
        return this.getScrollbar(orientation).isVisible();
    }

    public void setScrollVisible(int orientation, boolean visible) {
        if (visible != this.getScrollVisible(orientation)) {
            this.getScrollbar(orientation).setVisible(visible);
            this.validate();
        }
    }

    public void doHitURL(String urlString, String target) {
        String warn = "In an applet, this would show the URL:\n" + urlString + "\n(target=" + target + ")";
        AcceleratorOptionPane.showOKDialog(this, warn, MinerApp.getText("CanvasTabbedPane_message_warning"), 2);
    }

    public void doHitError(String action, String errorString) {
        String str = MinerApp.getText("CanvasTabbedPane_msg_error") + " " + errorString + "\n" + MinerApp.getText("CanvasTabbedPane_msg_inAction") + "\n" + action;
        AcceleratorOptionPane.showOKDialog(this, str, MinerApp.getText("CanvasTabbedPane_message_errorinAction"), 0);
    }

    public void doExec(String code, String language) {
        if (code == null || code.trim().equals("")) {
            return;
        }
        try {
            boolean splusCallable = MinerApp.isSplusLicensed();
            if (!splusCallable) {
                throw new Exception("can't call into Splus");
            }
            String safeCode = "{{" + code + "};NULL}";
            SplusDataResult result = MinerApp.eval(safeCode);
            if (result.hasError()) {
                throw new Exception("Splus error: " + result.getError());
            }
        }
        catch (Exception ex) {
            String str = "Error while executing action:\n   " + ex + "\n\n   code: " + (code != null && code.length() > 100 ? code.substring(0, 90) + "..." : code);
            JOptionPane.showMessageDialog(this, str, "Error in Action", 0);
        }
    }

    public boolean doHitQueryWebService(XMLElement elt, STreeNode rootLabels, STreeNode rootActions, boolean bShowErrorDialog) throws Exception {
        String str = "In an applet, this would query a web service.";
        JOptionPane.showMessageDialog(this, str, "Warning", 0);
        return false;
    }

    public void doHitMenu(String title, String[] labels, String[] actions, int x, int y) {
        if (labels == null || actions == null) {
            return;
        }
        int numItems = Math.min(labels.length, actions.length);
        if (numItems < 1) {
            return;
        }
        JPopupMenu menu = null;
        menu = title == null || title.length() < 1 ? new JPopupMenu() : new JPopupMenu(title);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd != null && CanvasTabbedPane.this.m_controller != null) {
                    CanvasTabbedPane.this.m_controller.doHitAction(cmd);
                }
            }
        };
        for (int i = 0; i < numItems; ++i) {
            JMenuItem item = new JMenuItem(labels[i]);
            item.setActionCommand(actions[i]);
            item.addActionListener(listener);
            menu.add(item);
        }
        this.showPopupMenu(menu, this.m_pageCanvas, x, y);
    }

    public void doHitMenu(STreeNode rootLabels, STreeNode rootActions, int x, int y) {
        if (rootLabels == null || rootActions == null) {
            return;
        }
        if (rootLabels.getChildCount() < 1 || rootActions.getChildCount() < 1) {
            return;
        }
        if (this.m_popupMenu == null) {
            this.m_popupMenu = new JPopupMenu();
            this.m_popupMenuListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String cmd = e.getActionCommand();
                    if (cmd != null && CanvasTabbedPane.this.m_controller != null) {
                        CanvasTabbedPane.this.m_controller.doHitAction(cmd);
                    }
                }
            };
        }
        this.m_popupMenu.removeAll();
        this.constructPopupMenu(this.m_popupMenu, this.m_popupMenuListener, rootLabels, rootActions);
        this.showPopupMenu(this.m_popupMenu, this.m_pageCanvas, x, y);
    }

    protected void constructPopupMenu(JPopupMenu menu, ActionListener listener, STreeNode rootLabels, STreeNode rootActions) {
        menu.setLabel((String)rootLabels.getUserObject());
        int nChildCount = Math.min(rootLabels.getChildCount(), rootActions.getChildCount());
        for (int i = 0; i < nChildCount; ++i) {
            STreeNode nodeLabels = rootLabels.getChildAt(i);
            STreeNode nodeActions = rootActions.getChildAt(i);
            if (nodeLabels.isLeaf() || nodeActions.isLeaf()) {
                JMenuItem item = new JMenuItem((String)nodeLabels.getUserObject());
                String strAction = (String)nodeActions.getUserObject();
                if (strAction != null && strAction.length() > 0) {
                    item.setActionCommand(strAction);
                    item.addActionListener(listener);
                } else {
                    item.setEnabled(false);
                }
                menu.add(item);
                continue;
            }
            JMenu submenu = new JMenu();
            this.constructSubMenu(submenu, listener, nodeLabels, nodeActions);
            menu.add(submenu);
        }
    }

    protected void constructSubMenu(JMenu menu, ActionListener listener, STreeNode rootLabels, STreeNode rootActions) {
        menu.setLabel((String)rootLabels.getUserObject());
        int nChildCount = Math.min(rootLabels.getChildCount(), rootActions.getChildCount());
        for (int i = 0; i < nChildCount; ++i) {
            STreeNode nodeLabels = rootLabels.getChildAt(i);
            STreeNode nodeActions = rootActions.getChildAt(i);
            if (nodeLabels.isLeaf() || nodeActions.isLeaf()) {
                JMenuItem item = new JMenuItem((String)nodeLabels.getUserObject());
                String strAction = (String)nodeActions.getUserObject();
                if (strAction != null && strAction.length() > 0) {
                    item.setActionCommand(strAction);
                    item.addActionListener(listener);
                } else {
                    item.setEnabled(false);
                }
                menu.add(item);
                continue;
            }
            JMenu submenu = new JMenu();
            this.constructSubMenu(submenu, listener, nodeLabels, nodeActions);
            menu.add(submenu);
        }
    }

    public static void setClearReaction(int reactNew) {
        if (reactNew >= 0 && reactNew <= 2) {
            m_clearReaction = reactNew;
        }
    }

    public static int getClearReaction() {
        return m_clearReaction;
    }

    public int getTabCount() {
        return this.m_controller.getTabCount();
    }

    public void removeAllTabs() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SCanvas canvas = this.getCanvas(i);
            if (canvas == null) continue;
            canvas.unlinkGraphicsDevice();
        }
        this.m_controller.removeAllPages();
    }

    public void removeTabAt(int index) {
        SCanvas canvas = this.getCanvas(index);
        if (canvas != null) {
            canvas.unlinkGraphicsDevice();
        }
        this.m_controller.removeTabAt(index);
    }

    public void zoom(double val) {
        this.m_controller.zoom(val);
    }

    public void zoomToRect() {
        this.m_controller.zoomToRect();
    }

    public void zoomToFrame() {
        this.m_controller.setAutoZoom(true);
    }

    public void selectRect() {
        this.m_controller.selectRect();
    }

    public void addCanvasTab(SCanvas canvas, int index) {
        this.m_controller.addCanvas((SCanvasAWT)canvas, index);
    }

    public void addCanvasTab(SCanvas canvas) {
        this.m_controller.addCanvas((SCanvasAWT)canvas);
    }

    public SCanvas getCanvas() {
        return (SCanvas)this.m_controller.getCanvas();
    }

    public SCanvas getCanvas(int iTab) {
        return (SCanvas)this.m_controller.getCanvas(iTab);
    }

    public Vector getAllCanvases() {
        Vector<SCanvas> canvasVector = new Vector<SCanvas>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            SCanvas canvas = this.getCanvas(i);
            if (canvas == null) continue;
            canvasVector.addElement(canvas);
        }
        return canvasVector;
    }

    public SCanvas setActiveCanvas(SCanvas canvNew) {
        if (this.m_activeCanvas != null) {
            this.m_activeCanvas.setNewActiveCanvas(canvNew);
        }
        this.m_activeCanvas = canvNew;
        this.m_activeCanvas.addCanvasListener((SCanvasListener)this.m_canvasListener);
        return this.m_activeCanvas;
    }

    int canvasToTab(SCanvas canvas) {
        if (this.m_lastCanvasTab < 0 || canvas != this.m_controller.getCanvas(this.m_lastCanvasTab)) {
            this.m_lastCanvasTab = -1;
            if (canvas != null) {
                int numTabs = this.m_controller.getTabCount();
                for (int i = 0; i < numTabs; ++i) {
                    if (canvas != this.m_controller.getCanvas(i)) continue;
                    this.m_lastCanvasTab = i;
                    break;
                }
            }
        }
        return this.m_lastCanvasTab;
    }

    SCanvas createNewActiveCanvas() {
        return this.setActiveCanvas(new SCanvas());
    }

    void canvasWrap(SCanvas canvas) {
        if (!this.m_closeOnWrap) {
            return;
        }
        this.unlinkCanvases();
        for (Container c = this; c != null; c = c.getParent()) {
            if (c instanceof Window) {
                ((Window)c).dispose();
            }
            if (!(c instanceof JInternalFrame)) continue;
            ((JInternalFrame)c).dispose();
        }
    }

    JFrame getParentJFrame() {
        Container c = this;
        while (c != null) {
            if (c instanceof JFrame) {
                return (JFrame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public void unlinkCanvases() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SCanvas canvas = this.getCanvas(i);
            canvas.unlinkGraphicsDevice();
        }
    }

    public int getDeviceNumber() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SCanvas canvas = this.getCanvas(i);
            int deviceNumber = canvas.getDeviceNumber();
            if (deviceNumber <= 0) continue;
            return deviceNumber;
        }
        return 0;
    }

    Point[] canvasReadPen(SCanvas canvas, int maxPoints) {
        int readPenTab = -1;
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (canvas != this.getCanvas(i)) continue;
            readPenTab = i;
            break;
        }
        if (readPenTab < 0 || maxPoints < 1) {
            return null;
        }
        this.m_controller.setSelectedTab(readPenTab);
        if (m_readPenDialog == null) {
            m_readPenDialog = new ReadPenDialog(MinerApp.getMainFrame());
        }
        Point[] pts = m_readPenDialog.runReadPen(this, maxPoints);
        return pts;
    }

    void showPopupMenu(JPopupMenu menu, Component c, int x, int y) {
        Point origin = c.getLocationOnScreen();
        this.m_screenPopupX = x + origin.x;
        this.m_screenPopupY = y + origin.y;
        this.m_screenPopupMenu = menu;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Container parent;
                for (parent = CanvasTabbedPane.this.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
                }
                if (parent == null) {
                    System.out.println("CanvasTabbedPane.showPopupMenu: no window");
                    return;
                }
                Window parentWindow = (Window)parent;
                Point parentOrigin = parentWindow.getLocationOnScreen();
                if (CanvasTabbedPane.this.m_screenPopupMenu == null) {
                    return;
                }
                CanvasTabbedPane.this.m_screenPopupMenu.show(parentWindow, CanvasTabbedPane.this.m_screenPopupX - parentOrigin.x, CanvasTabbedPane.this.m_screenPopupY - parentOrigin.y);
            }
        });
    }

    class PagePropertiesDialog
    extends JDialog
    implements ActionListener {
        JTextField m_tfPageTitle;
        JTextField m_tfPageTag;
        JButton m_okButton;
        JButton m_cancelButton;
        SCanvas m_canvas;

        PagePropertiesDialog(JFrame frame, int tabSelected) {
            super(frame, "Page Properties", true);
            this.m_tfPageTitle = new JTextField(15);
            this.m_tfPageTag = new JTextField(15);
            this.m_okButton = new JButton("OK");
            this.m_cancelButton = new JButton("Cancel");
            this.m_canvas = null;
            this.m_canvas = CanvasTabbedPane.this.getCanvas(tabSelected);
            JPanel box = new JPanel();
            box.setLayout(new BoxLayout(box, 1));
            box.setAlignmentX(0.0f);
            box.add(this.makeLabeledPanel("Properties for Page " + (tabSelected + 1), null));
            box.add(Box.createVerticalStrut(5));
            box.add(this.makeLabeledPanel("Page Title:  ", this.m_tfPageTitle));
            box.add(Box.createVerticalStrut(5));
            box.add(this.makeLabeledPanel("Page Tag:  ", this.m_tfPageTag));
            this.m_tfPageTitle.setText(this.m_canvas.getTitle());
            this.m_tfPageTag.setText(this.m_canvas.getTag());
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.m_okButton);
            buttonPanel.add(this.m_cancelButton);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.getContentPane().add((Component)box, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent ev) {
            JButton buttonPressed = (JButton)ev.getSource();
            if (buttonPressed == this.m_okButton) {
                this.m_canvas.setTitle(this.m_tfPageTitle.getText());
                this.m_canvas.setTag(this.m_tfPageTag.getText());
                CanvasTabbedPane.this.repaint(1000L);
                this.dispose();
            } else if (buttonPressed == this.m_cancelButton) {
                this.dispose();
            }
        }

        JPanel makeLabeledPanel(String str, JComponent comp) {
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.add(new JLabel(str));
            if (comp != null) {
                panel.add(comp);
            }
            return panel;
        }
    }

    class TabPaneContextMenu
    extends MouseAdapter {
        JPopupMenu m_menu = new JPopupMenu();
        int m_tabSelected;

        TabPaneContextMenu() {
            JMenuItem item = new JMenuItem("Zoom In");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    CanvasTabbedPane.this.zoom(1.5);
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Zoom Out");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    CanvasTabbedPane.this.zoom(0.6666666865348816);
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Zoom to Rectangle");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    CanvasTabbedPane.this.zoomToRect();
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Fit in Window");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    CanvasTabbedPane.this.zoomToFrame();
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Select Rectangle");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    CanvasTabbedPane.this.selectRect();
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Set Graph Colors...");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    GraphColorsDialog dlg = new GraphColorsDialog((Frame)CanvasTabbedPane.this.getParentJFrame(), CanvasTabbedPane.this.getCanvas(), true);
                    dlg.show();
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Graph Options...");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    GraphOptionsDialog dlg = new GraphOptionsDialog(CanvasTabbedPane.this.getParentJFrame());
                    dlg.show();
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Page Properties...");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    if (TabPaneContextMenu.this.m_tabSelected < 0 || CanvasTabbedPane.this.getCanvas(TabPaneContextMenu.this.m_tabSelected) == null) {
                        return;
                    }
                    PagePropertiesDialog dlg = new PagePropertiesDialog(CanvasTabbedPane.this.getParentJFrame(), TabPaneContextMenu.this.m_tabSelected);
                    dlg.show();
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Insert Page");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    SCanvas canvas = CanvasTabbedPane.this.createNewActiveCanvas();
                    CanvasTabbedPane.this.addCanvasTab(canvas, TabPaneContextMenu.this.m_tabSelected < 0 ? CanvasTabbedPane.this.m_controller.getTabCount() : TabPaneContextMenu.this.m_tabSelected + 1);
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Delete Page");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    if (TabPaneContextMenu.this.m_tabSelected < 0) {
                        return;
                    }
                    CanvasTabbedPane.this.removeTabAt(TabPaneContextMenu.this.m_tabSelected);
                    if (CanvasTabbedPane.this.getTabCount() < 1) {
                        SCanvas newCanvas = CanvasTabbedPane.this.createNewActiveCanvas();
                        CanvasTabbedPane.this.addCanvasTab(newCanvas);
                    }
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Clear Page");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    CanvasTabbedPane.this.getCanvas().clear();
                    CanvasTabbedPane.this.m_controller.updateCanvas();
                }
            });
            this.m_menu.add(item);
            item = new JMenuItem("Delete All Pages");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent A) {
                    SCanvas canvas = CanvasTabbedPane.this.createNewActiveCanvas();
                    CanvasTabbedPane.this.removeAllTabs();
                    CanvasTabbedPane.this.addCanvasTab(canvas);
                }
            });
            this.m_menu.add(item);
        }

        public void mouseClicked(MouseEvent ev) {
            int xClick = ev.getX();
            int yClick = ev.getY();
            if ((ev.getModifiers() & 8) != 0 || (ev.getModifiers() & 4) != 0) {
                this.m_tabSelected = CanvasTabbedPane.this.m_controller.getTabNumber(xClick, yClick);
                CanvasTabbedPane.this.showPopupMenu(this.m_menu, CanvasTabbedPane.this.m_tabCanvas, xClick, yClick);
            }
        }
    }

    class GWSCListener
    implements SCanvasListener {
        GWSCListener() {
        }

        public boolean canvasCleared(SCanvas sc, boolean newTopLevelExpr) {
            SCanvas newCanvas = null;
            switch (CanvasTabbedPane.getClearReaction()) {
                case 0: {
                    newCanvas = CanvasTabbedPane.this.createNewActiveCanvas();
                    if (newTopLevelExpr) {
                        CanvasTabbedPane.this.removeAllTabs();
                    }
                    CanvasTabbedPane.this.addCanvasTab(newCanvas);
                    return false;
                }
                case 1: {
                    newCanvas = CanvasTabbedPane.this.createNewActiveCanvas();
                    CanvasTabbedPane.this.addCanvasTab(newCanvas);
                    return false;
                }
                case 2: {
                    if (CanvasTabbedPane.this.getTabCount() < 1) {
                        newCanvas = CanvasTabbedPane.this.createNewActiveCanvas();
                        CanvasTabbedPane.this.addCanvasTab(newCanvas);
                    }
                    CanvasTabbedPane.this.repaint(1000L);
                    return true;
                }
            }
            return true;
        }

        public void canvasChanged(SCanvas sc) {
            int tabNum = CanvasTabbedPane.this.canvasToTab(sc);
            if (tabNum >= 0) {
                CanvasTabbedPane.this.m_controller.updateCanvas(tabNum);
                CanvasTabbedPane.this.m_controller.updateTabs();
            }
        }

        public void canvasWrap(SCanvas canvas) {
            CanvasTabbedPane.this.canvasWrap(canvas);
        }

        public Point[] canvasReadPen(SCanvas canvas, int maxPoints) {
            return CanvasTabbedPane.this.canvasReadPen(canvas, maxPoints);
        }
    }

    static class ReadPenDialog
    extends JDialog {
        int m_readPenMaxPoints = 0;
        int m_readPenPointsRead = 0;
        Point[] m_readPenPoints = null;
        boolean m_readPenDone = true;
        JLabel m_clickInfo;
        JLabel m_mouseInfoX;
        JLabel m_mouseInfoY;
        SCanvas m_canvas;
        CanvasTabbedPane m_tabbedPane;
        Component m_canvasPanel;
        boolean m_firstAppearance = true;
        MouseInputAdapter readPenMouse = new MouseInputAdapter(){

            public void mouseExited(MouseEvent e) {
                ReadPenDialog.this.showMousePosition(null);
            }

            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                ReadPenDialog.this.showMousePosition(x, y);
            }

            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 0x10) == 0) {
                    this.endReadPen();
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                Point pt = ReadPenDialog.this.m_tabbedPane.m_controller.getCanvasPointFromMouse(new Point(x, y));
                ReadPenDialog.this.m_readPenPoints[ReadPenDialog.this.m_readPenPointsRead++] = pt;
                if (ReadPenDialog.this.m_readPenPointsRead >= ReadPenDialog.this.m_readPenMaxPoints) {
                    this.endReadPen();
                    return;
                }
                ReadPenDialog.this.updateReadPenString();
                this.mouseMoved(e);
            }

            void endReadPen() {
                ReadPenDialog.this.m_readPenDone = true;
            }
        };

        ReadPenDialog(Frame frame) {
            super(frame, "Select Points", false);
            JPanel infoPanel = new JPanel();
            infoPanel.setLayout(new BoxLayout(infoPanel, 1));
            infoPanel.setAlignmentX(0.0f);
            this.m_clickInfo = new JLabel("Left-click to select points");
            JLabel clickInfo2 = new JLabel("Right-click or press OK button to end.");
            this.m_mouseInfoX = new JLabel("       ");
            this.m_mouseInfoY = new JLabel("       ");
            infoPanel.add(this.m_clickInfo);
            infoPanel.add(clickInfo2);
            infoPanel.add(Box.createHorizontalStrut(3));
            infoPanel.add(this.m_mouseInfoX);
            infoPanel.add(Box.createHorizontalStrut(3));
            infoPanel.add(this.m_mouseInfoY);
            infoPanel.add(Box.createHorizontalStrut(3));
            JPanel buttonPanel = new JPanel();
            JButton b = new JButton("OK");
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ReadPenDialog.this.m_readPenDone = true;
                }
            });
            buttonPanel.add(b);
            this.getContentPane().add((Component)infoPanel, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Point[] runReadPen(CanvasTabbedPane pane, int maxPoints) {
            int i;
            block10: {
                this.m_tabbedPane = pane;
                this.m_canvas = pane.getCanvas();
                if (this.m_canvas == null || maxPoints < 1) {
                    return null;
                }
                this.m_readPenMaxPoints = maxPoints;
                this.m_readPenPointsRead = 0;
                this.m_readPenPoints = new Point[this.m_readPenMaxPoints];
                this.m_readPenDone = false;
                this.updateReadPenString();
                this.showMousePosition(null);
                try {
                    Object var7_10;
                    try {
                        if (this.m_firstAppearance) {
                            this.m_firstAppearance = false;
                            Point topLeft = this.m_tabbedPane.getLocationOnScreen();
                            this.setLocation(Math.max(0, topLeft.x), Math.max(0, topLeft.y - this.getHeight() - 50));
                        }
                        this.setVisible(true);
                        this.toFront();
                        pane.m_pageCanvas.addMouseListener(this.readPenMouse);
                        pane.m_pageCanvas.addMouseMotionListener(this.readPenMouse);
                        int sleepMsecs = 200;
                        int iters = 300000 / sleepMsecs;
                        for (i = 0; i < iters && !this.m_readPenDone; ++i) {
                            Thread.sleep(sleepMsecs);
                        }
                        var7_10 = null;
                    }
                    catch (Exception ex) {
                        var7_10 = null;
                        pane.m_pageCanvas.removeMouseListener(this.readPenMouse);
                        pane.m_pageCanvas.removeMouseMotionListener(this.readPenMouse);
                        this.setVisible(false);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    pane.m_pageCanvas.removeMouseListener(this.readPenMouse);
                    pane.m_pageCanvas.removeMouseMotionListener(this.readPenMouse);
                    this.setVisible(false);
                    throw throwable;
                }
                pane.m_pageCanvas.removeMouseListener(this.readPenMouse);
                pane.m_pageCanvas.removeMouseMotionListener(this.readPenMouse);
                this.setVisible(false);
            }
            int pointsRead = this.m_readPenPointsRead;
            Point[] vals = new Point[pointsRead];
            i = 0;
            while (i < pointsRead) {
                vals[i] = this.m_readPenPoints[i];
                ++i;
            }
            return vals;
        }

        void showMousePosition(int x, int y) {
            this.showMousePosition(new Point(x, y));
        }

        void showMousePosition(Point pt) {
            Point canvasPt = this.m_tabbedPane.m_controller.getCanvasPointFromMouse(pt);
            SCanvasPoint valXY = this.m_canvas.getValueFromPoint(canvasPt);
            this.m_mouseInfoX.setText(valXY != null ? "  x: " + valXY.getX() : "    ");
            this.m_mouseInfoY.setText(valXY != null ? "  y: " + valXY.getY() : "    ");
        }

        void updateReadPenString() {
            this.toFront();
        }
    }
}

