/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.ChartBuilder;
import com.insightful.miner.ExplorerPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.SplusGraphNodeModel;
import com.insightful.miner.TwoDimChartNodeModel;
import com.insightful.miner.Viewable;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.XMLTreeNetwork;
import com.insightful.miner.XTProps;
import com.insightful.miner.graphdlg.GraphDialogSetupProvider;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GraphMenu
extends JMenu {
    private ActionListener m_actionListener;
    private GraphDialogSetupProvider m_setupProvider;
    private static HashMap g_nodeModelHashMap = null;
    private static HashMap g_defaultSplusLibraryHashMap = null;
    private JMenu m_oneColMenu = null;
    private JMenu m_twoColMenu = null;
    private JMenu m_threeColMenu = null;
    private JMenu m_multiColMenu = null;
    private JMenu m_timeSeriesMenu = null;
    private static final String SPLUS_GRAPH_NODE_MODEL_CLASS = "com.insightful.miner.SplusGraphNodeModel";
    private static final String CHART2D_NODE_MODEL_CLASS = "com.insightful.miner.TwoDimChartNodeModel";
    private static final String CHART2D_DIALOG_CLASS = "com.insightful.miner.TwoDimChartDialog";

    public GraphMenu(GraphDialogSetupProvider setupProvider) {
        this.setText(ChartBuilder.getText("tableViewer_menu_chart"));
        this.setMnemonic('C');
        this.m_setupProvider = setupProvider;
        this.m_actionListener = new LocalActionListener();
        this.m_oneColMenu = new JMenu(ChartBuilder.getText("tableViewer_menu_one_column"));
        this.m_oneColMenu.setMnemonic(79);
        this.add(this.m_oneColMenu);
        this.m_oneColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_density_plot"), 'E', "com.insightful.miner.graphdlg.DensityPlotDialog", MinerApp.getResourceManager().getIcon("densityplot_small.gif")));
        this.m_oneColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_histogram"), 'H', "com.insightful.miner.graphdlg.HistogramDialog", MinerApp.getResourceManager().getIcon("histogram2_small.gif")));
        this.m_oneColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_qq_math_plot"), 'Q', "com.insightful.miner.graphdlg.QQMathPlotDialog", MinerApp.getResourceManager().getIcon("qqmath_small.gif")));
        this.m_oneColMenu.addSeparator();
        this.m_oneColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_barchart"), 'B', "com.insightful.miner.graphdlg.BarChartDialog", MinerApp.getResourceManager().getIcon("barchart_small.gif")));
        this.m_oneColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_dot_plot"), 'D', "com.insightful.miner.graphdlg.DotPlotDialog", MinerApp.getResourceManager().getIcon("dotplot_small.gif")));
        this.m_oneColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_piechart"), 'P', "com.insightful.miner.graphdlg.PieChartDialog", MinerApp.getResourceManager().getIcon("piechart_small.gif")));
        this.m_twoColMenu = new JMenu(ChartBuilder.getText("tableViewer_menu_two_columns"));
        this.m_twoColMenu.setMnemonic(84);
        this.add(this.m_twoColMenu);
        this.m_twoColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_hexbin_plot"), 'H', "com.insightful.miner.graphdlg.HexbinPlotDialog", MinerApp.getResourceManager().getIcon("hex_bin_small.gif")));
        this.m_twoColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_scatter_plot"), 'S', "com.insightful.miner.graphdlg.ScatterPlotDialog", MinerApp.getResourceManager().getIcon("scatterplot_small.gif")));
        this.m_twoColMenu.addSeparator();
        this.m_twoColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_box_plot"), 'B', "com.insightful.miner.graphdlg.BoxPlotDialog", MinerApp.getResourceManager().getIcon("boxplot_small.gif")));
        this.m_twoColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_strip_plot"), 'S', "com.insightful.miner.graphdlg.StripPlotDialog", MinerApp.getResourceManager().getIcon("stripplot_small.gif")));
        this.m_twoColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_qq_plot"), 'Q', "com.insightful.miner.graphdlg.QQPlotDialog", MinerApp.getResourceManager().getIcon("qqplot_small.gif")));
        this.m_threeColMenu = new JMenu(ChartBuilder.getText("tableViewer_menu_three_columns"));
        this.m_threeColMenu.setMnemonic(72);
        this.add(this.m_threeColMenu);
        this.m_threeColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_contour_plot"), 'C', "com.insightful.miner.graphdlg.ContourPlotDialog", MinerApp.getResourceManager().getIcon("contourplot_small.gif")));
        this.m_threeColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_level_plot"), 'L', "com.insightful.miner.graphdlg.LevelPlotDialog", MinerApp.getResourceManager().getIcon("levelplot_small.gif")));
        this.m_threeColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_surface_plot"), 'S', "com.insightful.miner.graphdlg.SurfacePlotDialog", MinerApp.getResourceManager().getIcon("surfaceplot_small.gif")));
        this.m_threeColMenu.addSeparator();
        this.m_threeColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_cloud_plot"), 'P', "com.insightful.miner.graphdlg.CloudPlotDialog", MinerApp.getResourceManager().getIcon("cloudplot_small.gif")));
        this.m_multiColMenu = new JMenu(ChartBuilder.getText("tableViewer_menu_multi_columns"));
        this.m_multiColMenu.setMnemonic(77);
        this.add(this.m_multiColMenu);
        this.m_multiColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_multi_2D_plot"), '2', CHART2D_DIALOG_CLASS, MinerApp.getResourceManager().getIcon("default_small.gif")));
        this.m_multiColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_hexbin_matrix"), 'M', "com.insightful.miner.graphdlg.HexbinMatrixPlotDialog", MinerApp.getResourceManager().getIcon("default_small.gif")));
        this.m_multiColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_Scatterplot_matrix"), 'M', "com.insightful.miner.graphdlg.MatrixPlotDialog", MinerApp.getResourceManager().getIcon("matrixplot_small.gif")));
        this.m_multiColMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_parallel_plot"), 'P', "com.insightful.miner.graphdlg.ParallelPlotDialog", MinerApp.getResourceManager().getIcon("parallelplot_small.gif")));
        this.m_timeSeriesMenu = new JMenu(ChartBuilder.getText("tableViewer_menu_time_series"));
        this.m_timeSeriesMenu.setMnemonic(73);
        this.add(this.m_timeSeriesMenu);
        this.m_timeSeriesMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_line_plot"), 'L', "com.insightful.miner.graphdlg.TimeLinePlotDialog", MinerApp.getResourceManager().getIcon("tsline_small.gif")));
        this.m_timeSeriesMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_highlow_plot"), 'H', "com.insightful.miner.graphdlg.TimeHighLowPlotDialog", MinerApp.getResourceManager().getIcon("tshighlow_small.gif")));
        this.m_timeSeriesMenu.add(this.newMenuItem(ChartBuilder.getText("tableViewer_menu_stackedbar_plot"), 'S', "com.insightful.miner.graphdlg.TimeBarPlotDialog", MinerApp.getResourceManager().getIcon("tsbar_small.gif")));
        this.addMenuListener(new MenuListener(){

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                boolean enableMenus = false;
                try {
                    Viewable viewable = GraphMenu.this.m_setupProvider.getNodeModel();
                    enableMenus = MinerApp.isSplusLicensed() && MinerApp.getMainFrame().getExplorerPane().isEnabled() && viewable != null && viewable.getWorksheetDocument() != null && MinerApp.getCurrentView() != null && ((Object)((Object)viewable.getWorksheetDocument())).equals((Object)MinerApp.getCurrentDoc()) && viewable.isComputed();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                GraphMenu.this.m_oneColMenu.setEnabled(enableMenus);
                GraphMenu.this.m_twoColMenu.setEnabled(enableMenus);
                GraphMenu.this.m_threeColMenu.setEnabled(enableMenus);
                GraphMenu.this.m_multiColMenu.setEnabled(enableMenus);
                GraphMenu.this.m_timeSeriesMenu.setEnabled(enableMenus);
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    public JMenuItem newMenuItem(String text, char mnemonic, String actionCommand, Icon defaultIcon) {
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.setActionCommand(actionCommand);
        menuItem.addActionListener(this.m_actionListener);
        menuItem.setMnemonic(mnemonic);
        menuItem.setIcon(defaultIcon);
        return menuItem;
    }

    private ActivityNodeModel findGraphNodeModel(String graphDialogClass) {
        ActivityNodeModel nodeModel = null;
        if (g_nodeModelHashMap == null) {
            g_nodeModelHashMap = new HashMap();
        } else {
            nodeModel = (ActivityNodeModel)g_nodeModelHashMap.get(graphDialogClass);
        }
        if (nodeModel == null && nodeModel != null) {
            g_nodeModelHashMap.put(graphDialogClass, nodeModel);
        }
        if (nodeModel == null) {
            if (g_defaultSplusLibraryHashMap == null) {
                g_defaultSplusLibraryHashMap = new HashMap();
                Element elt = ExplorerPane.getLibraryAsElement(ExplorerPane.SPLUS_LIBRARY_FILE_NAME, false, true, false);
                GraphMenu.addGraphNodesToHashMap(elt, g_defaultSplusLibraryHashMap);
            }
            if ((nodeModel = (ActivityNodeModel)g_defaultSplusLibraryHashMap.get(graphDialogClass)) != null) {
                g_nodeModelHashMap.put(graphDialogClass, nodeModel);
            }
        }
        return nodeModel;
    }

    private static void addGraphNodesToHashMap(Element elt, HashMap map) {
        block5: {
            block3: {
                block4: {
                    if (!elt.getNodeName().equals(XMLTreeNetwork.ACTIVITY_NODE_NODE_TAG)) break block3;
                    if (!SPLUS_GRAPH_NODE_MODEL_CLASS.equals(elt.getAttribute(XMLTreeNetwork.GUI_CLASS_ATTRIBUTE_TAG))) break block4;
                    NodeList props = ((Element)((Element)elt.getElementsByTagName(XMLTreeNetwork.ARGUMENT_LIST_NODE_TAG).item(0)).getElementsByTagName(XTProps.XT_PROPERTY_NODE_TAG).item(0)).getElementsByTagName(XTProps.PROPERTY_NODE_TAG);
                    String dialogClass = null;
                    int i = -1;
                    while (dialogClass == null && i++ < props.getLength()) {
                        if (!"dialogClass".equals(((Element)props.item(i)).getAttribute(XTProps.NAME_ATTRIBUTE_TAG))) continue;
                        dialogClass = ((Element)props.item(i)).getAttribute(XTProps.VALUE_ATTRIBUTE_TAG);
                    }
                    if (!map.containsKey(dialogClass)) {
                        map.put(dialogClass, new SplusGraphNodeModel(elt));
                    }
                    break block5;
                }
                if (!CHART2D_NODE_MODEL_CLASS.equals(elt.getAttribute(XMLTreeNetwork.GUI_CLASS_ATTRIBUTE_TAG)) || map.containsKey(CHART2D_DIALOG_CLASS)) break block5;
                map.put(CHART2D_DIALOG_CLASS, new TwoDimChartNodeModel(elt));
                break block5;
            }
            NodeList children = elt.getChildNodes();
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                GraphMenu.addGraphNodesToHashMap((Element)children.item(i), map);
            }
        }
    }

    public class LocalActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (MinerApp.waitingOnSplus()) {
                AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), "Cannot open dialog while evaluating an S-PLUS expression.");
                return;
            }
            int portNum = GraphMenu.this.m_setupProvider.getPortNumber();
            boolean isInput = GraphMenu.this.m_setupProvider.isInputPort();
            Viewable viewable = GraphMenu.this.m_setupProvider.getNodeModel();
            Frame frame = GraphMenu.this.m_setupProvider.getParentFrame();
            Cursor oldCursor = frame.getCursor();
            frame.setCursor(Cursor.getPredefinedCursor(3));
            String actionCommand = e.getActionCommand();
            try {
                ActivityNodeModel nodeModel = GraphMenu.this.findGraphNodeModel(actionCommand);
                if (nodeModel == null) {
                    AcceleratorOptionPane.showOKDialog(frame, "Cannot find graph dialog default settings.", "Graph Dialog Defaults Not Found", 0);
                    frame.setCursor(oldCursor);
                    return;
                }
                nodeModel = nodeModel.copy();
                ActivityNodeArea newNodeArea = new ActivityNodeArea();
                newNodeArea.initialize(nodeModel);
                newNodeArea.setVisible(false);
                int parentNodeNum = isInput ? viewable.getAParentModel(portNum).getID() : viewable.getID();
                WorksheetDocument doc = viewable.getWorksheetDocument();
                BaseNodeArea parentNodeArea = doc.findNodeByID(parentNodeNum);
                newNodeArea.setSpotLocation(1, (JGoObject)parentNodeArea, 5);
                doc.addObjectAtTail((JGoObject)newNodeArea);
                BaseLink link = doc.newLink((JGoPort)parentNodeArea.getOutputPorts().elementAt(portNum), (JGoPort)newNodeArea.getInputPorts().elementAt(0), true);
                link.setVisible(false);
                if (nodeModel instanceof SplusGraphNodeModel) {
                    ((SplusGraphNodeModel)nodeModel).showPropertiesDialog(false, true);
                } else if (nodeModel instanceof TwoDimChartNodeModel) {
                    ((TwoDimChartNodeModel)nodeModel).showPropertiesDialog(false, true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            frame.setCursor(oldCursor);
        }
    }
}

