/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerControlMetrics;
import com.insightful.miner.graphdlg.controls.MinerLabelBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class MinerDoubleSpinner
extends MinerLabelBox
implements MinerControlMethods {
    JTextField textField;
    JScrollBar scrollBar;
    JLabel label;
    double minValue;
    double maxValue;
    double incrementValue;
    int numSteps;
    int lastStepValue;
    static int SCROLL_WIDTH = 15;

    public MinerDoubleSpinner(String text) {
        this(text, 0.0, 100.0, 1.0);
    }

    public MinerDoubleSpinner(String text, char mnemonic) {
        this(text, 0.0, 100.0, 1.0);
        this.setMnemonic(mnemonic);
    }

    public MinerDoubleSpinner(String text, int mnemonic) {
        this(text, 0.0, 100.0, 1.0);
        this.setMnemonic(mnemonic);
    }

    public MinerDoubleSpinner(String text, int mnemonic, double min, double max, double increment) {
        this(text, min, max, increment);
        this.setMnemonic(mnemonic);
    }

    public MinerDoubleSpinner(String text, char mnemonic, double min, double max, double increment) {
        this(text, min, max, increment);
        this.setMnemonic(mnemonic);
    }

    public MinerDoubleSpinner(String text, double min, double max, double increment) {
        super(text);
        this.minValue = min;
        this.maxValue = max;
        this.incrementValue = increment;
        this.lastStepValue = this.numSteps = (int)((max - min) / increment);
        Dimension labelDimension = MinerControlMetrics.getLabelDimension();
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(labelDimension.width - SCROLL_WIDTH, labelDimension.height));
        this.textField.setText(new Double(this.minValue).toString());
        this.scrollBar = new JScrollBar(1, this.lastStepValue, 0, 0, this.numSteps);
        this.scrollBar.setPreferredSize(new Dimension(SCROLL_WIDTH, labelDimension.height));
        this.scrollBar.addAdjustmentListener(new ScrollListener());
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout(0, 0));
        textPanel.add((Component)this.textField, "Center");
        textPanel.add((Component)this.scrollBar, "East");
        textPanel.setPreferredSize(labelDimension);
        textPanel.setMinimumSize(labelDimension);
        this.setActionControl(textPanel);
        this.setLabelFor(this.textField);
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setValue(String value) {
        this.textField.setText(value);
    }

    public String[] getOptionList() {
        return null;
    }

    public void setOptionList(String[] listData) {
    }

    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.textField.setEnabled(b);
        this.scrollBar.setEnabled(b);
        this.setLabelEnabled(b);
    }

    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    private class TextListener
    implements ActionListener {
        private TextListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MinerDoubleSpinner.this.setValue(MinerDoubleSpinner.this.textField.getText());
        }
    }

    private class ScrollListener
    implements AdjustmentListener {
        private ScrollListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            double numericValue;
            try {
                numericValue = Double.valueOf(MinerDoubleSpinner.this.textField.getText());
            }
            catch (NumberFormatException nef) {
                numericValue = MinerDoubleSpinner.this.minValue;
            }
            numericValue += (double)(MinerDoubleSpinner.this.lastStepValue - e.getValue()) * MinerDoubleSpinner.this.incrementValue;
            numericValue = Math.max(Math.min(numericValue, MinerDoubleSpinner.this.maxValue), MinerDoubleSpinner.this.minValue);
            MinerDoubleSpinner.this.textField.setText(new Double(numericValue).toString());
            MinerDoubleSpinner.this.lastStepValue = e.getValue();
        }
    }
}

