/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerLabelBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class MinerIntegerSpinner
extends MinerLabelBox
implements MinerControlMethods {
    JTextField textField;
    JScrollBar scrollBar;
    int minValue;
    int maxValue;
    int incrementValue;
    int numSteps;
    int lastStepValue;
    static int SCROLL_WIDTH = 15;

    public MinerIntegerSpinner(String text) {
        this(text, 0, 100, 1);
    }

    public MinerIntegerSpinner(String text, char mnemonic) {
        this(text, 0, 100, 1);
        this.setMnemonic(mnemonic);
    }

    public MinerIntegerSpinner(String text, int mnemonic) {
        this(text, 0, 100, 1);
        this.setMnemonic(mnemonic);
    }

    public MinerIntegerSpinner(String text, int mnemonic, int min, int max, int increment) {
        this(text, min, max, increment);
        this.setMnemonic(mnemonic);
    }

    public MinerIntegerSpinner(String text, char mnemonic, int min, int max, int increment) {
        this(text, min, max, increment);
        this.setMnemonic(mnemonic);
    }

    public MinerIntegerSpinner(String text, int min, int max, int increment) {
        super(text);
        this.minValue = min;
        this.maxValue = max;
        this.incrementValue = increment;
        this.lastStepValue = this.numSteps = (max - min) / increment;
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(MinerIntegerSpinner.labelDimension.width - SCROLL_WIDTH, MinerIntegerSpinner.labelDimension.height));
        this.textField.setText(new Integer(this.minValue).toString());
        this.scrollBar = new JScrollBar(1, this.lastStepValue, 0, 0, this.numSteps);
        this.scrollBar.setPreferredSize(new Dimension(SCROLL_WIDTH, MinerIntegerSpinner.labelDimension.height));
        this.scrollBar.addAdjustmentListener(new ScrollListener());
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout(0, 0));
        textPanel.add((Component)this.textField, "Center");
        textPanel.add((Component)this.scrollBar, "East");
        textPanel.setPreferredSize(labelDimension);
        textPanel.setMinimumSize(labelDimension);
        this.setActionControl(textPanel);
        this.setLabelFor(this.textField);
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setValue(String value) {
        this.textField.setText(value);
    }

    public String[] getOptionList() {
        return null;
    }

    public void setOptionList(String[] listData) {
    }

    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.textField.setEnabled(b);
        this.scrollBar.setEnabled(b);
        this.setLabelEnabled(b);
    }

    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    private class TextListener
    implements ActionListener {
        private TextListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MinerIntegerSpinner.this.setValue(MinerIntegerSpinner.this.textField.getText());
        }
    }

    private class ScrollListener
    implements AdjustmentListener {
        private ScrollListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            int numericValue;
            try {
                numericValue = Integer.valueOf(MinerIntegerSpinner.this.textField.getText());
            }
            catch (NumberFormatException nef) {
                numericValue = MinerIntegerSpinner.this.minValue;
            }
            numericValue += (MinerIntegerSpinner.this.lastStepValue - e.getValue()) * MinerIntegerSpinner.this.incrementValue;
            numericValue = Math.max(Math.min(numericValue, MinerIntegerSpinner.this.maxValue), MinerIntegerSpinner.this.minValue);
            MinerIntegerSpinner.this.textField.setText(new Integer(numericValue).toString());
            MinerIntegerSpinner.this.lastStepValue = e.getValue();
        }
    }
}

